# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DeploymentArgs', 'Deployment']

@pulumi.input_type
class DeploymentArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[_builtins.str],
                 sku: pulumi.Input[_builtins.str],
                 auto_scale_profiles: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentAutoScaleProfileArgs']]]] = None,
                 automatic_upgrade_channel: Optional[pulumi.Input[_builtins.str]] = None,
                 capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 diagnose_support_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 frontend_privates: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentFrontendPrivateArgs']]]] = None,
                 frontend_public: Optional[pulumi.Input['DeploymentFrontendPublicArgs']] = None,
                 identity: Optional[pulumi.Input['DeploymentIdentityArgs']] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 logging_storage_accounts: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentLoggingStorageAccountArgs']]]] = None,
                 managed_resource_group: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentNetworkInterfaceArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 web_application_firewall: Optional[pulumi.Input['DeploymentWebApplicationFirewallArgs']] = None):
        """
        The set of arguments for constructing a Deployment resource.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the NGINX Deployment should exist. Changing this forces a new NGINX Deployment to be created.
        :param pulumi.Input[Sequence[pulumi.Input['DeploymentAutoScaleProfileArgs']]] auto_scale_profiles: An `auto_scale_profile` block as defined below.
        :param pulumi.Input[_builtins.str] automatic_upgrade_channel: Specify the automatic upgrade channel for the NGINX deployment. Defaults to `stable`. The possible values are `stable` and `preview`.
        :param pulumi.Input[_builtins.int] capacity: Specify the number of NGINX capacity units for this NGINX deployment.
               
               > **Note:** For more information on NGINX capacity units, please refer to the [NGINX scaling guidance documentation](https://docs.nginx.com/nginxaas/azure/quickstart/scaling/)
        :param pulumi.Input[_builtins.bool] diagnose_support_enabled: Should the metrics be exported to Azure Monitor?
        :param pulumi.Input[_builtins.str] email: Specify the preferred support contact email address for receiving alerts and notifications.
        :param pulumi.Input[Sequence[pulumi.Input['DeploymentFrontendPrivateArgs']]] frontend_privates: One or more `frontend_private` blocks as defined below.
        :param pulumi.Input['DeploymentFrontendPublicArgs'] frontend_public: A `frontend_public` block as defined below.
        :param pulumi.Input['DeploymentIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the NGINX Deployment should exist. Changing this forces a new NGINX Deployment to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this NGINX Deployment. Changing this forces a new NGINX Deployment to be created.
        :param pulumi.Input[Sequence[pulumi.Input['DeploymentNetworkInterfaceArgs']]] network_interfaces: One or more `network_interface` blocks as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the NGINX Deployment.
        :param pulumi.Input['DeploymentWebApplicationFirewallArgs'] web_application_firewall: A `web_application_firewall` blocks as defined below.
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "sku", sku)
        if auto_scale_profiles is not None:
            pulumi.set(__self__, "auto_scale_profiles", auto_scale_profiles)
        if automatic_upgrade_channel is not None:
            pulumi.set(__self__, "automatic_upgrade_channel", automatic_upgrade_channel)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if diagnose_support_enabled is not None:
            pulumi.set(__self__, "diagnose_support_enabled", diagnose_support_enabled)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if frontend_privates is not None:
            pulumi.set(__self__, "frontend_privates", frontend_privates)
        if frontend_public is not None:
            pulumi.set(__self__, "frontend_public", frontend_public)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if logging_storage_accounts is not None:
            warnings.warn("""The `logging_storage_account` block has been deprecated and will be removed in v5.0 of the AzureRM Provider. To enable logs, use the `monitoring.DiagnosticSetting` resource instead.""", DeprecationWarning)
            pulumi.log.warn("""logging_storage_accounts is deprecated: The `logging_storage_account` block has been deprecated and will be removed in v5.0 of the AzureRM Provider. To enable logs, use the `monitoring.DiagnosticSetting` resource instead.""")
        if logging_storage_accounts is not None:
            pulumi.set(__self__, "logging_storage_accounts", logging_storage_accounts)
        if managed_resource_group is not None:
            warnings.warn("""The `managed_resource_group` field isn't supported by the API anymore and has been deprecated and will be removed in v5.0 of the AzureRM Provider.""", DeprecationWarning)
            pulumi.log.warn("""managed_resource_group is deprecated: The `managed_resource_group` field isn't supported by the API anymore and has been deprecated and will be removed in v5.0 of the AzureRM Provider.""")
        if managed_resource_group is not None:
            pulumi.set(__self__, "managed_resource_group", managed_resource_group)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if web_application_firewall is not None:
            pulumi.set(__self__, "web_application_firewall", web_application_firewall)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Resource Group where the NGINX Deployment should exist. Changing this forces a new NGINX Deployment to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def sku(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "sku", value)

    @_builtins.property
    @pulumi.getter(name="autoScaleProfiles")
    def auto_scale_profiles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentAutoScaleProfileArgs']]]]:
        """
        An `auto_scale_profile` block as defined below.
        """
        return pulumi.get(self, "auto_scale_profiles")

    @auto_scale_profiles.setter
    def auto_scale_profiles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentAutoScaleProfileArgs']]]]):
        pulumi.set(self, "auto_scale_profiles", value)

    @_builtins.property
    @pulumi.getter(name="automaticUpgradeChannel")
    def automatic_upgrade_channel(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specify the automatic upgrade channel for the NGINX deployment. Defaults to `stable`. The possible values are `stable` and `preview`.
        """
        return pulumi.get(self, "automatic_upgrade_channel")

    @automatic_upgrade_channel.setter
    def automatic_upgrade_channel(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "automatic_upgrade_channel", value)

    @_builtins.property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specify the number of NGINX capacity units for this NGINX deployment.

        > **Note:** For more information on NGINX capacity units, please refer to the [NGINX scaling guidance documentation](https://docs.nginx.com/nginxaas/azure/quickstart/scaling/)
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "capacity", value)

    @_builtins.property
    @pulumi.getter(name="diagnoseSupportEnabled")
    def diagnose_support_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the metrics be exported to Azure Monitor?
        """
        return pulumi.get(self, "diagnose_support_enabled")

    @diagnose_support_enabled.setter
    def diagnose_support_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "diagnose_support_enabled", value)

    @_builtins.property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specify the preferred support contact email address for receiving alerts and notifications.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "email", value)

    @_builtins.property
    @pulumi.getter(name="frontendPrivates")
    def frontend_privates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentFrontendPrivateArgs']]]]:
        """
        One or more `frontend_private` blocks as defined below.
        """
        return pulumi.get(self, "frontend_privates")

    @frontend_privates.setter
    def frontend_privates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentFrontendPrivateArgs']]]]):
        pulumi.set(self, "frontend_privates", value)

    @_builtins.property
    @pulumi.getter(name="frontendPublic")
    def frontend_public(self) -> Optional[pulumi.Input['DeploymentFrontendPublicArgs']]:
        """
        A `frontend_public` block as defined below.
        """
        return pulumi.get(self, "frontend_public")

    @frontend_public.setter
    def frontend_public(self, value: Optional[pulumi.Input['DeploymentFrontendPublicArgs']]):
        pulumi.set(self, "frontend_public", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['DeploymentIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['DeploymentIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the NGINX Deployment should exist. Changing this forces a new NGINX Deployment to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="loggingStorageAccounts")
    @_utilities.deprecated("""The `logging_storage_account` block has been deprecated and will be removed in v5.0 of the AzureRM Provider. To enable logs, use the `monitoring.DiagnosticSetting` resource instead.""")
    def logging_storage_accounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentLoggingStorageAccountArgs']]]]:
        return pulumi.get(self, "logging_storage_accounts")

    @logging_storage_accounts.setter
    def logging_storage_accounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentLoggingStorageAccountArgs']]]]):
        pulumi.set(self, "logging_storage_accounts", value)

    @_builtins.property
    @pulumi.getter(name="managedResourceGroup")
    @_utilities.deprecated("""The `managed_resource_group` field isn't supported by the API anymore and has been deprecated and will be removed in v5.0 of the AzureRM Provider.""")
    def managed_resource_group(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "managed_resource_group")

    @managed_resource_group.setter
    def managed_resource_group(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "managed_resource_group", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this NGINX Deployment. Changing this forces a new NGINX Deployment to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentNetworkInterfaceArgs']]]]:
        """
        One or more `network_interface` blocks as defined below.
        """
        return pulumi.get(self, "network_interfaces")

    @network_interfaces.setter
    def network_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentNetworkInterfaceArgs']]]]):
        pulumi.set(self, "network_interfaces", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the NGINX Deployment.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="webApplicationFirewall")
    def web_application_firewall(self) -> Optional[pulumi.Input['DeploymentWebApplicationFirewallArgs']]:
        """
        A `web_application_firewall` blocks as defined below.
        """
        return pulumi.get(self, "web_application_firewall")

    @web_application_firewall.setter
    def web_application_firewall(self, value: Optional[pulumi.Input['DeploymentWebApplicationFirewallArgs']]):
        pulumi.set(self, "web_application_firewall", value)


@pulumi.input_type
class _DeploymentState:
    def __init__(__self__, *,
                 auto_scale_profiles: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentAutoScaleProfileArgs']]]] = None,
                 automatic_upgrade_channel: Optional[pulumi.Input[_builtins.str]] = None,
                 capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 dataplane_api_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 diagnose_support_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 frontend_privates: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentFrontendPrivateArgs']]]] = None,
                 frontend_public: Optional[pulumi.Input['DeploymentFrontendPublicArgs']] = None,
                 identity: Optional[pulumi.Input['DeploymentIdentityArgs']] = None,
                 ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 logging_storage_accounts: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentLoggingStorageAccountArgs']]]] = None,
                 managed_resource_group: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentNetworkInterfaceArgs']]]] = None,
                 nginx_version: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 web_application_firewall: Optional[pulumi.Input['DeploymentWebApplicationFirewallArgs']] = None):
        """
        Input properties used for looking up and filtering Deployment resources.
        :param pulumi.Input[Sequence[pulumi.Input['DeploymentAutoScaleProfileArgs']]] auto_scale_profiles: An `auto_scale_profile` block as defined below.
        :param pulumi.Input[_builtins.str] automatic_upgrade_channel: Specify the automatic upgrade channel for the NGINX deployment. Defaults to `stable`. The possible values are `stable` and `preview`.
        :param pulumi.Input[_builtins.int] capacity: Specify the number of NGINX capacity units for this NGINX deployment.
               
               > **Note:** For more information on NGINX capacity units, please refer to the [NGINX scaling guidance documentation](https://docs.nginx.com/nginxaas/azure/quickstart/scaling/)
        :param pulumi.Input[_builtins.str] dataplane_api_endpoint: The dataplane API endpoint of the NGINX Deployment.
        :param pulumi.Input[_builtins.bool] diagnose_support_enabled: Should the metrics be exported to Azure Monitor?
        :param pulumi.Input[_builtins.str] email: Specify the preferred support contact email address for receiving alerts and notifications.
        :param pulumi.Input[Sequence[pulumi.Input['DeploymentFrontendPrivateArgs']]] frontend_privates: One or more `frontend_private` blocks as defined below.
        :param pulumi.Input['DeploymentFrontendPublicArgs'] frontend_public: A `frontend_public` block as defined below.
        :param pulumi.Input['DeploymentIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] ip_address: The IP address of the NGINX Deployment.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the NGINX Deployment should exist. Changing this forces a new NGINX Deployment to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this NGINX Deployment. Changing this forces a new NGINX Deployment to be created.
        :param pulumi.Input[Sequence[pulumi.Input['DeploymentNetworkInterfaceArgs']]] network_interfaces: One or more `network_interface` blocks as defined below.
        :param pulumi.Input[_builtins.str] nginx_version: The version of the NGINX Deployment.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the NGINX Deployment should exist. Changing this forces a new NGINX Deployment to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the NGINX Deployment.
        :param pulumi.Input['DeploymentWebApplicationFirewallArgs'] web_application_firewall: A `web_application_firewall` blocks as defined below.
        """
        if auto_scale_profiles is not None:
            pulumi.set(__self__, "auto_scale_profiles", auto_scale_profiles)
        if automatic_upgrade_channel is not None:
            pulumi.set(__self__, "automatic_upgrade_channel", automatic_upgrade_channel)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if dataplane_api_endpoint is not None:
            pulumi.set(__self__, "dataplane_api_endpoint", dataplane_api_endpoint)
        if diagnose_support_enabled is not None:
            pulumi.set(__self__, "diagnose_support_enabled", diagnose_support_enabled)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if frontend_privates is not None:
            pulumi.set(__self__, "frontend_privates", frontend_privates)
        if frontend_public is not None:
            pulumi.set(__self__, "frontend_public", frontend_public)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if logging_storage_accounts is not None:
            warnings.warn("""The `logging_storage_account` block has been deprecated and will be removed in v5.0 of the AzureRM Provider. To enable logs, use the `monitoring.DiagnosticSetting` resource instead.""", DeprecationWarning)
            pulumi.log.warn("""logging_storage_accounts is deprecated: The `logging_storage_account` block has been deprecated and will be removed in v5.0 of the AzureRM Provider. To enable logs, use the `monitoring.DiagnosticSetting` resource instead.""")
        if logging_storage_accounts is not None:
            pulumi.set(__self__, "logging_storage_accounts", logging_storage_accounts)
        if managed_resource_group is not None:
            warnings.warn("""The `managed_resource_group` field isn't supported by the API anymore and has been deprecated and will be removed in v5.0 of the AzureRM Provider.""", DeprecationWarning)
            pulumi.log.warn("""managed_resource_group is deprecated: The `managed_resource_group` field isn't supported by the API anymore and has been deprecated and will be removed in v5.0 of the AzureRM Provider.""")
        if managed_resource_group is not None:
            pulumi.set(__self__, "managed_resource_group", managed_resource_group)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)
        if nginx_version is not None:
            pulumi.set(__self__, "nginx_version", nginx_version)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if web_application_firewall is not None:
            pulumi.set(__self__, "web_application_firewall", web_application_firewall)

    @_builtins.property
    @pulumi.getter(name="autoScaleProfiles")
    def auto_scale_profiles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentAutoScaleProfileArgs']]]]:
        """
        An `auto_scale_profile` block as defined below.
        """
        return pulumi.get(self, "auto_scale_profiles")

    @auto_scale_profiles.setter
    def auto_scale_profiles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentAutoScaleProfileArgs']]]]):
        pulumi.set(self, "auto_scale_profiles", value)

    @_builtins.property
    @pulumi.getter(name="automaticUpgradeChannel")
    def automatic_upgrade_channel(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specify the automatic upgrade channel for the NGINX deployment. Defaults to `stable`. The possible values are `stable` and `preview`.
        """
        return pulumi.get(self, "automatic_upgrade_channel")

    @automatic_upgrade_channel.setter
    def automatic_upgrade_channel(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "automatic_upgrade_channel", value)

    @_builtins.property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specify the number of NGINX capacity units for this NGINX deployment.

        > **Note:** For more information on NGINX capacity units, please refer to the [NGINX scaling guidance documentation](https://docs.nginx.com/nginxaas/azure/quickstart/scaling/)
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "capacity", value)

    @_builtins.property
    @pulumi.getter(name="dataplaneApiEndpoint")
    def dataplane_api_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The dataplane API endpoint of the NGINX Deployment.
        """
        return pulumi.get(self, "dataplane_api_endpoint")

    @dataplane_api_endpoint.setter
    def dataplane_api_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dataplane_api_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="diagnoseSupportEnabled")
    def diagnose_support_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the metrics be exported to Azure Monitor?
        """
        return pulumi.get(self, "diagnose_support_enabled")

    @diagnose_support_enabled.setter
    def diagnose_support_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "diagnose_support_enabled", value)

    @_builtins.property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specify the preferred support contact email address for receiving alerts and notifications.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "email", value)

    @_builtins.property
    @pulumi.getter(name="frontendPrivates")
    def frontend_privates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentFrontendPrivateArgs']]]]:
        """
        One or more `frontend_private` blocks as defined below.
        """
        return pulumi.get(self, "frontend_privates")

    @frontend_privates.setter
    def frontend_privates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentFrontendPrivateArgs']]]]):
        pulumi.set(self, "frontend_privates", value)

    @_builtins.property
    @pulumi.getter(name="frontendPublic")
    def frontend_public(self) -> Optional[pulumi.Input['DeploymentFrontendPublicArgs']]:
        """
        A `frontend_public` block as defined below.
        """
        return pulumi.get(self, "frontend_public")

    @frontend_public.setter
    def frontend_public(self, value: Optional[pulumi.Input['DeploymentFrontendPublicArgs']]):
        pulumi.set(self, "frontend_public", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['DeploymentIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['DeploymentIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP address of the NGINX Deployment.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_address", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the NGINX Deployment should exist. Changing this forces a new NGINX Deployment to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="loggingStorageAccounts")
    @_utilities.deprecated("""The `logging_storage_account` block has been deprecated and will be removed in v5.0 of the AzureRM Provider. To enable logs, use the `monitoring.DiagnosticSetting` resource instead.""")
    def logging_storage_accounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentLoggingStorageAccountArgs']]]]:
        return pulumi.get(self, "logging_storage_accounts")

    @logging_storage_accounts.setter
    def logging_storage_accounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentLoggingStorageAccountArgs']]]]):
        pulumi.set(self, "logging_storage_accounts", value)

    @_builtins.property
    @pulumi.getter(name="managedResourceGroup")
    @_utilities.deprecated("""The `managed_resource_group` field isn't supported by the API anymore and has been deprecated and will be removed in v5.0 of the AzureRM Provider.""")
    def managed_resource_group(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "managed_resource_group")

    @managed_resource_group.setter
    def managed_resource_group(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "managed_resource_group", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this NGINX Deployment. Changing this forces a new NGINX Deployment to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentNetworkInterfaceArgs']]]]:
        """
        One or more `network_interface` blocks as defined below.
        """
        return pulumi.get(self, "network_interfaces")

    @network_interfaces.setter
    def network_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentNetworkInterfaceArgs']]]]):
        pulumi.set(self, "network_interfaces", value)

    @_builtins.property
    @pulumi.getter(name="nginxVersion")
    def nginx_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of the NGINX Deployment.
        """
        return pulumi.get(self, "nginx_version")

    @nginx_version.setter
    def nginx_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nginx_version", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Resource Group where the NGINX Deployment should exist. Changing this forces a new NGINX Deployment to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def sku(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sku", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the NGINX Deployment.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="webApplicationFirewall")
    def web_application_firewall(self) -> Optional[pulumi.Input['DeploymentWebApplicationFirewallArgs']]:
        """
        A `web_application_firewall` blocks as defined below.
        """
        return pulumi.get(self, "web_application_firewall")

    @web_application_firewall.setter
    def web_application_firewall(self, value: Optional[pulumi.Input['DeploymentWebApplicationFirewallArgs']]):
        pulumi.set(self, "web_application_firewall", value)


@pulumi.type_token("azure:nginx/deployment:Deployment")
class Deployment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_scale_profiles: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DeploymentAutoScaleProfileArgs', 'DeploymentAutoScaleProfileArgsDict']]]]] = None,
                 automatic_upgrade_channel: Optional[pulumi.Input[_builtins.str]] = None,
                 capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 diagnose_support_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 frontend_privates: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DeploymentFrontendPrivateArgs', 'DeploymentFrontendPrivateArgsDict']]]]] = None,
                 frontend_public: Optional[pulumi.Input[Union['DeploymentFrontendPublicArgs', 'DeploymentFrontendPublicArgsDict']]] = None,
                 identity: Optional[pulumi.Input[Union['DeploymentIdentityArgs', 'DeploymentIdentityArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 logging_storage_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DeploymentLoggingStorageAccountArgs', 'DeploymentLoggingStorageAccountArgsDict']]]]] = None,
                 managed_resource_group: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DeploymentNetworkInterfaceArgs', 'DeploymentNetworkInterfaceArgsDict']]]]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 web_application_firewall: Optional[pulumi.Input[Union['DeploymentWebApplicationFirewallArgs', 'DeploymentWebApplicationFirewallArgsDict']]] = None,
                 __props__=None):
        """
        Manages an NGINX Deployment.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-rg",
            location="West Europe")
        example_public_ip = azure.network.PublicIp("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            allocation_method="Static",
            sku="Standard",
            tags={
                "environment": "Production",
            })
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-vnet",
            address_spaces=["10.0.0.0/16"],
            location=example.location,
            resource_group_name=example.name)
        example_subnet = azure.network.Subnet("example",
            name="example-subnet",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/24"],
            delegations=[{
                "name": "delegation",
                "service_delegation": {
                    "name": "NGINX.NGINXPLUS/nginxDeployments",
                    "actions": ["Microsoft.Network/virtualNetworks/subnets/join/action"],
                },
            }])
        example_deployment = azure.nginx.Deployment("example",
            name="example-nginx",
            resource_group_name=example.name,
            sku="standardv2_Monthly",
            location=example.location,
            diagnose_support_enabled=True,
            automatic_upgrade_channel="stable",
            frontend_public={
                "ip_addresses": [example_public_ip.id],
            },
            network_interfaces=[{
                "subnet_id": example_subnet.id,
            }],
            capacity=20,
            email="user@test.com")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Nginx.NginxPlus` - 2024-11-01-preview

        ## Import

        NGINX Deployments can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:nginx/deployment:Deployment example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/group1/providers/Nginx.NginxPlus/nginxDeployments/dep1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DeploymentAutoScaleProfileArgs', 'DeploymentAutoScaleProfileArgsDict']]]] auto_scale_profiles: An `auto_scale_profile` block as defined below.
        :param pulumi.Input[_builtins.str] automatic_upgrade_channel: Specify the automatic upgrade channel for the NGINX deployment. Defaults to `stable`. The possible values are `stable` and `preview`.
        :param pulumi.Input[_builtins.int] capacity: Specify the number of NGINX capacity units for this NGINX deployment.
               
               > **Note:** For more information on NGINX capacity units, please refer to the [NGINX scaling guidance documentation](https://docs.nginx.com/nginxaas/azure/quickstart/scaling/)
        :param pulumi.Input[_builtins.bool] diagnose_support_enabled: Should the metrics be exported to Azure Monitor?
        :param pulumi.Input[_builtins.str] email: Specify the preferred support contact email address for receiving alerts and notifications.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DeploymentFrontendPrivateArgs', 'DeploymentFrontendPrivateArgsDict']]]] frontend_privates: One or more `frontend_private` blocks as defined below.
        :param pulumi.Input[Union['DeploymentFrontendPublicArgs', 'DeploymentFrontendPublicArgsDict']] frontend_public: A `frontend_public` block as defined below.
        :param pulumi.Input[Union['DeploymentIdentityArgs', 'DeploymentIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the NGINX Deployment should exist. Changing this forces a new NGINX Deployment to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this NGINX Deployment. Changing this forces a new NGINX Deployment to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DeploymentNetworkInterfaceArgs', 'DeploymentNetworkInterfaceArgsDict']]]] network_interfaces: One or more `network_interface` blocks as defined below.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the NGINX Deployment should exist. Changing this forces a new NGINX Deployment to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the NGINX Deployment.
        :param pulumi.Input[Union['DeploymentWebApplicationFirewallArgs', 'DeploymentWebApplicationFirewallArgsDict']] web_application_firewall: A `web_application_firewall` blocks as defined below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DeploymentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an NGINX Deployment.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-rg",
            location="West Europe")
        example_public_ip = azure.network.PublicIp("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            allocation_method="Static",
            sku="Standard",
            tags={
                "environment": "Production",
            })
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-vnet",
            address_spaces=["10.0.0.0/16"],
            location=example.location,
            resource_group_name=example.name)
        example_subnet = azure.network.Subnet("example",
            name="example-subnet",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/24"],
            delegations=[{
                "name": "delegation",
                "service_delegation": {
                    "name": "NGINX.NGINXPLUS/nginxDeployments",
                    "actions": ["Microsoft.Network/virtualNetworks/subnets/join/action"],
                },
            }])
        example_deployment = azure.nginx.Deployment("example",
            name="example-nginx",
            resource_group_name=example.name,
            sku="standardv2_Monthly",
            location=example.location,
            diagnose_support_enabled=True,
            automatic_upgrade_channel="stable",
            frontend_public={
                "ip_addresses": [example_public_ip.id],
            },
            network_interfaces=[{
                "subnet_id": example_subnet.id,
            }],
            capacity=20,
            email="user@test.com")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Nginx.NginxPlus` - 2024-11-01-preview

        ## Import

        NGINX Deployments can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:nginx/deployment:Deployment example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/group1/providers/Nginx.NginxPlus/nginxDeployments/dep1
        ```

        :param str resource_name: The name of the resource.
        :param DeploymentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DeploymentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_scale_profiles: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DeploymentAutoScaleProfileArgs', 'DeploymentAutoScaleProfileArgsDict']]]]] = None,
                 automatic_upgrade_channel: Optional[pulumi.Input[_builtins.str]] = None,
                 capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 diagnose_support_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 frontend_privates: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DeploymentFrontendPrivateArgs', 'DeploymentFrontendPrivateArgsDict']]]]] = None,
                 frontend_public: Optional[pulumi.Input[Union['DeploymentFrontendPublicArgs', 'DeploymentFrontendPublicArgsDict']]] = None,
                 identity: Optional[pulumi.Input[Union['DeploymentIdentityArgs', 'DeploymentIdentityArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 logging_storage_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DeploymentLoggingStorageAccountArgs', 'DeploymentLoggingStorageAccountArgsDict']]]]] = None,
                 managed_resource_group: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DeploymentNetworkInterfaceArgs', 'DeploymentNetworkInterfaceArgsDict']]]]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 web_application_firewall: Optional[pulumi.Input[Union['DeploymentWebApplicationFirewallArgs', 'DeploymentWebApplicationFirewallArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DeploymentArgs.__new__(DeploymentArgs)

            __props__.__dict__["auto_scale_profiles"] = auto_scale_profiles
            __props__.__dict__["automatic_upgrade_channel"] = automatic_upgrade_channel
            __props__.__dict__["capacity"] = capacity
            __props__.__dict__["diagnose_support_enabled"] = diagnose_support_enabled
            __props__.__dict__["email"] = email
            __props__.__dict__["frontend_privates"] = frontend_privates
            __props__.__dict__["frontend_public"] = frontend_public
            __props__.__dict__["identity"] = identity
            __props__.__dict__["location"] = location
            __props__.__dict__["logging_storage_accounts"] = logging_storage_accounts
            __props__.__dict__["managed_resource_group"] = managed_resource_group
            __props__.__dict__["name"] = name
            __props__.__dict__["network_interfaces"] = network_interfaces
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if sku is None and not opts.urn:
                raise TypeError("Missing required property 'sku'")
            __props__.__dict__["sku"] = sku
            __props__.__dict__["tags"] = tags
            __props__.__dict__["web_application_firewall"] = web_application_firewall
            __props__.__dict__["dataplane_api_endpoint"] = None
            __props__.__dict__["ip_address"] = None
            __props__.__dict__["nginx_version"] = None
        super(Deployment, __self__).__init__(
            'azure:nginx/deployment:Deployment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_scale_profiles: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DeploymentAutoScaleProfileArgs', 'DeploymentAutoScaleProfileArgsDict']]]]] = None,
            automatic_upgrade_channel: Optional[pulumi.Input[_builtins.str]] = None,
            capacity: Optional[pulumi.Input[_builtins.int]] = None,
            dataplane_api_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            diagnose_support_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            email: Optional[pulumi.Input[_builtins.str]] = None,
            frontend_privates: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DeploymentFrontendPrivateArgs', 'DeploymentFrontendPrivateArgsDict']]]]] = None,
            frontend_public: Optional[pulumi.Input[Union['DeploymentFrontendPublicArgs', 'DeploymentFrontendPublicArgsDict']]] = None,
            identity: Optional[pulumi.Input[Union['DeploymentIdentityArgs', 'DeploymentIdentityArgsDict']]] = None,
            ip_address: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            logging_storage_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DeploymentLoggingStorageAccountArgs', 'DeploymentLoggingStorageAccountArgsDict']]]]] = None,
            managed_resource_group: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DeploymentNetworkInterfaceArgs', 'DeploymentNetworkInterfaceArgsDict']]]]] = None,
            nginx_version: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            sku: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            web_application_firewall: Optional[pulumi.Input[Union['DeploymentWebApplicationFirewallArgs', 'DeploymentWebApplicationFirewallArgsDict']]] = None) -> 'Deployment':
        """
        Get an existing Deployment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DeploymentAutoScaleProfileArgs', 'DeploymentAutoScaleProfileArgsDict']]]] auto_scale_profiles: An `auto_scale_profile` block as defined below.
        :param pulumi.Input[_builtins.str] automatic_upgrade_channel: Specify the automatic upgrade channel for the NGINX deployment. Defaults to `stable`. The possible values are `stable` and `preview`.
        :param pulumi.Input[_builtins.int] capacity: Specify the number of NGINX capacity units for this NGINX deployment.
               
               > **Note:** For more information on NGINX capacity units, please refer to the [NGINX scaling guidance documentation](https://docs.nginx.com/nginxaas/azure/quickstart/scaling/)
        :param pulumi.Input[_builtins.str] dataplane_api_endpoint: The dataplane API endpoint of the NGINX Deployment.
        :param pulumi.Input[_builtins.bool] diagnose_support_enabled: Should the metrics be exported to Azure Monitor?
        :param pulumi.Input[_builtins.str] email: Specify the preferred support contact email address for receiving alerts and notifications.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DeploymentFrontendPrivateArgs', 'DeploymentFrontendPrivateArgsDict']]]] frontend_privates: One or more `frontend_private` blocks as defined below.
        :param pulumi.Input[Union['DeploymentFrontendPublicArgs', 'DeploymentFrontendPublicArgsDict']] frontend_public: A `frontend_public` block as defined below.
        :param pulumi.Input[Union['DeploymentIdentityArgs', 'DeploymentIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] ip_address: The IP address of the NGINX Deployment.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the NGINX Deployment should exist. Changing this forces a new NGINX Deployment to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this NGINX Deployment. Changing this forces a new NGINX Deployment to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DeploymentNetworkInterfaceArgs', 'DeploymentNetworkInterfaceArgsDict']]]] network_interfaces: One or more `network_interface` blocks as defined below.
        :param pulumi.Input[_builtins.str] nginx_version: The version of the NGINX Deployment.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the NGINX Deployment should exist. Changing this forces a new NGINX Deployment to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the NGINX Deployment.
        :param pulumi.Input[Union['DeploymentWebApplicationFirewallArgs', 'DeploymentWebApplicationFirewallArgsDict']] web_application_firewall: A `web_application_firewall` blocks as defined below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DeploymentState.__new__(_DeploymentState)

        __props__.__dict__["auto_scale_profiles"] = auto_scale_profiles
        __props__.__dict__["automatic_upgrade_channel"] = automatic_upgrade_channel
        __props__.__dict__["capacity"] = capacity
        __props__.__dict__["dataplane_api_endpoint"] = dataplane_api_endpoint
        __props__.__dict__["diagnose_support_enabled"] = diagnose_support_enabled
        __props__.__dict__["email"] = email
        __props__.__dict__["frontend_privates"] = frontend_privates
        __props__.__dict__["frontend_public"] = frontend_public
        __props__.__dict__["identity"] = identity
        __props__.__dict__["ip_address"] = ip_address
        __props__.__dict__["location"] = location
        __props__.__dict__["logging_storage_accounts"] = logging_storage_accounts
        __props__.__dict__["managed_resource_group"] = managed_resource_group
        __props__.__dict__["name"] = name
        __props__.__dict__["network_interfaces"] = network_interfaces
        __props__.__dict__["nginx_version"] = nginx_version
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["sku"] = sku
        __props__.__dict__["tags"] = tags
        __props__.__dict__["web_application_firewall"] = web_application_firewall
        return Deployment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autoScaleProfiles")
    def auto_scale_profiles(self) -> pulumi.Output[Optional[Sequence['outputs.DeploymentAutoScaleProfile']]]:
        """
        An `auto_scale_profile` block as defined below.
        """
        return pulumi.get(self, "auto_scale_profiles")

    @_builtins.property
    @pulumi.getter(name="automaticUpgradeChannel")
    def automatic_upgrade_channel(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specify the automatic upgrade channel for the NGINX deployment. Defaults to `stable`. The possible values are `stable` and `preview`.
        """
        return pulumi.get(self, "automatic_upgrade_channel")

    @_builtins.property
    @pulumi.getter
    def capacity(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specify the number of NGINX capacity units for this NGINX deployment.

        > **Note:** For more information on NGINX capacity units, please refer to the [NGINX scaling guidance documentation](https://docs.nginx.com/nginxaas/azure/quickstart/scaling/)
        """
        return pulumi.get(self, "capacity")

    @_builtins.property
    @pulumi.getter(name="dataplaneApiEndpoint")
    def dataplane_api_endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        The dataplane API endpoint of the NGINX Deployment.
        """
        return pulumi.get(self, "dataplane_api_endpoint")

    @_builtins.property
    @pulumi.getter(name="diagnoseSupportEnabled")
    def diagnose_support_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should the metrics be exported to Azure Monitor?
        """
        return pulumi.get(self, "diagnose_support_enabled")

    @_builtins.property
    @pulumi.getter
    def email(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specify the preferred support contact email address for receiving alerts and notifications.
        """
        return pulumi.get(self, "email")

    @_builtins.property
    @pulumi.getter(name="frontendPrivates")
    def frontend_privates(self) -> pulumi.Output[Optional[Sequence['outputs.DeploymentFrontendPrivate']]]:
        """
        One or more `frontend_private` blocks as defined below.
        """
        return pulumi.get(self, "frontend_privates")

    @_builtins.property
    @pulumi.getter(name="frontendPublic")
    def frontend_public(self) -> pulumi.Output[Optional['outputs.DeploymentFrontendPublic']]:
        """
        A `frontend_public` block as defined below.
        """
        return pulumi.get(self, "frontend_public")

    @_builtins.property
    @pulumi.getter
    def identity(self) -> pulumi.Output[Optional['outputs.DeploymentIdentity']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Output[_builtins.str]:
        """
        The IP address of the NGINX Deployment.
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The Azure Region where the NGINX Deployment should exist. Changing this forces a new NGINX Deployment to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="loggingStorageAccounts")
    @_utilities.deprecated("""The `logging_storage_account` block has been deprecated and will be removed in v5.0 of the AzureRM Provider. To enable logs, use the `monitoring.DiagnosticSetting` resource instead.""")
    def logging_storage_accounts(self) -> pulumi.Output[Optional[Sequence['outputs.DeploymentLoggingStorageAccount']]]:
        return pulumi.get(self, "logging_storage_accounts")

    @_builtins.property
    @pulumi.getter(name="managedResourceGroup")
    @_utilities.deprecated("""The `managed_resource_group` field isn't supported by the API anymore and has been deprecated and will be removed in v5.0 of the AzureRM Provider.""")
    def managed_resource_group(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "managed_resource_group")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this NGINX Deployment. Changing this forces a new NGINX Deployment to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> pulumi.Output[Optional[Sequence['outputs.DeploymentNetworkInterface']]]:
        """
        One or more `network_interface` blocks as defined below.
        """
        return pulumi.get(self, "network_interfaces")

    @_builtins.property
    @pulumi.getter(name="nginxVersion")
    def nginx_version(self) -> pulumi.Output[_builtins.str]:
        """
        The version of the NGINX Deployment.
        """
        return pulumi.get(self, "nginx_version")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Resource Group where the NGINX Deployment should exist. Changing this forces a new NGINX Deployment to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def sku(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "sku")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags which should be assigned to the NGINX Deployment.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="webApplicationFirewall")
    def web_application_firewall(self) -> pulumi.Output[Optional['outputs.DeploymentWebApplicationFirewall']]:
        """
        A `web_application_firewall` blocks as defined below.
        """
        return pulumi.get(self, "web_application_firewall")

