# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetFlexibleServerResult',
    'AwaitableGetFlexibleServerResult',
    'get_flexible_server',
    'get_flexible_server_output',
]

@pulumi.output_type
class GetFlexibleServerResult:
    """
    A collection of values returned by getFlexibleServer.
    """
    def __init__(__self__, administrator_login=None, auto_grow_enabled=None, backup_retention_days=None, delegated_subnet_id=None, fqdn=None, id=None, location=None, name=None, public_network_access_enabled=None, resource_group_name=None, sku_name=None, storage_mb=None, tags=None, version=None):
        if administrator_login and not isinstance(administrator_login, str):
            raise TypeError("Expected argument 'administrator_login' to be a str")
        pulumi.set(__self__, "administrator_login", administrator_login)
        if auto_grow_enabled and not isinstance(auto_grow_enabled, bool):
            raise TypeError("Expected argument 'auto_grow_enabled' to be a bool")
        pulumi.set(__self__, "auto_grow_enabled", auto_grow_enabled)
        if backup_retention_days and not isinstance(backup_retention_days, int):
            raise TypeError("Expected argument 'backup_retention_days' to be a int")
        pulumi.set(__self__, "backup_retention_days", backup_retention_days)
        if delegated_subnet_id and not isinstance(delegated_subnet_id, str):
            raise TypeError("Expected argument 'delegated_subnet_id' to be a str")
        pulumi.set(__self__, "delegated_subnet_id", delegated_subnet_id)
        if fqdn and not isinstance(fqdn, str):
            raise TypeError("Expected argument 'fqdn' to be a str")
        pulumi.set(__self__, "fqdn", fqdn)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if public_network_access_enabled and not isinstance(public_network_access_enabled, bool):
            raise TypeError("Expected argument 'public_network_access_enabled' to be a bool")
        pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if sku_name and not isinstance(sku_name, str):
            raise TypeError("Expected argument 'sku_name' to be a str")
        pulumi.set(__self__, "sku_name", sku_name)
        if storage_mb and not isinstance(storage_mb, int):
            raise TypeError("Expected argument 'storage_mb' to be a int")
        pulumi.set(__self__, "storage_mb", storage_mb)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="administratorLogin")
    def administrator_login(self) -> _builtins.str:
        """
        The Administrator login for the PostgreSQL Flexible Server.
        """
        return pulumi.get(self, "administrator_login")

    @_builtins.property
    @pulumi.getter(name="autoGrowEnabled")
    def auto_grow_enabled(self) -> _builtins.bool:
        """
        Is the storage auto grow for PostgreSQL Flexible Server enabled?
        """
        return pulumi.get(self, "auto_grow_enabled")

    @_builtins.property
    @pulumi.getter(name="backupRetentionDays")
    def backup_retention_days(self) -> _builtins.int:
        """
        The backup retention days for the PostgreSQL Flexible Server.
        """
        return pulumi.get(self, "backup_retention_days")

    @_builtins.property
    @pulumi.getter(name="delegatedSubnetId")
    def delegated_subnet_id(self) -> _builtins.str:
        """
        The ID of the virtual network subnet to create the PostgreSQL Flexible Server.
        """
        return pulumi.get(self, "delegated_subnet_id")

    @_builtins.property
    @pulumi.getter
    def fqdn(self) -> _builtins.str:
        """
        The FQDN of the PostgreSQL Flexible Server.
        """
        return pulumi.get(self, "fqdn")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        The Azure Region where the PostgreSQL Flexible Server exists.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> _builtins.bool:
        """
        Is public network access enabled?
        """
        return pulumi.get(self, "public_network_access_enabled")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> _builtins.str:
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> _builtins.str:
        """
        The SKU Name for the PostgreSQL Flexible Server. The name of the SKU, follows the `tier` + `name` pattern (e.g. `B_Standard_B1ms`, `GP_Standard_D2s_v3`, `MO_Standard_E4s_v3`).
        """
        return pulumi.get(self, "sku_name")

    @_builtins.property
    @pulumi.getter(name="storageMb")
    def storage_mb(self) -> _builtins.int:
        """
        The max storage allowed for the PostgreSQL Flexible Server.
        """
        return pulumi.get(self, "storage_mb")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A mapping of tags assigned to the PostgreSQL Flexible Server.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        The version of PostgreSQL Flexible Server to use.
        """
        return pulumi.get(self, "version")


class AwaitableGetFlexibleServerResult(GetFlexibleServerResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFlexibleServerResult(
            administrator_login=self.administrator_login,
            auto_grow_enabled=self.auto_grow_enabled,
            backup_retention_days=self.backup_retention_days,
            delegated_subnet_id=self.delegated_subnet_id,
            fqdn=self.fqdn,
            id=self.id,
            location=self.location,
            name=self.name,
            public_network_access_enabled=self.public_network_access_enabled,
            resource_group_name=self.resource_group_name,
            sku_name=self.sku_name,
            storage_mb=self.storage_mb,
            tags=self.tags,
            version=self.version)


def get_flexible_server(name: Optional[_builtins.str] = None,
                        resource_group_name: Optional[_builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFlexibleServerResult:
    """
    Use this data source to access information about an existing PostgreSQL Flexible Server.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.postgresql.get_flexible_server(name="existing-postgresql-fs",
        resource_group_name="existing-postgresql-resgroup")
    pulumi.export("id", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.DBforPostgreSQL` - 2024-08-01


    :param _builtins.str name: The name of this PostgreSQL Flexible Server.
    :param _builtins.str resource_group_name: The name of the Resource Group where the PostgreSQL Flexible Server exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:postgresql/getFlexibleServer:getFlexibleServer', __args__, opts=opts, typ=GetFlexibleServerResult).value

    return AwaitableGetFlexibleServerResult(
        administrator_login=pulumi.get(__ret__, 'administrator_login'),
        auto_grow_enabled=pulumi.get(__ret__, 'auto_grow_enabled'),
        backup_retention_days=pulumi.get(__ret__, 'backup_retention_days'),
        delegated_subnet_id=pulumi.get(__ret__, 'delegated_subnet_id'),
        fqdn=pulumi.get(__ret__, 'fqdn'),
        id=pulumi.get(__ret__, 'id'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        public_network_access_enabled=pulumi.get(__ret__, 'public_network_access_enabled'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        sku_name=pulumi.get(__ret__, 'sku_name'),
        storage_mb=pulumi.get(__ret__, 'storage_mb'),
        tags=pulumi.get(__ret__, 'tags'),
        version=pulumi.get(__ret__, 'version'))
def get_flexible_server_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                               resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFlexibleServerResult]:
    """
    Use this data source to access information about an existing PostgreSQL Flexible Server.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.postgresql.get_flexible_server(name="existing-postgresql-fs",
        resource_group_name="existing-postgresql-resgroup")
    pulumi.export("id", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.DBforPostgreSQL` - 2024-08-01


    :param _builtins.str name: The name of this PostgreSQL Flexible Server.
    :param _builtins.str resource_group_name: The name of the Resource Group where the PostgreSQL Flexible Server exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:postgresql/getFlexibleServer:getFlexibleServer', __args__, opts=opts, typ=GetFlexibleServerResult)
    return __ret__.apply(lambda __response__: GetFlexibleServerResult(
        administrator_login=pulumi.get(__response__, 'administrator_login'),
        auto_grow_enabled=pulumi.get(__response__, 'auto_grow_enabled'),
        backup_retention_days=pulumi.get(__response__, 'backup_retention_days'),
        delegated_subnet_id=pulumi.get(__response__, 'delegated_subnet_id'),
        fqdn=pulumi.get(__response__, 'fqdn'),
        id=pulumi.get(__response__, 'id'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        public_network_access_enabled=pulumi.get(__response__, 'public_network_access_enabled'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        sku_name=pulumi.get(__response__, 'sku_name'),
        storage_mb=pulumi.get(__response__, 'storage_mb'),
        tags=pulumi.get(__response__, 'tags'),
        version=pulumi.get(__response__, 'version')))
