# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'LinkServiceNatIpConfiguration',
    'MxRecordRecord',
    'ResolverForwardingRuleTargetDnsServer',
    'ResolverInboundEndpointIpConfigurations',
    'SRVRecordRecord',
    'TxtRecordRecord',
    'ZoneSoaRecord',
    'GetMxRecordRecordResult',
    'GetResolverForwardingRuleTargetDnsServerResult',
    'GetResolverInboundEndpointIpConfigurationResult',
    'GetSrvRecordRecordResult',
    'GetTxtRecordRecordResult',
]

@pulumi.output_type
class LinkServiceNatIpConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subnetId":
            suggest = "subnet_id"
        elif key == "privateIpAddress":
            suggest = "private_ip_address"
        elif key == "privateIpAddressVersion":
            suggest = "private_ip_address_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LinkServiceNatIpConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LinkServiceNatIpConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LinkServiceNatIpConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 primary: _builtins.bool,
                 subnet_id: _builtins.str,
                 private_ip_address: Optional[_builtins.str] = None,
                 private_ip_address_version: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: Specifies the name which should be used for the NAT IP Configuration. Changing this forces a new resource to be created.
        :param _builtins.bool primary: Is this is the Primary IP Configuration? Changing this forces a new resource to be created.
        :param _builtins.str subnet_id: Specifies the ID of the Subnet which should be used for the Private Link Service.
               
               > **Note:** Verify that the Subnet's `enforce_private_link_service_network_policies` attribute is set to `true`.
        :param _builtins.str private_ip_address: Specifies a Private Static IP Address for this IP Configuration.
        :param _builtins.str private_ip_address_version: The version of the IP Protocol which should be used. At this time the only supported value is `IPv4`. Defaults to `IPv4`.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "primary", primary)
        pulumi.set(__self__, "subnet_id", subnet_id)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if private_ip_address_version is not None:
            pulumi.set(__self__, "private_ip_address_version", private_ip_address_version)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the name which should be used for the NAT IP Configuration. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def primary(self) -> _builtins.bool:
        """
        Is this is the Primary IP Configuration? Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "primary")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> _builtins.str:
        """
        Specifies the ID of the Subnet which should be used for the Private Link Service.

        > **Note:** Verify that the Subnet's `enforce_private_link_service_network_policies` attribute is set to `true`.
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> Optional[_builtins.str]:
        """
        Specifies a Private Static IP Address for this IP Configuration.
        """
        return pulumi.get(self, "private_ip_address")

    @_builtins.property
    @pulumi.getter(name="privateIpAddressVersion")
    def private_ip_address_version(self) -> Optional[_builtins.str]:
        """
        The version of the IP Protocol which should be used. At this time the only supported value is `IPv4`. Defaults to `IPv4`.
        """
        return pulumi.get(self, "private_ip_address_version")


@pulumi.output_type
class MxRecordRecord(dict):
    def __init__(__self__, *,
                 exchange: _builtins.str,
                 preference: _builtins.int):
        """
        :param _builtins.str exchange: The FQDN of the exchange to MX record points to.
        :param _builtins.int preference: The preference of the MX record.
        """
        pulumi.set(__self__, "exchange", exchange)
        pulumi.set(__self__, "preference", preference)

    @_builtins.property
    @pulumi.getter
    def exchange(self) -> _builtins.str:
        """
        The FQDN of the exchange to MX record points to.
        """
        return pulumi.get(self, "exchange")

    @_builtins.property
    @pulumi.getter
    def preference(self) -> _builtins.int:
        """
        The preference of the MX record.
        """
        return pulumi.get(self, "preference")


@pulumi.output_type
class ResolverForwardingRuleTargetDnsServer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipAddress":
            suggest = "ip_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResolverForwardingRuleTargetDnsServer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResolverForwardingRuleTargetDnsServer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResolverForwardingRuleTargetDnsServer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_address: _builtins.str,
                 port: Optional[_builtins.int] = None):
        """
        :param _builtins.str ip_address: DNS server IP address.
        :param _builtins.int port: DNS server port.
        """
        pulumi.set(__self__, "ip_address", ip_address)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> _builtins.str:
        """
        DNS server IP address.
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        DNS server port.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class ResolverInboundEndpointIpConfigurations(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subnetId":
            suggest = "subnet_id"
        elif key == "privateIpAddress":
            suggest = "private_ip_address"
        elif key == "privateIpAllocationMethod":
            suggest = "private_ip_allocation_method"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResolverInboundEndpointIpConfigurations. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResolverInboundEndpointIpConfigurations.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResolverInboundEndpointIpConfigurations.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 subnet_id: _builtins.str,
                 private_ip_address: Optional[_builtins.str] = None,
                 private_ip_allocation_method: Optional[_builtins.str] = None):
        """
        :param _builtins.str subnet_id: The subnet ID of the IP configuration.
        :param _builtins.str private_ip_address: Private IP address of the IP configuration.
        :param _builtins.str private_ip_allocation_method: Private IP address allocation method. Allowed value is `Dynamic` and `Static`. Defaults to `Dynamic`.
        """
        pulumi.set(__self__, "subnet_id", subnet_id)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if private_ip_allocation_method is not None:
            pulumi.set(__self__, "private_ip_allocation_method", private_ip_allocation_method)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> _builtins.str:
        """
        The subnet ID of the IP configuration.
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> Optional[_builtins.str]:
        """
        Private IP address of the IP configuration.
        """
        return pulumi.get(self, "private_ip_address")

    @_builtins.property
    @pulumi.getter(name="privateIpAllocationMethod")
    def private_ip_allocation_method(self) -> Optional[_builtins.str]:
        """
        Private IP address allocation method. Allowed value is `Dynamic` and `Static`. Defaults to `Dynamic`.
        """
        return pulumi.get(self, "private_ip_allocation_method")


@pulumi.output_type
class SRVRecordRecord(dict):
    def __init__(__self__, *,
                 port: _builtins.int,
                 priority: _builtins.int,
                 target: _builtins.str,
                 weight: _builtins.int):
        """
        :param _builtins.int port: The Port the service is listening on.
        :param _builtins.int priority: The priority of the SRV record.
        :param _builtins.str target: The FQDN of the service.
        :param _builtins.int weight: The Weight of the SRV record.
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "target", target)
        pulumi.set(__self__, "weight", weight)

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The Port the service is listening on.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> _builtins.int:
        """
        The priority of the SRV record.
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter
    def target(self) -> _builtins.str:
        """
        The FQDN of the service.
        """
        return pulumi.get(self, "target")

    @_builtins.property
    @pulumi.getter
    def weight(self) -> _builtins.int:
        """
        The Weight of the SRV record.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class TxtRecordRecord(dict):
    def __init__(__self__, *,
                 value: _builtins.str):
        """
        :param _builtins.str value: The value of the TXT record. Max length: 1024 characters
        """
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The value of the TXT record. Max length: 1024 characters
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ZoneSoaRecord(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expireTime":
            suggest = "expire_time"
        elif key == "hostName":
            suggest = "host_name"
        elif key == "minimumTtl":
            suggest = "minimum_ttl"
        elif key == "refreshTime":
            suggest = "refresh_time"
        elif key == "retryTime":
            suggest = "retry_time"
        elif key == "serialNumber":
            suggest = "serial_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ZoneSoaRecord. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ZoneSoaRecord.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ZoneSoaRecord.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 email: _builtins.str,
                 expire_time: Optional[_builtins.int] = None,
                 fqdn: Optional[_builtins.str] = None,
                 host_name: Optional[_builtins.str] = None,
                 minimum_ttl: Optional[_builtins.int] = None,
                 refresh_time: Optional[_builtins.int] = None,
                 retry_time: Optional[_builtins.int] = None,
                 serial_number: Optional[_builtins.int] = None,
                 tags: Optional[Mapping[str, _builtins.str]] = None,
                 ttl: Optional[_builtins.int] = None):
        """
        :param _builtins.str email: The email contact for the SOA record.
        :param _builtins.int expire_time: The expire time for the SOA record. Defaults to `2419200`.
        :param _builtins.str fqdn: The fully qualified domain name of the Record Set.
        :param _builtins.str host_name: The domain name of the authoritative name server for the SOA record.
        :param _builtins.int minimum_ttl: The minimum Time To Live for the SOA record. By convention, it is used to determine the negative caching duration. Defaults to `10`.
        :param _builtins.int refresh_time: The refresh time for the SOA record. Defaults to `3600`.
        :param _builtins.int retry_time: The retry time for the SOA record. Defaults to `300`.
        :param _builtins.int serial_number: The serial number for the SOA record.
        :param Mapping[str, _builtins.str] tags: A mapping of tags to assign to the Record Set.
        :param _builtins.int ttl: The Time To Live of the SOA Record in seconds. Defaults to `3600`.
        """
        pulumi.set(__self__, "email", email)
        if expire_time is not None:
            pulumi.set(__self__, "expire_time", expire_time)
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if minimum_ttl is not None:
            pulumi.set(__self__, "minimum_ttl", minimum_ttl)
        if refresh_time is not None:
            pulumi.set(__self__, "refresh_time", refresh_time)
        if retry_time is not None:
            pulumi.set(__self__, "retry_time", retry_time)
        if serial_number is not None:
            pulumi.set(__self__, "serial_number", serial_number)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)

    @_builtins.property
    @pulumi.getter
    def email(self) -> _builtins.str:
        """
        The email contact for the SOA record.
        """
        return pulumi.get(self, "email")

    @_builtins.property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> Optional[_builtins.int]:
        """
        The expire time for the SOA record. Defaults to `2419200`.
        """
        return pulumi.get(self, "expire_time")

    @_builtins.property
    @pulumi.getter
    def fqdn(self) -> Optional[_builtins.str]:
        """
        The fully qualified domain name of the Record Set.
        """
        return pulumi.get(self, "fqdn")

    @_builtins.property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[_builtins.str]:
        """
        The domain name of the authoritative name server for the SOA record.
        """
        return pulumi.get(self, "host_name")

    @_builtins.property
    @pulumi.getter(name="minimumTtl")
    def minimum_ttl(self) -> Optional[_builtins.int]:
        """
        The minimum Time To Live for the SOA record. By convention, it is used to determine the negative caching duration. Defaults to `10`.
        """
        return pulumi.get(self, "minimum_ttl")

    @_builtins.property
    @pulumi.getter(name="refreshTime")
    def refresh_time(self) -> Optional[_builtins.int]:
        """
        The refresh time for the SOA record. Defaults to `3600`.
        """
        return pulumi.get(self, "refresh_time")

    @_builtins.property
    @pulumi.getter(name="retryTime")
    def retry_time(self) -> Optional[_builtins.int]:
        """
        The retry time for the SOA record. Defaults to `300`.
        """
        return pulumi.get(self, "retry_time")

    @_builtins.property
    @pulumi.getter(name="serialNumber")
    def serial_number(self) -> Optional[_builtins.int]:
        """
        The serial number for the SOA record.
        """
        return pulumi.get(self, "serial_number")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A mapping of tags to assign to the Record Set.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> Optional[_builtins.int]:
        """
        The Time To Live of the SOA Record in seconds. Defaults to `3600`.
        """
        return pulumi.get(self, "ttl")


@pulumi.output_type
class GetMxRecordRecordResult(dict):
    def __init__(__self__, *,
                 exchange: _builtins.str,
                 preference: _builtins.int):
        """
        :param _builtins.str exchange: The mail server responsible for the domain covered by the MX record.
        :param _builtins.int preference: String representing the "preference” value of the MX records. Records with lower preference value take priority.
        """
        pulumi.set(__self__, "exchange", exchange)
        pulumi.set(__self__, "preference", preference)

    @_builtins.property
    @pulumi.getter
    def exchange(self) -> _builtins.str:
        """
        The mail server responsible for the domain covered by the MX record.
        """
        return pulumi.get(self, "exchange")

    @_builtins.property
    @pulumi.getter
    def preference(self) -> _builtins.int:
        """
        String representing the "preference” value of the MX records. Records with lower preference value take priority.
        """
        return pulumi.get(self, "preference")


@pulumi.output_type
class GetResolverForwardingRuleTargetDnsServerResult(dict):
    def __init__(__self__, *,
                 ip_address: _builtins.str,
                 port: _builtins.int):
        """
        :param _builtins.str ip_address: The DNS server IP address.
        :param _builtins.int port: The DNS server port.
        """
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> _builtins.str:
        """
        The DNS server IP address.
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The DNS server port.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class GetResolverInboundEndpointIpConfigurationResult(dict):
    def __init__(__self__, *,
                 private_ip_address: _builtins.str,
                 private_ip_allocation_method: _builtins.str,
                 subnet_id: _builtins.str):
        """
        :param _builtins.str private_ip_address: The private IP address of the IP configuration.
        :param _builtins.str private_ip_allocation_method: The private IP address allocation method.
        :param _builtins.str subnet_id: The subnet ID of the IP configuration.
        """
        pulumi.set(__self__, "private_ip_address", private_ip_address)
        pulumi.set(__self__, "private_ip_allocation_method", private_ip_allocation_method)
        pulumi.set(__self__, "subnet_id", subnet_id)

    @_builtins.property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> _builtins.str:
        """
        The private IP address of the IP configuration.
        """
        return pulumi.get(self, "private_ip_address")

    @_builtins.property
    @pulumi.getter(name="privateIpAllocationMethod")
    def private_ip_allocation_method(self) -> _builtins.str:
        """
        The private IP address allocation method.
        """
        return pulumi.get(self, "private_ip_allocation_method")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> _builtins.str:
        """
        The subnet ID of the IP configuration.
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class GetSrvRecordRecordResult(dict):
    def __init__(__self__, *,
                 port: _builtins.int,
                 priority: _builtins.int,
                 target: _builtins.str,
                 weight: _builtins.int):
        """
        :param _builtins.int port: Port the service is listening on.
        :param _builtins.int priority: Priority of the SRV record.
        :param _builtins.str target: FQDN of the service.
        :param _builtins.int weight: Weight of the SRV record.
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "target", target)
        pulumi.set(__self__, "weight", weight)

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        Port the service is listening on.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> _builtins.int:
        """
        Priority of the SRV record.
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter
    def target(self) -> _builtins.str:
        """
        FQDN of the service.
        """
        return pulumi.get(self, "target")

    @_builtins.property
    @pulumi.getter
    def weight(self) -> _builtins.int:
        """
        Weight of the SRV record.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class GetTxtRecordRecordResult(dict):
    def __init__(__self__, *,
                 value: _builtins.str):
        """
        :param _builtins.str value: The value of the record. Max length: 1024 characters
        """
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The value of the record. Max length: 1024 characters
        """
        return pulumi.get(self, "value")


