# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'VaultEncryptionArgs',
    'VaultEncryptionArgsDict',
    'VaultIdentityArgs',
    'VaultIdentityArgsDict',
    'VaultMonitoringArgs',
    'VaultMonitoringArgsDict',
]

MYPY = False

if not MYPY:
    class VaultEncryptionArgsDict(TypedDict):
        infrastructure_encryption_enabled: pulumi.Input[_builtins.bool]
        """
        Enabling/Disabling the Double Encryption state.
        """
        key_id: pulumi.Input[_builtins.str]
        """
        The Key Vault key id used to encrypt this vault. Key managed by Vault Managed Hardware Security Module is also supported.
        """
        use_system_assigned_identity: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Indicate that system assigned identity should be used or not. Defaults to `true`. Must be set to `false` when `user_assigned_identity_id` is set.

        !> **Note:** `use_system_assigned_identity` only be able to set to `false` for **new** vaults. Any vaults containing existing items registered or attempted to be registered to it are not supported. Details can be found in [the document](https://learn.microsoft.com/en-us/azure/backup/encryption-at-rest-with-cmk?tabs=portal#before-you-start)

        !> **Note:** Once `infrastructure_encryption_enabled` has been set it's not possible to change it.
        """
        user_assigned_identity_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the user assigned identity ID to be used.
        """
elif False:
    VaultEncryptionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VaultEncryptionArgs:
    def __init__(__self__, *,
                 infrastructure_encryption_enabled: pulumi.Input[_builtins.bool],
                 key_id: pulumi.Input[_builtins.str],
                 use_system_assigned_identity: Optional[pulumi.Input[_builtins.bool]] = None,
                 user_assigned_identity_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.bool] infrastructure_encryption_enabled: Enabling/Disabling the Double Encryption state.
        :param pulumi.Input[_builtins.str] key_id: The Key Vault key id used to encrypt this vault. Key managed by Vault Managed Hardware Security Module is also supported.
        :param pulumi.Input[_builtins.bool] use_system_assigned_identity: Indicate that system assigned identity should be used or not. Defaults to `true`. Must be set to `false` when `user_assigned_identity_id` is set.
               
               !> **Note:** `use_system_assigned_identity` only be able to set to `false` for **new** vaults. Any vaults containing existing items registered or attempted to be registered to it are not supported. Details can be found in [the document](https://learn.microsoft.com/en-us/azure/backup/encryption-at-rest-with-cmk?tabs=portal#before-you-start)
               
               !> **Note:** Once `infrastructure_encryption_enabled` has been set it's not possible to change it.
        :param pulumi.Input[_builtins.str] user_assigned_identity_id: Specifies the user assigned identity ID to be used.
        """
        pulumi.set(__self__, "infrastructure_encryption_enabled", infrastructure_encryption_enabled)
        pulumi.set(__self__, "key_id", key_id)
        if use_system_assigned_identity is not None:
            pulumi.set(__self__, "use_system_assigned_identity", use_system_assigned_identity)
        if user_assigned_identity_id is not None:
            pulumi.set(__self__, "user_assigned_identity_id", user_assigned_identity_id)

    @_builtins.property
    @pulumi.getter(name="infrastructureEncryptionEnabled")
    def infrastructure_encryption_enabled(self) -> pulumi.Input[_builtins.bool]:
        """
        Enabling/Disabling the Double Encryption state.
        """
        return pulumi.get(self, "infrastructure_encryption_enabled")

    @infrastructure_encryption_enabled.setter
    def infrastructure_encryption_enabled(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "infrastructure_encryption_enabled", value)

    @_builtins.property
    @pulumi.getter(name="keyId")
    def key_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Key Vault key id used to encrypt this vault. Key managed by Vault Managed Hardware Security Module is also supported.
        """
        return pulumi.get(self, "key_id")

    @key_id.setter
    def key_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key_id", value)

    @_builtins.property
    @pulumi.getter(name="useSystemAssignedIdentity")
    def use_system_assigned_identity(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicate that system assigned identity should be used or not. Defaults to `true`. Must be set to `false` when `user_assigned_identity_id` is set.

        !> **Note:** `use_system_assigned_identity` only be able to set to `false` for **new** vaults. Any vaults containing existing items registered or attempted to be registered to it are not supported. Details can be found in [the document](https://learn.microsoft.com/en-us/azure/backup/encryption-at-rest-with-cmk?tabs=portal#before-you-start)

        !> **Note:** Once `infrastructure_encryption_enabled` has been set it's not possible to change it.
        """
        return pulumi.get(self, "use_system_assigned_identity")

    @use_system_assigned_identity.setter
    def use_system_assigned_identity(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_system_assigned_identity", value)

    @_builtins.property
    @pulumi.getter(name="userAssignedIdentityId")
    def user_assigned_identity_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the user assigned identity ID to be used.
        """
        return pulumi.get(self, "user_assigned_identity_id")

    @user_assigned_identity_id.setter
    def user_assigned_identity_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_assigned_identity_id", value)


if not MYPY:
    class VaultIdentityArgsDict(TypedDict):
        type: pulumi.Input[_builtins.str]
        """
        Specifies the type of Managed Service Identity that should be configured on this Recovery Services Vault. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both).
        """
        identity_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        A list of User Assigned Managed Identity IDs to be assigned to this App Configuration.

        > **Note:** `identity_ids` is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        principal_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Principal ID associated with this Managed Service Identity.
        """
        tenant_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Tenant ID associated with this Managed Service Identity.
        """
elif False:
    VaultIdentityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VaultIdentityArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[_builtins.str],
                 identity_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 principal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] type: Specifies the type of Managed Service Identity that should be configured on this Recovery Services Vault. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] identity_ids: A list of User Assigned Managed Identity IDs to be assigned to this App Configuration.
               
               > **Note:** `identity_ids` is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        :param pulumi.Input[_builtins.str] principal_id: The Principal ID associated with this Managed Service Identity.
        :param pulumi.Input[_builtins.str] tenant_id: The Tenant ID associated with this Managed Service Identity.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the type of Managed Service Identity that should be configured on this Recovery Services Vault. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both).
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of User Assigned Managed Identity IDs to be assigned to this App Configuration.

        > **Note:** `identity_ids` is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        return pulumi.get(self, "identity_ids")

    @identity_ids.setter
    def identity_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "identity_ids", value)

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Principal ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "principal_id", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Tenant ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)


if not MYPY:
    class VaultMonitoringArgsDict(TypedDict):
        alerts_for_all_job_failures_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Enabling/Disabling built-in Azure Monitor alerts for security scenarios and job failure scenarios. Defaults to `true`.
        """
        alerts_for_critical_operation_failures_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Enabling/Disabling alerts from the older (classic alerts) solution. Defaults to `true`. More details could be found [here](https://learn.microsoft.com/en-us/azure/backup/monitoring-and-alerts-overview).
        """
elif False:
    VaultMonitoringArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VaultMonitoringArgs:
    def __init__(__self__, *,
                 alerts_for_all_job_failures_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 alerts_for_critical_operation_failures_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        :param pulumi.Input[_builtins.bool] alerts_for_all_job_failures_enabled: Enabling/Disabling built-in Azure Monitor alerts for security scenarios and job failure scenarios. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] alerts_for_critical_operation_failures_enabled: Enabling/Disabling alerts from the older (classic alerts) solution. Defaults to `true`. More details could be found [here](https://learn.microsoft.com/en-us/azure/backup/monitoring-and-alerts-overview).
        """
        if alerts_for_all_job_failures_enabled is not None:
            pulumi.set(__self__, "alerts_for_all_job_failures_enabled", alerts_for_all_job_failures_enabled)
        if alerts_for_critical_operation_failures_enabled is not None:
            pulumi.set(__self__, "alerts_for_critical_operation_failures_enabled", alerts_for_critical_operation_failures_enabled)

    @_builtins.property
    @pulumi.getter(name="alertsForAllJobFailuresEnabled")
    def alerts_for_all_job_failures_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enabling/Disabling built-in Azure Monitor alerts for security scenarios and job failure scenarios. Defaults to `true`.
        """
        return pulumi.get(self, "alerts_for_all_job_failures_enabled")

    @alerts_for_all_job_failures_enabled.setter
    def alerts_for_all_job_failures_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "alerts_for_all_job_failures_enabled", value)

    @_builtins.property
    @pulumi.getter(name="alertsForCriticalOperationFailuresEnabled")
    def alerts_for_critical_operation_failures_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enabling/Disabling alerts from the older (classic alerts) solution. Defaults to `true`. More details could be found [here](https://learn.microsoft.com/en-us/azure/backup/monitoring-and-alerts-overview).
        """
        return pulumi.get(self, "alerts_for_critical_operation_failures_enabled")

    @alerts_for_critical_operation_failures_enabled.setter
    def alerts_for_critical_operation_failures_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "alerts_for_critical_operation_failures_enabled", value)


