# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SubscriptionPricingArgs', 'SubscriptionPricing']

@pulumi.input_type
class SubscriptionPricingArgs:
    def __init__(__self__, *,
                 tier: pulumi.Input[_builtins.str],
                 extensions: Optional[pulumi.Input[Sequence[pulumi.Input['SubscriptionPricingExtensionArgs']]]] = None,
                 resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 subplan: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a SubscriptionPricing resource.
        :param pulumi.Input[_builtins.str] tier: The pricing tier to use. Possible values are `Free` and `Standard`.
        :param pulumi.Input[Sequence[pulumi.Input['SubscriptionPricingExtensionArgs']]] extensions: One or more `extension` blocks as defined below.
        :param pulumi.Input[_builtins.str] resource_type: The resource type this setting affects. Possible values are `AI`, `Api`, `AppServices`, `ContainerRegistry`, `KeyVaults`, `KubernetesService`, `SqlServers`, `SqlServerVirtualMachines`, `StorageAccounts`, `VirtualMachines`, `Arm`, `Dns`, `OpenSourceRelationalDatabases`, `Containers`, `CosmosDbs` and `CloudPosture`. Defaults to `VirtualMachines`
        :param pulumi.Input[_builtins.str] subplan: Resource type pricing subplan. Contact your MSFT representative for possible values. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "tier", tier)
        if extensions is not None:
            pulumi.set(__self__, "extensions", extensions)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)
        if subplan is not None:
            pulumi.set(__self__, "subplan", subplan)

    @_builtins.property
    @pulumi.getter
    def tier(self) -> pulumi.Input[_builtins.str]:
        """
        The pricing tier to use. Possible values are `Free` and `Standard`.
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "tier", value)

    @_builtins.property
    @pulumi.getter
    def extensions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SubscriptionPricingExtensionArgs']]]]:
        """
        One or more `extension` blocks as defined below.
        """
        return pulumi.get(self, "extensions")

    @extensions.setter
    def extensions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SubscriptionPricingExtensionArgs']]]]):
        pulumi.set(self, "extensions", value)

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource type this setting affects. Possible values are `AI`, `Api`, `AppServices`, `ContainerRegistry`, `KeyVaults`, `KubernetesService`, `SqlServers`, `SqlServerVirtualMachines`, `StorageAccounts`, `VirtualMachines`, `Arm`, `Dns`, `OpenSourceRelationalDatabases`, `Containers`, `CosmosDbs` and `CloudPosture`. Defaults to `VirtualMachines`
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_type", value)

    @_builtins.property
    @pulumi.getter
    def subplan(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource type pricing subplan. Contact your MSFT representative for possible values. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "subplan")

    @subplan.setter
    def subplan(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subplan", value)


@pulumi.input_type
class _SubscriptionPricingState:
    def __init__(__self__, *,
                 extensions: Optional[pulumi.Input[Sequence[pulumi.Input['SubscriptionPricingExtensionArgs']]]] = None,
                 resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 subplan: Optional[pulumi.Input[_builtins.str]] = None,
                 tier: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SubscriptionPricing resources.
        :param pulumi.Input[Sequence[pulumi.Input['SubscriptionPricingExtensionArgs']]] extensions: One or more `extension` blocks as defined below.
        :param pulumi.Input[_builtins.str] resource_type: The resource type this setting affects. Possible values are `AI`, `Api`, `AppServices`, `ContainerRegistry`, `KeyVaults`, `KubernetesService`, `SqlServers`, `SqlServerVirtualMachines`, `StorageAccounts`, `VirtualMachines`, `Arm`, `Dns`, `OpenSourceRelationalDatabases`, `Containers`, `CosmosDbs` and `CloudPosture`. Defaults to `VirtualMachines`
        :param pulumi.Input[_builtins.str] subplan: Resource type pricing subplan. Contact your MSFT representative for possible values. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] tier: The pricing tier to use. Possible values are `Free` and `Standard`.
        """
        if extensions is not None:
            pulumi.set(__self__, "extensions", extensions)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)
        if subplan is not None:
            pulumi.set(__self__, "subplan", subplan)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @_builtins.property
    @pulumi.getter
    def extensions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SubscriptionPricingExtensionArgs']]]]:
        """
        One or more `extension` blocks as defined below.
        """
        return pulumi.get(self, "extensions")

    @extensions.setter
    def extensions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SubscriptionPricingExtensionArgs']]]]):
        pulumi.set(self, "extensions", value)

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource type this setting affects. Possible values are `AI`, `Api`, `AppServices`, `ContainerRegistry`, `KeyVaults`, `KubernetesService`, `SqlServers`, `SqlServerVirtualMachines`, `StorageAccounts`, `VirtualMachines`, `Arm`, `Dns`, `OpenSourceRelationalDatabases`, `Containers`, `CosmosDbs` and `CloudPosture`. Defaults to `VirtualMachines`
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_type", value)

    @_builtins.property
    @pulumi.getter
    def subplan(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource type pricing subplan. Contact your MSFT representative for possible values. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "subplan")

    @subplan.setter
    def subplan(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subplan", value)

    @_builtins.property
    @pulumi.getter
    def tier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The pricing tier to use. Possible values are `Free` and `Standard`.
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tier", value)


@pulumi.type_token("azure:securitycenter/subscriptionPricing:SubscriptionPricing")
class SubscriptionPricing(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 extensions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SubscriptionPricingExtensionArgs', 'SubscriptionPricingExtensionArgsDict']]]]] = None,
                 resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 subplan: Optional[pulumi.Input[_builtins.str]] = None,
                 tier: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages the Pricing Tier for Azure Security Center in the current subscription.

        > **Note:** Deletion of this resource will reset the pricing tier to `Free`

        ## Example Usage

        ### Basic usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.securitycenter.SubscriptionPricing("example",
            tier="Standard",
            resource_type="VirtualMachines")
        ```

        ### Using Extensions with Defender CSPM

        ```python
        import pulumi
        import pulumi_azure as azure

        example1 = azure.securitycenter.SubscriptionPricing("example1",
            tier="Standard",
            resource_type="CloudPosture",
            extensions=[
                {
                    "name": "ContainerRegistriesVulnerabilityAssessments",
                },
                {
                    "name": "AgentlessVmScanning",
                    "additional_extension_properties": {
                        "ExclusionTags": "[]",
                    },
                },
                {
                    "name": "AgentlessDiscoveryForKubernetes",
                },
                {
                    "name": "SensitiveDataDiscovery",
                },
            ])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Security` - 2023-01-01

        ## Import

        The pricing tier can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:securitycenter/subscriptionPricing:SubscriptionPricing example /subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Security/pricings/<resource_type>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SubscriptionPricingExtensionArgs', 'SubscriptionPricingExtensionArgsDict']]]] extensions: One or more `extension` blocks as defined below.
        :param pulumi.Input[_builtins.str] resource_type: The resource type this setting affects. Possible values are `AI`, `Api`, `AppServices`, `ContainerRegistry`, `KeyVaults`, `KubernetesService`, `SqlServers`, `SqlServerVirtualMachines`, `StorageAccounts`, `VirtualMachines`, `Arm`, `Dns`, `OpenSourceRelationalDatabases`, `Containers`, `CosmosDbs` and `CloudPosture`. Defaults to `VirtualMachines`
        :param pulumi.Input[_builtins.str] subplan: Resource type pricing subplan. Contact your MSFT representative for possible values. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] tier: The pricing tier to use. Possible values are `Free` and `Standard`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SubscriptionPricingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages the Pricing Tier for Azure Security Center in the current subscription.

        > **Note:** Deletion of this resource will reset the pricing tier to `Free`

        ## Example Usage

        ### Basic usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.securitycenter.SubscriptionPricing("example",
            tier="Standard",
            resource_type="VirtualMachines")
        ```

        ### Using Extensions with Defender CSPM

        ```python
        import pulumi
        import pulumi_azure as azure

        example1 = azure.securitycenter.SubscriptionPricing("example1",
            tier="Standard",
            resource_type="CloudPosture",
            extensions=[
                {
                    "name": "ContainerRegistriesVulnerabilityAssessments",
                },
                {
                    "name": "AgentlessVmScanning",
                    "additional_extension_properties": {
                        "ExclusionTags": "[]",
                    },
                },
                {
                    "name": "AgentlessDiscoveryForKubernetes",
                },
                {
                    "name": "SensitiveDataDiscovery",
                },
            ])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Security` - 2023-01-01

        ## Import

        The pricing tier can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:securitycenter/subscriptionPricing:SubscriptionPricing example /subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Security/pricings/<resource_type>
        ```

        :param str resource_name: The name of the resource.
        :param SubscriptionPricingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SubscriptionPricingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 extensions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SubscriptionPricingExtensionArgs', 'SubscriptionPricingExtensionArgsDict']]]]] = None,
                 resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 subplan: Optional[pulumi.Input[_builtins.str]] = None,
                 tier: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SubscriptionPricingArgs.__new__(SubscriptionPricingArgs)

            __props__.__dict__["extensions"] = extensions
            __props__.__dict__["resource_type"] = resource_type
            __props__.__dict__["subplan"] = subplan
            if tier is None and not opts.urn:
                raise TypeError("Missing required property 'tier'")
            __props__.__dict__["tier"] = tier
        super(SubscriptionPricing, __self__).__init__(
            'azure:securitycenter/subscriptionPricing:SubscriptionPricing',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            extensions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SubscriptionPricingExtensionArgs', 'SubscriptionPricingExtensionArgsDict']]]]] = None,
            resource_type: Optional[pulumi.Input[_builtins.str]] = None,
            subplan: Optional[pulumi.Input[_builtins.str]] = None,
            tier: Optional[pulumi.Input[_builtins.str]] = None) -> 'SubscriptionPricing':
        """
        Get an existing SubscriptionPricing resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SubscriptionPricingExtensionArgs', 'SubscriptionPricingExtensionArgsDict']]]] extensions: One or more `extension` blocks as defined below.
        :param pulumi.Input[_builtins.str] resource_type: The resource type this setting affects. Possible values are `AI`, `Api`, `AppServices`, `ContainerRegistry`, `KeyVaults`, `KubernetesService`, `SqlServers`, `SqlServerVirtualMachines`, `StorageAccounts`, `VirtualMachines`, `Arm`, `Dns`, `OpenSourceRelationalDatabases`, `Containers`, `CosmosDbs` and `CloudPosture`. Defaults to `VirtualMachines`
        :param pulumi.Input[_builtins.str] subplan: Resource type pricing subplan. Contact your MSFT representative for possible values. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] tier: The pricing tier to use. Possible values are `Free` and `Standard`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SubscriptionPricingState.__new__(_SubscriptionPricingState)

        __props__.__dict__["extensions"] = extensions
        __props__.__dict__["resource_type"] = resource_type
        __props__.__dict__["subplan"] = subplan
        __props__.__dict__["tier"] = tier
        return SubscriptionPricing(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def extensions(self) -> pulumi.Output[Optional[Sequence['outputs.SubscriptionPricingExtension']]]:
        """
        One or more `extension` blocks as defined below.
        """
        return pulumi.get(self, "extensions")

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The resource type this setting affects. Possible values are `AI`, `Api`, `AppServices`, `ContainerRegistry`, `KeyVaults`, `KubernetesService`, `SqlServers`, `SqlServerVirtualMachines`, `StorageAccounts`, `VirtualMachines`, `Arm`, `Dns`, `OpenSourceRelationalDatabases`, `Containers`, `CosmosDbs` and `CloudPosture`. Defaults to `VirtualMachines`
        """
        return pulumi.get(self, "resource_type")

    @_builtins.property
    @pulumi.getter
    def subplan(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Resource type pricing subplan. Contact your MSFT representative for possible values. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "subplan")

    @_builtins.property
    @pulumi.getter
    def tier(self) -> pulumi.Output[_builtins.str]:
        """
        The pricing tier to use. Possible values are `Free` and `Standard`.
        """
        return pulumi.get(self, "tier")

