# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetNamespaceAuthorizationRuleResult',
    'AwaitableGetNamespaceAuthorizationRuleResult',
    'get_namespace_authorization_rule',
    'get_namespace_authorization_rule_output',
]

@pulumi.output_type
class GetNamespaceAuthorizationRuleResult:
    """
    A collection of values returned by getNamespaceAuthorizationRule.
    """
    def __init__(__self__, id=None, name=None, namespace_id=None, namespace_name=None, primary_connection_string=None, primary_connection_string_alias=None, primary_key=None, resource_group_name=None, secondary_connection_string=None, secondary_connection_string_alias=None, secondary_key=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if namespace_id and not isinstance(namespace_id, str):
            raise TypeError("Expected argument 'namespace_id' to be a str")
        pulumi.set(__self__, "namespace_id", namespace_id)
        if namespace_name and not isinstance(namespace_name, str):
            raise TypeError("Expected argument 'namespace_name' to be a str")
        pulumi.set(__self__, "namespace_name", namespace_name)
        if primary_connection_string and not isinstance(primary_connection_string, str):
            raise TypeError("Expected argument 'primary_connection_string' to be a str")
        pulumi.set(__self__, "primary_connection_string", primary_connection_string)
        if primary_connection_string_alias and not isinstance(primary_connection_string_alias, str):
            raise TypeError("Expected argument 'primary_connection_string_alias' to be a str")
        pulumi.set(__self__, "primary_connection_string_alias", primary_connection_string_alias)
        if primary_key and not isinstance(primary_key, str):
            raise TypeError("Expected argument 'primary_key' to be a str")
        pulumi.set(__self__, "primary_key", primary_key)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if secondary_connection_string and not isinstance(secondary_connection_string, str):
            raise TypeError("Expected argument 'secondary_connection_string' to be a str")
        pulumi.set(__self__, "secondary_connection_string", secondary_connection_string)
        if secondary_connection_string_alias and not isinstance(secondary_connection_string_alias, str):
            raise TypeError("Expected argument 'secondary_connection_string_alias' to be a str")
        pulumi.set(__self__, "secondary_connection_string_alias", secondary_connection_string_alias)
        if secondary_key and not isinstance(secondary_key, str):
            raise TypeError("Expected argument 'secondary_key' to be a str")
        pulumi.set(__self__, "secondary_key", secondary_key)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="namespaceId")
    def namespace_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "namespace_id")

    @_builtins.property
    @pulumi.getter(name="namespaceName")
    @_utilities.deprecated("""`namespace_name` will be removed in favour of the property `namespace_id` in v5.0 of the AzureRM Provider.""")
    def namespace_name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "namespace_name")

    @_builtins.property
    @pulumi.getter(name="primaryConnectionString")
    def primary_connection_string(self) -> _builtins.str:
        """
        The primary connection string for the authorization rule.
        """
        return pulumi.get(self, "primary_connection_string")

    @_builtins.property
    @pulumi.getter(name="primaryConnectionStringAlias")
    def primary_connection_string_alias(self) -> _builtins.str:
        """
        The alias Primary Connection String for the ServiceBus Namespace, if the namespace is Geo DR paired.
        """
        return pulumi.get(self, "primary_connection_string_alias")

    @_builtins.property
    @pulumi.getter(name="primaryKey")
    def primary_key(self) -> _builtins.str:
        """
        The primary access key for the authorization rule.
        """
        return pulumi.get(self, "primary_key")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    @_utilities.deprecated("""`resource_group_name` will be removed in favour of the property `namespace_id` in v5.0 of the AzureRM Provider.""")
    def resource_group_name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="secondaryConnectionString")
    def secondary_connection_string(self) -> _builtins.str:
        """
        The secondary connection string for the authorization rule.
        """
        return pulumi.get(self, "secondary_connection_string")

    @_builtins.property
    @pulumi.getter(name="secondaryConnectionStringAlias")
    def secondary_connection_string_alias(self) -> _builtins.str:
        """
        The alias Secondary Connection String for the ServiceBus Namespace
        """
        return pulumi.get(self, "secondary_connection_string_alias")

    @_builtins.property
    @pulumi.getter(name="secondaryKey")
    def secondary_key(self) -> _builtins.str:
        """
        The secondary access key for the authorization rule.
        """
        return pulumi.get(self, "secondary_key")


class AwaitableGetNamespaceAuthorizationRuleResult(GetNamespaceAuthorizationRuleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNamespaceAuthorizationRuleResult(
            id=self.id,
            name=self.name,
            namespace_id=self.namespace_id,
            namespace_name=self.namespace_name,
            primary_connection_string=self.primary_connection_string,
            primary_connection_string_alias=self.primary_connection_string_alias,
            primary_key=self.primary_key,
            resource_group_name=self.resource_group_name,
            secondary_connection_string=self.secondary_connection_string,
            secondary_connection_string_alias=self.secondary_connection_string_alias,
            secondary_key=self.secondary_key)


def get_namespace_authorization_rule(name: Optional[_builtins.str] = None,
                                     namespace_id: Optional[_builtins.str] = None,
                                     namespace_name: Optional[_builtins.str] = None,
                                     resource_group_name: Optional[_builtins.str] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNamespaceAuthorizationRuleResult:
    """
    Use this data source to access information about an existing ServiceBus Namespace Authorization Rule.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.servicebus.get_namespace_authorization_rule(name="examplerule",
        namespace_id="examplenamespace")
    pulumi.export("ruleId", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.ServiceBus` - 2024-01-01


    :param _builtins.str name: Specifies the name of the ServiceBus Namespace Authorization Rule.
    :param _builtins.str namespace_id: Specifies the ID of the ServiceBus Namespace where the Service Bus Namespace Authorization Rule exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['namespaceId'] = namespace_id
    __args__['namespaceName'] = namespace_name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:servicebus/getNamespaceAuthorizationRule:getNamespaceAuthorizationRule', __args__, opts=opts, typ=GetNamespaceAuthorizationRuleResult).value

    return AwaitableGetNamespaceAuthorizationRuleResult(
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        namespace_id=pulumi.get(__ret__, 'namespace_id'),
        namespace_name=pulumi.get(__ret__, 'namespace_name'),
        primary_connection_string=pulumi.get(__ret__, 'primary_connection_string'),
        primary_connection_string_alias=pulumi.get(__ret__, 'primary_connection_string_alias'),
        primary_key=pulumi.get(__ret__, 'primary_key'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        secondary_connection_string=pulumi.get(__ret__, 'secondary_connection_string'),
        secondary_connection_string_alias=pulumi.get(__ret__, 'secondary_connection_string_alias'),
        secondary_key=pulumi.get(__ret__, 'secondary_key'))
def get_namespace_authorization_rule_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                                            namespace_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                            namespace_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                            resource_group_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNamespaceAuthorizationRuleResult]:
    """
    Use this data source to access information about an existing ServiceBus Namespace Authorization Rule.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.servicebus.get_namespace_authorization_rule(name="examplerule",
        namespace_id="examplenamespace")
    pulumi.export("ruleId", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.ServiceBus` - 2024-01-01


    :param _builtins.str name: Specifies the name of the ServiceBus Namespace Authorization Rule.
    :param _builtins.str namespace_id: Specifies the ID of the ServiceBus Namespace where the Service Bus Namespace Authorization Rule exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['namespaceId'] = namespace_id
    __args__['namespaceName'] = namespace_name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:servicebus/getNamespaceAuthorizationRule:getNamespaceAuthorizationRule', __args__, opts=opts, typ=GetNamespaceAuthorizationRuleResult)
    return __ret__.apply(lambda __response__: GetNamespaceAuthorizationRuleResult(
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        namespace_id=pulumi.get(__response__, 'namespace_id'),
        namespace_name=pulumi.get(__response__, 'namespace_name'),
        primary_connection_string=pulumi.get(__response__, 'primary_connection_string'),
        primary_connection_string_alias=pulumi.get(__response__, 'primary_connection_string_alias'),
        primary_key=pulumi.get(__response__, 'primary_key'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        secondary_connection_string=pulumi.get(__response__, 'secondary_connection_string'),
        secondary_connection_string_alias=pulumi.get(__response__, 'secondary_connection_string_alias'),
        secondary_key=pulumi.get(__response__, 'secondary_key')))
