# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['NamespaceCustomerManagedKeyInitArgs', 'NamespaceCustomerManagedKey']

@pulumi.input_type
class NamespaceCustomerManagedKeyInitArgs:
    def __init__(__self__, *,
                 key_vault_key_id: pulumi.Input[_builtins.str],
                 namespace_id: pulumi.Input[_builtins.str],
                 infrastructure_encryption_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a NamespaceCustomerManagedKey resource.
        :param pulumi.Input[_builtins.str] key_vault_key_id: The ID of the Key Vault Key which should be used to Encrypt the data in this Service Bus Namespace.
        :param pulumi.Input[_builtins.str] namespace_id: The ID of the Service Bus namespace. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] infrastructure_encryption_enabled: Used to specify whether enable Infrastructure Encryption. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "key_vault_key_id", key_vault_key_id)
        pulumi.set(__self__, "namespace_id", namespace_id)
        if infrastructure_encryption_enabled is not None:
            pulumi.set(__self__, "infrastructure_encryption_enabled", infrastructure_encryption_enabled)

    @_builtins.property
    @pulumi.getter(name="keyVaultKeyId")
    def key_vault_key_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Key Vault Key which should be used to Encrypt the data in this Service Bus Namespace.
        """
        return pulumi.get(self, "key_vault_key_id")

    @key_vault_key_id.setter
    def key_vault_key_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key_vault_key_id", value)

    @_builtins.property
    @pulumi.getter(name="namespaceId")
    def namespace_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Service Bus namespace. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "namespace_id")

    @namespace_id.setter
    def namespace_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "namespace_id", value)

    @_builtins.property
    @pulumi.getter(name="infrastructureEncryptionEnabled")
    def infrastructure_encryption_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Used to specify whether enable Infrastructure Encryption. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "infrastructure_encryption_enabled")

    @infrastructure_encryption_enabled.setter
    def infrastructure_encryption_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "infrastructure_encryption_enabled", value)


@pulumi.input_type
class _NamespaceCustomerManagedKeyState:
    def __init__(__self__, *,
                 infrastructure_encryption_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 key_vault_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering NamespaceCustomerManagedKey resources.
        :param pulumi.Input[_builtins.bool] infrastructure_encryption_enabled: Used to specify whether enable Infrastructure Encryption. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] key_vault_key_id: The ID of the Key Vault Key which should be used to Encrypt the data in this Service Bus Namespace.
        :param pulumi.Input[_builtins.str] namespace_id: The ID of the Service Bus namespace. Changing this forces a new resource to be created.
        """
        if infrastructure_encryption_enabled is not None:
            pulumi.set(__self__, "infrastructure_encryption_enabled", infrastructure_encryption_enabled)
        if key_vault_key_id is not None:
            pulumi.set(__self__, "key_vault_key_id", key_vault_key_id)
        if namespace_id is not None:
            pulumi.set(__self__, "namespace_id", namespace_id)

    @_builtins.property
    @pulumi.getter(name="infrastructureEncryptionEnabled")
    def infrastructure_encryption_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Used to specify whether enable Infrastructure Encryption. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "infrastructure_encryption_enabled")

    @infrastructure_encryption_enabled.setter
    def infrastructure_encryption_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "infrastructure_encryption_enabled", value)

    @_builtins.property
    @pulumi.getter(name="keyVaultKeyId")
    def key_vault_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Key Vault Key which should be used to Encrypt the data in this Service Bus Namespace.
        """
        return pulumi.get(self, "key_vault_key_id")

    @key_vault_key_id.setter
    def key_vault_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_vault_key_id", value)

    @_builtins.property
    @pulumi.getter(name="namespaceId")
    def namespace_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Service Bus namespace. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "namespace_id")

    @namespace_id.setter
    def namespace_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace_id", value)


@pulumi.type_token("azure:servicebus/namespaceCustomerManagedKey:NamespaceCustomerManagedKey")
class NamespaceCustomerManagedKey(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 infrastructure_encryption_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 key_vault_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Service Bus Namespace Customer Managed Key.

        !> **Note:** It is not possible to remove the Customer Managed Key from the Service Bus Namespace once it's been added. To remove the Customer Managed Key, the parent Service Bus Namespace must be deleted and recreated.

        > **Note:** This resource should only be used to create a Customer Managed Key for Service Bus Namespaces with System Assigned identities. The `customer_managed_key` block in `servicebus.Namespace` should be used to create a Customer Managed Key for a Service Bus Namespace with a User Assigned identity.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resource-group",
            location="West Europe")
        example_namespace = azure.servicebus.Namespace("example",
            name="example-servicebus-namespace",
            location=example.location,
            resource_group_name=example.name,
            sku="Premium",
            premium_messaging_partitions=1,
            capacity=1,
            identity={
                "type": "SystemAssigned",
            })
        current = azure.core.get_client_config()
        example_key_vault = azure.keyvault.KeyVault("example",
            name="example-key-vault",
            location=example.location,
            resource_group_name=example.name,
            enabled_for_disk_encryption=True,
            tenant_id=current.tenant_id,
            soft_delete_retention_days=7,
            purge_protection_enabled=True,
            sku_name="standard",
            access_policies=[
                {
                    "tenant_id": current.tenant_id,
                    "object_id": current.object_id,
                    "key_permissions": [
                        "Create",
                        "Decrypt",
                        "Encrypt",
                        "Delete",
                        "Get",
                        "List",
                        "Purge",
                        "UnwrapKey",
                        "WrapKey",
                        "Verify",
                        "GetRotationPolicy",
                    ],
                    "secret_permissions": ["Set"],
                },
                {
                    "tenant_id": example_namespace.identity.tenant_id,
                    "object_id": example_namespace.identity.principal_id,
                    "key_permissions": [
                        "Create",
                        "Decrypt",
                        "Encrypt",
                        "Delete",
                        "Get",
                        "List",
                        "Purge",
                        "UnwrapKey",
                        "WrapKey",
                        "Verify",
                        "GetRotationPolicy",
                    ],
                    "secret_permissions": ["Set"],
                },
            ])
        example_key = azure.keyvault.Key("example",
            name="example-key-vault-key",
            key_vault_id=example_key_vault.id,
            key_type="RSA",
            key_size=2048,
            key_opts=[
                "decrypt",
                "encrypt",
                "sign",
                "unwrapKey",
                "verify",
                "wrapKey",
            ])
        example_namespace_customer_managed_key = azure.servicebus.NamespaceCustomerManagedKey("example",
            namespace_id=example_namespace.id,
            key_vault_key_id=example_key.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ServiceBus` - 2024-01-01

        ## Import

        Service Bus Namespace Customer Managed Key can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:servicebus/namespaceCustomerManagedKey:NamespaceCustomerManagedKey example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.ServiceBus/namespaces/sbns1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] infrastructure_encryption_enabled: Used to specify whether enable Infrastructure Encryption. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] key_vault_key_id: The ID of the Key Vault Key which should be used to Encrypt the data in this Service Bus Namespace.
        :param pulumi.Input[_builtins.str] namespace_id: The ID of the Service Bus namespace. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NamespaceCustomerManagedKeyInitArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Service Bus Namespace Customer Managed Key.

        !> **Note:** It is not possible to remove the Customer Managed Key from the Service Bus Namespace once it's been added. To remove the Customer Managed Key, the parent Service Bus Namespace must be deleted and recreated.

        > **Note:** This resource should only be used to create a Customer Managed Key for Service Bus Namespaces with System Assigned identities. The `customer_managed_key` block in `servicebus.Namespace` should be used to create a Customer Managed Key for a Service Bus Namespace with a User Assigned identity.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resource-group",
            location="West Europe")
        example_namespace = azure.servicebus.Namespace("example",
            name="example-servicebus-namespace",
            location=example.location,
            resource_group_name=example.name,
            sku="Premium",
            premium_messaging_partitions=1,
            capacity=1,
            identity={
                "type": "SystemAssigned",
            })
        current = azure.core.get_client_config()
        example_key_vault = azure.keyvault.KeyVault("example",
            name="example-key-vault",
            location=example.location,
            resource_group_name=example.name,
            enabled_for_disk_encryption=True,
            tenant_id=current.tenant_id,
            soft_delete_retention_days=7,
            purge_protection_enabled=True,
            sku_name="standard",
            access_policies=[
                {
                    "tenant_id": current.tenant_id,
                    "object_id": current.object_id,
                    "key_permissions": [
                        "Create",
                        "Decrypt",
                        "Encrypt",
                        "Delete",
                        "Get",
                        "List",
                        "Purge",
                        "UnwrapKey",
                        "WrapKey",
                        "Verify",
                        "GetRotationPolicy",
                    ],
                    "secret_permissions": ["Set"],
                },
                {
                    "tenant_id": example_namespace.identity.tenant_id,
                    "object_id": example_namespace.identity.principal_id,
                    "key_permissions": [
                        "Create",
                        "Decrypt",
                        "Encrypt",
                        "Delete",
                        "Get",
                        "List",
                        "Purge",
                        "UnwrapKey",
                        "WrapKey",
                        "Verify",
                        "GetRotationPolicy",
                    ],
                    "secret_permissions": ["Set"],
                },
            ])
        example_key = azure.keyvault.Key("example",
            name="example-key-vault-key",
            key_vault_id=example_key_vault.id,
            key_type="RSA",
            key_size=2048,
            key_opts=[
                "decrypt",
                "encrypt",
                "sign",
                "unwrapKey",
                "verify",
                "wrapKey",
            ])
        example_namespace_customer_managed_key = azure.servicebus.NamespaceCustomerManagedKey("example",
            namespace_id=example_namespace.id,
            key_vault_key_id=example_key.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ServiceBus` - 2024-01-01

        ## Import

        Service Bus Namespace Customer Managed Key can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:servicebus/namespaceCustomerManagedKey:NamespaceCustomerManagedKey example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.ServiceBus/namespaces/sbns1
        ```

        :param str resource_name: The name of the resource.
        :param NamespaceCustomerManagedKeyInitArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NamespaceCustomerManagedKeyInitArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 infrastructure_encryption_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 key_vault_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NamespaceCustomerManagedKeyInitArgs.__new__(NamespaceCustomerManagedKeyInitArgs)

            __props__.__dict__["infrastructure_encryption_enabled"] = infrastructure_encryption_enabled
            if key_vault_key_id is None and not opts.urn:
                raise TypeError("Missing required property 'key_vault_key_id'")
            __props__.__dict__["key_vault_key_id"] = key_vault_key_id
            if namespace_id is None and not opts.urn:
                raise TypeError("Missing required property 'namespace_id'")
            __props__.__dict__["namespace_id"] = namespace_id
        super(NamespaceCustomerManagedKey, __self__).__init__(
            'azure:servicebus/namespaceCustomerManagedKey:NamespaceCustomerManagedKey',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            infrastructure_encryption_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            key_vault_key_id: Optional[pulumi.Input[_builtins.str]] = None,
            namespace_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'NamespaceCustomerManagedKey':
        """
        Get an existing NamespaceCustomerManagedKey resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] infrastructure_encryption_enabled: Used to specify whether enable Infrastructure Encryption. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] key_vault_key_id: The ID of the Key Vault Key which should be used to Encrypt the data in this Service Bus Namespace.
        :param pulumi.Input[_builtins.str] namespace_id: The ID of the Service Bus namespace. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NamespaceCustomerManagedKeyState.__new__(_NamespaceCustomerManagedKeyState)

        __props__.__dict__["infrastructure_encryption_enabled"] = infrastructure_encryption_enabled
        __props__.__dict__["key_vault_key_id"] = key_vault_key_id
        __props__.__dict__["namespace_id"] = namespace_id
        return NamespaceCustomerManagedKey(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="infrastructureEncryptionEnabled")
    def infrastructure_encryption_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Used to specify whether enable Infrastructure Encryption. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "infrastructure_encryption_enabled")

    @_builtins.property
    @pulumi.getter(name="keyVaultKeyId")
    def key_vault_key_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Key Vault Key which should be used to Encrypt the data in this Service Bus Namespace.
        """
        return pulumi.get(self, "key_vault_key_id")

    @_builtins.property
    @pulumi.getter(name="namespaceId")
    def namespace_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Service Bus namespace. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "namespace_id")

