# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SubscriptionArgs', 'Subscription']

@pulumi.input_type
class SubscriptionArgs:
    def __init__(__self__, *,
                 max_delivery_count: pulumi.Input[_builtins.int],
                 topic_id: pulumi.Input[_builtins.str],
                 auto_delete_on_idle: Optional[pulumi.Input[_builtins.str]] = None,
                 batched_operations_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 client_scoped_subscription: Optional[pulumi.Input['SubscriptionClientScopedSubscriptionArgs']] = None,
                 client_scoped_subscription_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 dead_lettering_on_filter_evaluation_error: Optional[pulumi.Input[_builtins.bool]] = None,
                 dead_lettering_on_message_expiration: Optional[pulumi.Input[_builtins.bool]] = None,
                 default_message_ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 forward_dead_lettered_messages_to: Optional[pulumi.Input[_builtins.str]] = None,
                 forward_to: Optional[pulumi.Input[_builtins.str]] = None,
                 lock_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 requires_session: Optional[pulumi.Input[_builtins.bool]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Subscription resource.
        :param pulumi.Input[_builtins.int] max_delivery_count: The maximum number of deliveries.
        :param pulumi.Input[_builtins.str] topic_id: The ID of the ServiceBus Topic to create this Subscription in. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] auto_delete_on_idle: The idle interval after which the topic is automatically deleted as an [ISO 8601 duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). The minimum duration is `5` minutes or `PT5M`. Defaults to `P10675199DT2H48M5.4775807S`.
        :param pulumi.Input[_builtins.bool] batched_operations_enabled: Boolean flag which controls whether the Subscription supports batched operations.
        :param pulumi.Input['SubscriptionClientScopedSubscriptionArgs'] client_scoped_subscription: A `client_scoped_subscription` block as defined below.
        :param pulumi.Input[_builtins.bool] client_scoped_subscription_enabled: whether the subscription is scoped to a client id. Defaults to `false`.
               
               > **Note:** Client Scoped Subscription can only be used for JMS subscription (Java Message Service).
        :param pulumi.Input[_builtins.bool] dead_lettering_on_filter_evaluation_error: Boolean flag which controls whether the Subscription has dead letter support on filter evaluation exceptions. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] dead_lettering_on_message_expiration: Boolean flag which controls whether the Subscription has dead letter support when a message expires.
        :param pulumi.Input[_builtins.str] default_message_ttl: The Default message timespan to live as an [ISO 8601 duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). This is the duration after which the message expires, starting from when the message is sent to Service Bus. This is the value used when TimeToLive is not set on a message itself. Defaults to `P10675199DT2H48M5.4775807S`.
        :param pulumi.Input[_builtins.str] forward_dead_lettered_messages_to: The name of a Queue or Topic to automatically forward Dead Letter messages to.
        :param pulumi.Input[_builtins.str] forward_to: The name of a Queue or Topic to automatically forward messages to.
        :param pulumi.Input[_builtins.str] lock_duration: The lock duration for the subscription as an [ISO 8601 duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). The default value is `1` minute or `P0DT0H1M0S` . The maximum value is `5` minutes or `P0DT0H5M0S` . Defaults to `PT1M`.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the ServiceBus Subscription resource. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] requires_session: Boolean flag which controls whether this Subscription supports the concept of a session. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] status: The status of the Subscription. Possible values are `Active`,`ReceiveDisabled`, or `Disabled`. Defaults to `Active`.
        """
        pulumi.set(__self__, "max_delivery_count", max_delivery_count)
        pulumi.set(__self__, "topic_id", topic_id)
        if auto_delete_on_idle is not None:
            pulumi.set(__self__, "auto_delete_on_idle", auto_delete_on_idle)
        if batched_operations_enabled is not None:
            pulumi.set(__self__, "batched_operations_enabled", batched_operations_enabled)
        if client_scoped_subscription is not None:
            pulumi.set(__self__, "client_scoped_subscription", client_scoped_subscription)
        if client_scoped_subscription_enabled is not None:
            pulumi.set(__self__, "client_scoped_subscription_enabled", client_scoped_subscription_enabled)
        if dead_lettering_on_filter_evaluation_error is not None:
            pulumi.set(__self__, "dead_lettering_on_filter_evaluation_error", dead_lettering_on_filter_evaluation_error)
        if dead_lettering_on_message_expiration is not None:
            pulumi.set(__self__, "dead_lettering_on_message_expiration", dead_lettering_on_message_expiration)
        if default_message_ttl is not None:
            pulumi.set(__self__, "default_message_ttl", default_message_ttl)
        if forward_dead_lettered_messages_to is not None:
            pulumi.set(__self__, "forward_dead_lettered_messages_to", forward_dead_lettered_messages_to)
        if forward_to is not None:
            pulumi.set(__self__, "forward_to", forward_to)
        if lock_duration is not None:
            pulumi.set(__self__, "lock_duration", lock_duration)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if requires_session is not None:
            pulumi.set(__self__, "requires_session", requires_session)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="maxDeliveryCount")
    def max_delivery_count(self) -> pulumi.Input[_builtins.int]:
        """
        The maximum number of deliveries.
        """
        return pulumi.get(self, "max_delivery_count")

    @max_delivery_count.setter
    def max_delivery_count(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "max_delivery_count", value)

    @_builtins.property
    @pulumi.getter(name="topicId")
    def topic_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the ServiceBus Topic to create this Subscription in. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "topic_id")

    @topic_id.setter
    def topic_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "topic_id", value)

    @_builtins.property
    @pulumi.getter(name="autoDeleteOnIdle")
    def auto_delete_on_idle(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The idle interval after which the topic is automatically deleted as an [ISO 8601 duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). The minimum duration is `5` minutes or `PT5M`. Defaults to `P10675199DT2H48M5.4775807S`.
        """
        return pulumi.get(self, "auto_delete_on_idle")

    @auto_delete_on_idle.setter
    def auto_delete_on_idle(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_delete_on_idle", value)

    @_builtins.property
    @pulumi.getter(name="batchedOperationsEnabled")
    def batched_operations_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean flag which controls whether the Subscription supports batched operations.
        """
        return pulumi.get(self, "batched_operations_enabled")

    @batched_operations_enabled.setter
    def batched_operations_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "batched_operations_enabled", value)

    @_builtins.property
    @pulumi.getter(name="clientScopedSubscription")
    def client_scoped_subscription(self) -> Optional[pulumi.Input['SubscriptionClientScopedSubscriptionArgs']]:
        """
        A `client_scoped_subscription` block as defined below.
        """
        return pulumi.get(self, "client_scoped_subscription")

    @client_scoped_subscription.setter
    def client_scoped_subscription(self, value: Optional[pulumi.Input['SubscriptionClientScopedSubscriptionArgs']]):
        pulumi.set(self, "client_scoped_subscription", value)

    @_builtins.property
    @pulumi.getter(name="clientScopedSubscriptionEnabled")
    def client_scoped_subscription_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        whether the subscription is scoped to a client id. Defaults to `false`.

        > **Note:** Client Scoped Subscription can only be used for JMS subscription (Java Message Service).
        """
        return pulumi.get(self, "client_scoped_subscription_enabled")

    @client_scoped_subscription_enabled.setter
    def client_scoped_subscription_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "client_scoped_subscription_enabled", value)

    @_builtins.property
    @pulumi.getter(name="deadLetteringOnFilterEvaluationError")
    def dead_lettering_on_filter_evaluation_error(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean flag which controls whether the Subscription has dead letter support on filter evaluation exceptions. Defaults to `true`.
        """
        return pulumi.get(self, "dead_lettering_on_filter_evaluation_error")

    @dead_lettering_on_filter_evaluation_error.setter
    def dead_lettering_on_filter_evaluation_error(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dead_lettering_on_filter_evaluation_error", value)

    @_builtins.property
    @pulumi.getter(name="deadLetteringOnMessageExpiration")
    def dead_lettering_on_message_expiration(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean flag which controls whether the Subscription has dead letter support when a message expires.
        """
        return pulumi.get(self, "dead_lettering_on_message_expiration")

    @dead_lettering_on_message_expiration.setter
    def dead_lettering_on_message_expiration(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dead_lettering_on_message_expiration", value)

    @_builtins.property
    @pulumi.getter(name="defaultMessageTtl")
    def default_message_ttl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Default message timespan to live as an [ISO 8601 duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). This is the duration after which the message expires, starting from when the message is sent to Service Bus. This is the value used when TimeToLive is not set on a message itself. Defaults to `P10675199DT2H48M5.4775807S`.
        """
        return pulumi.get(self, "default_message_ttl")

    @default_message_ttl.setter
    def default_message_ttl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_message_ttl", value)

    @_builtins.property
    @pulumi.getter(name="forwardDeadLetteredMessagesTo")
    def forward_dead_lettered_messages_to(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of a Queue or Topic to automatically forward Dead Letter messages to.
        """
        return pulumi.get(self, "forward_dead_lettered_messages_to")

    @forward_dead_lettered_messages_to.setter
    def forward_dead_lettered_messages_to(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "forward_dead_lettered_messages_to", value)

    @_builtins.property
    @pulumi.getter(name="forwardTo")
    def forward_to(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of a Queue or Topic to automatically forward messages to.
        """
        return pulumi.get(self, "forward_to")

    @forward_to.setter
    def forward_to(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "forward_to", value)

    @_builtins.property
    @pulumi.getter(name="lockDuration")
    def lock_duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The lock duration for the subscription as an [ISO 8601 duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). The default value is `1` minute or `P0DT0H1M0S` . The maximum value is `5` minutes or `P0DT0H5M0S` . Defaults to `PT1M`.
        """
        return pulumi.get(self, "lock_duration")

    @lock_duration.setter
    def lock_duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lock_duration", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the ServiceBus Subscription resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="requiresSession")
    def requires_session(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean flag which controls whether this Subscription supports the concept of a session. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "requires_session")

    @requires_session.setter
    def requires_session(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "requires_session", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the Subscription. Possible values are `Active`,`ReceiveDisabled`, or `Disabled`. Defaults to `Active`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class _SubscriptionState:
    def __init__(__self__, *,
                 auto_delete_on_idle: Optional[pulumi.Input[_builtins.str]] = None,
                 batched_operations_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 client_scoped_subscription: Optional[pulumi.Input['SubscriptionClientScopedSubscriptionArgs']] = None,
                 client_scoped_subscription_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 dead_lettering_on_filter_evaluation_error: Optional[pulumi.Input[_builtins.bool]] = None,
                 dead_lettering_on_message_expiration: Optional[pulumi.Input[_builtins.bool]] = None,
                 default_message_ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 forward_dead_lettered_messages_to: Optional[pulumi.Input[_builtins.str]] = None,
                 forward_to: Optional[pulumi.Input[_builtins.str]] = None,
                 lock_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 max_delivery_count: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 requires_session: Optional[pulumi.Input[_builtins.bool]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 topic_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Subscription resources.
        :param pulumi.Input[_builtins.str] auto_delete_on_idle: The idle interval after which the topic is automatically deleted as an [ISO 8601 duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). The minimum duration is `5` minutes or `PT5M`. Defaults to `P10675199DT2H48M5.4775807S`.
        :param pulumi.Input[_builtins.bool] batched_operations_enabled: Boolean flag which controls whether the Subscription supports batched operations.
        :param pulumi.Input['SubscriptionClientScopedSubscriptionArgs'] client_scoped_subscription: A `client_scoped_subscription` block as defined below.
        :param pulumi.Input[_builtins.bool] client_scoped_subscription_enabled: whether the subscription is scoped to a client id. Defaults to `false`.
               
               > **Note:** Client Scoped Subscription can only be used for JMS subscription (Java Message Service).
        :param pulumi.Input[_builtins.bool] dead_lettering_on_filter_evaluation_error: Boolean flag which controls whether the Subscription has dead letter support on filter evaluation exceptions. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] dead_lettering_on_message_expiration: Boolean flag which controls whether the Subscription has dead letter support when a message expires.
        :param pulumi.Input[_builtins.str] default_message_ttl: The Default message timespan to live as an [ISO 8601 duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). This is the duration after which the message expires, starting from when the message is sent to Service Bus. This is the value used when TimeToLive is not set on a message itself. Defaults to `P10675199DT2H48M5.4775807S`.
        :param pulumi.Input[_builtins.str] forward_dead_lettered_messages_to: The name of a Queue or Topic to automatically forward Dead Letter messages to.
        :param pulumi.Input[_builtins.str] forward_to: The name of a Queue or Topic to automatically forward messages to.
        :param pulumi.Input[_builtins.str] lock_duration: The lock duration for the subscription as an [ISO 8601 duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). The default value is `1` minute or `P0DT0H1M0S` . The maximum value is `5` minutes or `P0DT0H5M0S` . Defaults to `PT1M`.
        :param pulumi.Input[_builtins.int] max_delivery_count: The maximum number of deliveries.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the ServiceBus Subscription resource. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] requires_session: Boolean flag which controls whether this Subscription supports the concept of a session. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] status: The status of the Subscription. Possible values are `Active`,`ReceiveDisabled`, or `Disabled`. Defaults to `Active`.
        :param pulumi.Input[_builtins.str] topic_id: The ID of the ServiceBus Topic to create this Subscription in. Changing this forces a new resource to be created.
        """
        if auto_delete_on_idle is not None:
            pulumi.set(__self__, "auto_delete_on_idle", auto_delete_on_idle)
        if batched_operations_enabled is not None:
            pulumi.set(__self__, "batched_operations_enabled", batched_operations_enabled)
        if client_scoped_subscription is not None:
            pulumi.set(__self__, "client_scoped_subscription", client_scoped_subscription)
        if client_scoped_subscription_enabled is not None:
            pulumi.set(__self__, "client_scoped_subscription_enabled", client_scoped_subscription_enabled)
        if dead_lettering_on_filter_evaluation_error is not None:
            pulumi.set(__self__, "dead_lettering_on_filter_evaluation_error", dead_lettering_on_filter_evaluation_error)
        if dead_lettering_on_message_expiration is not None:
            pulumi.set(__self__, "dead_lettering_on_message_expiration", dead_lettering_on_message_expiration)
        if default_message_ttl is not None:
            pulumi.set(__self__, "default_message_ttl", default_message_ttl)
        if forward_dead_lettered_messages_to is not None:
            pulumi.set(__self__, "forward_dead_lettered_messages_to", forward_dead_lettered_messages_to)
        if forward_to is not None:
            pulumi.set(__self__, "forward_to", forward_to)
        if lock_duration is not None:
            pulumi.set(__self__, "lock_duration", lock_duration)
        if max_delivery_count is not None:
            pulumi.set(__self__, "max_delivery_count", max_delivery_count)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if requires_session is not None:
            pulumi.set(__self__, "requires_session", requires_session)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if topic_id is not None:
            pulumi.set(__self__, "topic_id", topic_id)

    @_builtins.property
    @pulumi.getter(name="autoDeleteOnIdle")
    def auto_delete_on_idle(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The idle interval after which the topic is automatically deleted as an [ISO 8601 duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). The minimum duration is `5` minutes or `PT5M`. Defaults to `P10675199DT2H48M5.4775807S`.
        """
        return pulumi.get(self, "auto_delete_on_idle")

    @auto_delete_on_idle.setter
    def auto_delete_on_idle(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_delete_on_idle", value)

    @_builtins.property
    @pulumi.getter(name="batchedOperationsEnabled")
    def batched_operations_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean flag which controls whether the Subscription supports batched operations.
        """
        return pulumi.get(self, "batched_operations_enabled")

    @batched_operations_enabled.setter
    def batched_operations_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "batched_operations_enabled", value)

    @_builtins.property
    @pulumi.getter(name="clientScopedSubscription")
    def client_scoped_subscription(self) -> Optional[pulumi.Input['SubscriptionClientScopedSubscriptionArgs']]:
        """
        A `client_scoped_subscription` block as defined below.
        """
        return pulumi.get(self, "client_scoped_subscription")

    @client_scoped_subscription.setter
    def client_scoped_subscription(self, value: Optional[pulumi.Input['SubscriptionClientScopedSubscriptionArgs']]):
        pulumi.set(self, "client_scoped_subscription", value)

    @_builtins.property
    @pulumi.getter(name="clientScopedSubscriptionEnabled")
    def client_scoped_subscription_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        whether the subscription is scoped to a client id. Defaults to `false`.

        > **Note:** Client Scoped Subscription can only be used for JMS subscription (Java Message Service).
        """
        return pulumi.get(self, "client_scoped_subscription_enabled")

    @client_scoped_subscription_enabled.setter
    def client_scoped_subscription_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "client_scoped_subscription_enabled", value)

    @_builtins.property
    @pulumi.getter(name="deadLetteringOnFilterEvaluationError")
    def dead_lettering_on_filter_evaluation_error(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean flag which controls whether the Subscription has dead letter support on filter evaluation exceptions. Defaults to `true`.
        """
        return pulumi.get(self, "dead_lettering_on_filter_evaluation_error")

    @dead_lettering_on_filter_evaluation_error.setter
    def dead_lettering_on_filter_evaluation_error(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dead_lettering_on_filter_evaluation_error", value)

    @_builtins.property
    @pulumi.getter(name="deadLetteringOnMessageExpiration")
    def dead_lettering_on_message_expiration(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean flag which controls whether the Subscription has dead letter support when a message expires.
        """
        return pulumi.get(self, "dead_lettering_on_message_expiration")

    @dead_lettering_on_message_expiration.setter
    def dead_lettering_on_message_expiration(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dead_lettering_on_message_expiration", value)

    @_builtins.property
    @pulumi.getter(name="defaultMessageTtl")
    def default_message_ttl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Default message timespan to live as an [ISO 8601 duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). This is the duration after which the message expires, starting from when the message is sent to Service Bus. This is the value used when TimeToLive is not set on a message itself. Defaults to `P10675199DT2H48M5.4775807S`.
        """
        return pulumi.get(self, "default_message_ttl")

    @default_message_ttl.setter
    def default_message_ttl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_message_ttl", value)

    @_builtins.property
    @pulumi.getter(name="forwardDeadLetteredMessagesTo")
    def forward_dead_lettered_messages_to(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of a Queue or Topic to automatically forward Dead Letter messages to.
        """
        return pulumi.get(self, "forward_dead_lettered_messages_to")

    @forward_dead_lettered_messages_to.setter
    def forward_dead_lettered_messages_to(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "forward_dead_lettered_messages_to", value)

    @_builtins.property
    @pulumi.getter(name="forwardTo")
    def forward_to(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of a Queue or Topic to automatically forward messages to.
        """
        return pulumi.get(self, "forward_to")

    @forward_to.setter
    def forward_to(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "forward_to", value)

    @_builtins.property
    @pulumi.getter(name="lockDuration")
    def lock_duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The lock duration for the subscription as an [ISO 8601 duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). The default value is `1` minute or `P0DT0H1M0S` . The maximum value is `5` minutes or `P0DT0H5M0S` . Defaults to `PT1M`.
        """
        return pulumi.get(self, "lock_duration")

    @lock_duration.setter
    def lock_duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lock_duration", value)

    @_builtins.property
    @pulumi.getter(name="maxDeliveryCount")
    def max_delivery_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of deliveries.
        """
        return pulumi.get(self, "max_delivery_count")

    @max_delivery_count.setter
    def max_delivery_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_delivery_count", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the ServiceBus Subscription resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="requiresSession")
    def requires_session(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean flag which controls whether this Subscription supports the concept of a session. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "requires_session")

    @requires_session.setter
    def requires_session(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "requires_session", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the Subscription. Possible values are `Active`,`ReceiveDisabled`, or `Disabled`. Defaults to `Active`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="topicId")
    def topic_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the ServiceBus Topic to create this Subscription in. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "topic_id")

    @topic_id.setter
    def topic_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "topic_id", value)


@pulumi.type_token("azure:servicebus/subscription:Subscription")
class Subscription(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_delete_on_idle: Optional[pulumi.Input[_builtins.str]] = None,
                 batched_operations_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 client_scoped_subscription: Optional[pulumi.Input[Union['SubscriptionClientScopedSubscriptionArgs', 'SubscriptionClientScopedSubscriptionArgsDict']]] = None,
                 client_scoped_subscription_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 dead_lettering_on_filter_evaluation_error: Optional[pulumi.Input[_builtins.bool]] = None,
                 dead_lettering_on_message_expiration: Optional[pulumi.Input[_builtins.bool]] = None,
                 default_message_ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 forward_dead_lettered_messages_to: Optional[pulumi.Input[_builtins.str]] = None,
                 forward_to: Optional[pulumi.Input[_builtins.str]] = None,
                 lock_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 max_delivery_count: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 requires_session: Optional[pulumi.Input[_builtins.bool]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 topic_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a ServiceBus Subscription.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="tfex-servicebus-subscription",
            location="West Europe")
        example_namespace = azure.servicebus.Namespace("example",
            name="tfex-servicebus-namespace",
            location=example.location,
            resource_group_name=example.name,
            sku="Standard",
            tags={
                "source": "example",
            })
        example_topic = azure.servicebus.Topic("example",
            name="tfex_servicebus_topic",
            namespace_id=example_namespace.id,
            partitioning_enabled=True)
        example_subscription = azure.servicebus.Subscription("example",
            name="tfex_servicebus_subscription",
            topic_id=example_topic.id,
            max_delivery_count=1)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ServiceBus` - 2024-01-01

        ## Import

        Service Bus Subscriptions can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:servicebus/subscription:Subscription example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.ServiceBus/namespaces/sbns1/topics/sntopic1/subscriptions/sbsub1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] auto_delete_on_idle: The idle interval after which the topic is automatically deleted as an [ISO 8601 duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). The minimum duration is `5` minutes or `PT5M`. Defaults to `P10675199DT2H48M5.4775807S`.
        :param pulumi.Input[_builtins.bool] batched_operations_enabled: Boolean flag which controls whether the Subscription supports batched operations.
        :param pulumi.Input[Union['SubscriptionClientScopedSubscriptionArgs', 'SubscriptionClientScopedSubscriptionArgsDict']] client_scoped_subscription: A `client_scoped_subscription` block as defined below.
        :param pulumi.Input[_builtins.bool] client_scoped_subscription_enabled: whether the subscription is scoped to a client id. Defaults to `false`.
               
               > **Note:** Client Scoped Subscription can only be used for JMS subscription (Java Message Service).
        :param pulumi.Input[_builtins.bool] dead_lettering_on_filter_evaluation_error: Boolean flag which controls whether the Subscription has dead letter support on filter evaluation exceptions. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] dead_lettering_on_message_expiration: Boolean flag which controls whether the Subscription has dead letter support when a message expires.
        :param pulumi.Input[_builtins.str] default_message_ttl: The Default message timespan to live as an [ISO 8601 duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). This is the duration after which the message expires, starting from when the message is sent to Service Bus. This is the value used when TimeToLive is not set on a message itself. Defaults to `P10675199DT2H48M5.4775807S`.
        :param pulumi.Input[_builtins.str] forward_dead_lettered_messages_to: The name of a Queue or Topic to automatically forward Dead Letter messages to.
        :param pulumi.Input[_builtins.str] forward_to: The name of a Queue or Topic to automatically forward messages to.
        :param pulumi.Input[_builtins.str] lock_duration: The lock duration for the subscription as an [ISO 8601 duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). The default value is `1` minute or `P0DT0H1M0S` . The maximum value is `5` minutes or `P0DT0H5M0S` . Defaults to `PT1M`.
        :param pulumi.Input[_builtins.int] max_delivery_count: The maximum number of deliveries.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the ServiceBus Subscription resource. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] requires_session: Boolean flag which controls whether this Subscription supports the concept of a session. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] status: The status of the Subscription. Possible values are `Active`,`ReceiveDisabled`, or `Disabled`. Defaults to `Active`.
        :param pulumi.Input[_builtins.str] topic_id: The ID of the ServiceBus Topic to create this Subscription in. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SubscriptionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a ServiceBus Subscription.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="tfex-servicebus-subscription",
            location="West Europe")
        example_namespace = azure.servicebus.Namespace("example",
            name="tfex-servicebus-namespace",
            location=example.location,
            resource_group_name=example.name,
            sku="Standard",
            tags={
                "source": "example",
            })
        example_topic = azure.servicebus.Topic("example",
            name="tfex_servicebus_topic",
            namespace_id=example_namespace.id,
            partitioning_enabled=True)
        example_subscription = azure.servicebus.Subscription("example",
            name="tfex_servicebus_subscription",
            topic_id=example_topic.id,
            max_delivery_count=1)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ServiceBus` - 2024-01-01

        ## Import

        Service Bus Subscriptions can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:servicebus/subscription:Subscription example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.ServiceBus/namespaces/sbns1/topics/sntopic1/subscriptions/sbsub1
        ```

        :param str resource_name: The name of the resource.
        :param SubscriptionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SubscriptionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_delete_on_idle: Optional[pulumi.Input[_builtins.str]] = None,
                 batched_operations_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 client_scoped_subscription: Optional[pulumi.Input[Union['SubscriptionClientScopedSubscriptionArgs', 'SubscriptionClientScopedSubscriptionArgsDict']]] = None,
                 client_scoped_subscription_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 dead_lettering_on_filter_evaluation_error: Optional[pulumi.Input[_builtins.bool]] = None,
                 dead_lettering_on_message_expiration: Optional[pulumi.Input[_builtins.bool]] = None,
                 default_message_ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 forward_dead_lettered_messages_to: Optional[pulumi.Input[_builtins.str]] = None,
                 forward_to: Optional[pulumi.Input[_builtins.str]] = None,
                 lock_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 max_delivery_count: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 requires_session: Optional[pulumi.Input[_builtins.bool]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 topic_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SubscriptionArgs.__new__(SubscriptionArgs)

            __props__.__dict__["auto_delete_on_idle"] = auto_delete_on_idle
            __props__.__dict__["batched_operations_enabled"] = batched_operations_enabled
            __props__.__dict__["client_scoped_subscription"] = client_scoped_subscription
            __props__.__dict__["client_scoped_subscription_enabled"] = client_scoped_subscription_enabled
            __props__.__dict__["dead_lettering_on_filter_evaluation_error"] = dead_lettering_on_filter_evaluation_error
            __props__.__dict__["dead_lettering_on_message_expiration"] = dead_lettering_on_message_expiration
            __props__.__dict__["default_message_ttl"] = default_message_ttl
            __props__.__dict__["forward_dead_lettered_messages_to"] = forward_dead_lettered_messages_to
            __props__.__dict__["forward_to"] = forward_to
            __props__.__dict__["lock_duration"] = lock_duration
            if max_delivery_count is None and not opts.urn:
                raise TypeError("Missing required property 'max_delivery_count'")
            __props__.__dict__["max_delivery_count"] = max_delivery_count
            __props__.__dict__["name"] = name
            __props__.__dict__["requires_session"] = requires_session
            __props__.__dict__["status"] = status
            if topic_id is None and not opts.urn:
                raise TypeError("Missing required property 'topic_id'")
            __props__.__dict__["topic_id"] = topic_id
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="azure:eventhub/subscription:Subscription")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(Subscription, __self__).__init__(
            'azure:servicebus/subscription:Subscription',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_delete_on_idle: Optional[pulumi.Input[_builtins.str]] = None,
            batched_operations_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            client_scoped_subscription: Optional[pulumi.Input[Union['SubscriptionClientScopedSubscriptionArgs', 'SubscriptionClientScopedSubscriptionArgsDict']]] = None,
            client_scoped_subscription_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            dead_lettering_on_filter_evaluation_error: Optional[pulumi.Input[_builtins.bool]] = None,
            dead_lettering_on_message_expiration: Optional[pulumi.Input[_builtins.bool]] = None,
            default_message_ttl: Optional[pulumi.Input[_builtins.str]] = None,
            forward_dead_lettered_messages_to: Optional[pulumi.Input[_builtins.str]] = None,
            forward_to: Optional[pulumi.Input[_builtins.str]] = None,
            lock_duration: Optional[pulumi.Input[_builtins.str]] = None,
            max_delivery_count: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            requires_session: Optional[pulumi.Input[_builtins.bool]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            topic_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'Subscription':
        """
        Get an existing Subscription resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] auto_delete_on_idle: The idle interval after which the topic is automatically deleted as an [ISO 8601 duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). The minimum duration is `5` minutes or `PT5M`. Defaults to `P10675199DT2H48M5.4775807S`.
        :param pulumi.Input[_builtins.bool] batched_operations_enabled: Boolean flag which controls whether the Subscription supports batched operations.
        :param pulumi.Input[Union['SubscriptionClientScopedSubscriptionArgs', 'SubscriptionClientScopedSubscriptionArgsDict']] client_scoped_subscription: A `client_scoped_subscription` block as defined below.
        :param pulumi.Input[_builtins.bool] client_scoped_subscription_enabled: whether the subscription is scoped to a client id. Defaults to `false`.
               
               > **Note:** Client Scoped Subscription can only be used for JMS subscription (Java Message Service).
        :param pulumi.Input[_builtins.bool] dead_lettering_on_filter_evaluation_error: Boolean flag which controls whether the Subscription has dead letter support on filter evaluation exceptions. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] dead_lettering_on_message_expiration: Boolean flag which controls whether the Subscription has dead letter support when a message expires.
        :param pulumi.Input[_builtins.str] default_message_ttl: The Default message timespan to live as an [ISO 8601 duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). This is the duration after which the message expires, starting from when the message is sent to Service Bus. This is the value used when TimeToLive is not set on a message itself. Defaults to `P10675199DT2H48M5.4775807S`.
        :param pulumi.Input[_builtins.str] forward_dead_lettered_messages_to: The name of a Queue or Topic to automatically forward Dead Letter messages to.
        :param pulumi.Input[_builtins.str] forward_to: The name of a Queue or Topic to automatically forward messages to.
        :param pulumi.Input[_builtins.str] lock_duration: The lock duration for the subscription as an [ISO 8601 duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). The default value is `1` minute or `P0DT0H1M0S` . The maximum value is `5` minutes or `P0DT0H5M0S` . Defaults to `PT1M`.
        :param pulumi.Input[_builtins.int] max_delivery_count: The maximum number of deliveries.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the ServiceBus Subscription resource. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] requires_session: Boolean flag which controls whether this Subscription supports the concept of a session. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] status: The status of the Subscription. Possible values are `Active`,`ReceiveDisabled`, or `Disabled`. Defaults to `Active`.
        :param pulumi.Input[_builtins.str] topic_id: The ID of the ServiceBus Topic to create this Subscription in. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SubscriptionState.__new__(_SubscriptionState)

        __props__.__dict__["auto_delete_on_idle"] = auto_delete_on_idle
        __props__.__dict__["batched_operations_enabled"] = batched_operations_enabled
        __props__.__dict__["client_scoped_subscription"] = client_scoped_subscription
        __props__.__dict__["client_scoped_subscription_enabled"] = client_scoped_subscription_enabled
        __props__.__dict__["dead_lettering_on_filter_evaluation_error"] = dead_lettering_on_filter_evaluation_error
        __props__.__dict__["dead_lettering_on_message_expiration"] = dead_lettering_on_message_expiration
        __props__.__dict__["default_message_ttl"] = default_message_ttl
        __props__.__dict__["forward_dead_lettered_messages_to"] = forward_dead_lettered_messages_to
        __props__.__dict__["forward_to"] = forward_to
        __props__.__dict__["lock_duration"] = lock_duration
        __props__.__dict__["max_delivery_count"] = max_delivery_count
        __props__.__dict__["name"] = name
        __props__.__dict__["requires_session"] = requires_session
        __props__.__dict__["status"] = status
        __props__.__dict__["topic_id"] = topic_id
        return Subscription(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autoDeleteOnIdle")
    def auto_delete_on_idle(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The idle interval after which the topic is automatically deleted as an [ISO 8601 duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). The minimum duration is `5` minutes or `PT5M`. Defaults to `P10675199DT2H48M5.4775807S`.
        """
        return pulumi.get(self, "auto_delete_on_idle")

    @_builtins.property
    @pulumi.getter(name="batchedOperationsEnabled")
    def batched_operations_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Boolean flag which controls whether the Subscription supports batched operations.
        """
        return pulumi.get(self, "batched_operations_enabled")

    @_builtins.property
    @pulumi.getter(name="clientScopedSubscription")
    def client_scoped_subscription(self) -> pulumi.Output[Optional['outputs.SubscriptionClientScopedSubscription']]:
        """
        A `client_scoped_subscription` block as defined below.
        """
        return pulumi.get(self, "client_scoped_subscription")

    @_builtins.property
    @pulumi.getter(name="clientScopedSubscriptionEnabled")
    def client_scoped_subscription_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        whether the subscription is scoped to a client id. Defaults to `false`.

        > **Note:** Client Scoped Subscription can only be used for JMS subscription (Java Message Service).
        """
        return pulumi.get(self, "client_scoped_subscription_enabled")

    @_builtins.property
    @pulumi.getter(name="deadLetteringOnFilterEvaluationError")
    def dead_lettering_on_filter_evaluation_error(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Boolean flag which controls whether the Subscription has dead letter support on filter evaluation exceptions. Defaults to `true`.
        """
        return pulumi.get(self, "dead_lettering_on_filter_evaluation_error")

    @_builtins.property
    @pulumi.getter(name="deadLetteringOnMessageExpiration")
    def dead_lettering_on_message_expiration(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Boolean flag which controls whether the Subscription has dead letter support when a message expires.
        """
        return pulumi.get(self, "dead_lettering_on_message_expiration")

    @_builtins.property
    @pulumi.getter(name="defaultMessageTtl")
    def default_message_ttl(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Default message timespan to live as an [ISO 8601 duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). This is the duration after which the message expires, starting from when the message is sent to Service Bus. This is the value used when TimeToLive is not set on a message itself. Defaults to `P10675199DT2H48M5.4775807S`.
        """
        return pulumi.get(self, "default_message_ttl")

    @_builtins.property
    @pulumi.getter(name="forwardDeadLetteredMessagesTo")
    def forward_dead_lettered_messages_to(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of a Queue or Topic to automatically forward Dead Letter messages to.
        """
        return pulumi.get(self, "forward_dead_lettered_messages_to")

    @_builtins.property
    @pulumi.getter(name="forwardTo")
    def forward_to(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of a Queue or Topic to automatically forward messages to.
        """
        return pulumi.get(self, "forward_to")

    @_builtins.property
    @pulumi.getter(name="lockDuration")
    def lock_duration(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The lock duration for the subscription as an [ISO 8601 duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). The default value is `1` minute or `P0DT0H1M0S` . The maximum value is `5` minutes or `P0DT0H5M0S` . Defaults to `PT1M`.
        """
        return pulumi.get(self, "lock_duration")

    @_builtins.property
    @pulumi.getter(name="maxDeliveryCount")
    def max_delivery_count(self) -> pulumi.Output[_builtins.int]:
        """
        The maximum number of deliveries.
        """
        return pulumi.get(self, "max_delivery_count")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the ServiceBus Subscription resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="requiresSession")
    def requires_session(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Boolean flag which controls whether this Subscription supports the concept of a session. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "requires_session")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The status of the Subscription. Possible values are `Active`,`ReceiveDisabled`, or `Disabled`. Defaults to `Active`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="topicId")
    def topic_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the ServiceBus Topic to create this Subscription in. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "topic_id")

