# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ProtectionContainerMappingAutomaticUpdate',
    'ReplicatedVMManagedDisk',
    'ReplicatedVMManagedDiskTargetDiskEncryption',
    'ReplicatedVMManagedDiskTargetDiskEncryptionDiskEncryptionKey',
    'ReplicatedVMManagedDiskTargetDiskEncryptionKeyEncryptionKey',
    'ReplicatedVMNetworkInterface',
    'ReplicatedVMUnmanagedDisk',
    'ReplicationRecoveryPlanAzureToAzureSettings',
    'ReplicationRecoveryPlanBootRecoveryGroup',
    'ReplicationRecoveryPlanBootRecoveryGroupPostAction',
    'ReplicationRecoveryPlanBootRecoveryGroupPreAction',
    'ReplicationRecoveryPlanFailoverRecoveryGroup',
    'ReplicationRecoveryPlanFailoverRecoveryGroupPostAction',
    'ReplicationRecoveryPlanFailoverRecoveryGroupPreAction',
    'ReplicationRecoveryPlanShutdownRecoveryGroup',
    'ReplicationRecoveryPlanShutdownRecoveryGroupPostAction',
    'ReplicationRecoveryPlanShutdownRecoveryGroupPreAction',
    'VmwareReplicatedVmManagedDisk',
    'VmwareReplicatedVmNetworkInterface',
    'GetReplicationRecoveryPlanAzureToAzureSettingResult',
    'GetReplicationRecoveryPlanRecoveryGroupResult',
    'GetReplicationRecoveryPlanRecoveryGroupPostActionResult',
    'GetReplicationRecoveryPlanRecoveryGroupPreActionResult',
]

@pulumi.output_type
class ProtectionContainerMappingAutomaticUpdate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authenticationType":
            suggest = "authentication_type"
        elif key == "automationAccountId":
            suggest = "automation_account_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProtectionContainerMappingAutomaticUpdate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProtectionContainerMappingAutomaticUpdate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProtectionContainerMappingAutomaticUpdate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authentication_type: Optional[_builtins.str] = None,
                 automation_account_id: Optional[_builtins.str] = None,
                 enabled: Optional[_builtins.bool] = None):
        """
        :param _builtins.str authentication_type: The authentication type used for automation account. Possible values are `RunAsAccount` and `SystemAssignedIdentity`. Defaults to `SystemAssignedIdentity`.
               
               > **Note:** `RunAsAccount` of `authentication_type` is deprecated and will retire on September 30, 2023. Details could be found [here](https://learn.microsoft.com/en-us/azure/automation/whats-new#support-for-run-as-accounts).
        :param _builtins.str automation_account_id: The automation account ID which holds the automatic update runbook and authenticates to Azure resources.
               
               > **Note:** `automation_account_id` is required when `enabled` is specified.
        :param _builtins.bool enabled: Should the Mobility service installed on Azure virtual machines be automatically updated. Defaults to `false`.
               
               > **Note:** The setting applies to all Azure VMs protected in the same container. For more details see [this document](https://learn.microsoft.com/en-us/azure/site-recovery/azure-to-azure-autoupdate#enable-automatic-updates)
        """
        if authentication_type is not None:
            pulumi.set(__self__, "authentication_type", authentication_type)
        if automation_account_id is not None:
            pulumi.set(__self__, "automation_account_id", automation_account_id)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @_builtins.property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> Optional[_builtins.str]:
        """
        The authentication type used for automation account. Possible values are `RunAsAccount` and `SystemAssignedIdentity`. Defaults to `SystemAssignedIdentity`.

        > **Note:** `RunAsAccount` of `authentication_type` is deprecated and will retire on September 30, 2023. Details could be found [here](https://learn.microsoft.com/en-us/azure/automation/whats-new#support-for-run-as-accounts).
        """
        return pulumi.get(self, "authentication_type")

    @_builtins.property
    @pulumi.getter(name="automationAccountId")
    def automation_account_id(self) -> Optional[_builtins.str]:
        """
        The automation account ID which holds the automatic update runbook and authenticates to Azure resources.

        > **Note:** `automation_account_id` is required when `enabled` is specified.
        """
        return pulumi.get(self, "automation_account_id")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Should the Mobility service installed on Azure virtual machines be automatically updated. Defaults to `false`.

        > **Note:** The setting applies to all Azure VMs protected in the same container. For more details see [this document](https://learn.microsoft.com/en-us/azure/site-recovery/azure-to-azure-autoupdate#enable-automatic-updates)
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class ReplicatedVMManagedDisk(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskId":
            suggest = "disk_id"
        elif key == "stagingStorageAccountId":
            suggest = "staging_storage_account_id"
        elif key == "targetDiskType":
            suggest = "target_disk_type"
        elif key == "targetReplicaDiskType":
            suggest = "target_replica_disk_type"
        elif key == "targetResourceGroupId":
            suggest = "target_resource_group_id"
        elif key == "targetDiskEncryption":
            suggest = "target_disk_encryption"
        elif key == "targetDiskEncryptionSetId":
            suggest = "target_disk_encryption_set_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReplicatedVMManagedDisk. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReplicatedVMManagedDisk.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReplicatedVMManagedDisk.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disk_id: _builtins.str,
                 staging_storage_account_id: _builtins.str,
                 target_disk_type: _builtins.str,
                 target_replica_disk_type: _builtins.str,
                 target_resource_group_id: _builtins.str,
                 target_disk_encryption: Optional['outputs.ReplicatedVMManagedDiskTargetDiskEncryption'] = None,
                 target_disk_encryption_set_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str disk_id: Id of disk that should be replicated. Changing this forces a new resource to be created.
        :param _builtins.str staging_storage_account_id: Storage account that should be used for caching. Changing this forces a new resource to be created.
        :param _builtins.str target_disk_type: What type should the disk be when a failover is done. Possible values are `Standard_LRS`, `Premium_LRS`, `PremiumV2_LRS`, `StandardSSD_LRS`, `UltraSSD_LRS`, `StandardSSD_ZRS` and `Premium_ZRS`. Changing this forces a new resource to be created.
        :param _builtins.str target_replica_disk_type: What type should the disk be that holds the replication data. Possible values are `Standard_LRS`, `Premium_LRS`, `StandardSSD_LRS`, `UltraSSD_LRS`, `StandardSSD_ZRS` and `Premium_ZRS`. Changing this forces a new resource to be created.
        :param _builtins.str target_resource_group_id: Resource group disk should belong to when a failover is done. Changing this forces a new resource to be created.
        :param 'ReplicatedVMManagedDiskTargetDiskEncryptionArgs' target_disk_encryption: A `target_disk_encryption` block as defined below.
        :param _builtins.str target_disk_encryption_set_id: The Disk Encryption Set that the Managed Disk will be associated with. Changing this forces a new resource to be created.
               
               > **Note:** Creating replicated vm with `target_disk_encryption_set_id` wil take more time (up to 5 hours), please extend the `timeout` for `create`.
        """
        pulumi.set(__self__, "disk_id", disk_id)
        pulumi.set(__self__, "staging_storage_account_id", staging_storage_account_id)
        pulumi.set(__self__, "target_disk_type", target_disk_type)
        pulumi.set(__self__, "target_replica_disk_type", target_replica_disk_type)
        pulumi.set(__self__, "target_resource_group_id", target_resource_group_id)
        if target_disk_encryption is not None:
            pulumi.set(__self__, "target_disk_encryption", target_disk_encryption)
        if target_disk_encryption_set_id is not None:
            pulumi.set(__self__, "target_disk_encryption_set_id", target_disk_encryption_set_id)

    @_builtins.property
    @pulumi.getter(name="diskId")
    def disk_id(self) -> _builtins.str:
        """
        Id of disk that should be replicated. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "disk_id")

    @_builtins.property
    @pulumi.getter(name="stagingStorageAccountId")
    def staging_storage_account_id(self) -> _builtins.str:
        """
        Storage account that should be used for caching. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "staging_storage_account_id")

    @_builtins.property
    @pulumi.getter(name="targetDiskType")
    def target_disk_type(self) -> _builtins.str:
        """
        What type should the disk be when a failover is done. Possible values are `Standard_LRS`, `Premium_LRS`, `PremiumV2_LRS`, `StandardSSD_LRS`, `UltraSSD_LRS`, `StandardSSD_ZRS` and `Premium_ZRS`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "target_disk_type")

    @_builtins.property
    @pulumi.getter(name="targetReplicaDiskType")
    def target_replica_disk_type(self) -> _builtins.str:
        """
        What type should the disk be that holds the replication data. Possible values are `Standard_LRS`, `Premium_LRS`, `StandardSSD_LRS`, `UltraSSD_LRS`, `StandardSSD_ZRS` and `Premium_ZRS`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "target_replica_disk_type")

    @_builtins.property
    @pulumi.getter(name="targetResourceGroupId")
    def target_resource_group_id(self) -> _builtins.str:
        """
        Resource group disk should belong to when a failover is done. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "target_resource_group_id")

    @_builtins.property
    @pulumi.getter(name="targetDiskEncryption")
    def target_disk_encryption(self) -> Optional['outputs.ReplicatedVMManagedDiskTargetDiskEncryption']:
        """
        A `target_disk_encryption` block as defined below.
        """
        return pulumi.get(self, "target_disk_encryption")

    @_builtins.property
    @pulumi.getter(name="targetDiskEncryptionSetId")
    def target_disk_encryption_set_id(self) -> Optional[_builtins.str]:
        """
        The Disk Encryption Set that the Managed Disk will be associated with. Changing this forces a new resource to be created.

        > **Note:** Creating replicated vm with `target_disk_encryption_set_id` wil take more time (up to 5 hours), please extend the `timeout` for `create`.
        """
        return pulumi.get(self, "target_disk_encryption_set_id")


@pulumi.output_type
class ReplicatedVMManagedDiskTargetDiskEncryption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskEncryptionKey":
            suggest = "disk_encryption_key"
        elif key == "keyEncryptionKey":
            suggest = "key_encryption_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReplicatedVMManagedDiskTargetDiskEncryption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReplicatedVMManagedDiskTargetDiskEncryption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReplicatedVMManagedDiskTargetDiskEncryption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disk_encryption_key: 'outputs.ReplicatedVMManagedDiskTargetDiskEncryptionDiskEncryptionKey',
                 key_encryption_key: Optional['outputs.ReplicatedVMManagedDiskTargetDiskEncryptionKeyEncryptionKey'] = None):
        """
        :param 'ReplicatedVMManagedDiskTargetDiskEncryptionDiskEncryptionKeyArgs' disk_encryption_key: A `disk_encryption_key` block as defined below.
        :param 'ReplicatedVMManagedDiskTargetDiskEncryptionKeyEncryptionKeyArgs' key_encryption_key: A `key_encryption_key` block as defined below.
        """
        pulumi.set(__self__, "disk_encryption_key", disk_encryption_key)
        if key_encryption_key is not None:
            pulumi.set(__self__, "key_encryption_key", key_encryption_key)

    @_builtins.property
    @pulumi.getter(name="diskEncryptionKey")
    def disk_encryption_key(self) -> 'outputs.ReplicatedVMManagedDiskTargetDiskEncryptionDiskEncryptionKey':
        """
        A `disk_encryption_key` block as defined below.
        """
        return pulumi.get(self, "disk_encryption_key")

    @_builtins.property
    @pulumi.getter(name="keyEncryptionKey")
    def key_encryption_key(self) -> Optional['outputs.ReplicatedVMManagedDiskTargetDiskEncryptionKeyEncryptionKey']:
        """
        A `key_encryption_key` block as defined below.
        """
        return pulumi.get(self, "key_encryption_key")


@pulumi.output_type
class ReplicatedVMManagedDiskTargetDiskEncryptionDiskEncryptionKey(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretUrl":
            suggest = "secret_url"
        elif key == "vaultId":
            suggest = "vault_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReplicatedVMManagedDiskTargetDiskEncryptionDiskEncryptionKey. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReplicatedVMManagedDiskTargetDiskEncryptionDiskEncryptionKey.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReplicatedVMManagedDiskTargetDiskEncryptionDiskEncryptionKey.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret_url: _builtins.str,
                 vault_id: _builtins.str):
        """
        :param _builtins.str secret_url: The URL to the Key Vault Secret used as the Disk Encryption Key that the Managed Disk will be associated with. This can be found as `id` on the `keyvault.Secret` resource. Changing this forces a new resource to be created.
        :param _builtins.str vault_id: The ID of the Key Vault. This can be found as `id` on the `keyvault.KeyVault` resource. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "secret_url", secret_url)
        pulumi.set(__self__, "vault_id", vault_id)

    @_builtins.property
    @pulumi.getter(name="secretUrl")
    def secret_url(self) -> _builtins.str:
        """
        The URL to the Key Vault Secret used as the Disk Encryption Key that the Managed Disk will be associated with. This can be found as `id` on the `keyvault.Secret` resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "secret_url")

    @_builtins.property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> _builtins.str:
        """
        The ID of the Key Vault. This can be found as `id` on the `keyvault.KeyVault` resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "vault_id")


@pulumi.output_type
class ReplicatedVMManagedDiskTargetDiskEncryptionKeyEncryptionKey(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyUrl":
            suggest = "key_url"
        elif key == "vaultId":
            suggest = "vault_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReplicatedVMManagedDiskTargetDiskEncryptionKeyEncryptionKey. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReplicatedVMManagedDiskTargetDiskEncryptionKeyEncryptionKey.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReplicatedVMManagedDiskTargetDiskEncryptionKeyEncryptionKey.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_url: _builtins.str,
                 vault_id: _builtins.str):
        """
        :param _builtins.str key_url: The URL to the Key Vault Key used as the Key Encryption Key that the Managed Disk will be associated with. This can be found as `id` on the `keyvault.Key` resource. Changing this forces a new resource to be created.
        :param _builtins.str vault_id: The ID of the Key Vault. This can be found as `id` on the `keyvault.KeyVault` resource. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "key_url", key_url)
        pulumi.set(__self__, "vault_id", vault_id)

    @_builtins.property
    @pulumi.getter(name="keyUrl")
    def key_url(self) -> _builtins.str:
        """
        The URL to the Key Vault Key used as the Key Encryption Key that the Managed Disk will be associated with. This can be found as `id` on the `keyvault.Key` resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "key_url")

    @_builtins.property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> _builtins.str:
        """
        The ID of the Key Vault. This can be found as `id` on the `keyvault.KeyVault` resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "vault_id")


@pulumi.output_type
class ReplicatedVMNetworkInterface(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failoverTestPublicIpAddressId":
            suggest = "failover_test_public_ip_address_id"
        elif key == "failoverTestStaticIp":
            suggest = "failover_test_static_ip"
        elif key == "failoverTestSubnetName":
            suggest = "failover_test_subnet_name"
        elif key == "recoveryLoadBalancerBackendAddressPoolIds":
            suggest = "recovery_load_balancer_backend_address_pool_ids"
        elif key == "recoveryPublicIpAddressId":
            suggest = "recovery_public_ip_address_id"
        elif key == "sourceNetworkInterfaceId":
            suggest = "source_network_interface_id"
        elif key == "targetStaticIp":
            suggest = "target_static_ip"
        elif key == "targetSubnetName":
            suggest = "target_subnet_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReplicatedVMNetworkInterface. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReplicatedVMNetworkInterface.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReplicatedVMNetworkInterface.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 failover_test_public_ip_address_id: Optional[_builtins.str] = None,
                 failover_test_static_ip: Optional[_builtins.str] = None,
                 failover_test_subnet_name: Optional[_builtins.str] = None,
                 recovery_load_balancer_backend_address_pool_ids: Optional[Sequence[_builtins.str]] = None,
                 recovery_public_ip_address_id: Optional[_builtins.str] = None,
                 source_network_interface_id: Optional[_builtins.str] = None,
                 target_static_ip: Optional[_builtins.str] = None,
                 target_subnet_name: Optional[_builtins.str] = None):
        """
        :param _builtins.str failover_test_public_ip_address_id: Id of the public IP object to use when a test failover is done.
        :param _builtins.str failover_test_static_ip: Static IP to assign when a test failover is done.
        :param _builtins.str failover_test_subnet_name: Name of the subnet to use when a test failover is done.
        :param Sequence[_builtins.str] recovery_load_balancer_backend_address_pool_ids: A list of IDs of Load Balancer Backend Address Pools to use when a failover is done.
        :param _builtins.str recovery_public_ip_address_id: Id of the public IP object to use when a failover is done.
        :param _builtins.str source_network_interface_id: (Required if the network_interface block is specified) Id source network interface.
        :param _builtins.str target_static_ip: Static IP to assign when a failover is done.
        :param _builtins.str target_subnet_name: Name of the subnet to use when a failover is done.
        """
        if failover_test_public_ip_address_id is not None:
            pulumi.set(__self__, "failover_test_public_ip_address_id", failover_test_public_ip_address_id)
        if failover_test_static_ip is not None:
            pulumi.set(__self__, "failover_test_static_ip", failover_test_static_ip)
        if failover_test_subnet_name is not None:
            pulumi.set(__self__, "failover_test_subnet_name", failover_test_subnet_name)
        if recovery_load_balancer_backend_address_pool_ids is not None:
            pulumi.set(__self__, "recovery_load_balancer_backend_address_pool_ids", recovery_load_balancer_backend_address_pool_ids)
        if recovery_public_ip_address_id is not None:
            pulumi.set(__self__, "recovery_public_ip_address_id", recovery_public_ip_address_id)
        if source_network_interface_id is not None:
            pulumi.set(__self__, "source_network_interface_id", source_network_interface_id)
        if target_static_ip is not None:
            pulumi.set(__self__, "target_static_ip", target_static_ip)
        if target_subnet_name is not None:
            pulumi.set(__self__, "target_subnet_name", target_subnet_name)

    @_builtins.property
    @pulumi.getter(name="failoverTestPublicIpAddressId")
    def failover_test_public_ip_address_id(self) -> Optional[_builtins.str]:
        """
        Id of the public IP object to use when a test failover is done.
        """
        return pulumi.get(self, "failover_test_public_ip_address_id")

    @_builtins.property
    @pulumi.getter(name="failoverTestStaticIp")
    def failover_test_static_ip(self) -> Optional[_builtins.str]:
        """
        Static IP to assign when a test failover is done.
        """
        return pulumi.get(self, "failover_test_static_ip")

    @_builtins.property
    @pulumi.getter(name="failoverTestSubnetName")
    def failover_test_subnet_name(self) -> Optional[_builtins.str]:
        """
        Name of the subnet to use when a test failover is done.
        """
        return pulumi.get(self, "failover_test_subnet_name")

    @_builtins.property
    @pulumi.getter(name="recoveryLoadBalancerBackendAddressPoolIds")
    def recovery_load_balancer_backend_address_pool_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of IDs of Load Balancer Backend Address Pools to use when a failover is done.
        """
        return pulumi.get(self, "recovery_load_balancer_backend_address_pool_ids")

    @_builtins.property
    @pulumi.getter(name="recoveryPublicIpAddressId")
    def recovery_public_ip_address_id(self) -> Optional[_builtins.str]:
        """
        Id of the public IP object to use when a failover is done.
        """
        return pulumi.get(self, "recovery_public_ip_address_id")

    @_builtins.property
    @pulumi.getter(name="sourceNetworkInterfaceId")
    def source_network_interface_id(self) -> Optional[_builtins.str]:
        """
        (Required if the network_interface block is specified) Id source network interface.
        """
        return pulumi.get(self, "source_network_interface_id")

    @_builtins.property
    @pulumi.getter(name="targetStaticIp")
    def target_static_ip(self) -> Optional[_builtins.str]:
        """
        Static IP to assign when a failover is done.
        """
        return pulumi.get(self, "target_static_ip")

    @_builtins.property
    @pulumi.getter(name="targetSubnetName")
    def target_subnet_name(self) -> Optional[_builtins.str]:
        """
        Name of the subnet to use when a failover is done.
        """
        return pulumi.get(self, "target_subnet_name")


@pulumi.output_type
class ReplicatedVMUnmanagedDisk(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskUri":
            suggest = "disk_uri"
        elif key == "stagingStorageAccountId":
            suggest = "staging_storage_account_id"
        elif key == "targetStorageAccountId":
            suggest = "target_storage_account_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReplicatedVMUnmanagedDisk. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReplicatedVMUnmanagedDisk.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReplicatedVMUnmanagedDisk.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disk_uri: _builtins.str,
                 staging_storage_account_id: _builtins.str,
                 target_storage_account_id: _builtins.str):
        """
        :param _builtins.str disk_uri: Id of disk that should be replicated. Changing this forces a new resource to be created.
        :param _builtins.str staging_storage_account_id: Storage account that should be used for caching. Changing this forces a new resource to be created.
        :param _builtins.str target_storage_account_id: Storage account disk should belong to when a failover is done. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "disk_uri", disk_uri)
        pulumi.set(__self__, "staging_storage_account_id", staging_storage_account_id)
        pulumi.set(__self__, "target_storage_account_id", target_storage_account_id)

    @_builtins.property
    @pulumi.getter(name="diskUri")
    def disk_uri(self) -> _builtins.str:
        """
        Id of disk that should be replicated. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "disk_uri")

    @_builtins.property
    @pulumi.getter(name="stagingStorageAccountId")
    def staging_storage_account_id(self) -> _builtins.str:
        """
        Storage account that should be used for caching. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "staging_storage_account_id")

    @_builtins.property
    @pulumi.getter(name="targetStorageAccountId")
    def target_storage_account_id(self) -> _builtins.str:
        """
        Storage account disk should belong to when a failover is done. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "target_storage_account_id")


@pulumi.output_type
class ReplicationRecoveryPlanAzureToAzureSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "primaryEdgeZone":
            suggest = "primary_edge_zone"
        elif key == "primaryZone":
            suggest = "primary_zone"
        elif key == "recoveryEdgeZone":
            suggest = "recovery_edge_zone"
        elif key == "recoveryZone":
            suggest = "recovery_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReplicationRecoveryPlanAzureToAzureSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReplicationRecoveryPlanAzureToAzureSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReplicationRecoveryPlanAzureToAzureSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 primary_edge_zone: Optional[_builtins.str] = None,
                 primary_zone: Optional[_builtins.str] = None,
                 recovery_edge_zone: Optional[_builtins.str] = None,
                 recovery_zone: Optional[_builtins.str] = None):
        """
        :param _builtins.str primary_edge_zone: The Edge Zone within the Azure Region where the VM exists. Changing this forces a new Site Recovery Replication Recovery Plan to be created.
        :param _builtins.str primary_zone: The Availability Zone in which the VM is located. Changing this forces a new Site Recovery Replication Recovery Plan to be created.
        :param _builtins.str recovery_edge_zone: The Edge Zone within the Azure Region where the VM is recovered. Changing this forces a new Site Recovery Replication Recovery Plan to be created.
               
               > **Note:** `primary_edge_zone` and `recovery_edge_zone` must be specified together.
        :param _builtins.str recovery_zone: The Availability Zone in which the VM is recovered. Changing this forces a new Site Recovery Replication Recovery Plan to be created.
               
               > **Note:** `primary_zone` and `recovery_zone` must be specified together.
        """
        if primary_edge_zone is not None:
            pulumi.set(__self__, "primary_edge_zone", primary_edge_zone)
        if primary_zone is not None:
            pulumi.set(__self__, "primary_zone", primary_zone)
        if recovery_edge_zone is not None:
            pulumi.set(__self__, "recovery_edge_zone", recovery_edge_zone)
        if recovery_zone is not None:
            pulumi.set(__self__, "recovery_zone", recovery_zone)

    @_builtins.property
    @pulumi.getter(name="primaryEdgeZone")
    def primary_edge_zone(self) -> Optional[_builtins.str]:
        """
        The Edge Zone within the Azure Region where the VM exists. Changing this forces a new Site Recovery Replication Recovery Plan to be created.
        """
        return pulumi.get(self, "primary_edge_zone")

    @_builtins.property
    @pulumi.getter(name="primaryZone")
    def primary_zone(self) -> Optional[_builtins.str]:
        """
        The Availability Zone in which the VM is located. Changing this forces a new Site Recovery Replication Recovery Plan to be created.
        """
        return pulumi.get(self, "primary_zone")

    @_builtins.property
    @pulumi.getter(name="recoveryEdgeZone")
    def recovery_edge_zone(self) -> Optional[_builtins.str]:
        """
        The Edge Zone within the Azure Region where the VM is recovered. Changing this forces a new Site Recovery Replication Recovery Plan to be created.

        > **Note:** `primary_edge_zone` and `recovery_edge_zone` must be specified together.
        """
        return pulumi.get(self, "recovery_edge_zone")

    @_builtins.property
    @pulumi.getter(name="recoveryZone")
    def recovery_zone(self) -> Optional[_builtins.str]:
        """
        The Availability Zone in which the VM is recovered. Changing this forces a new Site Recovery Replication Recovery Plan to be created.

        > **Note:** `primary_zone` and `recovery_zone` must be specified together.
        """
        return pulumi.get(self, "recovery_zone")


@pulumi.output_type
class ReplicationRecoveryPlanBootRecoveryGroup(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "postActions":
            suggest = "post_actions"
        elif key == "preActions":
            suggest = "pre_actions"
        elif key == "replicatedProtectedItems":
            suggest = "replicated_protected_items"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReplicationRecoveryPlanBootRecoveryGroup. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReplicationRecoveryPlanBootRecoveryGroup.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReplicationRecoveryPlanBootRecoveryGroup.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 post_actions: Optional[Sequence['outputs.ReplicationRecoveryPlanBootRecoveryGroupPostAction']] = None,
                 pre_actions: Optional[Sequence['outputs.ReplicationRecoveryPlanBootRecoveryGroupPreAction']] = None,
                 replicated_protected_items: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence['ReplicationRecoveryPlanBootRecoveryGroupPostActionArgs'] post_actions: one or more `action` block as defined below. which will be executed after the group recovery.
        :param Sequence['ReplicationRecoveryPlanBootRecoveryGroupPreActionArgs'] pre_actions: one or more `action` block as defined below. which will be executed before the group recovery.
        :param Sequence[_builtins.str] replicated_protected_items: One or more protected VM IDs.
        """
        if post_actions is not None:
            pulumi.set(__self__, "post_actions", post_actions)
        if pre_actions is not None:
            pulumi.set(__self__, "pre_actions", pre_actions)
        if replicated_protected_items is not None:
            pulumi.set(__self__, "replicated_protected_items", replicated_protected_items)

    @_builtins.property
    @pulumi.getter(name="postActions")
    def post_actions(self) -> Optional[Sequence['outputs.ReplicationRecoveryPlanBootRecoveryGroupPostAction']]:
        """
        one or more `action` block as defined below. which will be executed after the group recovery.
        """
        return pulumi.get(self, "post_actions")

    @_builtins.property
    @pulumi.getter(name="preActions")
    def pre_actions(self) -> Optional[Sequence['outputs.ReplicationRecoveryPlanBootRecoveryGroupPreAction']]:
        """
        one or more `action` block as defined below. which will be executed before the group recovery.
        """
        return pulumi.get(self, "pre_actions")

    @_builtins.property
    @pulumi.getter(name="replicatedProtectedItems")
    def replicated_protected_items(self) -> Optional[Sequence[_builtins.str]]:
        """
        One or more protected VM IDs.
        """
        return pulumi.get(self, "replicated_protected_items")


@pulumi.output_type
class ReplicationRecoveryPlanBootRecoveryGroupPostAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failOverDirections":
            suggest = "fail_over_directions"
        elif key == "failOverTypes":
            suggest = "fail_over_types"
        elif key == "fabricLocation":
            suggest = "fabric_location"
        elif key == "manualActionInstruction":
            suggest = "manual_action_instruction"
        elif key == "runbookId":
            suggest = "runbook_id"
        elif key == "scriptPath":
            suggest = "script_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReplicationRecoveryPlanBootRecoveryGroupPostAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReplicationRecoveryPlanBootRecoveryGroupPostAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReplicationRecoveryPlanBootRecoveryGroupPostAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fail_over_directions: Sequence[_builtins.str],
                 fail_over_types: Sequence[_builtins.str],
                 name: _builtins.str,
                 type: _builtins.str,
                 fabric_location: Optional[_builtins.str] = None,
                 manual_action_instruction: Optional[_builtins.str] = None,
                 runbook_id: Optional[_builtins.str] = None,
                 script_path: Optional[_builtins.str] = None):
        """
        :param Sequence[_builtins.str] fail_over_directions: Directions of fail over. Possible values are `PrimaryToRecovery` and `RecoveryToPrimary`
        :param Sequence[_builtins.str] fail_over_types: Types of fail over. Possible values are `TestFailover`, `PlannedFailover` and `UnplannedFailover`
        :param _builtins.str name: The name of the Replication Plan. The name can contain only letters, numbers, and hyphens. It should start with a letter and end with a letter or a number. Can be a maximum of 63 characters. Changing this forces a new resource to be created.
        :param _builtins.str type: Type of the action detail. Possible values are `AutomationRunbookActionDetails`, `ManualActionDetails` and `ScriptActionDetails`.
        :param _builtins.str fabric_location: The fabric location of runbook or script. Possible values are `Primary` and `Recovery`. It must not be specified when `type` is `ManualActionDetails`.
               
               > **Note:** This is required when `type` is set to `AutomationRunbookActionDetails` or `ScriptActionDetails`.
        :param _builtins.str manual_action_instruction: Instructions of manual action.
               
               > **Note:** This property is required when `type` is set to `ManualActionDetails`.
        :param _builtins.str runbook_id: Id of runbook.
               
               > **Note:** This property is required when `type` is set to `AutomationRunbookActionDetails`.
        :param _builtins.str script_path: Path of action script.
               
               > **Note:** This property is required when `type` is set to `ScriptActionDetails`.
        """
        pulumi.set(__self__, "fail_over_directions", fail_over_directions)
        pulumi.set(__self__, "fail_over_types", fail_over_types)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if fabric_location is not None:
            pulumi.set(__self__, "fabric_location", fabric_location)
        if manual_action_instruction is not None:
            pulumi.set(__self__, "manual_action_instruction", manual_action_instruction)
        if runbook_id is not None:
            pulumi.set(__self__, "runbook_id", runbook_id)
        if script_path is not None:
            pulumi.set(__self__, "script_path", script_path)

    @_builtins.property
    @pulumi.getter(name="failOverDirections")
    def fail_over_directions(self) -> Sequence[_builtins.str]:
        """
        Directions of fail over. Possible values are `PrimaryToRecovery` and `RecoveryToPrimary`
        """
        return pulumi.get(self, "fail_over_directions")

    @_builtins.property
    @pulumi.getter(name="failOverTypes")
    def fail_over_types(self) -> Sequence[_builtins.str]:
        """
        Types of fail over. Possible values are `TestFailover`, `PlannedFailover` and `UnplannedFailover`
        """
        return pulumi.get(self, "fail_over_types")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Replication Plan. The name can contain only letters, numbers, and hyphens. It should start with a letter and end with a letter or a number. Can be a maximum of 63 characters. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of the action detail. Possible values are `AutomationRunbookActionDetails`, `ManualActionDetails` and `ScriptActionDetails`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="fabricLocation")
    def fabric_location(self) -> Optional[_builtins.str]:
        """
        The fabric location of runbook or script. Possible values are `Primary` and `Recovery`. It must not be specified when `type` is `ManualActionDetails`.

        > **Note:** This is required when `type` is set to `AutomationRunbookActionDetails` or `ScriptActionDetails`.
        """
        return pulumi.get(self, "fabric_location")

    @_builtins.property
    @pulumi.getter(name="manualActionInstruction")
    def manual_action_instruction(self) -> Optional[_builtins.str]:
        """
        Instructions of manual action.

        > **Note:** This property is required when `type` is set to `ManualActionDetails`.
        """
        return pulumi.get(self, "manual_action_instruction")

    @_builtins.property
    @pulumi.getter(name="runbookId")
    def runbook_id(self) -> Optional[_builtins.str]:
        """
        Id of runbook.

        > **Note:** This property is required when `type` is set to `AutomationRunbookActionDetails`.
        """
        return pulumi.get(self, "runbook_id")

    @_builtins.property
    @pulumi.getter(name="scriptPath")
    def script_path(self) -> Optional[_builtins.str]:
        """
        Path of action script.

        > **Note:** This property is required when `type` is set to `ScriptActionDetails`.
        """
        return pulumi.get(self, "script_path")


@pulumi.output_type
class ReplicationRecoveryPlanBootRecoveryGroupPreAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failOverDirections":
            suggest = "fail_over_directions"
        elif key == "failOverTypes":
            suggest = "fail_over_types"
        elif key == "fabricLocation":
            suggest = "fabric_location"
        elif key == "manualActionInstruction":
            suggest = "manual_action_instruction"
        elif key == "runbookId":
            suggest = "runbook_id"
        elif key == "scriptPath":
            suggest = "script_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReplicationRecoveryPlanBootRecoveryGroupPreAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReplicationRecoveryPlanBootRecoveryGroupPreAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReplicationRecoveryPlanBootRecoveryGroupPreAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fail_over_directions: Sequence[_builtins.str],
                 fail_over_types: Sequence[_builtins.str],
                 name: _builtins.str,
                 type: _builtins.str,
                 fabric_location: Optional[_builtins.str] = None,
                 manual_action_instruction: Optional[_builtins.str] = None,
                 runbook_id: Optional[_builtins.str] = None,
                 script_path: Optional[_builtins.str] = None):
        """
        :param Sequence[_builtins.str] fail_over_directions: Directions of fail over. Possible values are `PrimaryToRecovery` and `RecoveryToPrimary`
        :param Sequence[_builtins.str] fail_over_types: Types of fail over. Possible values are `TestFailover`, `PlannedFailover` and `UnplannedFailover`
        :param _builtins.str name: The name of the Replication Plan. The name can contain only letters, numbers, and hyphens. It should start with a letter and end with a letter or a number. Can be a maximum of 63 characters. Changing this forces a new resource to be created.
        :param _builtins.str type: Type of the action detail. Possible values are `AutomationRunbookActionDetails`, `ManualActionDetails` and `ScriptActionDetails`.
        :param _builtins.str fabric_location: The fabric location of runbook or script. Possible values are `Primary` and `Recovery`. It must not be specified when `type` is `ManualActionDetails`.
               
               > **Note:** This is required when `type` is set to `AutomationRunbookActionDetails` or `ScriptActionDetails`.
        :param _builtins.str manual_action_instruction: Instructions of manual action.
               
               > **Note:** This property is required when `type` is set to `ManualActionDetails`.
        :param _builtins.str runbook_id: Id of runbook.
               
               > **Note:** This property is required when `type` is set to `AutomationRunbookActionDetails`.
        :param _builtins.str script_path: Path of action script.
               
               > **Note:** This property is required when `type` is set to `ScriptActionDetails`.
        """
        pulumi.set(__self__, "fail_over_directions", fail_over_directions)
        pulumi.set(__self__, "fail_over_types", fail_over_types)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if fabric_location is not None:
            pulumi.set(__self__, "fabric_location", fabric_location)
        if manual_action_instruction is not None:
            pulumi.set(__self__, "manual_action_instruction", manual_action_instruction)
        if runbook_id is not None:
            pulumi.set(__self__, "runbook_id", runbook_id)
        if script_path is not None:
            pulumi.set(__self__, "script_path", script_path)

    @_builtins.property
    @pulumi.getter(name="failOverDirections")
    def fail_over_directions(self) -> Sequence[_builtins.str]:
        """
        Directions of fail over. Possible values are `PrimaryToRecovery` and `RecoveryToPrimary`
        """
        return pulumi.get(self, "fail_over_directions")

    @_builtins.property
    @pulumi.getter(name="failOverTypes")
    def fail_over_types(self) -> Sequence[_builtins.str]:
        """
        Types of fail over. Possible values are `TestFailover`, `PlannedFailover` and `UnplannedFailover`
        """
        return pulumi.get(self, "fail_over_types")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Replication Plan. The name can contain only letters, numbers, and hyphens. It should start with a letter and end with a letter or a number. Can be a maximum of 63 characters. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of the action detail. Possible values are `AutomationRunbookActionDetails`, `ManualActionDetails` and `ScriptActionDetails`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="fabricLocation")
    def fabric_location(self) -> Optional[_builtins.str]:
        """
        The fabric location of runbook or script. Possible values are `Primary` and `Recovery`. It must not be specified when `type` is `ManualActionDetails`.

        > **Note:** This is required when `type` is set to `AutomationRunbookActionDetails` or `ScriptActionDetails`.
        """
        return pulumi.get(self, "fabric_location")

    @_builtins.property
    @pulumi.getter(name="manualActionInstruction")
    def manual_action_instruction(self) -> Optional[_builtins.str]:
        """
        Instructions of manual action.

        > **Note:** This property is required when `type` is set to `ManualActionDetails`.
        """
        return pulumi.get(self, "manual_action_instruction")

    @_builtins.property
    @pulumi.getter(name="runbookId")
    def runbook_id(self) -> Optional[_builtins.str]:
        """
        Id of runbook.

        > **Note:** This property is required when `type` is set to `AutomationRunbookActionDetails`.
        """
        return pulumi.get(self, "runbook_id")

    @_builtins.property
    @pulumi.getter(name="scriptPath")
    def script_path(self) -> Optional[_builtins.str]:
        """
        Path of action script.

        > **Note:** This property is required when `type` is set to `ScriptActionDetails`.
        """
        return pulumi.get(self, "script_path")


@pulumi.output_type
class ReplicationRecoveryPlanFailoverRecoveryGroup(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "postActions":
            suggest = "post_actions"
        elif key == "preActions":
            suggest = "pre_actions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReplicationRecoveryPlanFailoverRecoveryGroup. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReplicationRecoveryPlanFailoverRecoveryGroup.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReplicationRecoveryPlanFailoverRecoveryGroup.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 post_actions: Optional[Sequence['outputs.ReplicationRecoveryPlanFailoverRecoveryGroupPostAction']] = None,
                 pre_actions: Optional[Sequence['outputs.ReplicationRecoveryPlanFailoverRecoveryGroupPreAction']] = None):
        """
        :param Sequence['ReplicationRecoveryPlanFailoverRecoveryGroupPostActionArgs'] post_actions: one or more `action` block as defined below. which will be executed after the group recovery.
        :param Sequence['ReplicationRecoveryPlanFailoverRecoveryGroupPreActionArgs'] pre_actions: one or more `action` block as defined below. which will be executed before the group recovery.
        """
        if post_actions is not None:
            pulumi.set(__self__, "post_actions", post_actions)
        if pre_actions is not None:
            pulumi.set(__self__, "pre_actions", pre_actions)

    @_builtins.property
    @pulumi.getter(name="postActions")
    def post_actions(self) -> Optional[Sequence['outputs.ReplicationRecoveryPlanFailoverRecoveryGroupPostAction']]:
        """
        one or more `action` block as defined below. which will be executed after the group recovery.
        """
        return pulumi.get(self, "post_actions")

    @_builtins.property
    @pulumi.getter(name="preActions")
    def pre_actions(self) -> Optional[Sequence['outputs.ReplicationRecoveryPlanFailoverRecoveryGroupPreAction']]:
        """
        one or more `action` block as defined below. which will be executed before the group recovery.
        """
        return pulumi.get(self, "pre_actions")


@pulumi.output_type
class ReplicationRecoveryPlanFailoverRecoveryGroupPostAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failOverDirections":
            suggest = "fail_over_directions"
        elif key == "failOverTypes":
            suggest = "fail_over_types"
        elif key == "fabricLocation":
            suggest = "fabric_location"
        elif key == "manualActionInstruction":
            suggest = "manual_action_instruction"
        elif key == "runbookId":
            suggest = "runbook_id"
        elif key == "scriptPath":
            suggest = "script_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReplicationRecoveryPlanFailoverRecoveryGroupPostAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReplicationRecoveryPlanFailoverRecoveryGroupPostAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReplicationRecoveryPlanFailoverRecoveryGroupPostAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fail_over_directions: Sequence[_builtins.str],
                 fail_over_types: Sequence[_builtins.str],
                 name: _builtins.str,
                 type: _builtins.str,
                 fabric_location: Optional[_builtins.str] = None,
                 manual_action_instruction: Optional[_builtins.str] = None,
                 runbook_id: Optional[_builtins.str] = None,
                 script_path: Optional[_builtins.str] = None):
        """
        :param Sequence[_builtins.str] fail_over_directions: Directions of fail over. Possible values are `PrimaryToRecovery` and `RecoveryToPrimary`
        :param Sequence[_builtins.str] fail_over_types: Types of fail over. Possible values are `TestFailover`, `PlannedFailover` and `UnplannedFailover`
        :param _builtins.str name: The name of the Replication Plan. The name can contain only letters, numbers, and hyphens. It should start with a letter and end with a letter or a number. Can be a maximum of 63 characters. Changing this forces a new resource to be created.
        :param _builtins.str type: Type of the action detail. Possible values are `AutomationRunbookActionDetails`, `ManualActionDetails` and `ScriptActionDetails`.
        :param _builtins.str fabric_location: The fabric location of runbook or script. Possible values are `Primary` and `Recovery`. It must not be specified when `type` is `ManualActionDetails`.
               
               > **Note:** This is required when `type` is set to `AutomationRunbookActionDetails` or `ScriptActionDetails`.
        :param _builtins.str manual_action_instruction: Instructions of manual action.
               
               > **Note:** This property is required when `type` is set to `ManualActionDetails`.
        :param _builtins.str runbook_id: Id of runbook.
               
               > **Note:** This property is required when `type` is set to `AutomationRunbookActionDetails`.
        :param _builtins.str script_path: Path of action script.
               
               > **Note:** This property is required when `type` is set to `ScriptActionDetails`.
        """
        pulumi.set(__self__, "fail_over_directions", fail_over_directions)
        pulumi.set(__self__, "fail_over_types", fail_over_types)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if fabric_location is not None:
            pulumi.set(__self__, "fabric_location", fabric_location)
        if manual_action_instruction is not None:
            pulumi.set(__self__, "manual_action_instruction", manual_action_instruction)
        if runbook_id is not None:
            pulumi.set(__self__, "runbook_id", runbook_id)
        if script_path is not None:
            pulumi.set(__self__, "script_path", script_path)

    @_builtins.property
    @pulumi.getter(name="failOverDirections")
    def fail_over_directions(self) -> Sequence[_builtins.str]:
        """
        Directions of fail over. Possible values are `PrimaryToRecovery` and `RecoveryToPrimary`
        """
        return pulumi.get(self, "fail_over_directions")

    @_builtins.property
    @pulumi.getter(name="failOverTypes")
    def fail_over_types(self) -> Sequence[_builtins.str]:
        """
        Types of fail over. Possible values are `TestFailover`, `PlannedFailover` and `UnplannedFailover`
        """
        return pulumi.get(self, "fail_over_types")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Replication Plan. The name can contain only letters, numbers, and hyphens. It should start with a letter and end with a letter or a number. Can be a maximum of 63 characters. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of the action detail. Possible values are `AutomationRunbookActionDetails`, `ManualActionDetails` and `ScriptActionDetails`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="fabricLocation")
    def fabric_location(self) -> Optional[_builtins.str]:
        """
        The fabric location of runbook or script. Possible values are `Primary` and `Recovery`. It must not be specified when `type` is `ManualActionDetails`.

        > **Note:** This is required when `type` is set to `AutomationRunbookActionDetails` or `ScriptActionDetails`.
        """
        return pulumi.get(self, "fabric_location")

    @_builtins.property
    @pulumi.getter(name="manualActionInstruction")
    def manual_action_instruction(self) -> Optional[_builtins.str]:
        """
        Instructions of manual action.

        > **Note:** This property is required when `type` is set to `ManualActionDetails`.
        """
        return pulumi.get(self, "manual_action_instruction")

    @_builtins.property
    @pulumi.getter(name="runbookId")
    def runbook_id(self) -> Optional[_builtins.str]:
        """
        Id of runbook.

        > **Note:** This property is required when `type` is set to `AutomationRunbookActionDetails`.
        """
        return pulumi.get(self, "runbook_id")

    @_builtins.property
    @pulumi.getter(name="scriptPath")
    def script_path(self) -> Optional[_builtins.str]:
        """
        Path of action script.

        > **Note:** This property is required when `type` is set to `ScriptActionDetails`.
        """
        return pulumi.get(self, "script_path")


@pulumi.output_type
class ReplicationRecoveryPlanFailoverRecoveryGroupPreAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failOverDirections":
            suggest = "fail_over_directions"
        elif key == "failOverTypes":
            suggest = "fail_over_types"
        elif key == "fabricLocation":
            suggest = "fabric_location"
        elif key == "manualActionInstruction":
            suggest = "manual_action_instruction"
        elif key == "runbookId":
            suggest = "runbook_id"
        elif key == "scriptPath":
            suggest = "script_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReplicationRecoveryPlanFailoverRecoveryGroupPreAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReplicationRecoveryPlanFailoverRecoveryGroupPreAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReplicationRecoveryPlanFailoverRecoveryGroupPreAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fail_over_directions: Sequence[_builtins.str],
                 fail_over_types: Sequence[_builtins.str],
                 name: _builtins.str,
                 type: _builtins.str,
                 fabric_location: Optional[_builtins.str] = None,
                 manual_action_instruction: Optional[_builtins.str] = None,
                 runbook_id: Optional[_builtins.str] = None,
                 script_path: Optional[_builtins.str] = None):
        """
        :param Sequence[_builtins.str] fail_over_directions: Directions of fail over. Possible values are `PrimaryToRecovery` and `RecoveryToPrimary`
        :param Sequence[_builtins.str] fail_over_types: Types of fail over. Possible values are `TestFailover`, `PlannedFailover` and `UnplannedFailover`
        :param _builtins.str name: The name of the Replication Plan. The name can contain only letters, numbers, and hyphens. It should start with a letter and end with a letter or a number. Can be a maximum of 63 characters. Changing this forces a new resource to be created.
        :param _builtins.str type: Type of the action detail. Possible values are `AutomationRunbookActionDetails`, `ManualActionDetails` and `ScriptActionDetails`.
        :param _builtins.str fabric_location: The fabric location of runbook or script. Possible values are `Primary` and `Recovery`. It must not be specified when `type` is `ManualActionDetails`.
               
               > **Note:** This is required when `type` is set to `AutomationRunbookActionDetails` or `ScriptActionDetails`.
        :param _builtins.str manual_action_instruction: Instructions of manual action.
               
               > **Note:** This property is required when `type` is set to `ManualActionDetails`.
        :param _builtins.str runbook_id: Id of runbook.
               
               > **Note:** This property is required when `type` is set to `AutomationRunbookActionDetails`.
        :param _builtins.str script_path: Path of action script.
               
               > **Note:** This property is required when `type` is set to `ScriptActionDetails`.
        """
        pulumi.set(__self__, "fail_over_directions", fail_over_directions)
        pulumi.set(__self__, "fail_over_types", fail_over_types)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if fabric_location is not None:
            pulumi.set(__self__, "fabric_location", fabric_location)
        if manual_action_instruction is not None:
            pulumi.set(__self__, "manual_action_instruction", manual_action_instruction)
        if runbook_id is not None:
            pulumi.set(__self__, "runbook_id", runbook_id)
        if script_path is not None:
            pulumi.set(__self__, "script_path", script_path)

    @_builtins.property
    @pulumi.getter(name="failOverDirections")
    def fail_over_directions(self) -> Sequence[_builtins.str]:
        """
        Directions of fail over. Possible values are `PrimaryToRecovery` and `RecoveryToPrimary`
        """
        return pulumi.get(self, "fail_over_directions")

    @_builtins.property
    @pulumi.getter(name="failOverTypes")
    def fail_over_types(self) -> Sequence[_builtins.str]:
        """
        Types of fail over. Possible values are `TestFailover`, `PlannedFailover` and `UnplannedFailover`
        """
        return pulumi.get(self, "fail_over_types")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Replication Plan. The name can contain only letters, numbers, and hyphens. It should start with a letter and end with a letter or a number. Can be a maximum of 63 characters. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of the action detail. Possible values are `AutomationRunbookActionDetails`, `ManualActionDetails` and `ScriptActionDetails`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="fabricLocation")
    def fabric_location(self) -> Optional[_builtins.str]:
        """
        The fabric location of runbook or script. Possible values are `Primary` and `Recovery`. It must not be specified when `type` is `ManualActionDetails`.

        > **Note:** This is required when `type` is set to `AutomationRunbookActionDetails` or `ScriptActionDetails`.
        """
        return pulumi.get(self, "fabric_location")

    @_builtins.property
    @pulumi.getter(name="manualActionInstruction")
    def manual_action_instruction(self) -> Optional[_builtins.str]:
        """
        Instructions of manual action.

        > **Note:** This property is required when `type` is set to `ManualActionDetails`.
        """
        return pulumi.get(self, "manual_action_instruction")

    @_builtins.property
    @pulumi.getter(name="runbookId")
    def runbook_id(self) -> Optional[_builtins.str]:
        """
        Id of runbook.

        > **Note:** This property is required when `type` is set to `AutomationRunbookActionDetails`.
        """
        return pulumi.get(self, "runbook_id")

    @_builtins.property
    @pulumi.getter(name="scriptPath")
    def script_path(self) -> Optional[_builtins.str]:
        """
        Path of action script.

        > **Note:** This property is required when `type` is set to `ScriptActionDetails`.
        """
        return pulumi.get(self, "script_path")


@pulumi.output_type
class ReplicationRecoveryPlanShutdownRecoveryGroup(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "postActions":
            suggest = "post_actions"
        elif key == "preActions":
            suggest = "pre_actions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReplicationRecoveryPlanShutdownRecoveryGroup. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReplicationRecoveryPlanShutdownRecoveryGroup.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReplicationRecoveryPlanShutdownRecoveryGroup.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 post_actions: Optional[Sequence['outputs.ReplicationRecoveryPlanShutdownRecoveryGroupPostAction']] = None,
                 pre_actions: Optional[Sequence['outputs.ReplicationRecoveryPlanShutdownRecoveryGroupPreAction']] = None):
        """
        :param Sequence['ReplicationRecoveryPlanShutdownRecoveryGroupPostActionArgs'] post_actions: one or more `action` block as defined below. which will be executed after the group recovery.
        :param Sequence['ReplicationRecoveryPlanShutdownRecoveryGroupPreActionArgs'] pre_actions: one or more `action` block as defined below. which will be executed before the group recovery.
        """
        if post_actions is not None:
            pulumi.set(__self__, "post_actions", post_actions)
        if pre_actions is not None:
            pulumi.set(__self__, "pre_actions", pre_actions)

    @_builtins.property
    @pulumi.getter(name="postActions")
    def post_actions(self) -> Optional[Sequence['outputs.ReplicationRecoveryPlanShutdownRecoveryGroupPostAction']]:
        """
        one or more `action` block as defined below. which will be executed after the group recovery.
        """
        return pulumi.get(self, "post_actions")

    @_builtins.property
    @pulumi.getter(name="preActions")
    def pre_actions(self) -> Optional[Sequence['outputs.ReplicationRecoveryPlanShutdownRecoveryGroupPreAction']]:
        """
        one or more `action` block as defined below. which will be executed before the group recovery.
        """
        return pulumi.get(self, "pre_actions")


@pulumi.output_type
class ReplicationRecoveryPlanShutdownRecoveryGroupPostAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failOverDirections":
            suggest = "fail_over_directions"
        elif key == "failOverTypes":
            suggest = "fail_over_types"
        elif key == "fabricLocation":
            suggest = "fabric_location"
        elif key == "manualActionInstruction":
            suggest = "manual_action_instruction"
        elif key == "runbookId":
            suggest = "runbook_id"
        elif key == "scriptPath":
            suggest = "script_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReplicationRecoveryPlanShutdownRecoveryGroupPostAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReplicationRecoveryPlanShutdownRecoveryGroupPostAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReplicationRecoveryPlanShutdownRecoveryGroupPostAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fail_over_directions: Sequence[_builtins.str],
                 fail_over_types: Sequence[_builtins.str],
                 name: _builtins.str,
                 type: _builtins.str,
                 fabric_location: Optional[_builtins.str] = None,
                 manual_action_instruction: Optional[_builtins.str] = None,
                 runbook_id: Optional[_builtins.str] = None,
                 script_path: Optional[_builtins.str] = None):
        """
        :param Sequence[_builtins.str] fail_over_directions: Directions of fail over. Possible values are `PrimaryToRecovery` and `RecoveryToPrimary`
        :param Sequence[_builtins.str] fail_over_types: Types of fail over. Possible values are `TestFailover`, `PlannedFailover` and `UnplannedFailover`
        :param _builtins.str name: The name of the Replication Plan. The name can contain only letters, numbers, and hyphens. It should start with a letter and end with a letter or a number. Can be a maximum of 63 characters. Changing this forces a new resource to be created.
        :param _builtins.str type: Type of the action detail. Possible values are `AutomationRunbookActionDetails`, `ManualActionDetails` and `ScriptActionDetails`.
        :param _builtins.str fabric_location: The fabric location of runbook or script. Possible values are `Primary` and `Recovery`. It must not be specified when `type` is `ManualActionDetails`.
               
               > **Note:** This is required when `type` is set to `AutomationRunbookActionDetails` or `ScriptActionDetails`.
        :param _builtins.str manual_action_instruction: Instructions of manual action.
               
               > **Note:** This property is required when `type` is set to `ManualActionDetails`.
        :param _builtins.str runbook_id: Id of runbook.
               
               > **Note:** This property is required when `type` is set to `AutomationRunbookActionDetails`.
        :param _builtins.str script_path: Path of action script.
               
               > **Note:** This property is required when `type` is set to `ScriptActionDetails`.
        """
        pulumi.set(__self__, "fail_over_directions", fail_over_directions)
        pulumi.set(__self__, "fail_over_types", fail_over_types)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if fabric_location is not None:
            pulumi.set(__self__, "fabric_location", fabric_location)
        if manual_action_instruction is not None:
            pulumi.set(__self__, "manual_action_instruction", manual_action_instruction)
        if runbook_id is not None:
            pulumi.set(__self__, "runbook_id", runbook_id)
        if script_path is not None:
            pulumi.set(__self__, "script_path", script_path)

    @_builtins.property
    @pulumi.getter(name="failOverDirections")
    def fail_over_directions(self) -> Sequence[_builtins.str]:
        """
        Directions of fail over. Possible values are `PrimaryToRecovery` and `RecoveryToPrimary`
        """
        return pulumi.get(self, "fail_over_directions")

    @_builtins.property
    @pulumi.getter(name="failOverTypes")
    def fail_over_types(self) -> Sequence[_builtins.str]:
        """
        Types of fail over. Possible values are `TestFailover`, `PlannedFailover` and `UnplannedFailover`
        """
        return pulumi.get(self, "fail_over_types")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Replication Plan. The name can contain only letters, numbers, and hyphens. It should start with a letter and end with a letter or a number. Can be a maximum of 63 characters. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of the action detail. Possible values are `AutomationRunbookActionDetails`, `ManualActionDetails` and `ScriptActionDetails`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="fabricLocation")
    def fabric_location(self) -> Optional[_builtins.str]:
        """
        The fabric location of runbook or script. Possible values are `Primary` and `Recovery`. It must not be specified when `type` is `ManualActionDetails`.

        > **Note:** This is required when `type` is set to `AutomationRunbookActionDetails` or `ScriptActionDetails`.
        """
        return pulumi.get(self, "fabric_location")

    @_builtins.property
    @pulumi.getter(name="manualActionInstruction")
    def manual_action_instruction(self) -> Optional[_builtins.str]:
        """
        Instructions of manual action.

        > **Note:** This property is required when `type` is set to `ManualActionDetails`.
        """
        return pulumi.get(self, "manual_action_instruction")

    @_builtins.property
    @pulumi.getter(name="runbookId")
    def runbook_id(self) -> Optional[_builtins.str]:
        """
        Id of runbook.

        > **Note:** This property is required when `type` is set to `AutomationRunbookActionDetails`.
        """
        return pulumi.get(self, "runbook_id")

    @_builtins.property
    @pulumi.getter(name="scriptPath")
    def script_path(self) -> Optional[_builtins.str]:
        """
        Path of action script.

        > **Note:** This property is required when `type` is set to `ScriptActionDetails`.
        """
        return pulumi.get(self, "script_path")


@pulumi.output_type
class ReplicationRecoveryPlanShutdownRecoveryGroupPreAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failOverDirections":
            suggest = "fail_over_directions"
        elif key == "failOverTypes":
            suggest = "fail_over_types"
        elif key == "fabricLocation":
            suggest = "fabric_location"
        elif key == "manualActionInstruction":
            suggest = "manual_action_instruction"
        elif key == "runbookId":
            suggest = "runbook_id"
        elif key == "scriptPath":
            suggest = "script_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReplicationRecoveryPlanShutdownRecoveryGroupPreAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReplicationRecoveryPlanShutdownRecoveryGroupPreAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReplicationRecoveryPlanShutdownRecoveryGroupPreAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fail_over_directions: Sequence[_builtins.str],
                 fail_over_types: Sequence[_builtins.str],
                 name: _builtins.str,
                 type: _builtins.str,
                 fabric_location: Optional[_builtins.str] = None,
                 manual_action_instruction: Optional[_builtins.str] = None,
                 runbook_id: Optional[_builtins.str] = None,
                 script_path: Optional[_builtins.str] = None):
        """
        :param Sequence[_builtins.str] fail_over_directions: Directions of fail over. Possible values are `PrimaryToRecovery` and `RecoveryToPrimary`
        :param Sequence[_builtins.str] fail_over_types: Types of fail over. Possible values are `TestFailover`, `PlannedFailover` and `UnplannedFailover`
        :param _builtins.str name: The name of the Replication Plan. The name can contain only letters, numbers, and hyphens. It should start with a letter and end with a letter or a number. Can be a maximum of 63 characters. Changing this forces a new resource to be created.
        :param _builtins.str type: Type of the action detail. Possible values are `AutomationRunbookActionDetails`, `ManualActionDetails` and `ScriptActionDetails`.
        :param _builtins.str fabric_location: The fabric location of runbook or script. Possible values are `Primary` and `Recovery`. It must not be specified when `type` is `ManualActionDetails`.
               
               > **Note:** This is required when `type` is set to `AutomationRunbookActionDetails` or `ScriptActionDetails`.
        :param _builtins.str manual_action_instruction: Instructions of manual action.
               
               > **Note:** This property is required when `type` is set to `ManualActionDetails`.
        :param _builtins.str runbook_id: Id of runbook.
               
               > **Note:** This property is required when `type` is set to `AutomationRunbookActionDetails`.
        :param _builtins.str script_path: Path of action script.
               
               > **Note:** This property is required when `type` is set to `ScriptActionDetails`.
        """
        pulumi.set(__self__, "fail_over_directions", fail_over_directions)
        pulumi.set(__self__, "fail_over_types", fail_over_types)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if fabric_location is not None:
            pulumi.set(__self__, "fabric_location", fabric_location)
        if manual_action_instruction is not None:
            pulumi.set(__self__, "manual_action_instruction", manual_action_instruction)
        if runbook_id is not None:
            pulumi.set(__self__, "runbook_id", runbook_id)
        if script_path is not None:
            pulumi.set(__self__, "script_path", script_path)

    @_builtins.property
    @pulumi.getter(name="failOverDirections")
    def fail_over_directions(self) -> Sequence[_builtins.str]:
        """
        Directions of fail over. Possible values are `PrimaryToRecovery` and `RecoveryToPrimary`
        """
        return pulumi.get(self, "fail_over_directions")

    @_builtins.property
    @pulumi.getter(name="failOverTypes")
    def fail_over_types(self) -> Sequence[_builtins.str]:
        """
        Types of fail over. Possible values are `TestFailover`, `PlannedFailover` and `UnplannedFailover`
        """
        return pulumi.get(self, "fail_over_types")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Replication Plan. The name can contain only letters, numbers, and hyphens. It should start with a letter and end with a letter or a number. Can be a maximum of 63 characters. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of the action detail. Possible values are `AutomationRunbookActionDetails`, `ManualActionDetails` and `ScriptActionDetails`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="fabricLocation")
    def fabric_location(self) -> Optional[_builtins.str]:
        """
        The fabric location of runbook or script. Possible values are `Primary` and `Recovery`. It must not be specified when `type` is `ManualActionDetails`.

        > **Note:** This is required when `type` is set to `AutomationRunbookActionDetails` or `ScriptActionDetails`.
        """
        return pulumi.get(self, "fabric_location")

    @_builtins.property
    @pulumi.getter(name="manualActionInstruction")
    def manual_action_instruction(self) -> Optional[_builtins.str]:
        """
        Instructions of manual action.

        > **Note:** This property is required when `type` is set to `ManualActionDetails`.
        """
        return pulumi.get(self, "manual_action_instruction")

    @_builtins.property
    @pulumi.getter(name="runbookId")
    def runbook_id(self) -> Optional[_builtins.str]:
        """
        Id of runbook.

        > **Note:** This property is required when `type` is set to `AutomationRunbookActionDetails`.
        """
        return pulumi.get(self, "runbook_id")

    @_builtins.property
    @pulumi.getter(name="scriptPath")
    def script_path(self) -> Optional[_builtins.str]:
        """
        Path of action script.

        > **Note:** This property is required when `type` is set to `ScriptActionDetails`.
        """
        return pulumi.get(self, "script_path")


@pulumi.output_type
class VmwareReplicatedVmManagedDisk(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskId":
            suggest = "disk_id"
        elif key == "targetDiskType":
            suggest = "target_disk_type"
        elif key == "logStorageAccountId":
            suggest = "log_storage_account_id"
        elif key == "targetDiskEncryptionSetId":
            suggest = "target_disk_encryption_set_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VmwareReplicatedVmManagedDisk. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VmwareReplicatedVmManagedDisk.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VmwareReplicatedVmManagedDisk.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disk_id: _builtins.str,
                 target_disk_type: _builtins.str,
                 log_storage_account_id: Optional[_builtins.str] = None,
                 target_disk_encryption_set_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str disk_id: The ID of the disk to be replicated.
        :param _builtins.str target_disk_type: The disk type of the disk to be created when a failover is done. Possible values are `Premium_LRS`, `Standard_LRS` and `StandardSSD_LRS`.
        :param _builtins.str log_storage_account_id: The ID of the storage account that should be used for logging during replication.
        :param _builtins.str target_disk_encryption_set_id: The ID of the Disk Encryption Set that should be used for the disks when a failover is done.
        """
        pulumi.set(__self__, "disk_id", disk_id)
        pulumi.set(__self__, "target_disk_type", target_disk_type)
        if log_storage_account_id is not None:
            pulumi.set(__self__, "log_storage_account_id", log_storage_account_id)
        if target_disk_encryption_set_id is not None:
            pulumi.set(__self__, "target_disk_encryption_set_id", target_disk_encryption_set_id)

    @_builtins.property
    @pulumi.getter(name="diskId")
    def disk_id(self) -> _builtins.str:
        """
        The ID of the disk to be replicated.
        """
        return pulumi.get(self, "disk_id")

    @_builtins.property
    @pulumi.getter(name="targetDiskType")
    def target_disk_type(self) -> _builtins.str:
        """
        The disk type of the disk to be created when a failover is done. Possible values are `Premium_LRS`, `Standard_LRS` and `StandardSSD_LRS`.
        """
        return pulumi.get(self, "target_disk_type")

    @_builtins.property
    @pulumi.getter(name="logStorageAccountId")
    def log_storage_account_id(self) -> Optional[_builtins.str]:
        """
        The ID of the storage account that should be used for logging during replication.
        """
        return pulumi.get(self, "log_storage_account_id")

    @_builtins.property
    @pulumi.getter(name="targetDiskEncryptionSetId")
    def target_disk_encryption_set_id(self) -> Optional[_builtins.str]:
        """
        The ID of the Disk Encryption Set that should be used for the disks when a failover is done.
        """
        return pulumi.get(self, "target_disk_encryption_set_id")


@pulumi.output_type
class VmwareReplicatedVmNetworkInterface(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isPrimary":
            suggest = "is_primary"
        elif key == "sourceMacAddress":
            suggest = "source_mac_address"
        elif key == "targetStaticIp":
            suggest = "target_static_ip"
        elif key == "targetSubnetName":
            suggest = "target_subnet_name"
        elif key == "testSubnetName":
            suggest = "test_subnet_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VmwareReplicatedVmNetworkInterface. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VmwareReplicatedVmNetworkInterface.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VmwareReplicatedVmNetworkInterface.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_primary: _builtins.bool,
                 source_mac_address: _builtins.str,
                 target_static_ip: Optional[_builtins.str] = None,
                 target_subnet_name: Optional[_builtins.str] = None,
                 test_subnet_name: Optional[_builtins.str] = None):
        """
        :param _builtins.bool is_primary: Whether this `network_interface` is primary for the replicated VM.
        :param _builtins.str source_mac_address: Mac address of the network interface of source VM.
        :param _builtins.str target_static_ip: Static IP to assign when a failover is done.
        :param _builtins.str target_subnet_name: Name of the subnet to use when a failover is done.
        :param _builtins.str test_subnet_name: Name of the subnet to use when a test failover is done.
        """
        pulumi.set(__self__, "is_primary", is_primary)
        pulumi.set(__self__, "source_mac_address", source_mac_address)
        if target_static_ip is not None:
            pulumi.set(__self__, "target_static_ip", target_static_ip)
        if target_subnet_name is not None:
            pulumi.set(__self__, "target_subnet_name", target_subnet_name)
        if test_subnet_name is not None:
            pulumi.set(__self__, "test_subnet_name", test_subnet_name)

    @_builtins.property
    @pulumi.getter(name="isPrimary")
    def is_primary(self) -> _builtins.bool:
        """
        Whether this `network_interface` is primary for the replicated VM.
        """
        return pulumi.get(self, "is_primary")

    @_builtins.property
    @pulumi.getter(name="sourceMacAddress")
    def source_mac_address(self) -> _builtins.str:
        """
        Mac address of the network interface of source VM.
        """
        return pulumi.get(self, "source_mac_address")

    @_builtins.property
    @pulumi.getter(name="targetStaticIp")
    def target_static_ip(self) -> Optional[_builtins.str]:
        """
        Static IP to assign when a failover is done.
        """
        return pulumi.get(self, "target_static_ip")

    @_builtins.property
    @pulumi.getter(name="targetSubnetName")
    def target_subnet_name(self) -> Optional[_builtins.str]:
        """
        Name of the subnet to use when a failover is done.
        """
        return pulumi.get(self, "target_subnet_name")

    @_builtins.property
    @pulumi.getter(name="testSubnetName")
    def test_subnet_name(self) -> Optional[_builtins.str]:
        """
        Name of the subnet to use when a test failover is done.
        """
        return pulumi.get(self, "test_subnet_name")


@pulumi.output_type
class GetReplicationRecoveryPlanAzureToAzureSettingResult(dict):
    def __init__(__self__, *,
                 primary_edge_zone: _builtins.str,
                 primary_zone: _builtins.str,
                 recovery_edge_zone: _builtins.str,
                 recovery_zone: _builtins.str):
        pulumi.set(__self__, "primary_edge_zone", primary_edge_zone)
        pulumi.set(__self__, "primary_zone", primary_zone)
        pulumi.set(__self__, "recovery_edge_zone", recovery_edge_zone)
        pulumi.set(__self__, "recovery_zone", recovery_zone)

    @_builtins.property
    @pulumi.getter(name="primaryEdgeZone")
    def primary_edge_zone(self) -> _builtins.str:
        return pulumi.get(self, "primary_edge_zone")

    @_builtins.property
    @pulumi.getter(name="primaryZone")
    def primary_zone(self) -> _builtins.str:
        return pulumi.get(self, "primary_zone")

    @_builtins.property
    @pulumi.getter(name="recoveryEdgeZone")
    def recovery_edge_zone(self) -> _builtins.str:
        return pulumi.get(self, "recovery_edge_zone")

    @_builtins.property
    @pulumi.getter(name="recoveryZone")
    def recovery_zone(self) -> _builtins.str:
        return pulumi.get(self, "recovery_zone")


@pulumi.output_type
class GetReplicationRecoveryPlanRecoveryGroupResult(dict):
    def __init__(__self__, *,
                 post_actions: Sequence[Sequence['outputs.GetReplicationRecoveryPlanRecoveryGroupPostActionResult']],
                 pre_actions: Sequence[Sequence['outputs.GetReplicationRecoveryPlanRecoveryGroupPreActionResult']],
                 replicated_protected_items: Sequence[_builtins.str],
                 type: _builtins.str):
        """
        :param Sequence[Sequence['GetReplicationRecoveryPlanRecoveryGroupPostActionArgs']] post_actions: one or more `action` block. which will be executed after the group recovery.
        :param Sequence[Sequence['GetReplicationRecoveryPlanRecoveryGroupPreActionArgs']] pre_actions: one or more `action` block. which will be executed before the group recovery.
        :param Sequence[_builtins.str] replicated_protected_items: one or more id of protected VM.
        :param _builtins.str type: Type of the action detail.
        """
        pulumi.set(__self__, "post_actions", post_actions)
        pulumi.set(__self__, "pre_actions", pre_actions)
        pulumi.set(__self__, "replicated_protected_items", replicated_protected_items)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="postActions")
    def post_actions(self) -> Sequence[Sequence['outputs.GetReplicationRecoveryPlanRecoveryGroupPostActionResult']]:
        """
        one or more `action` block. which will be executed after the group recovery.
        """
        return pulumi.get(self, "post_actions")

    @_builtins.property
    @pulumi.getter(name="preActions")
    def pre_actions(self) -> Sequence[Sequence['outputs.GetReplicationRecoveryPlanRecoveryGroupPreActionResult']]:
        """
        one or more `action` block. which will be executed before the group recovery.
        """
        return pulumi.get(self, "pre_actions")

    @_builtins.property
    @pulumi.getter(name="replicatedProtectedItems")
    def replicated_protected_items(self) -> Sequence[_builtins.str]:
        """
        one or more id of protected VM.
        """
        return pulumi.get(self, "replicated_protected_items")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of the action detail.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetReplicationRecoveryPlanRecoveryGroupPostActionResult(dict):
    def __init__(__self__, *,
                 fabric_location: _builtins.str,
                 fail_over_directions: Sequence[_builtins.str],
                 fail_over_types: Sequence[_builtins.str],
                 manual_action_instruction: _builtins.str,
                 name: _builtins.str,
                 runbook_id: _builtins.str,
                 script_path: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str fabric_location: The fabric location of runbook or script.
        :param Sequence[_builtins.str] fail_over_directions: Directions of fail over.
        :param Sequence[_builtins.str] fail_over_types: Types of fail over.
        :param _builtins.str manual_action_instruction: Instructions of manual action.
        :param _builtins.str name: The name of the Replication Plan.
        :param _builtins.str runbook_id: Id of runbook.
        :param _builtins.str script_path: Path of action script.
        :param _builtins.str type: Type of the action detail.
        """
        pulumi.set(__self__, "fabric_location", fabric_location)
        pulumi.set(__self__, "fail_over_directions", fail_over_directions)
        pulumi.set(__self__, "fail_over_types", fail_over_types)
        pulumi.set(__self__, "manual_action_instruction", manual_action_instruction)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "runbook_id", runbook_id)
        pulumi.set(__self__, "script_path", script_path)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="fabricLocation")
    def fabric_location(self) -> _builtins.str:
        """
        The fabric location of runbook or script.
        """
        return pulumi.get(self, "fabric_location")

    @_builtins.property
    @pulumi.getter(name="failOverDirections")
    def fail_over_directions(self) -> Sequence[_builtins.str]:
        """
        Directions of fail over.
        """
        return pulumi.get(self, "fail_over_directions")

    @_builtins.property
    @pulumi.getter(name="failOverTypes")
    def fail_over_types(self) -> Sequence[_builtins.str]:
        """
        Types of fail over.
        """
        return pulumi.get(self, "fail_over_types")

    @_builtins.property
    @pulumi.getter(name="manualActionInstruction")
    def manual_action_instruction(self) -> _builtins.str:
        """
        Instructions of manual action.
        """
        return pulumi.get(self, "manual_action_instruction")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Replication Plan.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="runbookId")
    def runbook_id(self) -> _builtins.str:
        """
        Id of runbook.
        """
        return pulumi.get(self, "runbook_id")

    @_builtins.property
    @pulumi.getter(name="scriptPath")
    def script_path(self) -> _builtins.str:
        """
        Path of action script.
        """
        return pulumi.get(self, "script_path")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of the action detail.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetReplicationRecoveryPlanRecoveryGroupPreActionResult(dict):
    def __init__(__self__, *,
                 fabric_location: _builtins.str,
                 fail_over_directions: Sequence[_builtins.str],
                 fail_over_types: Sequence[_builtins.str],
                 manual_action_instruction: _builtins.str,
                 name: _builtins.str,
                 runbook_id: _builtins.str,
                 script_path: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str fabric_location: The fabric location of runbook or script.
        :param Sequence[_builtins.str] fail_over_directions: Directions of fail over.
        :param Sequence[_builtins.str] fail_over_types: Types of fail over.
        :param _builtins.str manual_action_instruction: Instructions of manual action.
        :param _builtins.str name: The name of the Replication Plan.
        :param _builtins.str runbook_id: Id of runbook.
        :param _builtins.str script_path: Path of action script.
        :param _builtins.str type: Type of the action detail.
        """
        pulumi.set(__self__, "fabric_location", fabric_location)
        pulumi.set(__self__, "fail_over_directions", fail_over_directions)
        pulumi.set(__self__, "fail_over_types", fail_over_types)
        pulumi.set(__self__, "manual_action_instruction", manual_action_instruction)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "runbook_id", runbook_id)
        pulumi.set(__self__, "script_path", script_path)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="fabricLocation")
    def fabric_location(self) -> _builtins.str:
        """
        The fabric location of runbook or script.
        """
        return pulumi.get(self, "fabric_location")

    @_builtins.property
    @pulumi.getter(name="failOverDirections")
    def fail_over_directions(self) -> Sequence[_builtins.str]:
        """
        Directions of fail over.
        """
        return pulumi.get(self, "fail_over_directions")

    @_builtins.property
    @pulumi.getter(name="failOverTypes")
    def fail_over_types(self) -> Sequence[_builtins.str]:
        """
        Types of fail over.
        """
        return pulumi.get(self, "fail_over_types")

    @_builtins.property
    @pulumi.getter(name="manualActionInstruction")
    def manual_action_instruction(self) -> _builtins.str:
        """
        Instructions of manual action.
        """
        return pulumi.get(self, "manual_action_instruction")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Replication Plan.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="runbookId")
    def runbook_id(self) -> _builtins.str:
        """
        Id of runbook.
        """
        return pulumi.get(self, "runbook_id")

    @_builtins.property
    @pulumi.getter(name="scriptPath")
    def script_path(self) -> _builtins.str:
        """
        Path of action script.
        """
        return pulumi.get(self, "script_path")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of the action detail.
        """
        return pulumi.get(self, "type")


