# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VmwareReplicatedVmArgs', 'VmwareReplicatedVm']

@pulumi.input_type
class VmwareReplicatedVmArgs:
    def __init__(__self__, *,
                 appliance_name: pulumi.Input[_builtins.str],
                 physical_server_credential_name: pulumi.Input[_builtins.str],
                 recovery_replication_policy_id: pulumi.Input[_builtins.str],
                 recovery_vault_id: pulumi.Input[_builtins.str],
                 source_vm_name: pulumi.Input[_builtins.str],
                 target_resource_group_id: pulumi.Input[_builtins.str],
                 target_vm_name: pulumi.Input[_builtins.str],
                 default_log_storage_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 default_recovery_disk_type: Optional[pulumi.Input[_builtins.str]] = None,
                 default_target_disk_encryption_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                 license_type: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_disks: Optional[pulumi.Input[Sequence[pulumi.Input['VmwareReplicatedVmManagedDiskArgs']]]] = None,
                 multi_vm_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['VmwareReplicatedVmNetworkInterfaceArgs']]]] = None,
                 target_availability_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_boot_diagnostics_storage_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_proximity_placement_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_vm_size: Optional[pulumi.Input[_builtins.str]] = None,
                 target_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 test_network_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a VmwareReplicatedVm resource.
        :param pulumi.Input[_builtins.str] appliance_name: The name of VMWare appliance which handles the replication. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] physical_server_credential_name: The name of the credential to access the source VM. Changing this forces a new resource to be created. More information about the credentials could be found [here](https://learn.microsoft.com/en-us/azure/site-recovery/deploy-vmware-azure-replication-appliance-modernized).
        :param pulumi.Input[_builtins.str] recovery_replication_policy_id: The ID of the policy to use for this replicated VM.
        :param pulumi.Input[_builtins.str] recovery_vault_id: The ID of the Recovery Services Vault where the replicated VM is created.
        :param pulumi.Input[_builtins.str] source_vm_name: The name of the source VM in VMWare. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] target_resource_group_id: The ID of resource group where the VM should be created when a failover is done.
        :param pulumi.Input[_builtins.str] target_vm_name: Name of the VM that should be created when a failover is done. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] default_log_storage_account_id: The ID of the stroage account that should be used for logging during replication. 
               
               > **Note:** Only standard types of storage accounts are allowed.
               
               > **Note:** Only one of `default_log_storage_account_id` or `managed_disk` must be specified.
               
               > **Note:** Changing `default_log_storage_account_id` forces a new resource to be created. But removing it does not.
               
               > **Note:** When `default_log_storage_account_id` co-exist with `managed_disk`, the value of `default_log_storage_account_id` must be as same as `log_storage_account_id` of every `managed_disk` or it forces a new resource to be created.
        :param pulumi.Input[_builtins.str] default_recovery_disk_type: The type of storage account that should be used for recovery disks when a failover is done. Possible values are `Premium_LRS`, `Standard_LRS` and `StandardSSD_LRS`.
               
               > **Note:** Only one of `default_recovery_disk_type` or `managed_disk` must be specified.
               
               > **Note:** Changing `default_recovery_disk_type` forces a new resource to be created. But removing it does not.
               
               > **Note:** When `default_recovery_disk_type` co-exist with `managed_disk`, the value of `default_recovery_disk_type` must be as same as `target_disk_type` of every `managed_disk` or it forces a new resource to be created.
        :param pulumi.Input[_builtins.str] default_target_disk_encryption_set_id: The ID of the default Disk Encryption Set that should be used for the disks when a failover is done.
               
               > **Note:** Changing `default_target_disk_encryption_set_id` forces a new resource to be created. But removing it does not.
               
               > **Note:** When `default_target_disk_encryption_set_id` co-exist with `managed_disk`, the value of `default_target_disk_encryption_set_id` must be as same as `target_disk_encryption_set_id` of every `managed_disk` or it forces a new resource to be created.
        :param pulumi.Input[_builtins.str] license_type: The license type of the VM. Possible values are `NoLicenseType`, `NotSpecified` and `WindowsServer`. Defaults to `NotSpecified`.
        :param pulumi.Input[Sequence[pulumi.Input['VmwareReplicatedVmManagedDiskArgs']]] managed_disks: One or more `managed_disk` block as defined below. It's available only if mobility service is already installed on the source VM.
               
               > **Note:** A replicated VM could be created without `managed_disk` block, once the block has been specified, changing it expect removing it forces a new resource to be created.
        :param pulumi.Input[_builtins.str] multi_vm_group_name: Name of group in which all machines will replicate together and have shared crash consistent and app-consistent recovery points when failed over.
        :param pulumi.Input[_builtins.str] name: The name of the replicated VM. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['VmwareReplicatedVmNetworkInterfaceArgs']]] network_interfaces: One or more `network_interface` block as defined below.
        :param pulumi.Input[_builtins.str] target_availability_set_id: The ID of availability set that the new VM should belong to when a failover is done.
        :param pulumi.Input[_builtins.str] target_boot_diagnostics_storage_account_id: The ID of the storage account that should be used for boot diagnostics when a failover is done.
        :param pulumi.Input[_builtins.str] target_network_id: The ID of network to use when a failover is done.
               
               > **Note:** `target_network_id` is required when `network_interface` is specified.
        :param pulumi.Input[_builtins.str] target_proximity_placement_group_id: The ID of Proximity Placement Group the new VM should belong to when a failover is done.
               
               > **Note:** Only one of `target_availability_set_id` or `target_zone` can be specified.
        :param pulumi.Input[_builtins.str] target_vm_size: Size of the VM that should be created when a failover is done, such as `Standard_F2`. If it's not specified, it will automatically be set by detecting the source VM size.
        :param pulumi.Input[_builtins.str] target_zone: Specifies the Availability Zone where the Failover VM should exist.
        :param pulumi.Input[_builtins.str] test_network_id: The ID of network to use when a test failover is done.
        """
        pulumi.set(__self__, "appliance_name", appliance_name)
        pulumi.set(__self__, "physical_server_credential_name", physical_server_credential_name)
        pulumi.set(__self__, "recovery_replication_policy_id", recovery_replication_policy_id)
        pulumi.set(__self__, "recovery_vault_id", recovery_vault_id)
        pulumi.set(__self__, "source_vm_name", source_vm_name)
        pulumi.set(__self__, "target_resource_group_id", target_resource_group_id)
        pulumi.set(__self__, "target_vm_name", target_vm_name)
        if default_log_storage_account_id is not None:
            pulumi.set(__self__, "default_log_storage_account_id", default_log_storage_account_id)
        if default_recovery_disk_type is not None:
            pulumi.set(__self__, "default_recovery_disk_type", default_recovery_disk_type)
        if default_target_disk_encryption_set_id is not None:
            pulumi.set(__self__, "default_target_disk_encryption_set_id", default_target_disk_encryption_set_id)
        if license_type is not None:
            pulumi.set(__self__, "license_type", license_type)
        if managed_disks is not None:
            pulumi.set(__self__, "managed_disks", managed_disks)
        if multi_vm_group_name is not None:
            pulumi.set(__self__, "multi_vm_group_name", multi_vm_group_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)
        if target_availability_set_id is not None:
            pulumi.set(__self__, "target_availability_set_id", target_availability_set_id)
        if target_boot_diagnostics_storage_account_id is not None:
            pulumi.set(__self__, "target_boot_diagnostics_storage_account_id", target_boot_diagnostics_storage_account_id)
        if target_network_id is not None:
            pulumi.set(__self__, "target_network_id", target_network_id)
        if target_proximity_placement_group_id is not None:
            pulumi.set(__self__, "target_proximity_placement_group_id", target_proximity_placement_group_id)
        if target_vm_size is not None:
            pulumi.set(__self__, "target_vm_size", target_vm_size)
        if target_zone is not None:
            pulumi.set(__self__, "target_zone", target_zone)
        if test_network_id is not None:
            pulumi.set(__self__, "test_network_id", test_network_id)

    @_builtins.property
    @pulumi.getter(name="applianceName")
    def appliance_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of VMWare appliance which handles the replication. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "appliance_name")

    @appliance_name.setter
    def appliance_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "appliance_name", value)

    @_builtins.property
    @pulumi.getter(name="physicalServerCredentialName")
    def physical_server_credential_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the credential to access the source VM. Changing this forces a new resource to be created. More information about the credentials could be found [here](https://learn.microsoft.com/en-us/azure/site-recovery/deploy-vmware-azure-replication-appliance-modernized).
        """
        return pulumi.get(self, "physical_server_credential_name")

    @physical_server_credential_name.setter
    def physical_server_credential_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "physical_server_credential_name", value)

    @_builtins.property
    @pulumi.getter(name="recoveryReplicationPolicyId")
    def recovery_replication_policy_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the policy to use for this replicated VM.
        """
        return pulumi.get(self, "recovery_replication_policy_id")

    @recovery_replication_policy_id.setter
    def recovery_replication_policy_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "recovery_replication_policy_id", value)

    @_builtins.property
    @pulumi.getter(name="recoveryVaultId")
    def recovery_vault_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Recovery Services Vault where the replicated VM is created.
        """
        return pulumi.get(self, "recovery_vault_id")

    @recovery_vault_id.setter
    def recovery_vault_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "recovery_vault_id", value)

    @_builtins.property
    @pulumi.getter(name="sourceVmName")
    def source_vm_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the source VM in VMWare. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "source_vm_name")

    @source_vm_name.setter
    def source_vm_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "source_vm_name", value)

    @_builtins.property
    @pulumi.getter(name="targetResourceGroupId")
    def target_resource_group_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of resource group where the VM should be created when a failover is done.
        """
        return pulumi.get(self, "target_resource_group_id")

    @target_resource_group_id.setter
    def target_resource_group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "target_resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="targetVmName")
    def target_vm_name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the VM that should be created when a failover is done. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "target_vm_name")

    @target_vm_name.setter
    def target_vm_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "target_vm_name", value)

    @_builtins.property
    @pulumi.getter(name="defaultLogStorageAccountId")
    def default_log_storage_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the stroage account that should be used for logging during replication. 

        > **Note:** Only standard types of storage accounts are allowed.

        > **Note:** Only one of `default_log_storage_account_id` or `managed_disk` must be specified.

        > **Note:** Changing `default_log_storage_account_id` forces a new resource to be created. But removing it does not.

        > **Note:** When `default_log_storage_account_id` co-exist with `managed_disk`, the value of `default_log_storage_account_id` must be as same as `log_storage_account_id` of every `managed_disk` or it forces a new resource to be created.
        """
        return pulumi.get(self, "default_log_storage_account_id")

    @default_log_storage_account_id.setter
    def default_log_storage_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_log_storage_account_id", value)

    @_builtins.property
    @pulumi.getter(name="defaultRecoveryDiskType")
    def default_recovery_disk_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of storage account that should be used for recovery disks when a failover is done. Possible values are `Premium_LRS`, `Standard_LRS` and `StandardSSD_LRS`.

        > **Note:** Only one of `default_recovery_disk_type` or `managed_disk` must be specified.

        > **Note:** Changing `default_recovery_disk_type` forces a new resource to be created. But removing it does not.

        > **Note:** When `default_recovery_disk_type` co-exist with `managed_disk`, the value of `default_recovery_disk_type` must be as same as `target_disk_type` of every `managed_disk` or it forces a new resource to be created.
        """
        return pulumi.get(self, "default_recovery_disk_type")

    @default_recovery_disk_type.setter
    def default_recovery_disk_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_recovery_disk_type", value)

    @_builtins.property
    @pulumi.getter(name="defaultTargetDiskEncryptionSetId")
    def default_target_disk_encryption_set_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the default Disk Encryption Set that should be used for the disks when a failover is done.

        > **Note:** Changing `default_target_disk_encryption_set_id` forces a new resource to be created. But removing it does not.

        > **Note:** When `default_target_disk_encryption_set_id` co-exist with `managed_disk`, the value of `default_target_disk_encryption_set_id` must be as same as `target_disk_encryption_set_id` of every `managed_disk` or it forces a new resource to be created.
        """
        return pulumi.get(self, "default_target_disk_encryption_set_id")

    @default_target_disk_encryption_set_id.setter
    def default_target_disk_encryption_set_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_target_disk_encryption_set_id", value)

    @_builtins.property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The license type of the VM. Possible values are `NoLicenseType`, `NotSpecified` and `WindowsServer`. Defaults to `NotSpecified`.
        """
        return pulumi.get(self, "license_type")

    @license_type.setter
    def license_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "license_type", value)

    @_builtins.property
    @pulumi.getter(name="managedDisks")
    def managed_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VmwareReplicatedVmManagedDiskArgs']]]]:
        """
        One or more `managed_disk` block as defined below. It's available only if mobility service is already installed on the source VM.

        > **Note:** A replicated VM could be created without `managed_disk` block, once the block has been specified, changing it expect removing it forces a new resource to be created.
        """
        return pulumi.get(self, "managed_disks")

    @managed_disks.setter
    def managed_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VmwareReplicatedVmManagedDiskArgs']]]]):
        pulumi.set(self, "managed_disks", value)

    @_builtins.property
    @pulumi.getter(name="multiVmGroupName")
    def multi_vm_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of group in which all machines will replicate together and have shared crash consistent and app-consistent recovery points when failed over.
        """
        return pulumi.get(self, "multi_vm_group_name")

    @multi_vm_group_name.setter
    def multi_vm_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "multi_vm_group_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the replicated VM. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VmwareReplicatedVmNetworkInterfaceArgs']]]]:
        """
        One or more `network_interface` block as defined below.
        """
        return pulumi.get(self, "network_interfaces")

    @network_interfaces.setter
    def network_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VmwareReplicatedVmNetworkInterfaceArgs']]]]):
        pulumi.set(self, "network_interfaces", value)

    @_builtins.property
    @pulumi.getter(name="targetAvailabilitySetId")
    def target_availability_set_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of availability set that the new VM should belong to when a failover is done.
        """
        return pulumi.get(self, "target_availability_set_id")

    @target_availability_set_id.setter
    def target_availability_set_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_availability_set_id", value)

    @_builtins.property
    @pulumi.getter(name="targetBootDiagnosticsStorageAccountId")
    def target_boot_diagnostics_storage_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the storage account that should be used for boot diagnostics when a failover is done.
        """
        return pulumi.get(self, "target_boot_diagnostics_storage_account_id")

    @target_boot_diagnostics_storage_account_id.setter
    def target_boot_diagnostics_storage_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_boot_diagnostics_storage_account_id", value)

    @_builtins.property
    @pulumi.getter(name="targetNetworkId")
    def target_network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of network to use when a failover is done.

        > **Note:** `target_network_id` is required when `network_interface` is specified.
        """
        return pulumi.get(self, "target_network_id")

    @target_network_id.setter
    def target_network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_network_id", value)

    @_builtins.property
    @pulumi.getter(name="targetProximityPlacementGroupId")
    def target_proximity_placement_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of Proximity Placement Group the new VM should belong to when a failover is done.

        > **Note:** Only one of `target_availability_set_id` or `target_zone` can be specified.
        """
        return pulumi.get(self, "target_proximity_placement_group_id")

    @target_proximity_placement_group_id.setter
    def target_proximity_placement_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_proximity_placement_group_id", value)

    @_builtins.property
    @pulumi.getter(name="targetVmSize")
    def target_vm_size(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Size of the VM that should be created when a failover is done, such as `Standard_F2`. If it's not specified, it will automatically be set by detecting the source VM size.
        """
        return pulumi.get(self, "target_vm_size")

    @target_vm_size.setter
    def target_vm_size(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_vm_size", value)

    @_builtins.property
    @pulumi.getter(name="targetZone")
    def target_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Availability Zone where the Failover VM should exist.
        """
        return pulumi.get(self, "target_zone")

    @target_zone.setter
    def target_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_zone", value)

    @_builtins.property
    @pulumi.getter(name="testNetworkId")
    def test_network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of network to use when a test failover is done.
        """
        return pulumi.get(self, "test_network_id")

    @test_network_id.setter
    def test_network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "test_network_id", value)


@pulumi.input_type
class _VmwareReplicatedVmState:
    def __init__(__self__, *,
                 appliance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 default_log_storage_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 default_recovery_disk_type: Optional[pulumi.Input[_builtins.str]] = None,
                 default_target_disk_encryption_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                 license_type: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_disks: Optional[pulumi.Input[Sequence[pulumi.Input['VmwareReplicatedVmManagedDiskArgs']]]] = None,
                 multi_vm_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['VmwareReplicatedVmNetworkInterfaceArgs']]]] = None,
                 physical_server_credential_name: Optional[pulumi.Input[_builtins.str]] = None,
                 recovery_replication_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 recovery_vault_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_vm_name: Optional[pulumi.Input[_builtins.str]] = None,
                 target_availability_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_boot_diagnostics_storage_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_proximity_placement_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_vm_name: Optional[pulumi.Input[_builtins.str]] = None,
                 target_vm_size: Optional[pulumi.Input[_builtins.str]] = None,
                 target_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 test_network_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering VmwareReplicatedVm resources.
        :param pulumi.Input[_builtins.str] appliance_name: The name of VMWare appliance which handles the replication. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] default_log_storage_account_id: The ID of the stroage account that should be used for logging during replication. 
               
               > **Note:** Only standard types of storage accounts are allowed.
               
               > **Note:** Only one of `default_log_storage_account_id` or `managed_disk` must be specified.
               
               > **Note:** Changing `default_log_storage_account_id` forces a new resource to be created. But removing it does not.
               
               > **Note:** When `default_log_storage_account_id` co-exist with `managed_disk`, the value of `default_log_storage_account_id` must be as same as `log_storage_account_id` of every `managed_disk` or it forces a new resource to be created.
        :param pulumi.Input[_builtins.str] default_recovery_disk_type: The type of storage account that should be used for recovery disks when a failover is done. Possible values are `Premium_LRS`, `Standard_LRS` and `StandardSSD_LRS`.
               
               > **Note:** Only one of `default_recovery_disk_type` or `managed_disk` must be specified.
               
               > **Note:** Changing `default_recovery_disk_type` forces a new resource to be created. But removing it does not.
               
               > **Note:** When `default_recovery_disk_type` co-exist with `managed_disk`, the value of `default_recovery_disk_type` must be as same as `target_disk_type` of every `managed_disk` or it forces a new resource to be created.
        :param pulumi.Input[_builtins.str] default_target_disk_encryption_set_id: The ID of the default Disk Encryption Set that should be used for the disks when a failover is done.
               
               > **Note:** Changing `default_target_disk_encryption_set_id` forces a new resource to be created. But removing it does not.
               
               > **Note:** When `default_target_disk_encryption_set_id` co-exist with `managed_disk`, the value of `default_target_disk_encryption_set_id` must be as same as `target_disk_encryption_set_id` of every `managed_disk` or it forces a new resource to be created.
        :param pulumi.Input[_builtins.str] license_type: The license type of the VM. Possible values are `NoLicenseType`, `NotSpecified` and `WindowsServer`. Defaults to `NotSpecified`.
        :param pulumi.Input[Sequence[pulumi.Input['VmwareReplicatedVmManagedDiskArgs']]] managed_disks: One or more `managed_disk` block as defined below. It's available only if mobility service is already installed on the source VM.
               
               > **Note:** A replicated VM could be created without `managed_disk` block, once the block has been specified, changing it expect removing it forces a new resource to be created.
        :param pulumi.Input[_builtins.str] multi_vm_group_name: Name of group in which all machines will replicate together and have shared crash consistent and app-consistent recovery points when failed over.
        :param pulumi.Input[_builtins.str] name: The name of the replicated VM. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['VmwareReplicatedVmNetworkInterfaceArgs']]] network_interfaces: One or more `network_interface` block as defined below.
        :param pulumi.Input[_builtins.str] physical_server_credential_name: The name of the credential to access the source VM. Changing this forces a new resource to be created. More information about the credentials could be found [here](https://learn.microsoft.com/en-us/azure/site-recovery/deploy-vmware-azure-replication-appliance-modernized).
        :param pulumi.Input[_builtins.str] recovery_replication_policy_id: The ID of the policy to use for this replicated VM.
        :param pulumi.Input[_builtins.str] recovery_vault_id: The ID of the Recovery Services Vault where the replicated VM is created.
        :param pulumi.Input[_builtins.str] source_vm_name: The name of the source VM in VMWare. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] target_availability_set_id: The ID of availability set that the new VM should belong to when a failover is done.
        :param pulumi.Input[_builtins.str] target_boot_diagnostics_storage_account_id: The ID of the storage account that should be used for boot diagnostics when a failover is done.
        :param pulumi.Input[_builtins.str] target_network_id: The ID of network to use when a failover is done.
               
               > **Note:** `target_network_id` is required when `network_interface` is specified.
        :param pulumi.Input[_builtins.str] target_proximity_placement_group_id: The ID of Proximity Placement Group the new VM should belong to when a failover is done.
               
               > **Note:** Only one of `target_availability_set_id` or `target_zone` can be specified.
        :param pulumi.Input[_builtins.str] target_resource_group_id: The ID of resource group where the VM should be created when a failover is done.
        :param pulumi.Input[_builtins.str] target_vm_name: Name of the VM that should be created when a failover is done. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] target_vm_size: Size of the VM that should be created when a failover is done, such as `Standard_F2`. If it's not specified, it will automatically be set by detecting the source VM size.
        :param pulumi.Input[_builtins.str] target_zone: Specifies the Availability Zone where the Failover VM should exist.
        :param pulumi.Input[_builtins.str] test_network_id: The ID of network to use when a test failover is done.
        """
        if appliance_name is not None:
            pulumi.set(__self__, "appliance_name", appliance_name)
        if default_log_storage_account_id is not None:
            pulumi.set(__self__, "default_log_storage_account_id", default_log_storage_account_id)
        if default_recovery_disk_type is not None:
            pulumi.set(__self__, "default_recovery_disk_type", default_recovery_disk_type)
        if default_target_disk_encryption_set_id is not None:
            pulumi.set(__self__, "default_target_disk_encryption_set_id", default_target_disk_encryption_set_id)
        if license_type is not None:
            pulumi.set(__self__, "license_type", license_type)
        if managed_disks is not None:
            pulumi.set(__self__, "managed_disks", managed_disks)
        if multi_vm_group_name is not None:
            pulumi.set(__self__, "multi_vm_group_name", multi_vm_group_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)
        if physical_server_credential_name is not None:
            pulumi.set(__self__, "physical_server_credential_name", physical_server_credential_name)
        if recovery_replication_policy_id is not None:
            pulumi.set(__self__, "recovery_replication_policy_id", recovery_replication_policy_id)
        if recovery_vault_id is not None:
            pulumi.set(__self__, "recovery_vault_id", recovery_vault_id)
        if source_vm_name is not None:
            pulumi.set(__self__, "source_vm_name", source_vm_name)
        if target_availability_set_id is not None:
            pulumi.set(__self__, "target_availability_set_id", target_availability_set_id)
        if target_boot_diagnostics_storage_account_id is not None:
            pulumi.set(__self__, "target_boot_diagnostics_storage_account_id", target_boot_diagnostics_storage_account_id)
        if target_network_id is not None:
            pulumi.set(__self__, "target_network_id", target_network_id)
        if target_proximity_placement_group_id is not None:
            pulumi.set(__self__, "target_proximity_placement_group_id", target_proximity_placement_group_id)
        if target_resource_group_id is not None:
            pulumi.set(__self__, "target_resource_group_id", target_resource_group_id)
        if target_vm_name is not None:
            pulumi.set(__self__, "target_vm_name", target_vm_name)
        if target_vm_size is not None:
            pulumi.set(__self__, "target_vm_size", target_vm_size)
        if target_zone is not None:
            pulumi.set(__self__, "target_zone", target_zone)
        if test_network_id is not None:
            pulumi.set(__self__, "test_network_id", test_network_id)

    @_builtins.property
    @pulumi.getter(name="applianceName")
    def appliance_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of VMWare appliance which handles the replication. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "appliance_name")

    @appliance_name.setter
    def appliance_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "appliance_name", value)

    @_builtins.property
    @pulumi.getter(name="defaultLogStorageAccountId")
    def default_log_storage_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the stroage account that should be used for logging during replication. 

        > **Note:** Only standard types of storage accounts are allowed.

        > **Note:** Only one of `default_log_storage_account_id` or `managed_disk` must be specified.

        > **Note:** Changing `default_log_storage_account_id` forces a new resource to be created. But removing it does not.

        > **Note:** When `default_log_storage_account_id` co-exist with `managed_disk`, the value of `default_log_storage_account_id` must be as same as `log_storage_account_id` of every `managed_disk` or it forces a new resource to be created.
        """
        return pulumi.get(self, "default_log_storage_account_id")

    @default_log_storage_account_id.setter
    def default_log_storage_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_log_storage_account_id", value)

    @_builtins.property
    @pulumi.getter(name="defaultRecoveryDiskType")
    def default_recovery_disk_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of storage account that should be used for recovery disks when a failover is done. Possible values are `Premium_LRS`, `Standard_LRS` and `StandardSSD_LRS`.

        > **Note:** Only one of `default_recovery_disk_type` or `managed_disk` must be specified.

        > **Note:** Changing `default_recovery_disk_type` forces a new resource to be created. But removing it does not.

        > **Note:** When `default_recovery_disk_type` co-exist with `managed_disk`, the value of `default_recovery_disk_type` must be as same as `target_disk_type` of every `managed_disk` or it forces a new resource to be created.
        """
        return pulumi.get(self, "default_recovery_disk_type")

    @default_recovery_disk_type.setter
    def default_recovery_disk_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_recovery_disk_type", value)

    @_builtins.property
    @pulumi.getter(name="defaultTargetDiskEncryptionSetId")
    def default_target_disk_encryption_set_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the default Disk Encryption Set that should be used for the disks when a failover is done.

        > **Note:** Changing `default_target_disk_encryption_set_id` forces a new resource to be created. But removing it does not.

        > **Note:** When `default_target_disk_encryption_set_id` co-exist with `managed_disk`, the value of `default_target_disk_encryption_set_id` must be as same as `target_disk_encryption_set_id` of every `managed_disk` or it forces a new resource to be created.
        """
        return pulumi.get(self, "default_target_disk_encryption_set_id")

    @default_target_disk_encryption_set_id.setter
    def default_target_disk_encryption_set_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_target_disk_encryption_set_id", value)

    @_builtins.property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The license type of the VM. Possible values are `NoLicenseType`, `NotSpecified` and `WindowsServer`. Defaults to `NotSpecified`.
        """
        return pulumi.get(self, "license_type")

    @license_type.setter
    def license_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "license_type", value)

    @_builtins.property
    @pulumi.getter(name="managedDisks")
    def managed_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VmwareReplicatedVmManagedDiskArgs']]]]:
        """
        One or more `managed_disk` block as defined below. It's available only if mobility service is already installed on the source VM.

        > **Note:** A replicated VM could be created without `managed_disk` block, once the block has been specified, changing it expect removing it forces a new resource to be created.
        """
        return pulumi.get(self, "managed_disks")

    @managed_disks.setter
    def managed_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VmwareReplicatedVmManagedDiskArgs']]]]):
        pulumi.set(self, "managed_disks", value)

    @_builtins.property
    @pulumi.getter(name="multiVmGroupName")
    def multi_vm_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of group in which all machines will replicate together and have shared crash consistent and app-consistent recovery points when failed over.
        """
        return pulumi.get(self, "multi_vm_group_name")

    @multi_vm_group_name.setter
    def multi_vm_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "multi_vm_group_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the replicated VM. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VmwareReplicatedVmNetworkInterfaceArgs']]]]:
        """
        One or more `network_interface` block as defined below.
        """
        return pulumi.get(self, "network_interfaces")

    @network_interfaces.setter
    def network_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VmwareReplicatedVmNetworkInterfaceArgs']]]]):
        pulumi.set(self, "network_interfaces", value)

    @_builtins.property
    @pulumi.getter(name="physicalServerCredentialName")
    def physical_server_credential_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the credential to access the source VM. Changing this forces a new resource to be created. More information about the credentials could be found [here](https://learn.microsoft.com/en-us/azure/site-recovery/deploy-vmware-azure-replication-appliance-modernized).
        """
        return pulumi.get(self, "physical_server_credential_name")

    @physical_server_credential_name.setter
    def physical_server_credential_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "physical_server_credential_name", value)

    @_builtins.property
    @pulumi.getter(name="recoveryReplicationPolicyId")
    def recovery_replication_policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the policy to use for this replicated VM.
        """
        return pulumi.get(self, "recovery_replication_policy_id")

    @recovery_replication_policy_id.setter
    def recovery_replication_policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "recovery_replication_policy_id", value)

    @_builtins.property
    @pulumi.getter(name="recoveryVaultId")
    def recovery_vault_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Recovery Services Vault where the replicated VM is created.
        """
        return pulumi.get(self, "recovery_vault_id")

    @recovery_vault_id.setter
    def recovery_vault_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "recovery_vault_id", value)

    @_builtins.property
    @pulumi.getter(name="sourceVmName")
    def source_vm_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the source VM in VMWare. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "source_vm_name")

    @source_vm_name.setter
    def source_vm_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_vm_name", value)

    @_builtins.property
    @pulumi.getter(name="targetAvailabilitySetId")
    def target_availability_set_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of availability set that the new VM should belong to when a failover is done.
        """
        return pulumi.get(self, "target_availability_set_id")

    @target_availability_set_id.setter
    def target_availability_set_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_availability_set_id", value)

    @_builtins.property
    @pulumi.getter(name="targetBootDiagnosticsStorageAccountId")
    def target_boot_diagnostics_storage_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the storage account that should be used for boot diagnostics when a failover is done.
        """
        return pulumi.get(self, "target_boot_diagnostics_storage_account_id")

    @target_boot_diagnostics_storage_account_id.setter
    def target_boot_diagnostics_storage_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_boot_diagnostics_storage_account_id", value)

    @_builtins.property
    @pulumi.getter(name="targetNetworkId")
    def target_network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of network to use when a failover is done.

        > **Note:** `target_network_id` is required when `network_interface` is specified.
        """
        return pulumi.get(self, "target_network_id")

    @target_network_id.setter
    def target_network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_network_id", value)

    @_builtins.property
    @pulumi.getter(name="targetProximityPlacementGroupId")
    def target_proximity_placement_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of Proximity Placement Group the new VM should belong to when a failover is done.

        > **Note:** Only one of `target_availability_set_id` or `target_zone` can be specified.
        """
        return pulumi.get(self, "target_proximity_placement_group_id")

    @target_proximity_placement_group_id.setter
    def target_proximity_placement_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_proximity_placement_group_id", value)

    @_builtins.property
    @pulumi.getter(name="targetResourceGroupId")
    def target_resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of resource group where the VM should be created when a failover is done.
        """
        return pulumi.get(self, "target_resource_group_id")

    @target_resource_group_id.setter
    def target_resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="targetVmName")
    def target_vm_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the VM that should be created when a failover is done. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "target_vm_name")

    @target_vm_name.setter
    def target_vm_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_vm_name", value)

    @_builtins.property
    @pulumi.getter(name="targetVmSize")
    def target_vm_size(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Size of the VM that should be created when a failover is done, such as `Standard_F2`. If it's not specified, it will automatically be set by detecting the source VM size.
        """
        return pulumi.get(self, "target_vm_size")

    @target_vm_size.setter
    def target_vm_size(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_vm_size", value)

    @_builtins.property
    @pulumi.getter(name="targetZone")
    def target_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Availability Zone where the Failover VM should exist.
        """
        return pulumi.get(self, "target_zone")

    @target_zone.setter
    def target_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_zone", value)

    @_builtins.property
    @pulumi.getter(name="testNetworkId")
    def test_network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of network to use when a test failover is done.
        """
        return pulumi.get(self, "test_network_id")

    @test_network_id.setter
    def test_network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "test_network_id", value)


@pulumi.type_token("azure:siterecovery/vmwareReplicatedVm:VmwareReplicatedVm")
class VmwareReplicatedVm(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 appliance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 default_log_storage_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 default_recovery_disk_type: Optional[pulumi.Input[_builtins.str]] = None,
                 default_target_disk_encryption_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                 license_type: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VmwareReplicatedVmManagedDiskArgs', 'VmwareReplicatedVmManagedDiskArgsDict']]]]] = None,
                 multi_vm_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VmwareReplicatedVmNetworkInterfaceArgs', 'VmwareReplicatedVmNetworkInterfaceArgsDict']]]]] = None,
                 physical_server_credential_name: Optional[pulumi.Input[_builtins.str]] = None,
                 recovery_replication_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 recovery_vault_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_vm_name: Optional[pulumi.Input[_builtins.str]] = None,
                 target_availability_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_boot_diagnostics_storage_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_proximity_placement_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_vm_name: Optional[pulumi.Input[_builtins.str]] = None,
                 target_vm_size: Optional[pulumi.Input[_builtins.str]] = None,
                 target_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 test_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a VMWare replicated VM using Azure Site Recovery (VMWare to Azure only). A replicated VM keeps a copiously updated image of the VM in Azure in order to be able to start the VM in Azure in case of a disaster.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-rg",
            location="West US")
        example_vault = azure.recoveryservices.Vault("example",
            name="example-recovery-vault",
            location=example.location,
            resource_group_name=example.name,
            sku="Standard")
        example_vm_ware_replication_policy = azure.siterecovery.VMWareReplicationPolicy("example",
            recovery_vault_id=example_vault.id,
            name="example-policy",
            recovery_point_retention_in_minutes=1440,
            application_consistent_snapshot_frequency_in_minutes=240)
        test = azure.siterecovery.VmwareReplicationPolicyAssociation("test",
            name="example-association",
            recovery_vault_id=example_vault.id,
            policy_id=example_vm_ware_replication_policy.id)
        example_account = azure.storage.Account("example",
            name="examplestorageacc",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_kind="StorageV2",
            account_replication_type="LRS")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-net",
            resource_group_name=example.name,
            address_spaces=["192.168.2.0/24"],
            location=example.location)
        example_subnet = azure.network.Subnet("example",
            name="example-subnet",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["192.168.2.0/24"])
        example_vmware_replicated_vm = azure.siterecovery.VmwareReplicatedVm("example",
            name="example-vmware-vm",
            recovery_vault_id=example_vault.id,
            source_vm_name="example-vm",
            appliance_name="example-appliance",
            recovery_replication_policy_id=example_azurerm_site_recovery_vmware_replication_policy_association["policyId"],
            physical_server_credential_name="example-creds",
            license_type="NotSpecified",
            target_boot_diagnostics_storage_account_id=example_account.id,
            target_vm_name="example_replicated_vm",
            target_resource_group_id=example.id,
            default_log_storage_account_id=example_account.id,
            default_recovery_disk_type="Standard_LRS",
            target_network_id=example_virtual_network.id,
            network_interfaces=[{
                "source_mac_address": "00:00:00:00:00:00",
                "target_subnet_name": example_subnet.name,
                "is_primary": True,
            }])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.OffAzure` - 2020-01-01

        * `Microsoft.RecoveryServices` - 2024-04-01

        ## Import

        Site Recovery VMWare Replicated VM's can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:siterecovery/vmwareReplicatedVm:VmwareReplicatedVm vmreplication /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resource-group-name/providers/Microsoft.RecoveryServices/vaults/recovery-vault-name/replicationFabrics/fabric-name/replicationProtectionContainers/protection-container-name/replicationProtectedItems/vm-replication-name
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] appliance_name: The name of VMWare appliance which handles the replication. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] default_log_storage_account_id: The ID of the stroage account that should be used for logging during replication. 
               
               > **Note:** Only standard types of storage accounts are allowed.
               
               > **Note:** Only one of `default_log_storage_account_id` or `managed_disk` must be specified.
               
               > **Note:** Changing `default_log_storage_account_id` forces a new resource to be created. But removing it does not.
               
               > **Note:** When `default_log_storage_account_id` co-exist with `managed_disk`, the value of `default_log_storage_account_id` must be as same as `log_storage_account_id` of every `managed_disk` or it forces a new resource to be created.
        :param pulumi.Input[_builtins.str] default_recovery_disk_type: The type of storage account that should be used for recovery disks when a failover is done. Possible values are `Premium_LRS`, `Standard_LRS` and `StandardSSD_LRS`.
               
               > **Note:** Only one of `default_recovery_disk_type` or `managed_disk` must be specified.
               
               > **Note:** Changing `default_recovery_disk_type` forces a new resource to be created. But removing it does not.
               
               > **Note:** When `default_recovery_disk_type` co-exist with `managed_disk`, the value of `default_recovery_disk_type` must be as same as `target_disk_type` of every `managed_disk` or it forces a new resource to be created.
        :param pulumi.Input[_builtins.str] default_target_disk_encryption_set_id: The ID of the default Disk Encryption Set that should be used for the disks when a failover is done.
               
               > **Note:** Changing `default_target_disk_encryption_set_id` forces a new resource to be created. But removing it does not.
               
               > **Note:** When `default_target_disk_encryption_set_id` co-exist with `managed_disk`, the value of `default_target_disk_encryption_set_id` must be as same as `target_disk_encryption_set_id` of every `managed_disk` or it forces a new resource to be created.
        :param pulumi.Input[_builtins.str] license_type: The license type of the VM. Possible values are `NoLicenseType`, `NotSpecified` and `WindowsServer`. Defaults to `NotSpecified`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VmwareReplicatedVmManagedDiskArgs', 'VmwareReplicatedVmManagedDiskArgsDict']]]] managed_disks: One or more `managed_disk` block as defined below. It's available only if mobility service is already installed on the source VM.
               
               > **Note:** A replicated VM could be created without `managed_disk` block, once the block has been specified, changing it expect removing it forces a new resource to be created.
        :param pulumi.Input[_builtins.str] multi_vm_group_name: Name of group in which all machines will replicate together and have shared crash consistent and app-consistent recovery points when failed over.
        :param pulumi.Input[_builtins.str] name: The name of the replicated VM. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VmwareReplicatedVmNetworkInterfaceArgs', 'VmwareReplicatedVmNetworkInterfaceArgsDict']]]] network_interfaces: One or more `network_interface` block as defined below.
        :param pulumi.Input[_builtins.str] physical_server_credential_name: The name of the credential to access the source VM. Changing this forces a new resource to be created. More information about the credentials could be found [here](https://learn.microsoft.com/en-us/azure/site-recovery/deploy-vmware-azure-replication-appliance-modernized).
        :param pulumi.Input[_builtins.str] recovery_replication_policy_id: The ID of the policy to use for this replicated VM.
        :param pulumi.Input[_builtins.str] recovery_vault_id: The ID of the Recovery Services Vault where the replicated VM is created.
        :param pulumi.Input[_builtins.str] source_vm_name: The name of the source VM in VMWare. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] target_availability_set_id: The ID of availability set that the new VM should belong to when a failover is done.
        :param pulumi.Input[_builtins.str] target_boot_diagnostics_storage_account_id: The ID of the storage account that should be used for boot diagnostics when a failover is done.
        :param pulumi.Input[_builtins.str] target_network_id: The ID of network to use when a failover is done.
               
               > **Note:** `target_network_id` is required when `network_interface` is specified.
        :param pulumi.Input[_builtins.str] target_proximity_placement_group_id: The ID of Proximity Placement Group the new VM should belong to when a failover is done.
               
               > **Note:** Only one of `target_availability_set_id` or `target_zone` can be specified.
        :param pulumi.Input[_builtins.str] target_resource_group_id: The ID of resource group where the VM should be created when a failover is done.
        :param pulumi.Input[_builtins.str] target_vm_name: Name of the VM that should be created when a failover is done. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] target_vm_size: Size of the VM that should be created when a failover is done, such as `Standard_F2`. If it's not specified, it will automatically be set by detecting the source VM size.
        :param pulumi.Input[_builtins.str] target_zone: Specifies the Availability Zone where the Failover VM should exist.
        :param pulumi.Input[_builtins.str] test_network_id: The ID of network to use when a test failover is done.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VmwareReplicatedVmArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a VMWare replicated VM using Azure Site Recovery (VMWare to Azure only). A replicated VM keeps a copiously updated image of the VM in Azure in order to be able to start the VM in Azure in case of a disaster.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-rg",
            location="West US")
        example_vault = azure.recoveryservices.Vault("example",
            name="example-recovery-vault",
            location=example.location,
            resource_group_name=example.name,
            sku="Standard")
        example_vm_ware_replication_policy = azure.siterecovery.VMWareReplicationPolicy("example",
            recovery_vault_id=example_vault.id,
            name="example-policy",
            recovery_point_retention_in_minutes=1440,
            application_consistent_snapshot_frequency_in_minutes=240)
        test = azure.siterecovery.VmwareReplicationPolicyAssociation("test",
            name="example-association",
            recovery_vault_id=example_vault.id,
            policy_id=example_vm_ware_replication_policy.id)
        example_account = azure.storage.Account("example",
            name="examplestorageacc",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_kind="StorageV2",
            account_replication_type="LRS")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-net",
            resource_group_name=example.name,
            address_spaces=["192.168.2.0/24"],
            location=example.location)
        example_subnet = azure.network.Subnet("example",
            name="example-subnet",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["192.168.2.0/24"])
        example_vmware_replicated_vm = azure.siterecovery.VmwareReplicatedVm("example",
            name="example-vmware-vm",
            recovery_vault_id=example_vault.id,
            source_vm_name="example-vm",
            appliance_name="example-appliance",
            recovery_replication_policy_id=example_azurerm_site_recovery_vmware_replication_policy_association["policyId"],
            physical_server_credential_name="example-creds",
            license_type="NotSpecified",
            target_boot_diagnostics_storage_account_id=example_account.id,
            target_vm_name="example_replicated_vm",
            target_resource_group_id=example.id,
            default_log_storage_account_id=example_account.id,
            default_recovery_disk_type="Standard_LRS",
            target_network_id=example_virtual_network.id,
            network_interfaces=[{
                "source_mac_address": "00:00:00:00:00:00",
                "target_subnet_name": example_subnet.name,
                "is_primary": True,
            }])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.OffAzure` - 2020-01-01

        * `Microsoft.RecoveryServices` - 2024-04-01

        ## Import

        Site Recovery VMWare Replicated VM's can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:siterecovery/vmwareReplicatedVm:VmwareReplicatedVm vmreplication /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resource-group-name/providers/Microsoft.RecoveryServices/vaults/recovery-vault-name/replicationFabrics/fabric-name/replicationProtectionContainers/protection-container-name/replicationProtectedItems/vm-replication-name
        ```

        :param str resource_name: The name of the resource.
        :param VmwareReplicatedVmArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VmwareReplicatedVmArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 appliance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 default_log_storage_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 default_recovery_disk_type: Optional[pulumi.Input[_builtins.str]] = None,
                 default_target_disk_encryption_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                 license_type: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VmwareReplicatedVmManagedDiskArgs', 'VmwareReplicatedVmManagedDiskArgsDict']]]]] = None,
                 multi_vm_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VmwareReplicatedVmNetworkInterfaceArgs', 'VmwareReplicatedVmNetworkInterfaceArgsDict']]]]] = None,
                 physical_server_credential_name: Optional[pulumi.Input[_builtins.str]] = None,
                 recovery_replication_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 recovery_vault_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_vm_name: Optional[pulumi.Input[_builtins.str]] = None,
                 target_availability_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_boot_diagnostics_storage_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_proximity_placement_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_vm_name: Optional[pulumi.Input[_builtins.str]] = None,
                 target_vm_size: Optional[pulumi.Input[_builtins.str]] = None,
                 target_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 test_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VmwareReplicatedVmArgs.__new__(VmwareReplicatedVmArgs)

            if appliance_name is None and not opts.urn:
                raise TypeError("Missing required property 'appliance_name'")
            __props__.__dict__["appliance_name"] = appliance_name
            __props__.__dict__["default_log_storage_account_id"] = default_log_storage_account_id
            __props__.__dict__["default_recovery_disk_type"] = default_recovery_disk_type
            __props__.__dict__["default_target_disk_encryption_set_id"] = default_target_disk_encryption_set_id
            __props__.__dict__["license_type"] = license_type
            __props__.__dict__["managed_disks"] = managed_disks
            __props__.__dict__["multi_vm_group_name"] = multi_vm_group_name
            __props__.__dict__["name"] = name
            __props__.__dict__["network_interfaces"] = network_interfaces
            if physical_server_credential_name is None and not opts.urn:
                raise TypeError("Missing required property 'physical_server_credential_name'")
            __props__.__dict__["physical_server_credential_name"] = physical_server_credential_name
            if recovery_replication_policy_id is None and not opts.urn:
                raise TypeError("Missing required property 'recovery_replication_policy_id'")
            __props__.__dict__["recovery_replication_policy_id"] = recovery_replication_policy_id
            if recovery_vault_id is None and not opts.urn:
                raise TypeError("Missing required property 'recovery_vault_id'")
            __props__.__dict__["recovery_vault_id"] = recovery_vault_id
            if source_vm_name is None and not opts.urn:
                raise TypeError("Missing required property 'source_vm_name'")
            __props__.__dict__["source_vm_name"] = source_vm_name
            __props__.__dict__["target_availability_set_id"] = target_availability_set_id
            __props__.__dict__["target_boot_diagnostics_storage_account_id"] = target_boot_diagnostics_storage_account_id
            __props__.__dict__["target_network_id"] = target_network_id
            __props__.__dict__["target_proximity_placement_group_id"] = target_proximity_placement_group_id
            if target_resource_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'target_resource_group_id'")
            __props__.__dict__["target_resource_group_id"] = target_resource_group_id
            if target_vm_name is None and not opts.urn:
                raise TypeError("Missing required property 'target_vm_name'")
            __props__.__dict__["target_vm_name"] = target_vm_name
            __props__.__dict__["target_vm_size"] = target_vm_size
            __props__.__dict__["target_zone"] = target_zone
            __props__.__dict__["test_network_id"] = test_network_id
        super(VmwareReplicatedVm, __self__).__init__(
            'azure:siterecovery/vmwareReplicatedVm:VmwareReplicatedVm',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            appliance_name: Optional[pulumi.Input[_builtins.str]] = None,
            default_log_storage_account_id: Optional[pulumi.Input[_builtins.str]] = None,
            default_recovery_disk_type: Optional[pulumi.Input[_builtins.str]] = None,
            default_target_disk_encryption_set_id: Optional[pulumi.Input[_builtins.str]] = None,
            license_type: Optional[pulumi.Input[_builtins.str]] = None,
            managed_disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VmwareReplicatedVmManagedDiskArgs', 'VmwareReplicatedVmManagedDiskArgsDict']]]]] = None,
            multi_vm_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VmwareReplicatedVmNetworkInterfaceArgs', 'VmwareReplicatedVmNetworkInterfaceArgsDict']]]]] = None,
            physical_server_credential_name: Optional[pulumi.Input[_builtins.str]] = None,
            recovery_replication_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
            recovery_vault_id: Optional[pulumi.Input[_builtins.str]] = None,
            source_vm_name: Optional[pulumi.Input[_builtins.str]] = None,
            target_availability_set_id: Optional[pulumi.Input[_builtins.str]] = None,
            target_boot_diagnostics_storage_account_id: Optional[pulumi.Input[_builtins.str]] = None,
            target_network_id: Optional[pulumi.Input[_builtins.str]] = None,
            target_proximity_placement_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            target_resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            target_vm_name: Optional[pulumi.Input[_builtins.str]] = None,
            target_vm_size: Optional[pulumi.Input[_builtins.str]] = None,
            target_zone: Optional[pulumi.Input[_builtins.str]] = None,
            test_network_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'VmwareReplicatedVm':
        """
        Get an existing VmwareReplicatedVm resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] appliance_name: The name of VMWare appliance which handles the replication. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] default_log_storage_account_id: The ID of the stroage account that should be used for logging during replication. 
               
               > **Note:** Only standard types of storage accounts are allowed.
               
               > **Note:** Only one of `default_log_storage_account_id` or `managed_disk` must be specified.
               
               > **Note:** Changing `default_log_storage_account_id` forces a new resource to be created. But removing it does not.
               
               > **Note:** When `default_log_storage_account_id` co-exist with `managed_disk`, the value of `default_log_storage_account_id` must be as same as `log_storage_account_id` of every `managed_disk` or it forces a new resource to be created.
        :param pulumi.Input[_builtins.str] default_recovery_disk_type: The type of storage account that should be used for recovery disks when a failover is done. Possible values are `Premium_LRS`, `Standard_LRS` and `StandardSSD_LRS`.
               
               > **Note:** Only one of `default_recovery_disk_type` or `managed_disk` must be specified.
               
               > **Note:** Changing `default_recovery_disk_type` forces a new resource to be created. But removing it does not.
               
               > **Note:** When `default_recovery_disk_type` co-exist with `managed_disk`, the value of `default_recovery_disk_type` must be as same as `target_disk_type` of every `managed_disk` or it forces a new resource to be created.
        :param pulumi.Input[_builtins.str] default_target_disk_encryption_set_id: The ID of the default Disk Encryption Set that should be used for the disks when a failover is done.
               
               > **Note:** Changing `default_target_disk_encryption_set_id` forces a new resource to be created. But removing it does not.
               
               > **Note:** When `default_target_disk_encryption_set_id` co-exist with `managed_disk`, the value of `default_target_disk_encryption_set_id` must be as same as `target_disk_encryption_set_id` of every `managed_disk` or it forces a new resource to be created.
        :param pulumi.Input[_builtins.str] license_type: The license type of the VM. Possible values are `NoLicenseType`, `NotSpecified` and `WindowsServer`. Defaults to `NotSpecified`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VmwareReplicatedVmManagedDiskArgs', 'VmwareReplicatedVmManagedDiskArgsDict']]]] managed_disks: One or more `managed_disk` block as defined below. It's available only if mobility service is already installed on the source VM.
               
               > **Note:** A replicated VM could be created without `managed_disk` block, once the block has been specified, changing it expect removing it forces a new resource to be created.
        :param pulumi.Input[_builtins.str] multi_vm_group_name: Name of group in which all machines will replicate together and have shared crash consistent and app-consistent recovery points when failed over.
        :param pulumi.Input[_builtins.str] name: The name of the replicated VM. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VmwareReplicatedVmNetworkInterfaceArgs', 'VmwareReplicatedVmNetworkInterfaceArgsDict']]]] network_interfaces: One or more `network_interface` block as defined below.
        :param pulumi.Input[_builtins.str] physical_server_credential_name: The name of the credential to access the source VM. Changing this forces a new resource to be created. More information about the credentials could be found [here](https://learn.microsoft.com/en-us/azure/site-recovery/deploy-vmware-azure-replication-appliance-modernized).
        :param pulumi.Input[_builtins.str] recovery_replication_policy_id: The ID of the policy to use for this replicated VM.
        :param pulumi.Input[_builtins.str] recovery_vault_id: The ID of the Recovery Services Vault where the replicated VM is created.
        :param pulumi.Input[_builtins.str] source_vm_name: The name of the source VM in VMWare. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] target_availability_set_id: The ID of availability set that the new VM should belong to when a failover is done.
        :param pulumi.Input[_builtins.str] target_boot_diagnostics_storage_account_id: The ID of the storage account that should be used for boot diagnostics when a failover is done.
        :param pulumi.Input[_builtins.str] target_network_id: The ID of network to use when a failover is done.
               
               > **Note:** `target_network_id` is required when `network_interface` is specified.
        :param pulumi.Input[_builtins.str] target_proximity_placement_group_id: The ID of Proximity Placement Group the new VM should belong to when a failover is done.
               
               > **Note:** Only one of `target_availability_set_id` or `target_zone` can be specified.
        :param pulumi.Input[_builtins.str] target_resource_group_id: The ID of resource group where the VM should be created when a failover is done.
        :param pulumi.Input[_builtins.str] target_vm_name: Name of the VM that should be created when a failover is done. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] target_vm_size: Size of the VM that should be created when a failover is done, such as `Standard_F2`. If it's not specified, it will automatically be set by detecting the source VM size.
        :param pulumi.Input[_builtins.str] target_zone: Specifies the Availability Zone where the Failover VM should exist.
        :param pulumi.Input[_builtins.str] test_network_id: The ID of network to use when a test failover is done.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VmwareReplicatedVmState.__new__(_VmwareReplicatedVmState)

        __props__.__dict__["appliance_name"] = appliance_name
        __props__.__dict__["default_log_storage_account_id"] = default_log_storage_account_id
        __props__.__dict__["default_recovery_disk_type"] = default_recovery_disk_type
        __props__.__dict__["default_target_disk_encryption_set_id"] = default_target_disk_encryption_set_id
        __props__.__dict__["license_type"] = license_type
        __props__.__dict__["managed_disks"] = managed_disks
        __props__.__dict__["multi_vm_group_name"] = multi_vm_group_name
        __props__.__dict__["name"] = name
        __props__.__dict__["network_interfaces"] = network_interfaces
        __props__.__dict__["physical_server_credential_name"] = physical_server_credential_name
        __props__.__dict__["recovery_replication_policy_id"] = recovery_replication_policy_id
        __props__.__dict__["recovery_vault_id"] = recovery_vault_id
        __props__.__dict__["source_vm_name"] = source_vm_name
        __props__.__dict__["target_availability_set_id"] = target_availability_set_id
        __props__.__dict__["target_boot_diagnostics_storage_account_id"] = target_boot_diagnostics_storage_account_id
        __props__.__dict__["target_network_id"] = target_network_id
        __props__.__dict__["target_proximity_placement_group_id"] = target_proximity_placement_group_id
        __props__.__dict__["target_resource_group_id"] = target_resource_group_id
        __props__.__dict__["target_vm_name"] = target_vm_name
        __props__.__dict__["target_vm_size"] = target_vm_size
        __props__.__dict__["target_zone"] = target_zone
        __props__.__dict__["test_network_id"] = test_network_id
        return VmwareReplicatedVm(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="applianceName")
    def appliance_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of VMWare appliance which handles the replication. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "appliance_name")

    @_builtins.property
    @pulumi.getter(name="defaultLogStorageAccountId")
    def default_log_storage_account_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the stroage account that should be used for logging during replication. 

        > **Note:** Only standard types of storage accounts are allowed.

        > **Note:** Only one of `default_log_storage_account_id` or `managed_disk` must be specified.

        > **Note:** Changing `default_log_storage_account_id` forces a new resource to be created. But removing it does not.

        > **Note:** When `default_log_storage_account_id` co-exist with `managed_disk`, the value of `default_log_storage_account_id` must be as same as `log_storage_account_id` of every `managed_disk` or it forces a new resource to be created.
        """
        return pulumi.get(self, "default_log_storage_account_id")

    @_builtins.property
    @pulumi.getter(name="defaultRecoveryDiskType")
    def default_recovery_disk_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The type of storage account that should be used for recovery disks when a failover is done. Possible values are `Premium_LRS`, `Standard_LRS` and `StandardSSD_LRS`.

        > **Note:** Only one of `default_recovery_disk_type` or `managed_disk` must be specified.

        > **Note:** Changing `default_recovery_disk_type` forces a new resource to be created. But removing it does not.

        > **Note:** When `default_recovery_disk_type` co-exist with `managed_disk`, the value of `default_recovery_disk_type` must be as same as `target_disk_type` of every `managed_disk` or it forces a new resource to be created.
        """
        return pulumi.get(self, "default_recovery_disk_type")

    @_builtins.property
    @pulumi.getter(name="defaultTargetDiskEncryptionSetId")
    def default_target_disk_encryption_set_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the default Disk Encryption Set that should be used for the disks when a failover is done.

        > **Note:** Changing `default_target_disk_encryption_set_id` forces a new resource to be created. But removing it does not.

        > **Note:** When `default_target_disk_encryption_set_id` co-exist with `managed_disk`, the value of `default_target_disk_encryption_set_id` must be as same as `target_disk_encryption_set_id` of every `managed_disk` or it forces a new resource to be created.
        """
        return pulumi.get(self, "default_target_disk_encryption_set_id")

    @_builtins.property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The license type of the VM. Possible values are `NoLicenseType`, `NotSpecified` and `WindowsServer`. Defaults to `NotSpecified`.
        """
        return pulumi.get(self, "license_type")

    @_builtins.property
    @pulumi.getter(name="managedDisks")
    def managed_disks(self) -> pulumi.Output[Optional[Sequence['outputs.VmwareReplicatedVmManagedDisk']]]:
        """
        One or more `managed_disk` block as defined below. It's available only if mobility service is already installed on the source VM.

        > **Note:** A replicated VM could be created without `managed_disk` block, once the block has been specified, changing it expect removing it forces a new resource to be created.
        """
        return pulumi.get(self, "managed_disks")

    @_builtins.property
    @pulumi.getter(name="multiVmGroupName")
    def multi_vm_group_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Name of group in which all machines will replicate together and have shared crash consistent and app-consistent recovery points when failed over.
        """
        return pulumi.get(self, "multi_vm_group_name")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the replicated VM. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> pulumi.Output[Optional[Sequence['outputs.VmwareReplicatedVmNetworkInterface']]]:
        """
        One or more `network_interface` block as defined below.
        """
        return pulumi.get(self, "network_interfaces")

    @_builtins.property
    @pulumi.getter(name="physicalServerCredentialName")
    def physical_server_credential_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the credential to access the source VM. Changing this forces a new resource to be created. More information about the credentials could be found [here](https://learn.microsoft.com/en-us/azure/site-recovery/deploy-vmware-azure-replication-appliance-modernized).
        """
        return pulumi.get(self, "physical_server_credential_name")

    @_builtins.property
    @pulumi.getter(name="recoveryReplicationPolicyId")
    def recovery_replication_policy_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the policy to use for this replicated VM.
        """
        return pulumi.get(self, "recovery_replication_policy_id")

    @_builtins.property
    @pulumi.getter(name="recoveryVaultId")
    def recovery_vault_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Recovery Services Vault where the replicated VM is created.
        """
        return pulumi.get(self, "recovery_vault_id")

    @_builtins.property
    @pulumi.getter(name="sourceVmName")
    def source_vm_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the source VM in VMWare. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "source_vm_name")

    @_builtins.property
    @pulumi.getter(name="targetAvailabilitySetId")
    def target_availability_set_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of availability set that the new VM should belong to when a failover is done.
        """
        return pulumi.get(self, "target_availability_set_id")

    @_builtins.property
    @pulumi.getter(name="targetBootDiagnosticsStorageAccountId")
    def target_boot_diagnostics_storage_account_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the storage account that should be used for boot diagnostics when a failover is done.
        """
        return pulumi.get(self, "target_boot_diagnostics_storage_account_id")

    @_builtins.property
    @pulumi.getter(name="targetNetworkId")
    def target_network_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of network to use when a failover is done.

        > **Note:** `target_network_id` is required when `network_interface` is specified.
        """
        return pulumi.get(self, "target_network_id")

    @_builtins.property
    @pulumi.getter(name="targetProximityPlacementGroupId")
    def target_proximity_placement_group_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of Proximity Placement Group the new VM should belong to when a failover is done.

        > **Note:** Only one of `target_availability_set_id` or `target_zone` can be specified.
        """
        return pulumi.get(self, "target_proximity_placement_group_id")

    @_builtins.property
    @pulumi.getter(name="targetResourceGroupId")
    def target_resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of resource group where the VM should be created when a failover is done.
        """
        return pulumi.get(self, "target_resource_group_id")

    @_builtins.property
    @pulumi.getter(name="targetVmName")
    def target_vm_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the VM that should be created when a failover is done. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "target_vm_name")

    @_builtins.property
    @pulumi.getter(name="targetVmSize")
    def target_vm_size(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Size of the VM that should be created when a failover is done, such as `Standard_F2`. If it's not specified, it will automatically be set by detecting the source VM size.
        """
        return pulumi.get(self, "target_vm_size")

    @_builtins.property
    @pulumi.getter(name="targetZone")
    def target_zone(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the Availability Zone where the Failover VM should exist.
        """
        return pulumi.get(self, "target_zone")

    @_builtins.property
    @pulumi.getter(name="testNetworkId")
    def test_network_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of network to use when a test failover is done.
        """
        return pulumi.get(self, "test_network_id")

