# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AccountNetworkRulesInitArgs', 'AccountNetworkRules']

@pulumi.input_type
class AccountNetworkRulesInitArgs:
    def __init__(__self__, *,
                 default_action: pulumi.Input[_builtins.str],
                 storage_account_id: pulumi.Input[_builtins.str],
                 bypasses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ip_rules: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 private_link_access_rules: Optional[pulumi.Input[Sequence[pulumi.Input['AccountNetworkRulesPrivateLinkAccessRuleArgs']]]] = None,
                 virtual_network_subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a AccountNetworkRules resource.
        :param pulumi.Input[_builtins.str] default_action: Specifies the default action of allow or deny when no other rules match. Valid options are `Deny` or `Allow`.
        :param pulumi.Input[_builtins.str] storage_account_id: Specifies the ID of the storage account. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] bypasses: Specifies whether traffic is bypassed for Logging/Metrics/AzureServices. Valid options are any combination of `Logging`, `Metrics`, `AzureServices`, or `None`. Defaults to `["AzureServices"]`.
               
               > **Note:** User has to explicitly set `bypass` to empty slice (`[]`) to remove it.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ip_rules: List of public IP or IP ranges in CIDR Format. Only IPv4 addresses are allowed. Private IP address ranges (as defined in [RFC 1918](https://tools.ietf.org/html/rfc1918#section-3)) are not allowed.
               
               > **Note:** Small address ranges using "/31" or "/32" prefix sizes are not supported. These ranges should be configured using individual IP address rules without prefix specified.
               
               > **Note:** IP network rules have no effect on requests originating from the same Azure region as the storage account. Use Virtual network rules to allow same-region requests. Services deployed in the same region as the storage account use private Azure IP addresses for communication. Thus, you cannot restrict access to specific Azure services based on their public outbound IP address range.
               
               > **Note:** User has to explicitly set `ip_rules` to empty slice (`[]`) to remove it.
        :param pulumi.Input[Sequence[pulumi.Input['AccountNetworkRulesPrivateLinkAccessRuleArgs']]] private_link_access_rules: One or more `private_link_access` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] virtual_network_subnet_ids: A list of virtual network subnet ids to secure the storage account.
               
               > **Note:** User has to explicitly set `virtual_network_subnet_ids` to empty slice (`[]`) to remove it.
        """
        pulumi.set(__self__, "default_action", default_action)
        pulumi.set(__self__, "storage_account_id", storage_account_id)
        if bypasses is not None:
            pulumi.set(__self__, "bypasses", bypasses)
        if ip_rules is not None:
            pulumi.set(__self__, "ip_rules", ip_rules)
        if private_link_access_rules is not None:
            pulumi.set(__self__, "private_link_access_rules", private_link_access_rules)
        if virtual_network_subnet_ids is not None:
            pulumi.set(__self__, "virtual_network_subnet_ids", virtual_network_subnet_ids)

    @_builtins.property
    @pulumi.getter(name="defaultAction")
    def default_action(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the default action of allow or deny when no other rules match. Valid options are `Deny` or `Allow`.
        """
        return pulumi.get(self, "default_action")

    @default_action.setter
    def default_action(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "default_action", value)

    @_builtins.property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of the storage account. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_account_id")

    @storage_account_id.setter
    def storage_account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "storage_account_id", value)

    @_builtins.property
    @pulumi.getter
    def bypasses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies whether traffic is bypassed for Logging/Metrics/AzureServices. Valid options are any combination of `Logging`, `Metrics`, `AzureServices`, or `None`. Defaults to `["AzureServices"]`.

        > **Note:** User has to explicitly set `bypass` to empty slice (`[]`) to remove it.
        """
        return pulumi.get(self, "bypasses")

    @bypasses.setter
    def bypasses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "bypasses", value)

    @_builtins.property
    @pulumi.getter(name="ipRules")
    def ip_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of public IP or IP ranges in CIDR Format. Only IPv4 addresses are allowed. Private IP address ranges (as defined in [RFC 1918](https://tools.ietf.org/html/rfc1918#section-3)) are not allowed.

        > **Note:** Small address ranges using "/31" or "/32" prefix sizes are not supported. These ranges should be configured using individual IP address rules without prefix specified.

        > **Note:** IP network rules have no effect on requests originating from the same Azure region as the storage account. Use Virtual network rules to allow same-region requests. Services deployed in the same region as the storage account use private Azure IP addresses for communication. Thus, you cannot restrict access to specific Azure services based on their public outbound IP address range.

        > **Note:** User has to explicitly set `ip_rules` to empty slice (`[]`) to remove it.
        """
        return pulumi.get(self, "ip_rules")

    @ip_rules.setter
    def ip_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ip_rules", value)

    @_builtins.property
    @pulumi.getter(name="privateLinkAccessRules")
    def private_link_access_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AccountNetworkRulesPrivateLinkAccessRuleArgs']]]]:
        """
        One or more `private_link_access` block as defined below.
        """
        return pulumi.get(self, "private_link_access_rules")

    @private_link_access_rules.setter
    def private_link_access_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AccountNetworkRulesPrivateLinkAccessRuleArgs']]]]):
        pulumi.set(self, "private_link_access_rules", value)

    @_builtins.property
    @pulumi.getter(name="virtualNetworkSubnetIds")
    def virtual_network_subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of virtual network subnet ids to secure the storage account.

        > **Note:** User has to explicitly set `virtual_network_subnet_ids` to empty slice (`[]`) to remove it.
        """
        return pulumi.get(self, "virtual_network_subnet_ids")

    @virtual_network_subnet_ids.setter
    def virtual_network_subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "virtual_network_subnet_ids", value)


@pulumi.input_type
class _AccountNetworkRulesState:
    def __init__(__self__, *,
                 bypasses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 default_action: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_rules: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 private_link_access_rules: Optional[pulumi.Input[Sequence[pulumi.Input['AccountNetworkRulesPrivateLinkAccessRuleArgs']]]] = None,
                 storage_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_network_subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering AccountNetworkRules resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] bypasses: Specifies whether traffic is bypassed for Logging/Metrics/AzureServices. Valid options are any combination of `Logging`, `Metrics`, `AzureServices`, or `None`. Defaults to `["AzureServices"]`.
               
               > **Note:** User has to explicitly set `bypass` to empty slice (`[]`) to remove it.
        :param pulumi.Input[_builtins.str] default_action: Specifies the default action of allow or deny when no other rules match. Valid options are `Deny` or `Allow`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ip_rules: List of public IP or IP ranges in CIDR Format. Only IPv4 addresses are allowed. Private IP address ranges (as defined in [RFC 1918](https://tools.ietf.org/html/rfc1918#section-3)) are not allowed.
               
               > **Note:** Small address ranges using "/31" or "/32" prefix sizes are not supported. These ranges should be configured using individual IP address rules without prefix specified.
               
               > **Note:** IP network rules have no effect on requests originating from the same Azure region as the storage account. Use Virtual network rules to allow same-region requests. Services deployed in the same region as the storage account use private Azure IP addresses for communication. Thus, you cannot restrict access to specific Azure services based on their public outbound IP address range.
               
               > **Note:** User has to explicitly set `ip_rules` to empty slice (`[]`) to remove it.
        :param pulumi.Input[Sequence[pulumi.Input['AccountNetworkRulesPrivateLinkAccessRuleArgs']]] private_link_access_rules: One or more `private_link_access` block as defined below.
        :param pulumi.Input[_builtins.str] storage_account_id: Specifies the ID of the storage account. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] virtual_network_subnet_ids: A list of virtual network subnet ids to secure the storage account.
               
               > **Note:** User has to explicitly set `virtual_network_subnet_ids` to empty slice (`[]`) to remove it.
        """
        if bypasses is not None:
            pulumi.set(__self__, "bypasses", bypasses)
        if default_action is not None:
            pulumi.set(__self__, "default_action", default_action)
        if ip_rules is not None:
            pulumi.set(__self__, "ip_rules", ip_rules)
        if private_link_access_rules is not None:
            pulumi.set(__self__, "private_link_access_rules", private_link_access_rules)
        if storage_account_id is not None:
            pulumi.set(__self__, "storage_account_id", storage_account_id)
        if virtual_network_subnet_ids is not None:
            pulumi.set(__self__, "virtual_network_subnet_ids", virtual_network_subnet_ids)

    @_builtins.property
    @pulumi.getter
    def bypasses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies whether traffic is bypassed for Logging/Metrics/AzureServices. Valid options are any combination of `Logging`, `Metrics`, `AzureServices`, or `None`. Defaults to `["AzureServices"]`.

        > **Note:** User has to explicitly set `bypass` to empty slice (`[]`) to remove it.
        """
        return pulumi.get(self, "bypasses")

    @bypasses.setter
    def bypasses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "bypasses", value)

    @_builtins.property
    @pulumi.getter(name="defaultAction")
    def default_action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the default action of allow or deny when no other rules match. Valid options are `Deny` or `Allow`.
        """
        return pulumi.get(self, "default_action")

    @default_action.setter
    def default_action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_action", value)

    @_builtins.property
    @pulumi.getter(name="ipRules")
    def ip_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of public IP or IP ranges in CIDR Format. Only IPv4 addresses are allowed. Private IP address ranges (as defined in [RFC 1918](https://tools.ietf.org/html/rfc1918#section-3)) are not allowed.

        > **Note:** Small address ranges using "/31" or "/32" prefix sizes are not supported. These ranges should be configured using individual IP address rules without prefix specified.

        > **Note:** IP network rules have no effect on requests originating from the same Azure region as the storage account. Use Virtual network rules to allow same-region requests. Services deployed in the same region as the storage account use private Azure IP addresses for communication. Thus, you cannot restrict access to specific Azure services based on their public outbound IP address range.

        > **Note:** User has to explicitly set `ip_rules` to empty slice (`[]`) to remove it.
        """
        return pulumi.get(self, "ip_rules")

    @ip_rules.setter
    def ip_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ip_rules", value)

    @_builtins.property
    @pulumi.getter(name="privateLinkAccessRules")
    def private_link_access_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AccountNetworkRulesPrivateLinkAccessRuleArgs']]]]:
        """
        One or more `private_link_access` block as defined below.
        """
        return pulumi.get(self, "private_link_access_rules")

    @private_link_access_rules.setter
    def private_link_access_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AccountNetworkRulesPrivateLinkAccessRuleArgs']]]]):
        pulumi.set(self, "private_link_access_rules", value)

    @_builtins.property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the storage account. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_account_id")

    @storage_account_id.setter
    def storage_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_account_id", value)

    @_builtins.property
    @pulumi.getter(name="virtualNetworkSubnetIds")
    def virtual_network_subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of virtual network subnet ids to secure the storage account.

        > **Note:** User has to explicitly set `virtual_network_subnet_ids` to empty slice (`[]`) to remove it.
        """
        return pulumi.get(self, "virtual_network_subnet_ids")

    @virtual_network_subnet_ids.setter
    def virtual_network_subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "virtual_network_subnet_ids", value)


@pulumi.type_token("azure:storage/accountNetworkRules:AccountNetworkRules")
class AccountNetworkRules(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bypasses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 default_action: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_rules: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 private_link_access_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccountNetworkRulesPrivateLinkAccessRuleArgs', 'AccountNetworkRulesPrivateLinkAccessRuleArgsDict']]]]] = None,
                 storage_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_network_subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages network rules inside of a Azure Storage Account.

        > **Note:** Network Rules can be defined either directly on the `storage.Account` resource, or using the `storage.AccountNetworkRules` resource - but the two cannot be used together. Spurious changes will occur if both are used against the same Storage Account.

        > **Note:** Only one `storage.AccountNetworkRules` can be tied to an `storage.Account`. Spurious changes will occur if more than `storage.AccountNetworkRules` is tied to the same `storage.Account`.

        > **Note:** Deleting this resource updates the storage account back to the default values it had when the storage account was created.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-vnet",
            address_spaces=["10.0.0.0/16"],
            location=example.location,
            resource_group_name=example.name)
        example_subnet = azure.network.Subnet("example",
            name="example-subnet",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/24"],
            service_endpoints=["Microsoft.Storage"])
        example_account = azure.storage.Account("example",
            name="storageaccountname",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="GRS",
            tags={
                "environment": "staging",
            })
        example_account_network_rules = azure.storage.AccountNetworkRules("example",
            storage_account_id=example_account.id,
            default_action="Allow",
            ip_rules=["127.0.0.1"],
            virtual_network_subnet_ids=[example_subnet.id],
            bypasses=["Metrics"])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Storage` - 2023-05-01

        ## Import

        Storage Account Network Rules can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:storage/accountNetworkRules:AccountNetworkRules storageAcc1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myresourcegroup/providers/Microsoft.Storage/storageAccounts/myaccount
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] bypasses: Specifies whether traffic is bypassed for Logging/Metrics/AzureServices. Valid options are any combination of `Logging`, `Metrics`, `AzureServices`, or `None`. Defaults to `["AzureServices"]`.
               
               > **Note:** User has to explicitly set `bypass` to empty slice (`[]`) to remove it.
        :param pulumi.Input[_builtins.str] default_action: Specifies the default action of allow or deny when no other rules match. Valid options are `Deny` or `Allow`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ip_rules: List of public IP or IP ranges in CIDR Format. Only IPv4 addresses are allowed. Private IP address ranges (as defined in [RFC 1918](https://tools.ietf.org/html/rfc1918#section-3)) are not allowed.
               
               > **Note:** Small address ranges using "/31" or "/32" prefix sizes are not supported. These ranges should be configured using individual IP address rules without prefix specified.
               
               > **Note:** IP network rules have no effect on requests originating from the same Azure region as the storage account. Use Virtual network rules to allow same-region requests. Services deployed in the same region as the storage account use private Azure IP addresses for communication. Thus, you cannot restrict access to specific Azure services based on their public outbound IP address range.
               
               > **Note:** User has to explicitly set `ip_rules` to empty slice (`[]`) to remove it.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AccountNetworkRulesPrivateLinkAccessRuleArgs', 'AccountNetworkRulesPrivateLinkAccessRuleArgsDict']]]] private_link_access_rules: One or more `private_link_access` block as defined below.
        :param pulumi.Input[_builtins.str] storage_account_id: Specifies the ID of the storage account. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] virtual_network_subnet_ids: A list of virtual network subnet ids to secure the storage account.
               
               > **Note:** User has to explicitly set `virtual_network_subnet_ids` to empty slice (`[]`) to remove it.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AccountNetworkRulesInitArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages network rules inside of a Azure Storage Account.

        > **Note:** Network Rules can be defined either directly on the `storage.Account` resource, or using the `storage.AccountNetworkRules` resource - but the two cannot be used together. Spurious changes will occur if both are used against the same Storage Account.

        > **Note:** Only one `storage.AccountNetworkRules` can be tied to an `storage.Account`. Spurious changes will occur if more than `storage.AccountNetworkRules` is tied to the same `storage.Account`.

        > **Note:** Deleting this resource updates the storage account back to the default values it had when the storage account was created.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-vnet",
            address_spaces=["10.0.0.0/16"],
            location=example.location,
            resource_group_name=example.name)
        example_subnet = azure.network.Subnet("example",
            name="example-subnet",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/24"],
            service_endpoints=["Microsoft.Storage"])
        example_account = azure.storage.Account("example",
            name="storageaccountname",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="GRS",
            tags={
                "environment": "staging",
            })
        example_account_network_rules = azure.storage.AccountNetworkRules("example",
            storage_account_id=example_account.id,
            default_action="Allow",
            ip_rules=["127.0.0.1"],
            virtual_network_subnet_ids=[example_subnet.id],
            bypasses=["Metrics"])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Storage` - 2023-05-01

        ## Import

        Storage Account Network Rules can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:storage/accountNetworkRules:AccountNetworkRules storageAcc1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myresourcegroup/providers/Microsoft.Storage/storageAccounts/myaccount
        ```

        :param str resource_name: The name of the resource.
        :param AccountNetworkRulesInitArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AccountNetworkRulesInitArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bypasses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 default_action: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_rules: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 private_link_access_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccountNetworkRulesPrivateLinkAccessRuleArgs', 'AccountNetworkRulesPrivateLinkAccessRuleArgsDict']]]]] = None,
                 storage_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_network_subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AccountNetworkRulesInitArgs.__new__(AccountNetworkRulesInitArgs)

            __props__.__dict__["bypasses"] = bypasses
            if default_action is None and not opts.urn:
                raise TypeError("Missing required property 'default_action'")
            __props__.__dict__["default_action"] = default_action
            __props__.__dict__["ip_rules"] = ip_rules
            __props__.__dict__["private_link_access_rules"] = private_link_access_rules
            if storage_account_id is None and not opts.urn:
                raise TypeError("Missing required property 'storage_account_id'")
            __props__.__dict__["storage_account_id"] = storage_account_id
            __props__.__dict__["virtual_network_subnet_ids"] = virtual_network_subnet_ids
        super(AccountNetworkRules, __self__).__init__(
            'azure:storage/accountNetworkRules:AccountNetworkRules',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bypasses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            default_action: Optional[pulumi.Input[_builtins.str]] = None,
            ip_rules: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            private_link_access_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccountNetworkRulesPrivateLinkAccessRuleArgs', 'AccountNetworkRulesPrivateLinkAccessRuleArgsDict']]]]] = None,
            storage_account_id: Optional[pulumi.Input[_builtins.str]] = None,
            virtual_network_subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'AccountNetworkRules':
        """
        Get an existing AccountNetworkRules resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] bypasses: Specifies whether traffic is bypassed for Logging/Metrics/AzureServices. Valid options are any combination of `Logging`, `Metrics`, `AzureServices`, or `None`. Defaults to `["AzureServices"]`.
               
               > **Note:** User has to explicitly set `bypass` to empty slice (`[]`) to remove it.
        :param pulumi.Input[_builtins.str] default_action: Specifies the default action of allow or deny when no other rules match. Valid options are `Deny` or `Allow`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ip_rules: List of public IP or IP ranges in CIDR Format. Only IPv4 addresses are allowed. Private IP address ranges (as defined in [RFC 1918](https://tools.ietf.org/html/rfc1918#section-3)) are not allowed.
               
               > **Note:** Small address ranges using "/31" or "/32" prefix sizes are not supported. These ranges should be configured using individual IP address rules without prefix specified.
               
               > **Note:** IP network rules have no effect on requests originating from the same Azure region as the storage account. Use Virtual network rules to allow same-region requests. Services deployed in the same region as the storage account use private Azure IP addresses for communication. Thus, you cannot restrict access to specific Azure services based on their public outbound IP address range.
               
               > **Note:** User has to explicitly set `ip_rules` to empty slice (`[]`) to remove it.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AccountNetworkRulesPrivateLinkAccessRuleArgs', 'AccountNetworkRulesPrivateLinkAccessRuleArgsDict']]]] private_link_access_rules: One or more `private_link_access` block as defined below.
        :param pulumi.Input[_builtins.str] storage_account_id: Specifies the ID of the storage account. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] virtual_network_subnet_ids: A list of virtual network subnet ids to secure the storage account.
               
               > **Note:** User has to explicitly set `virtual_network_subnet_ids` to empty slice (`[]`) to remove it.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AccountNetworkRulesState.__new__(_AccountNetworkRulesState)

        __props__.__dict__["bypasses"] = bypasses
        __props__.__dict__["default_action"] = default_action
        __props__.__dict__["ip_rules"] = ip_rules
        __props__.__dict__["private_link_access_rules"] = private_link_access_rules
        __props__.__dict__["storage_account_id"] = storage_account_id
        __props__.__dict__["virtual_network_subnet_ids"] = virtual_network_subnet_ids
        return AccountNetworkRules(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def bypasses(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Specifies whether traffic is bypassed for Logging/Metrics/AzureServices. Valid options are any combination of `Logging`, `Metrics`, `AzureServices`, or `None`. Defaults to `["AzureServices"]`.

        > **Note:** User has to explicitly set `bypass` to empty slice (`[]`) to remove it.
        """
        return pulumi.get(self, "bypasses")

    @_builtins.property
    @pulumi.getter(name="defaultAction")
    def default_action(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the default action of allow or deny when no other rules match. Valid options are `Deny` or `Allow`.
        """
        return pulumi.get(self, "default_action")

    @_builtins.property
    @pulumi.getter(name="ipRules")
    def ip_rules(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of public IP or IP ranges in CIDR Format. Only IPv4 addresses are allowed. Private IP address ranges (as defined in [RFC 1918](https://tools.ietf.org/html/rfc1918#section-3)) are not allowed.

        > **Note:** Small address ranges using "/31" or "/32" prefix sizes are not supported. These ranges should be configured using individual IP address rules without prefix specified.

        > **Note:** IP network rules have no effect on requests originating from the same Azure region as the storage account. Use Virtual network rules to allow same-region requests. Services deployed in the same region as the storage account use private Azure IP addresses for communication. Thus, you cannot restrict access to specific Azure services based on their public outbound IP address range.

        > **Note:** User has to explicitly set `ip_rules` to empty slice (`[]`) to remove it.
        """
        return pulumi.get(self, "ip_rules")

    @_builtins.property
    @pulumi.getter(name="privateLinkAccessRules")
    def private_link_access_rules(self) -> pulumi.Output[Optional[Sequence['outputs.AccountNetworkRulesPrivateLinkAccessRule']]]:
        """
        One or more `private_link_access` block as defined below.
        """
        return pulumi.get(self, "private_link_access_rules")

    @_builtins.property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of the storage account. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_account_id")

    @_builtins.property
    @pulumi.getter(name="virtualNetworkSubnetIds")
    def virtual_network_subnet_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of virtual network subnet ids to secure the storage account.

        > **Note:** User has to explicitly set `virtual_network_subnet_ids` to empty slice (`[]`) to remove it.
        """
        return pulumi.get(self, "virtual_network_subnet_ids")

