# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['JobArgs', 'Job']

@pulumi.input_type
class JobArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[_builtins.str],
                 transformation_query: pulumi.Input[_builtins.str],
                 compatibility_level: Optional[pulumi.Input[_builtins.str]] = None,
                 content_storage_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 data_locale: Optional[pulumi.Input[_builtins.str]] = None,
                 events_late_arrival_max_delay_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 events_out_of_order_max_delay_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 events_out_of_order_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input['JobIdentityArgs']] = None,
                 job_storage_accounts: Optional[pulumi.Input[Sequence[pulumi.Input['JobJobStorageAccountArgs']]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 output_error_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 sku_name: Optional[pulumi.Input[_builtins.str]] = None,
                 stream_analytics_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 streaming_units: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Job resource.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Stream Analytics Job should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] compatibility_level: Specifies the compatibility level for this job - which controls certain runtime behaviours of the streaming job. Possible values are `1.0`, `1.1` and `1.2`.
               
               > **Note:** Support for Compatibility Level 1.2 is dependent on a new version of the Stream Analytics API, which [being tracked in this issue](https://github.com/Azure/azure-rest-api-specs/issues/5604).
        :param pulumi.Input[_builtins.str] content_storage_policy: The policy for storing stream analytics content. Possible values are `JobStorageAccount`, `SystemAccount`. Defaults to `SystemAccount`.
        :param pulumi.Input[_builtins.str] data_locale: Specifies the Data Locale of the Job, which [should be a supported .NET Culture](https://msdn.microsoft.com/en-us/library/system.globalization.culturetypes(v=vs.110).aspx). Defaults to `en-US`.
        :param pulumi.Input[_builtins.int] events_late_arrival_max_delay_in_seconds: Specifies the maximum tolerable delay in seconds where events arriving late could be included. Supported range is `-1` (indefinite) to `1814399` (20d 23h 59m 59s). Default is `5`.
        :param pulumi.Input[_builtins.int] events_out_of_order_max_delay_in_seconds: Specifies the maximum tolerable delay in seconds where out-of-order events can be adjusted to be back in order. Supported range is `0` to `599` (9m 59s). Default is `0`.
        :param pulumi.Input[_builtins.str] events_out_of_order_policy: Specifies the policy which should be applied to events which arrive out of order in the input event stream. Possible values are `Adjust` and `Drop`. Default is `Adjust`.
        :param pulumi.Input['JobIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['JobJobStorageAccountArgs']]] job_storage_accounts: The details of the job storage account. A `job_storage_account` block as defined below.
               
               > **Note:** `content_storage_policy` must be set to `JobStorageAccount` when specifying `job_storage_account`.
        :param pulumi.Input[_builtins.str] location: The Azure Region in which the Resource Group exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the Stream Analytics Job. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] output_error_policy: Specifies the policy which should be applied to events which arrive at the output and cannot be written to the external storage due to being malformed (such as missing column values, column values of wrong type or size). Possible values are `Drop` and `Stop`. Default is `Drop`.
        :param pulumi.Input[_builtins.str] sku_name: The SKU Name to use for the Stream Analytics Job. Possible values are `Standard`, `StandardV2`. Defaults to `Standard`.
        :param pulumi.Input[_builtins.str] stream_analytics_cluster_id: The ID of an existing Stream Analytics Cluster where the Stream Analytics Job should run.
        :param pulumi.Input[_builtins.int] streaming_units: Specifies the number of streaming units that the streaming job uses. Supported values are `1`, `3`, `6` and multiples of `6` up to `120`. A conversion table for V2 streaming units can be found [here](https://learn.microsoft.com/azure/stream-analytics/stream-analytics-streaming-unit-consumption#understand-streaming-unit-conversions-and-where-they-apply)
               
               > **Note:** `streaming_units` must be set when `type` is `Cloud`.
        :param pulumi.Input[_builtins.str] type: The type of the Stream Analytics Job. Possible values are `Cloud` and `Edge`. Defaults to `Cloud`. Changing this forces a new resource to be created.
               
               > **Note:** `Edge` doesn't support `stream_analytics_cluster_id` and `streaming_units`.
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "transformation_query", transformation_query)
        if compatibility_level is not None:
            pulumi.set(__self__, "compatibility_level", compatibility_level)
        if content_storage_policy is not None:
            pulumi.set(__self__, "content_storage_policy", content_storage_policy)
        if data_locale is not None:
            pulumi.set(__self__, "data_locale", data_locale)
        if events_late_arrival_max_delay_in_seconds is not None:
            pulumi.set(__self__, "events_late_arrival_max_delay_in_seconds", events_late_arrival_max_delay_in_seconds)
        if events_out_of_order_max_delay_in_seconds is not None:
            pulumi.set(__self__, "events_out_of_order_max_delay_in_seconds", events_out_of_order_max_delay_in_seconds)
        if events_out_of_order_policy is not None:
            pulumi.set(__self__, "events_out_of_order_policy", events_out_of_order_policy)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if job_storage_accounts is not None:
            pulumi.set(__self__, "job_storage_accounts", job_storage_accounts)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if output_error_policy is not None:
            pulumi.set(__self__, "output_error_policy", output_error_policy)
        if sku_name is not None:
            pulumi.set(__self__, "sku_name", sku_name)
        if stream_analytics_cluster_id is not None:
            pulumi.set(__self__, "stream_analytics_cluster_id", stream_analytics_cluster_id)
        if streaming_units is not None:
            pulumi.set(__self__, "streaming_units", streaming_units)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Resource Group where the Stream Analytics Job should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="transformationQuery")
    def transformation_query(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "transformation_query")

    @transformation_query.setter
    def transformation_query(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "transformation_query", value)

    @_builtins.property
    @pulumi.getter(name="compatibilityLevel")
    def compatibility_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the compatibility level for this job - which controls certain runtime behaviours of the streaming job. Possible values are `1.0`, `1.1` and `1.2`.

        > **Note:** Support for Compatibility Level 1.2 is dependent on a new version of the Stream Analytics API, which [being tracked in this issue](https://github.com/Azure/azure-rest-api-specs/issues/5604).
        """
        return pulumi.get(self, "compatibility_level")

    @compatibility_level.setter
    def compatibility_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compatibility_level", value)

    @_builtins.property
    @pulumi.getter(name="contentStoragePolicy")
    def content_storage_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The policy for storing stream analytics content. Possible values are `JobStorageAccount`, `SystemAccount`. Defaults to `SystemAccount`.
        """
        return pulumi.get(self, "content_storage_policy")

    @content_storage_policy.setter
    def content_storage_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content_storage_policy", value)

    @_builtins.property
    @pulumi.getter(name="dataLocale")
    def data_locale(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Data Locale of the Job, which [should be a supported .NET Culture](https://msdn.microsoft.com/en-us/library/system.globalization.culturetypes(v=vs.110).aspx). Defaults to `en-US`.
        """
        return pulumi.get(self, "data_locale")

    @data_locale.setter
    def data_locale(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_locale", value)

    @_builtins.property
    @pulumi.getter(name="eventsLateArrivalMaxDelayInSeconds")
    def events_late_arrival_max_delay_in_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the maximum tolerable delay in seconds where events arriving late could be included. Supported range is `-1` (indefinite) to `1814399` (20d 23h 59m 59s). Default is `5`.
        """
        return pulumi.get(self, "events_late_arrival_max_delay_in_seconds")

    @events_late_arrival_max_delay_in_seconds.setter
    def events_late_arrival_max_delay_in_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "events_late_arrival_max_delay_in_seconds", value)

    @_builtins.property
    @pulumi.getter(name="eventsOutOfOrderMaxDelayInSeconds")
    def events_out_of_order_max_delay_in_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the maximum tolerable delay in seconds where out-of-order events can be adjusted to be back in order. Supported range is `0` to `599` (9m 59s). Default is `0`.
        """
        return pulumi.get(self, "events_out_of_order_max_delay_in_seconds")

    @events_out_of_order_max_delay_in_seconds.setter
    def events_out_of_order_max_delay_in_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "events_out_of_order_max_delay_in_seconds", value)

    @_builtins.property
    @pulumi.getter(name="eventsOutOfOrderPolicy")
    def events_out_of_order_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the policy which should be applied to events which arrive out of order in the input event stream. Possible values are `Adjust` and `Drop`. Default is `Adjust`.
        """
        return pulumi.get(self, "events_out_of_order_policy")

    @events_out_of_order_policy.setter
    def events_out_of_order_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "events_out_of_order_policy", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['JobIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['JobIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter(name="jobStorageAccounts")
    def job_storage_accounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobJobStorageAccountArgs']]]]:
        """
        The details of the job storage account. A `job_storage_account` block as defined below.

        > **Note:** `content_storage_policy` must be set to `JobStorageAccount` when specifying `job_storage_account`.
        """
        return pulumi.get(self, "job_storage_accounts")

    @job_storage_accounts.setter
    def job_storage_accounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobJobStorageAccountArgs']]]]):
        pulumi.set(self, "job_storage_accounts", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region in which the Resource Group exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Stream Analytics Job. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="outputErrorPolicy")
    def output_error_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the policy which should be applied to events which arrive at the output and cannot be written to the external storage due to being malformed (such as missing column values, column values of wrong type or size). Possible values are `Drop` and `Stop`. Default is `Drop`.
        """
        return pulumi.get(self, "output_error_policy")

    @output_error_policy.setter
    def output_error_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "output_error_policy", value)

    @_builtins.property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The SKU Name to use for the Stream Analytics Job. Possible values are `Standard`, `StandardV2`. Defaults to `Standard`.
        """
        return pulumi.get(self, "sku_name")

    @sku_name.setter
    def sku_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sku_name", value)

    @_builtins.property
    @pulumi.getter(name="streamAnalyticsClusterId")
    def stream_analytics_cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of an existing Stream Analytics Cluster where the Stream Analytics Job should run.
        """
        return pulumi.get(self, "stream_analytics_cluster_id")

    @stream_analytics_cluster_id.setter
    def stream_analytics_cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "stream_analytics_cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="streamingUnits")
    def streaming_units(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the number of streaming units that the streaming job uses. Supported values are `1`, `3`, `6` and multiples of `6` up to `120`. A conversion table for V2 streaming units can be found [here](https://learn.microsoft.com/azure/stream-analytics/stream-analytics-streaming-unit-consumption#understand-streaming-unit-conversions-and-where-they-apply)

        > **Note:** `streaming_units` must be set when `type` is `Cloud`.
        """
        return pulumi.get(self, "streaming_units")

    @streaming_units.setter
    def streaming_units(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "streaming_units", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the Stream Analytics Job. Possible values are `Cloud` and `Edge`. Defaults to `Cloud`. Changing this forces a new resource to be created.

        > **Note:** `Edge` doesn't support `stream_analytics_cluster_id` and `streaming_units`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _JobState:
    def __init__(__self__, *,
                 compatibility_level: Optional[pulumi.Input[_builtins.str]] = None,
                 content_storage_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 data_locale: Optional[pulumi.Input[_builtins.str]] = None,
                 events_late_arrival_max_delay_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 events_out_of_order_max_delay_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 events_out_of_order_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input['JobIdentityArgs']] = None,
                 job_id: Optional[pulumi.Input[_builtins.str]] = None,
                 job_storage_accounts: Optional[pulumi.Input[Sequence[pulumi.Input['JobJobStorageAccountArgs']]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 output_error_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku_name: Optional[pulumi.Input[_builtins.str]] = None,
                 stream_analytics_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 streaming_units: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 transformation_query: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Job resources.
        :param pulumi.Input[_builtins.str] compatibility_level: Specifies the compatibility level for this job - which controls certain runtime behaviours of the streaming job. Possible values are `1.0`, `1.1` and `1.2`.
               
               > **Note:** Support for Compatibility Level 1.2 is dependent on a new version of the Stream Analytics API, which [being tracked in this issue](https://github.com/Azure/azure-rest-api-specs/issues/5604).
        :param pulumi.Input[_builtins.str] content_storage_policy: The policy for storing stream analytics content. Possible values are `JobStorageAccount`, `SystemAccount`. Defaults to `SystemAccount`.
        :param pulumi.Input[_builtins.str] data_locale: Specifies the Data Locale of the Job, which [should be a supported .NET Culture](https://msdn.microsoft.com/en-us/library/system.globalization.culturetypes(v=vs.110).aspx). Defaults to `en-US`.
        :param pulumi.Input[_builtins.int] events_late_arrival_max_delay_in_seconds: Specifies the maximum tolerable delay in seconds where events arriving late could be included. Supported range is `-1` (indefinite) to `1814399` (20d 23h 59m 59s). Default is `5`.
        :param pulumi.Input[_builtins.int] events_out_of_order_max_delay_in_seconds: Specifies the maximum tolerable delay in seconds where out-of-order events can be adjusted to be back in order. Supported range is `0` to `599` (9m 59s). Default is `0`.
        :param pulumi.Input[_builtins.str] events_out_of_order_policy: Specifies the policy which should be applied to events which arrive out of order in the input event stream. Possible values are `Adjust` and `Drop`. Default is `Adjust`.
        :param pulumi.Input['JobIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] job_id: The Job ID assigned by the Stream Analytics Job.
        :param pulumi.Input[Sequence[pulumi.Input['JobJobStorageAccountArgs']]] job_storage_accounts: The details of the job storage account. A `job_storage_account` block as defined below.
               
               > **Note:** `content_storage_policy` must be set to `JobStorageAccount` when specifying `job_storage_account`.
        :param pulumi.Input[_builtins.str] location: The Azure Region in which the Resource Group exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the Stream Analytics Job. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] output_error_policy: Specifies the policy which should be applied to events which arrive at the output and cannot be written to the external storage due to being malformed (such as missing column values, column values of wrong type or size). Possible values are `Drop` and `Stop`. Default is `Drop`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Stream Analytics Job should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sku_name: The SKU Name to use for the Stream Analytics Job. Possible values are `Standard`, `StandardV2`. Defaults to `Standard`.
        :param pulumi.Input[_builtins.str] stream_analytics_cluster_id: The ID of an existing Stream Analytics Cluster where the Stream Analytics Job should run.
        :param pulumi.Input[_builtins.int] streaming_units: Specifies the number of streaming units that the streaming job uses. Supported values are `1`, `3`, `6` and multiples of `6` up to `120`. A conversion table for V2 streaming units can be found [here](https://learn.microsoft.com/azure/stream-analytics/stream-analytics-streaming-unit-consumption#understand-streaming-unit-conversions-and-where-they-apply)
               
               > **Note:** `streaming_units` must be set when `type` is `Cloud`.
        :param pulumi.Input[_builtins.str] type: The type of the Stream Analytics Job. Possible values are `Cloud` and `Edge`. Defaults to `Cloud`. Changing this forces a new resource to be created.
               
               > **Note:** `Edge` doesn't support `stream_analytics_cluster_id` and `streaming_units`.
        """
        if compatibility_level is not None:
            pulumi.set(__self__, "compatibility_level", compatibility_level)
        if content_storage_policy is not None:
            pulumi.set(__self__, "content_storage_policy", content_storage_policy)
        if data_locale is not None:
            pulumi.set(__self__, "data_locale", data_locale)
        if events_late_arrival_max_delay_in_seconds is not None:
            pulumi.set(__self__, "events_late_arrival_max_delay_in_seconds", events_late_arrival_max_delay_in_seconds)
        if events_out_of_order_max_delay_in_seconds is not None:
            pulumi.set(__self__, "events_out_of_order_max_delay_in_seconds", events_out_of_order_max_delay_in_seconds)
        if events_out_of_order_policy is not None:
            pulumi.set(__self__, "events_out_of_order_policy", events_out_of_order_policy)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if job_id is not None:
            pulumi.set(__self__, "job_id", job_id)
        if job_storage_accounts is not None:
            pulumi.set(__self__, "job_storage_accounts", job_storage_accounts)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if output_error_policy is not None:
            pulumi.set(__self__, "output_error_policy", output_error_policy)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if sku_name is not None:
            pulumi.set(__self__, "sku_name", sku_name)
        if stream_analytics_cluster_id is not None:
            pulumi.set(__self__, "stream_analytics_cluster_id", stream_analytics_cluster_id)
        if streaming_units is not None:
            pulumi.set(__self__, "streaming_units", streaming_units)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if transformation_query is not None:
            pulumi.set(__self__, "transformation_query", transformation_query)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="compatibilityLevel")
    def compatibility_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the compatibility level for this job - which controls certain runtime behaviours of the streaming job. Possible values are `1.0`, `1.1` and `1.2`.

        > **Note:** Support for Compatibility Level 1.2 is dependent on a new version of the Stream Analytics API, which [being tracked in this issue](https://github.com/Azure/azure-rest-api-specs/issues/5604).
        """
        return pulumi.get(self, "compatibility_level")

    @compatibility_level.setter
    def compatibility_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compatibility_level", value)

    @_builtins.property
    @pulumi.getter(name="contentStoragePolicy")
    def content_storage_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The policy for storing stream analytics content. Possible values are `JobStorageAccount`, `SystemAccount`. Defaults to `SystemAccount`.
        """
        return pulumi.get(self, "content_storage_policy")

    @content_storage_policy.setter
    def content_storage_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content_storage_policy", value)

    @_builtins.property
    @pulumi.getter(name="dataLocale")
    def data_locale(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Data Locale of the Job, which [should be a supported .NET Culture](https://msdn.microsoft.com/en-us/library/system.globalization.culturetypes(v=vs.110).aspx). Defaults to `en-US`.
        """
        return pulumi.get(self, "data_locale")

    @data_locale.setter
    def data_locale(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_locale", value)

    @_builtins.property
    @pulumi.getter(name="eventsLateArrivalMaxDelayInSeconds")
    def events_late_arrival_max_delay_in_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the maximum tolerable delay in seconds where events arriving late could be included. Supported range is `-1` (indefinite) to `1814399` (20d 23h 59m 59s). Default is `5`.
        """
        return pulumi.get(self, "events_late_arrival_max_delay_in_seconds")

    @events_late_arrival_max_delay_in_seconds.setter
    def events_late_arrival_max_delay_in_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "events_late_arrival_max_delay_in_seconds", value)

    @_builtins.property
    @pulumi.getter(name="eventsOutOfOrderMaxDelayInSeconds")
    def events_out_of_order_max_delay_in_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the maximum tolerable delay in seconds where out-of-order events can be adjusted to be back in order. Supported range is `0` to `599` (9m 59s). Default is `0`.
        """
        return pulumi.get(self, "events_out_of_order_max_delay_in_seconds")

    @events_out_of_order_max_delay_in_seconds.setter
    def events_out_of_order_max_delay_in_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "events_out_of_order_max_delay_in_seconds", value)

    @_builtins.property
    @pulumi.getter(name="eventsOutOfOrderPolicy")
    def events_out_of_order_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the policy which should be applied to events which arrive out of order in the input event stream. Possible values are `Adjust` and `Drop`. Default is `Adjust`.
        """
        return pulumi.get(self, "events_out_of_order_policy")

    @events_out_of_order_policy.setter
    def events_out_of_order_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "events_out_of_order_policy", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['JobIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['JobIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter(name="jobId")
    def job_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Job ID assigned by the Stream Analytics Job.
        """
        return pulumi.get(self, "job_id")

    @job_id.setter
    def job_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "job_id", value)

    @_builtins.property
    @pulumi.getter(name="jobStorageAccounts")
    def job_storage_accounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobJobStorageAccountArgs']]]]:
        """
        The details of the job storage account. A `job_storage_account` block as defined below.

        > **Note:** `content_storage_policy` must be set to `JobStorageAccount` when specifying `job_storage_account`.
        """
        return pulumi.get(self, "job_storage_accounts")

    @job_storage_accounts.setter
    def job_storage_accounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobJobStorageAccountArgs']]]]):
        pulumi.set(self, "job_storage_accounts", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region in which the Resource Group exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Stream Analytics Job. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="outputErrorPolicy")
    def output_error_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the policy which should be applied to events which arrive at the output and cannot be written to the external storage due to being malformed (such as missing column values, column values of wrong type or size). Possible values are `Drop` and `Stop`. Default is `Drop`.
        """
        return pulumi.get(self, "output_error_policy")

    @output_error_policy.setter
    def output_error_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "output_error_policy", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Resource Group where the Stream Analytics Job should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The SKU Name to use for the Stream Analytics Job. Possible values are `Standard`, `StandardV2`. Defaults to `Standard`.
        """
        return pulumi.get(self, "sku_name")

    @sku_name.setter
    def sku_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sku_name", value)

    @_builtins.property
    @pulumi.getter(name="streamAnalyticsClusterId")
    def stream_analytics_cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of an existing Stream Analytics Cluster where the Stream Analytics Job should run.
        """
        return pulumi.get(self, "stream_analytics_cluster_id")

    @stream_analytics_cluster_id.setter
    def stream_analytics_cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "stream_analytics_cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="streamingUnits")
    def streaming_units(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the number of streaming units that the streaming job uses. Supported values are `1`, `3`, `6` and multiples of `6` up to `120`. A conversion table for V2 streaming units can be found [here](https://learn.microsoft.com/azure/stream-analytics/stream-analytics-streaming-unit-consumption#understand-streaming-unit-conversions-and-where-they-apply)

        > **Note:** `streaming_units` must be set when `type` is `Cloud`.
        """
        return pulumi.get(self, "streaming_units")

    @streaming_units.setter
    def streaming_units(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "streaming_units", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="transformationQuery")
    def transformation_query(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "transformation_query")

    @transformation_query.setter
    def transformation_query(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transformation_query", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the Stream Analytics Job. Possible values are `Cloud` and `Edge`. Defaults to `Cloud`. Changing this forces a new resource to be created.

        > **Note:** `Edge` doesn't support `stream_analytics_cluster_id` and `streaming_units`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("azure:streamanalytics/job:Job")
class Job(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compatibility_level: Optional[pulumi.Input[_builtins.str]] = None,
                 content_storage_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 data_locale: Optional[pulumi.Input[_builtins.str]] = None,
                 events_late_arrival_max_delay_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 events_out_of_order_max_delay_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 events_out_of_order_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input[Union['JobIdentityArgs', 'JobIdentityArgsDict']]] = None,
                 job_storage_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['JobJobStorageAccountArgs', 'JobJobStorageAccountArgsDict']]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 output_error_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku_name: Optional[pulumi.Input[_builtins.str]] = None,
                 stream_analytics_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 streaming_units: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 transformation_query: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Stream Analytics Job.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_job = azure.streamanalytics.Job("example",
            name="example-job",
            resource_group_name=example.name,
            location=example.location,
            compatibility_level="1.2",
            data_locale="en-GB",
            events_late_arrival_max_delay_in_seconds=60,
            events_out_of_order_max_delay_in_seconds=50,
            events_out_of_order_policy="Adjust",
            output_error_policy="Drop",
            streaming_units=3,
            sku_name="StandardV2",
            tags={
                "environment": "Example",
            },
            transformation_query=\"\"\"    SELECT *
            INTO [YourOutputAlias]
            FROM [YourInputAlias]
        \"\"\")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.StreamAnalytics` - 2021-10-01-preview, 2020-03-01

        ## Import

        Stream Analytics Job's can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:streamanalytics/job:Job example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.StreamAnalytics/streamingJobs/job1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compatibility_level: Specifies the compatibility level for this job - which controls certain runtime behaviours of the streaming job. Possible values are `1.0`, `1.1` and `1.2`.
               
               > **Note:** Support for Compatibility Level 1.2 is dependent on a new version of the Stream Analytics API, which [being tracked in this issue](https://github.com/Azure/azure-rest-api-specs/issues/5604).
        :param pulumi.Input[_builtins.str] content_storage_policy: The policy for storing stream analytics content. Possible values are `JobStorageAccount`, `SystemAccount`. Defaults to `SystemAccount`.
        :param pulumi.Input[_builtins.str] data_locale: Specifies the Data Locale of the Job, which [should be a supported .NET Culture](https://msdn.microsoft.com/en-us/library/system.globalization.culturetypes(v=vs.110).aspx). Defaults to `en-US`.
        :param pulumi.Input[_builtins.int] events_late_arrival_max_delay_in_seconds: Specifies the maximum tolerable delay in seconds where events arriving late could be included. Supported range is `-1` (indefinite) to `1814399` (20d 23h 59m 59s). Default is `5`.
        :param pulumi.Input[_builtins.int] events_out_of_order_max_delay_in_seconds: Specifies the maximum tolerable delay in seconds where out-of-order events can be adjusted to be back in order. Supported range is `0` to `599` (9m 59s). Default is `0`.
        :param pulumi.Input[_builtins.str] events_out_of_order_policy: Specifies the policy which should be applied to events which arrive out of order in the input event stream. Possible values are `Adjust` and `Drop`. Default is `Adjust`.
        :param pulumi.Input[Union['JobIdentityArgs', 'JobIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['JobJobStorageAccountArgs', 'JobJobStorageAccountArgsDict']]]] job_storage_accounts: The details of the job storage account. A `job_storage_account` block as defined below.
               
               > **Note:** `content_storage_policy` must be set to `JobStorageAccount` when specifying `job_storage_account`.
        :param pulumi.Input[_builtins.str] location: The Azure Region in which the Resource Group exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the Stream Analytics Job. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] output_error_policy: Specifies the policy which should be applied to events which arrive at the output and cannot be written to the external storage due to being malformed (such as missing column values, column values of wrong type or size). Possible values are `Drop` and `Stop`. Default is `Drop`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Stream Analytics Job should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sku_name: The SKU Name to use for the Stream Analytics Job. Possible values are `Standard`, `StandardV2`. Defaults to `Standard`.
        :param pulumi.Input[_builtins.str] stream_analytics_cluster_id: The ID of an existing Stream Analytics Cluster where the Stream Analytics Job should run.
        :param pulumi.Input[_builtins.int] streaming_units: Specifies the number of streaming units that the streaming job uses. Supported values are `1`, `3`, `6` and multiples of `6` up to `120`. A conversion table for V2 streaming units can be found [here](https://learn.microsoft.com/azure/stream-analytics/stream-analytics-streaming-unit-consumption#understand-streaming-unit-conversions-and-where-they-apply)
               
               > **Note:** `streaming_units` must be set when `type` is `Cloud`.
        :param pulumi.Input[_builtins.str] type: The type of the Stream Analytics Job. Possible values are `Cloud` and `Edge`. Defaults to `Cloud`. Changing this forces a new resource to be created.
               
               > **Note:** `Edge` doesn't support `stream_analytics_cluster_id` and `streaming_units`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: JobArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Stream Analytics Job.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_job = azure.streamanalytics.Job("example",
            name="example-job",
            resource_group_name=example.name,
            location=example.location,
            compatibility_level="1.2",
            data_locale="en-GB",
            events_late_arrival_max_delay_in_seconds=60,
            events_out_of_order_max_delay_in_seconds=50,
            events_out_of_order_policy="Adjust",
            output_error_policy="Drop",
            streaming_units=3,
            sku_name="StandardV2",
            tags={
                "environment": "Example",
            },
            transformation_query=\"\"\"    SELECT *
            INTO [YourOutputAlias]
            FROM [YourInputAlias]
        \"\"\")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.StreamAnalytics` - 2021-10-01-preview, 2020-03-01

        ## Import

        Stream Analytics Job's can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:streamanalytics/job:Job example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.StreamAnalytics/streamingJobs/job1
        ```

        :param str resource_name: The name of the resource.
        :param JobArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(JobArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compatibility_level: Optional[pulumi.Input[_builtins.str]] = None,
                 content_storage_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 data_locale: Optional[pulumi.Input[_builtins.str]] = None,
                 events_late_arrival_max_delay_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 events_out_of_order_max_delay_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 events_out_of_order_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input[Union['JobIdentityArgs', 'JobIdentityArgsDict']]] = None,
                 job_storage_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['JobJobStorageAccountArgs', 'JobJobStorageAccountArgsDict']]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 output_error_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku_name: Optional[pulumi.Input[_builtins.str]] = None,
                 stream_analytics_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 streaming_units: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 transformation_query: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = JobArgs.__new__(JobArgs)

            __props__.__dict__["compatibility_level"] = compatibility_level
            __props__.__dict__["content_storage_policy"] = content_storage_policy
            __props__.__dict__["data_locale"] = data_locale
            __props__.__dict__["events_late_arrival_max_delay_in_seconds"] = events_late_arrival_max_delay_in_seconds
            __props__.__dict__["events_out_of_order_max_delay_in_seconds"] = events_out_of_order_max_delay_in_seconds
            __props__.__dict__["events_out_of_order_policy"] = events_out_of_order_policy
            __props__.__dict__["identity"] = identity
            __props__.__dict__["job_storage_accounts"] = job_storage_accounts
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["output_error_policy"] = output_error_policy
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["sku_name"] = sku_name
            __props__.__dict__["stream_analytics_cluster_id"] = stream_analytics_cluster_id
            __props__.__dict__["streaming_units"] = streaming_units
            __props__.__dict__["tags"] = tags
            if transformation_query is None and not opts.urn:
                raise TypeError("Missing required property 'transformation_query'")
            __props__.__dict__["transformation_query"] = transformation_query
            __props__.__dict__["type"] = type
            __props__.__dict__["job_id"] = None
        super(Job, __self__).__init__(
            'azure:streamanalytics/job:Job',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compatibility_level: Optional[pulumi.Input[_builtins.str]] = None,
            content_storage_policy: Optional[pulumi.Input[_builtins.str]] = None,
            data_locale: Optional[pulumi.Input[_builtins.str]] = None,
            events_late_arrival_max_delay_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
            events_out_of_order_max_delay_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
            events_out_of_order_policy: Optional[pulumi.Input[_builtins.str]] = None,
            identity: Optional[pulumi.Input[Union['JobIdentityArgs', 'JobIdentityArgsDict']]] = None,
            job_id: Optional[pulumi.Input[_builtins.str]] = None,
            job_storage_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['JobJobStorageAccountArgs', 'JobJobStorageAccountArgsDict']]]]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            output_error_policy: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            sku_name: Optional[pulumi.Input[_builtins.str]] = None,
            stream_analytics_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            streaming_units: Optional[pulumi.Input[_builtins.int]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            transformation_query: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'Job':
        """
        Get an existing Job resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compatibility_level: Specifies the compatibility level for this job - which controls certain runtime behaviours of the streaming job. Possible values are `1.0`, `1.1` and `1.2`.
               
               > **Note:** Support for Compatibility Level 1.2 is dependent on a new version of the Stream Analytics API, which [being tracked in this issue](https://github.com/Azure/azure-rest-api-specs/issues/5604).
        :param pulumi.Input[_builtins.str] content_storage_policy: The policy for storing stream analytics content. Possible values are `JobStorageAccount`, `SystemAccount`. Defaults to `SystemAccount`.
        :param pulumi.Input[_builtins.str] data_locale: Specifies the Data Locale of the Job, which [should be a supported .NET Culture](https://msdn.microsoft.com/en-us/library/system.globalization.culturetypes(v=vs.110).aspx). Defaults to `en-US`.
        :param pulumi.Input[_builtins.int] events_late_arrival_max_delay_in_seconds: Specifies the maximum tolerable delay in seconds where events arriving late could be included. Supported range is `-1` (indefinite) to `1814399` (20d 23h 59m 59s). Default is `5`.
        :param pulumi.Input[_builtins.int] events_out_of_order_max_delay_in_seconds: Specifies the maximum tolerable delay in seconds where out-of-order events can be adjusted to be back in order. Supported range is `0` to `599` (9m 59s). Default is `0`.
        :param pulumi.Input[_builtins.str] events_out_of_order_policy: Specifies the policy which should be applied to events which arrive out of order in the input event stream. Possible values are `Adjust` and `Drop`. Default is `Adjust`.
        :param pulumi.Input[Union['JobIdentityArgs', 'JobIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] job_id: The Job ID assigned by the Stream Analytics Job.
        :param pulumi.Input[Sequence[pulumi.Input[Union['JobJobStorageAccountArgs', 'JobJobStorageAccountArgsDict']]]] job_storage_accounts: The details of the job storage account. A `job_storage_account` block as defined below.
               
               > **Note:** `content_storage_policy` must be set to `JobStorageAccount` when specifying `job_storage_account`.
        :param pulumi.Input[_builtins.str] location: The Azure Region in which the Resource Group exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the Stream Analytics Job. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] output_error_policy: Specifies the policy which should be applied to events which arrive at the output and cannot be written to the external storage due to being malformed (such as missing column values, column values of wrong type or size). Possible values are `Drop` and `Stop`. Default is `Drop`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Stream Analytics Job should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sku_name: The SKU Name to use for the Stream Analytics Job. Possible values are `Standard`, `StandardV2`. Defaults to `Standard`.
        :param pulumi.Input[_builtins.str] stream_analytics_cluster_id: The ID of an existing Stream Analytics Cluster where the Stream Analytics Job should run.
        :param pulumi.Input[_builtins.int] streaming_units: Specifies the number of streaming units that the streaming job uses. Supported values are `1`, `3`, `6` and multiples of `6` up to `120`. A conversion table for V2 streaming units can be found [here](https://learn.microsoft.com/azure/stream-analytics/stream-analytics-streaming-unit-consumption#understand-streaming-unit-conversions-and-where-they-apply)
               
               > **Note:** `streaming_units` must be set when `type` is `Cloud`.
        :param pulumi.Input[_builtins.str] type: The type of the Stream Analytics Job. Possible values are `Cloud` and `Edge`. Defaults to `Cloud`. Changing this forces a new resource to be created.
               
               > **Note:** `Edge` doesn't support `stream_analytics_cluster_id` and `streaming_units`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _JobState.__new__(_JobState)

        __props__.__dict__["compatibility_level"] = compatibility_level
        __props__.__dict__["content_storage_policy"] = content_storage_policy
        __props__.__dict__["data_locale"] = data_locale
        __props__.__dict__["events_late_arrival_max_delay_in_seconds"] = events_late_arrival_max_delay_in_seconds
        __props__.__dict__["events_out_of_order_max_delay_in_seconds"] = events_out_of_order_max_delay_in_seconds
        __props__.__dict__["events_out_of_order_policy"] = events_out_of_order_policy
        __props__.__dict__["identity"] = identity
        __props__.__dict__["job_id"] = job_id
        __props__.__dict__["job_storage_accounts"] = job_storage_accounts
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["output_error_policy"] = output_error_policy
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["sku_name"] = sku_name
        __props__.__dict__["stream_analytics_cluster_id"] = stream_analytics_cluster_id
        __props__.__dict__["streaming_units"] = streaming_units
        __props__.__dict__["tags"] = tags
        __props__.__dict__["transformation_query"] = transformation_query
        __props__.__dict__["type"] = type
        return Job(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="compatibilityLevel")
    def compatibility_level(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the compatibility level for this job - which controls certain runtime behaviours of the streaming job. Possible values are `1.0`, `1.1` and `1.2`.

        > **Note:** Support for Compatibility Level 1.2 is dependent on a new version of the Stream Analytics API, which [being tracked in this issue](https://github.com/Azure/azure-rest-api-specs/issues/5604).
        """
        return pulumi.get(self, "compatibility_level")

    @_builtins.property
    @pulumi.getter(name="contentStoragePolicy")
    def content_storage_policy(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The policy for storing stream analytics content. Possible values are `JobStorageAccount`, `SystemAccount`. Defaults to `SystemAccount`.
        """
        return pulumi.get(self, "content_storage_policy")

    @_builtins.property
    @pulumi.getter(name="dataLocale")
    def data_locale(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the Data Locale of the Job, which [should be a supported .NET Culture](https://msdn.microsoft.com/en-us/library/system.globalization.culturetypes(v=vs.110).aspx). Defaults to `en-US`.
        """
        return pulumi.get(self, "data_locale")

    @_builtins.property
    @pulumi.getter(name="eventsLateArrivalMaxDelayInSeconds")
    def events_late_arrival_max_delay_in_seconds(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies the maximum tolerable delay in seconds where events arriving late could be included. Supported range is `-1` (indefinite) to `1814399` (20d 23h 59m 59s). Default is `5`.
        """
        return pulumi.get(self, "events_late_arrival_max_delay_in_seconds")

    @_builtins.property
    @pulumi.getter(name="eventsOutOfOrderMaxDelayInSeconds")
    def events_out_of_order_max_delay_in_seconds(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies the maximum tolerable delay in seconds where out-of-order events can be adjusted to be back in order. Supported range is `0` to `599` (9m 59s). Default is `0`.
        """
        return pulumi.get(self, "events_out_of_order_max_delay_in_seconds")

    @_builtins.property
    @pulumi.getter(name="eventsOutOfOrderPolicy")
    def events_out_of_order_policy(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the policy which should be applied to events which arrive out of order in the input event stream. Possible values are `Adjust` and `Drop`. Default is `Adjust`.
        """
        return pulumi.get(self, "events_out_of_order_policy")

    @_builtins.property
    @pulumi.getter
    def identity(self) -> pulumi.Output[Optional['outputs.JobIdentity']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @_builtins.property
    @pulumi.getter(name="jobId")
    def job_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Job ID assigned by the Stream Analytics Job.
        """
        return pulumi.get(self, "job_id")

    @_builtins.property
    @pulumi.getter(name="jobStorageAccounts")
    def job_storage_accounts(self) -> pulumi.Output[Optional[Sequence['outputs.JobJobStorageAccount']]]:
        """
        The details of the job storage account. A `job_storage_account` block as defined below.

        > **Note:** `content_storage_policy` must be set to `JobStorageAccount` when specifying `job_storage_account`.
        """
        return pulumi.get(self, "job_storage_accounts")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The Azure Region in which the Resource Group exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Stream Analytics Job. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="outputErrorPolicy")
    def output_error_policy(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the policy which should be applied to events which arrive at the output and cannot be written to the external storage due to being malformed (such as missing column values, column values of wrong type or size). Possible values are `Drop` and `Stop`. Default is `Drop`.
        """
        return pulumi.get(self, "output_error_policy")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Resource Group where the Stream Analytics Job should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The SKU Name to use for the Stream Analytics Job. Possible values are `Standard`, `StandardV2`. Defaults to `Standard`.
        """
        return pulumi.get(self, "sku_name")

    @_builtins.property
    @pulumi.getter(name="streamAnalyticsClusterId")
    def stream_analytics_cluster_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of an existing Stream Analytics Cluster where the Stream Analytics Job should run.
        """
        return pulumi.get(self, "stream_analytics_cluster_id")

    @_builtins.property
    @pulumi.getter(name="streamingUnits")
    def streaming_units(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies the number of streaming units that the streaming job uses. Supported values are `1`, `3`, `6` and multiples of `6` up to `120`. A conversion table for V2 streaming units can be found [here](https://learn.microsoft.com/azure/stream-analytics/stream-analytics-streaming-unit-consumption#understand-streaming-unit-conversions-and-where-they-apply)

        > **Note:** `streaming_units` must be set when `type` is `Cloud`.
        """
        return pulumi.get(self, "streaming_units")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="transformationQuery")
    def transformation_query(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "transformation_query")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The type of the Stream Analytics Job. Possible values are `Cloud` and `Edge`. Defaults to `Cloud`. Changing this forces a new resource to be created.

        > **Note:** `Edge` doesn't support `stream_analytics_cluster_id` and `streaming_units`.
        """
        return pulumi.get(self, "type")

