# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['WorkspaceVulnerabilityAssessmentArgs', 'WorkspaceVulnerabilityAssessment']

@pulumi.input_type
class WorkspaceVulnerabilityAssessmentArgs:
    def __init__(__self__, *,
                 storage_container_path: pulumi.Input[_builtins.str],
                 workspace_security_alert_policy_id: pulumi.Input[_builtins.str],
                 recurring_scans: Optional[pulumi.Input['WorkspaceVulnerabilityAssessmentRecurringScansArgs']] = None,
                 storage_account_access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_container_sas_key: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a WorkspaceVulnerabilityAssessment resource.
        :param pulumi.Input[_builtins.str] storage_container_path: A blob storage container path to hold the scan results (e.g. <https://example.blob.core.windows.net/VaScans/>).
        :param pulumi.Input[_builtins.str] workspace_security_alert_policy_id: The ID of the security alert policy of the Synapse Workspace. Changing this forces a new resource to be created.
        :param pulumi.Input['WorkspaceVulnerabilityAssessmentRecurringScansArgs'] recurring_scans: The recurring scans settings. The `recurring_scans` block supports fields documented below.
        :param pulumi.Input[_builtins.str] storage_account_access_key: Specifies the identifier key of the storage account for vulnerability assessment scan results. If `storage_container_sas_key` isn't specified, `storage_account_access_key` is required.
        :param pulumi.Input[_builtins.str] storage_container_sas_key: A shared access signature (SAS Key) that has write access to the blob container specified in `storage_container_path` parameter. If `storage_account_access_key` isn't specified, `storage_container_sas_key` is required.
        """
        pulumi.set(__self__, "storage_container_path", storage_container_path)
        pulumi.set(__self__, "workspace_security_alert_policy_id", workspace_security_alert_policy_id)
        if recurring_scans is not None:
            pulumi.set(__self__, "recurring_scans", recurring_scans)
        if storage_account_access_key is not None:
            pulumi.set(__self__, "storage_account_access_key", storage_account_access_key)
        if storage_container_sas_key is not None:
            pulumi.set(__self__, "storage_container_sas_key", storage_container_sas_key)

    @_builtins.property
    @pulumi.getter(name="storageContainerPath")
    def storage_container_path(self) -> pulumi.Input[_builtins.str]:
        """
        A blob storage container path to hold the scan results (e.g. <https://example.blob.core.windows.net/VaScans/>).
        """
        return pulumi.get(self, "storage_container_path")

    @storage_container_path.setter
    def storage_container_path(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "storage_container_path", value)

    @_builtins.property
    @pulumi.getter(name="workspaceSecurityAlertPolicyId")
    def workspace_security_alert_policy_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the security alert policy of the Synapse Workspace. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "workspace_security_alert_policy_id")

    @workspace_security_alert_policy_id.setter
    def workspace_security_alert_policy_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "workspace_security_alert_policy_id", value)

    @_builtins.property
    @pulumi.getter(name="recurringScans")
    def recurring_scans(self) -> Optional[pulumi.Input['WorkspaceVulnerabilityAssessmentRecurringScansArgs']]:
        """
        The recurring scans settings. The `recurring_scans` block supports fields documented below.
        """
        return pulumi.get(self, "recurring_scans")

    @recurring_scans.setter
    def recurring_scans(self, value: Optional[pulumi.Input['WorkspaceVulnerabilityAssessmentRecurringScansArgs']]):
        pulumi.set(self, "recurring_scans", value)

    @_builtins.property
    @pulumi.getter(name="storageAccountAccessKey")
    def storage_account_access_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the identifier key of the storage account for vulnerability assessment scan results. If `storage_container_sas_key` isn't specified, `storage_account_access_key` is required.
        """
        return pulumi.get(self, "storage_account_access_key")

    @storage_account_access_key.setter
    def storage_account_access_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_account_access_key", value)

    @_builtins.property
    @pulumi.getter(name="storageContainerSasKey")
    def storage_container_sas_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A shared access signature (SAS Key) that has write access to the blob container specified in `storage_container_path` parameter. If `storage_account_access_key` isn't specified, `storage_container_sas_key` is required.
        """
        return pulumi.get(self, "storage_container_sas_key")

    @storage_container_sas_key.setter
    def storage_container_sas_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_container_sas_key", value)


@pulumi.input_type
class _WorkspaceVulnerabilityAssessmentState:
    def __init__(__self__, *,
                 recurring_scans: Optional[pulumi.Input['WorkspaceVulnerabilityAssessmentRecurringScansArgs']] = None,
                 storage_account_access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_container_path: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_container_sas_key: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_security_alert_policy_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering WorkspaceVulnerabilityAssessment resources.
        :param pulumi.Input['WorkspaceVulnerabilityAssessmentRecurringScansArgs'] recurring_scans: The recurring scans settings. The `recurring_scans` block supports fields documented below.
        :param pulumi.Input[_builtins.str] storage_account_access_key: Specifies the identifier key of the storage account for vulnerability assessment scan results. If `storage_container_sas_key` isn't specified, `storage_account_access_key` is required.
        :param pulumi.Input[_builtins.str] storage_container_path: A blob storage container path to hold the scan results (e.g. <https://example.blob.core.windows.net/VaScans/>).
        :param pulumi.Input[_builtins.str] storage_container_sas_key: A shared access signature (SAS Key) that has write access to the blob container specified in `storage_container_path` parameter. If `storage_account_access_key` isn't specified, `storage_container_sas_key` is required.
        :param pulumi.Input[_builtins.str] workspace_security_alert_policy_id: The ID of the security alert policy of the Synapse Workspace. Changing this forces a new resource to be created.
        """
        if recurring_scans is not None:
            pulumi.set(__self__, "recurring_scans", recurring_scans)
        if storage_account_access_key is not None:
            pulumi.set(__self__, "storage_account_access_key", storage_account_access_key)
        if storage_container_path is not None:
            pulumi.set(__self__, "storage_container_path", storage_container_path)
        if storage_container_sas_key is not None:
            pulumi.set(__self__, "storage_container_sas_key", storage_container_sas_key)
        if workspace_security_alert_policy_id is not None:
            pulumi.set(__self__, "workspace_security_alert_policy_id", workspace_security_alert_policy_id)

    @_builtins.property
    @pulumi.getter(name="recurringScans")
    def recurring_scans(self) -> Optional[pulumi.Input['WorkspaceVulnerabilityAssessmentRecurringScansArgs']]:
        """
        The recurring scans settings. The `recurring_scans` block supports fields documented below.
        """
        return pulumi.get(self, "recurring_scans")

    @recurring_scans.setter
    def recurring_scans(self, value: Optional[pulumi.Input['WorkspaceVulnerabilityAssessmentRecurringScansArgs']]):
        pulumi.set(self, "recurring_scans", value)

    @_builtins.property
    @pulumi.getter(name="storageAccountAccessKey")
    def storage_account_access_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the identifier key of the storage account for vulnerability assessment scan results. If `storage_container_sas_key` isn't specified, `storage_account_access_key` is required.
        """
        return pulumi.get(self, "storage_account_access_key")

    @storage_account_access_key.setter
    def storage_account_access_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_account_access_key", value)

    @_builtins.property
    @pulumi.getter(name="storageContainerPath")
    def storage_container_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A blob storage container path to hold the scan results (e.g. <https://example.blob.core.windows.net/VaScans/>).
        """
        return pulumi.get(self, "storage_container_path")

    @storage_container_path.setter
    def storage_container_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_container_path", value)

    @_builtins.property
    @pulumi.getter(name="storageContainerSasKey")
    def storage_container_sas_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A shared access signature (SAS Key) that has write access to the blob container specified in `storage_container_path` parameter. If `storage_account_access_key` isn't specified, `storage_container_sas_key` is required.
        """
        return pulumi.get(self, "storage_container_sas_key")

    @storage_container_sas_key.setter
    def storage_container_sas_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_container_sas_key", value)

    @_builtins.property
    @pulumi.getter(name="workspaceSecurityAlertPolicyId")
    def workspace_security_alert_policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the security alert policy of the Synapse Workspace. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "workspace_security_alert_policy_id")

    @workspace_security_alert_policy_id.setter
    def workspace_security_alert_policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workspace_security_alert_policy_id", value)


@pulumi.type_token("azure:synapse/workspaceVulnerabilityAssessment:WorkspaceVulnerabilityAssessment")
class WorkspaceVulnerabilityAssessment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 recurring_scans: Optional[pulumi.Input[Union['WorkspaceVulnerabilityAssessmentRecurringScansArgs', 'WorkspaceVulnerabilityAssessmentRecurringScansArgsDict']]] = None,
                 storage_account_access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_container_path: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_container_sas_key: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_security_alert_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages the Vulnerability Assessment for a Synapse Workspace.

        ## Import

        Synapse Workspace Vulnerability Assessment can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:synapse/workspaceVulnerabilityAssessment:WorkspaceVulnerabilityAssessment example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Synapse/workspaces/workspace1/vulnerabilityAssessments/default
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['WorkspaceVulnerabilityAssessmentRecurringScansArgs', 'WorkspaceVulnerabilityAssessmentRecurringScansArgsDict']] recurring_scans: The recurring scans settings. The `recurring_scans` block supports fields documented below.
        :param pulumi.Input[_builtins.str] storage_account_access_key: Specifies the identifier key of the storage account for vulnerability assessment scan results. If `storage_container_sas_key` isn't specified, `storage_account_access_key` is required.
        :param pulumi.Input[_builtins.str] storage_container_path: A blob storage container path to hold the scan results (e.g. <https://example.blob.core.windows.net/VaScans/>).
        :param pulumi.Input[_builtins.str] storage_container_sas_key: A shared access signature (SAS Key) that has write access to the blob container specified in `storage_container_path` parameter. If `storage_account_access_key` isn't specified, `storage_container_sas_key` is required.
        :param pulumi.Input[_builtins.str] workspace_security_alert_policy_id: The ID of the security alert policy of the Synapse Workspace. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WorkspaceVulnerabilityAssessmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages the Vulnerability Assessment for a Synapse Workspace.

        ## Import

        Synapse Workspace Vulnerability Assessment can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:synapse/workspaceVulnerabilityAssessment:WorkspaceVulnerabilityAssessment example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Synapse/workspaces/workspace1/vulnerabilityAssessments/default
        ```

        :param str resource_name: The name of the resource.
        :param WorkspaceVulnerabilityAssessmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkspaceVulnerabilityAssessmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 recurring_scans: Optional[pulumi.Input[Union['WorkspaceVulnerabilityAssessmentRecurringScansArgs', 'WorkspaceVulnerabilityAssessmentRecurringScansArgsDict']]] = None,
                 storage_account_access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_container_path: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_container_sas_key: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_security_alert_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkspaceVulnerabilityAssessmentArgs.__new__(WorkspaceVulnerabilityAssessmentArgs)

            __props__.__dict__["recurring_scans"] = recurring_scans
            __props__.__dict__["storage_account_access_key"] = None if storage_account_access_key is None else pulumi.Output.secret(storage_account_access_key)
            if storage_container_path is None and not opts.urn:
                raise TypeError("Missing required property 'storage_container_path'")
            __props__.__dict__["storage_container_path"] = storage_container_path
            __props__.__dict__["storage_container_sas_key"] = None if storage_container_sas_key is None else pulumi.Output.secret(storage_container_sas_key)
            if workspace_security_alert_policy_id is None and not opts.urn:
                raise TypeError("Missing required property 'workspace_security_alert_policy_id'")
            __props__.__dict__["workspace_security_alert_policy_id"] = workspace_security_alert_policy_id
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["storageAccountAccessKey", "storageContainerSasKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(WorkspaceVulnerabilityAssessment, __self__).__init__(
            'azure:synapse/workspaceVulnerabilityAssessment:WorkspaceVulnerabilityAssessment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            recurring_scans: Optional[pulumi.Input[Union['WorkspaceVulnerabilityAssessmentRecurringScansArgs', 'WorkspaceVulnerabilityAssessmentRecurringScansArgsDict']]] = None,
            storage_account_access_key: Optional[pulumi.Input[_builtins.str]] = None,
            storage_container_path: Optional[pulumi.Input[_builtins.str]] = None,
            storage_container_sas_key: Optional[pulumi.Input[_builtins.str]] = None,
            workspace_security_alert_policy_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'WorkspaceVulnerabilityAssessment':
        """
        Get an existing WorkspaceVulnerabilityAssessment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['WorkspaceVulnerabilityAssessmentRecurringScansArgs', 'WorkspaceVulnerabilityAssessmentRecurringScansArgsDict']] recurring_scans: The recurring scans settings. The `recurring_scans` block supports fields documented below.
        :param pulumi.Input[_builtins.str] storage_account_access_key: Specifies the identifier key of the storage account for vulnerability assessment scan results. If `storage_container_sas_key` isn't specified, `storage_account_access_key` is required.
        :param pulumi.Input[_builtins.str] storage_container_path: A blob storage container path to hold the scan results (e.g. <https://example.blob.core.windows.net/VaScans/>).
        :param pulumi.Input[_builtins.str] storage_container_sas_key: A shared access signature (SAS Key) that has write access to the blob container specified in `storage_container_path` parameter. If `storage_account_access_key` isn't specified, `storage_container_sas_key` is required.
        :param pulumi.Input[_builtins.str] workspace_security_alert_policy_id: The ID of the security alert policy of the Synapse Workspace. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WorkspaceVulnerabilityAssessmentState.__new__(_WorkspaceVulnerabilityAssessmentState)

        __props__.__dict__["recurring_scans"] = recurring_scans
        __props__.__dict__["storage_account_access_key"] = storage_account_access_key
        __props__.__dict__["storage_container_path"] = storage_container_path
        __props__.__dict__["storage_container_sas_key"] = storage_container_sas_key
        __props__.__dict__["workspace_security_alert_policy_id"] = workspace_security_alert_policy_id
        return WorkspaceVulnerabilityAssessment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="recurringScans")
    def recurring_scans(self) -> pulumi.Output['outputs.WorkspaceVulnerabilityAssessmentRecurringScans']:
        """
        The recurring scans settings. The `recurring_scans` block supports fields documented below.
        """
        return pulumi.get(self, "recurring_scans")

    @_builtins.property
    @pulumi.getter(name="storageAccountAccessKey")
    def storage_account_access_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the identifier key of the storage account for vulnerability assessment scan results. If `storage_container_sas_key` isn't specified, `storage_account_access_key` is required.
        """
        return pulumi.get(self, "storage_account_access_key")

    @_builtins.property
    @pulumi.getter(name="storageContainerPath")
    def storage_container_path(self) -> pulumi.Output[_builtins.str]:
        """
        A blob storage container path to hold the scan results (e.g. <https://example.blob.core.windows.net/VaScans/>).
        """
        return pulumi.get(self, "storage_container_path")

    @_builtins.property
    @pulumi.getter(name="storageContainerSasKey")
    def storage_container_sas_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A shared access signature (SAS Key) that has write access to the blob container specified in `storage_container_path` parameter. If `storage_account_access_key` isn't specified, `storage_container_sas_key` is required.
        """
        return pulumi.get(self, "storage_container_sas_key")

    @_builtins.property
    @pulumi.getter(name="workspaceSecurityAlertPolicyId")
    def workspace_security_alert_policy_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the security alert policy of the Synapse Workspace. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "workspace_security_alert_policy_id")

