# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'PolicyCustomRuleArgs',
    'PolicyCustomRuleArgsDict',
    'PolicyCustomRuleMatchConditionArgs',
    'PolicyCustomRuleMatchConditionArgsDict',
    'PolicyCustomRuleMatchConditionMatchVariableArgs',
    'PolicyCustomRuleMatchConditionMatchVariableArgsDict',
    'PolicyManagedRulesArgs',
    'PolicyManagedRulesArgsDict',
    'PolicyManagedRulesExclusionArgs',
    'PolicyManagedRulesExclusionArgsDict',
    'PolicyManagedRulesExclusionExcludedRuleSetArgs',
    'PolicyManagedRulesExclusionExcludedRuleSetArgsDict',
    'PolicyManagedRulesExclusionExcludedRuleSetRuleGroupArgs',
    'PolicyManagedRulesExclusionExcludedRuleSetRuleGroupArgsDict',
    'PolicyManagedRulesManagedRuleSetArgs',
    'PolicyManagedRulesManagedRuleSetArgsDict',
    'PolicyManagedRulesManagedRuleSetRuleGroupOverrideArgs',
    'PolicyManagedRulesManagedRuleSetRuleGroupOverrideArgsDict',
    'PolicyManagedRulesManagedRuleSetRuleGroupOverrideRuleArgs',
    'PolicyManagedRulesManagedRuleSetRuleGroupOverrideRuleArgsDict',
    'PolicyPolicySettingsArgs',
    'PolicyPolicySettingsArgsDict',
    'PolicyPolicySettingsLogScrubbingArgs',
    'PolicyPolicySettingsLogScrubbingArgsDict',
    'PolicyPolicySettingsLogScrubbingRuleArgs',
    'PolicyPolicySettingsLogScrubbingRuleArgsDict',
]

MYPY = False

if not MYPY:
    class PolicyCustomRuleArgsDict(TypedDict):
        action: pulumi.Input[_builtins.str]
        """
        Type of action. Possible values are `Allow`, `Block`, `JSChallenge` and `Log`.

        > **Note:** If the `rule_type` is specified as `RateLimitRule`, the `Allow` is not supported.
        """
        match_conditions: pulumi.Input[Sequence[pulumi.Input['PolicyCustomRuleMatchConditionArgsDict']]]
        """
        One or more `match_conditions` blocks as defined below.
        """
        priority: pulumi.Input[_builtins.int]
        """
        Describes priority of the rule. Rules with a lower value will be evaluated before rules with a higher value.
        """
        rule_type: pulumi.Input[_builtins.str]
        """
        Describes the type of rule. Possible values are `MatchRule`, `RateLimitRule` and `Invalid`.
        """
        enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Describes if the policy is in enabled state or disabled state. Defaults to `true`.
        """
        group_rate_limit_by: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies what grouping the rate limit will count requests by. Possible values are `GeoLocation`, `ClientAddr` and `None`.
        """
        name: NotRequired[pulumi.Input[_builtins.str]]
        """
        Gets name of the resource that is unique within a policy. This name can be used to access the resource.
        """
        rate_limit_duration: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the duration at which the rate limit policy will be applied. Should be used with `RateLimitRule` rule type. Possible values are `FiveMins` and `OneMin`.
        """
        rate_limit_threshold: NotRequired[pulumi.Input[_builtins.int]]
        """
        Specifies the threshold value for the rate limit policy. Must be greater than or equal to 1 if provided.
        """
elif False:
    PolicyCustomRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PolicyCustomRuleArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[_builtins.str],
                 match_conditions: pulumi.Input[Sequence[pulumi.Input['PolicyCustomRuleMatchConditionArgs']]],
                 priority: pulumi.Input[_builtins.int],
                 rule_type: pulumi.Input[_builtins.str],
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 group_rate_limit_by: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 rate_limit_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 rate_limit_threshold: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.str] action: Type of action. Possible values are `Allow`, `Block`, `JSChallenge` and `Log`.
               
               > **Note:** If the `rule_type` is specified as `RateLimitRule`, the `Allow` is not supported.
        :param pulumi.Input[Sequence[pulumi.Input['PolicyCustomRuleMatchConditionArgs']]] match_conditions: One or more `match_conditions` blocks as defined below.
        :param pulumi.Input[_builtins.int] priority: Describes priority of the rule. Rules with a lower value will be evaluated before rules with a higher value.
        :param pulumi.Input[_builtins.str] rule_type: Describes the type of rule. Possible values are `MatchRule`, `RateLimitRule` and `Invalid`.
        :param pulumi.Input[_builtins.bool] enabled: Describes if the policy is in enabled state or disabled state. Defaults to `true`.
        :param pulumi.Input[_builtins.str] group_rate_limit_by: Specifies what grouping the rate limit will count requests by. Possible values are `GeoLocation`, `ClientAddr` and `None`.
        :param pulumi.Input[_builtins.str] name: Gets name of the resource that is unique within a policy. This name can be used to access the resource.
        :param pulumi.Input[_builtins.str] rate_limit_duration: Specifies the duration at which the rate limit policy will be applied. Should be used with `RateLimitRule` rule type. Possible values are `FiveMins` and `OneMin`.
        :param pulumi.Input[_builtins.int] rate_limit_threshold: Specifies the threshold value for the rate limit policy. Must be greater than or equal to 1 if provided.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "match_conditions", match_conditions)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "rule_type", rule_type)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if group_rate_limit_by is not None:
            pulumi.set(__self__, "group_rate_limit_by", group_rate_limit_by)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if rate_limit_duration is not None:
            pulumi.set(__self__, "rate_limit_duration", rate_limit_duration)
        if rate_limit_threshold is not None:
            pulumi.set(__self__, "rate_limit_threshold", rate_limit_threshold)

    @_builtins.property
    @pulumi.getter
    def action(self) -> pulumi.Input[_builtins.str]:
        """
        Type of action. Possible values are `Allow`, `Block`, `JSChallenge` and `Log`.

        > **Note:** If the `rule_type` is specified as `RateLimitRule`, the `Allow` is not supported.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter(name="matchConditions")
    def match_conditions(self) -> pulumi.Input[Sequence[pulumi.Input['PolicyCustomRuleMatchConditionArgs']]]:
        """
        One or more `match_conditions` blocks as defined below.
        """
        return pulumi.get(self, "match_conditions")

    @match_conditions.setter
    def match_conditions(self, value: pulumi.Input[Sequence[pulumi.Input['PolicyCustomRuleMatchConditionArgs']]]):
        pulumi.set(self, "match_conditions", value)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> pulumi.Input[_builtins.int]:
        """
        Describes priority of the rule. Rules with a lower value will be evaluated before rules with a higher value.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "priority", value)

    @_builtins.property
    @pulumi.getter(name="ruleType")
    def rule_type(self) -> pulumi.Input[_builtins.str]:
        """
        Describes the type of rule. Possible values are `MatchRule`, `RateLimitRule` and `Invalid`.
        """
        return pulumi.get(self, "rule_type")

    @rule_type.setter
    def rule_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "rule_type", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Describes if the policy is in enabled state or disabled state. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="groupRateLimitBy")
    def group_rate_limit_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies what grouping the rate limit will count requests by. Possible values are `GeoLocation`, `ClientAddr` and `None`.
        """
        return pulumi.get(self, "group_rate_limit_by")

    @group_rate_limit_by.setter
    def group_rate_limit_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_rate_limit_by", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Gets name of the resource that is unique within a policy. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="rateLimitDuration")
    def rate_limit_duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the duration at which the rate limit policy will be applied. Should be used with `RateLimitRule` rule type. Possible values are `FiveMins` and `OneMin`.
        """
        return pulumi.get(self, "rate_limit_duration")

    @rate_limit_duration.setter
    def rate_limit_duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rate_limit_duration", value)

    @_builtins.property
    @pulumi.getter(name="rateLimitThreshold")
    def rate_limit_threshold(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the threshold value for the rate limit policy. Must be greater than or equal to 1 if provided.
        """
        return pulumi.get(self, "rate_limit_threshold")

    @rate_limit_threshold.setter
    def rate_limit_threshold(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "rate_limit_threshold", value)


if not MYPY:
    class PolicyCustomRuleMatchConditionArgsDict(TypedDict):
        match_variables: pulumi.Input[Sequence[pulumi.Input['PolicyCustomRuleMatchConditionMatchVariableArgsDict']]]
        """
        One or more `match_variables` blocks as defined below.
        """
        operator: pulumi.Input[_builtins.str]
        """
        Describes operator to be matched. Possible values are `Any`, `IPMatch`, `GeoMatch`, `Equal`, `Contains`, `LessThan`, `GreaterThan`, `LessThanOrEqual`, `GreaterThanOrEqual`, `BeginsWith`, `EndsWith` and `Regex`.
        """
        match_values: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        A list of match values. This is **Required** when the `operator` is not `Any`.
        """
        negation_condition: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Describes if this is negate condition or not
        """
        transforms: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        A list of transformations to do before the match is attempted. Possible values are `HtmlEntityDecode`, `Lowercase`, `RemoveNulls`, `Trim`, `Uppercase`, `UrlDecode` and `UrlEncode`.
        """
elif False:
    PolicyCustomRuleMatchConditionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PolicyCustomRuleMatchConditionArgs:
    def __init__(__self__, *,
                 match_variables: pulumi.Input[Sequence[pulumi.Input['PolicyCustomRuleMatchConditionMatchVariableArgs']]],
                 operator: pulumi.Input[_builtins.str],
                 match_values: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 negation_condition: Optional[pulumi.Input[_builtins.bool]] = None,
                 transforms: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['PolicyCustomRuleMatchConditionMatchVariableArgs']]] match_variables: One or more `match_variables` blocks as defined below.
        :param pulumi.Input[_builtins.str] operator: Describes operator to be matched. Possible values are `Any`, `IPMatch`, `GeoMatch`, `Equal`, `Contains`, `LessThan`, `GreaterThan`, `LessThanOrEqual`, `GreaterThanOrEqual`, `BeginsWith`, `EndsWith` and `Regex`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] match_values: A list of match values. This is **Required** when the `operator` is not `Any`.
        :param pulumi.Input[_builtins.bool] negation_condition: Describes if this is negate condition or not
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] transforms: A list of transformations to do before the match is attempted. Possible values are `HtmlEntityDecode`, `Lowercase`, `RemoveNulls`, `Trim`, `Uppercase`, `UrlDecode` and `UrlEncode`.
        """
        pulumi.set(__self__, "match_variables", match_variables)
        pulumi.set(__self__, "operator", operator)
        if match_values is not None:
            pulumi.set(__self__, "match_values", match_values)
        if negation_condition is not None:
            pulumi.set(__self__, "negation_condition", negation_condition)
        if transforms is not None:
            pulumi.set(__self__, "transforms", transforms)

    @_builtins.property
    @pulumi.getter(name="matchVariables")
    def match_variables(self) -> pulumi.Input[Sequence[pulumi.Input['PolicyCustomRuleMatchConditionMatchVariableArgs']]]:
        """
        One or more `match_variables` blocks as defined below.
        """
        return pulumi.get(self, "match_variables")

    @match_variables.setter
    def match_variables(self, value: pulumi.Input[Sequence[pulumi.Input['PolicyCustomRuleMatchConditionMatchVariableArgs']]]):
        pulumi.set(self, "match_variables", value)

    @_builtins.property
    @pulumi.getter
    def operator(self) -> pulumi.Input[_builtins.str]:
        """
        Describes operator to be matched. Possible values are `Any`, `IPMatch`, `GeoMatch`, `Equal`, `Contains`, `LessThan`, `GreaterThan`, `LessThanOrEqual`, `GreaterThanOrEqual`, `BeginsWith`, `EndsWith` and `Regex`.
        """
        return pulumi.get(self, "operator")

    @operator.setter
    def operator(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "operator", value)

    @_builtins.property
    @pulumi.getter(name="matchValues")
    def match_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of match values. This is **Required** when the `operator` is not `Any`.
        """
        return pulumi.get(self, "match_values")

    @match_values.setter
    def match_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "match_values", value)

    @_builtins.property
    @pulumi.getter(name="negationCondition")
    def negation_condition(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Describes if this is negate condition or not
        """
        return pulumi.get(self, "negation_condition")

    @negation_condition.setter
    def negation_condition(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "negation_condition", value)

    @_builtins.property
    @pulumi.getter
    def transforms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of transformations to do before the match is attempted. Possible values are `HtmlEntityDecode`, `Lowercase`, `RemoveNulls`, `Trim`, `Uppercase`, `UrlDecode` and `UrlEncode`.
        """
        return pulumi.get(self, "transforms")

    @transforms.setter
    def transforms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "transforms", value)


if not MYPY:
    class PolicyCustomRuleMatchConditionMatchVariableArgsDict(TypedDict):
        variable_name: pulumi.Input[_builtins.str]
        """
        The name of the Match Variable. Possible values are `RemoteAddr`, `RequestMethod`, `QueryString`, `PostArgs`, `RequestUri`, `RequestHeaders`, `RequestBody` and `RequestCookies`.
        """
        selector: NotRequired[pulumi.Input[_builtins.str]]
        """
        Describes field of the matchVariable collection
        """
elif False:
    PolicyCustomRuleMatchConditionMatchVariableArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PolicyCustomRuleMatchConditionMatchVariableArgs:
    def __init__(__self__, *,
                 variable_name: pulumi.Input[_builtins.str],
                 selector: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] variable_name: The name of the Match Variable. Possible values are `RemoteAddr`, `RequestMethod`, `QueryString`, `PostArgs`, `RequestUri`, `RequestHeaders`, `RequestBody` and `RequestCookies`.
        :param pulumi.Input[_builtins.str] selector: Describes field of the matchVariable collection
        """
        pulumi.set(__self__, "variable_name", variable_name)
        if selector is not None:
            pulumi.set(__self__, "selector", selector)

    @_builtins.property
    @pulumi.getter(name="variableName")
    def variable_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Match Variable. Possible values are `RemoteAddr`, `RequestMethod`, `QueryString`, `PostArgs`, `RequestUri`, `RequestHeaders`, `RequestBody` and `RequestCookies`.
        """
        return pulumi.get(self, "variable_name")

    @variable_name.setter
    def variable_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "variable_name", value)

    @_builtins.property
    @pulumi.getter
    def selector(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Describes field of the matchVariable collection
        """
        return pulumi.get(self, "selector")

    @selector.setter
    def selector(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "selector", value)


if not MYPY:
    class PolicyManagedRulesArgsDict(TypedDict):
        managed_rule_sets: pulumi.Input[Sequence[pulumi.Input['PolicyManagedRulesManagedRuleSetArgsDict']]]
        """
        One or more `managed_rule_set` block defined below.
        """
        exclusions: NotRequired[pulumi.Input[Sequence[pulumi.Input['PolicyManagedRulesExclusionArgsDict']]]]
        """
        One or more `exclusion` block defined below.
        """
elif False:
    PolicyManagedRulesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PolicyManagedRulesArgs:
    def __init__(__self__, *,
                 managed_rule_sets: pulumi.Input[Sequence[pulumi.Input['PolicyManagedRulesManagedRuleSetArgs']]],
                 exclusions: Optional[pulumi.Input[Sequence[pulumi.Input['PolicyManagedRulesExclusionArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['PolicyManagedRulesManagedRuleSetArgs']]] managed_rule_sets: One or more `managed_rule_set` block defined below.
        :param pulumi.Input[Sequence[pulumi.Input['PolicyManagedRulesExclusionArgs']]] exclusions: One or more `exclusion` block defined below.
        """
        pulumi.set(__self__, "managed_rule_sets", managed_rule_sets)
        if exclusions is not None:
            pulumi.set(__self__, "exclusions", exclusions)

    @_builtins.property
    @pulumi.getter(name="managedRuleSets")
    def managed_rule_sets(self) -> pulumi.Input[Sequence[pulumi.Input['PolicyManagedRulesManagedRuleSetArgs']]]:
        """
        One or more `managed_rule_set` block defined below.
        """
        return pulumi.get(self, "managed_rule_sets")

    @managed_rule_sets.setter
    def managed_rule_sets(self, value: pulumi.Input[Sequence[pulumi.Input['PolicyManagedRulesManagedRuleSetArgs']]]):
        pulumi.set(self, "managed_rule_sets", value)

    @_builtins.property
    @pulumi.getter
    def exclusions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PolicyManagedRulesExclusionArgs']]]]:
        """
        One or more `exclusion` block defined below.
        """
        return pulumi.get(self, "exclusions")

    @exclusions.setter
    def exclusions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PolicyManagedRulesExclusionArgs']]]]):
        pulumi.set(self, "exclusions", value)


if not MYPY:
    class PolicyManagedRulesExclusionArgsDict(TypedDict):
        match_variable: pulumi.Input[_builtins.str]
        """
        The name of the Match Variable. Possible values: `RequestArgKeys`, `RequestArgNames`, `RequestArgValues`, `RequestCookieKeys`, `RequestCookieNames`, `RequestCookieValues`, `RequestHeaderKeys`, `RequestHeaderNames`, `RequestHeaderValues`.
        """
        selector: pulumi.Input[_builtins.str]
        """
        Describes field of the matchVariable collection.
        """
        selector_match_operator: pulumi.Input[_builtins.str]
        """
        Describes operator to be matched. Possible values: `Contains`, `EndsWith`, `Equals`, `EqualsAny`, `StartsWith`.
        """
        excluded_rule_set: NotRequired[pulumi.Input['PolicyManagedRulesExclusionExcludedRuleSetArgsDict']]
        """
        One or more `excluded_rule_set` block defined below.
        """
elif False:
    PolicyManagedRulesExclusionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PolicyManagedRulesExclusionArgs:
    def __init__(__self__, *,
                 match_variable: pulumi.Input[_builtins.str],
                 selector: pulumi.Input[_builtins.str],
                 selector_match_operator: pulumi.Input[_builtins.str],
                 excluded_rule_set: Optional[pulumi.Input['PolicyManagedRulesExclusionExcludedRuleSetArgs']] = None):
        """
        :param pulumi.Input[_builtins.str] match_variable: The name of the Match Variable. Possible values: `RequestArgKeys`, `RequestArgNames`, `RequestArgValues`, `RequestCookieKeys`, `RequestCookieNames`, `RequestCookieValues`, `RequestHeaderKeys`, `RequestHeaderNames`, `RequestHeaderValues`.
        :param pulumi.Input[_builtins.str] selector: Describes field of the matchVariable collection.
        :param pulumi.Input[_builtins.str] selector_match_operator: Describes operator to be matched. Possible values: `Contains`, `EndsWith`, `Equals`, `EqualsAny`, `StartsWith`.
        :param pulumi.Input['PolicyManagedRulesExclusionExcludedRuleSetArgs'] excluded_rule_set: One or more `excluded_rule_set` block defined below.
        """
        pulumi.set(__self__, "match_variable", match_variable)
        pulumi.set(__self__, "selector", selector)
        pulumi.set(__self__, "selector_match_operator", selector_match_operator)
        if excluded_rule_set is not None:
            pulumi.set(__self__, "excluded_rule_set", excluded_rule_set)

    @_builtins.property
    @pulumi.getter(name="matchVariable")
    def match_variable(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Match Variable. Possible values: `RequestArgKeys`, `RequestArgNames`, `RequestArgValues`, `RequestCookieKeys`, `RequestCookieNames`, `RequestCookieValues`, `RequestHeaderKeys`, `RequestHeaderNames`, `RequestHeaderValues`.
        """
        return pulumi.get(self, "match_variable")

    @match_variable.setter
    def match_variable(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "match_variable", value)

    @_builtins.property
    @pulumi.getter
    def selector(self) -> pulumi.Input[_builtins.str]:
        """
        Describes field of the matchVariable collection.
        """
        return pulumi.get(self, "selector")

    @selector.setter
    def selector(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "selector", value)

    @_builtins.property
    @pulumi.getter(name="selectorMatchOperator")
    def selector_match_operator(self) -> pulumi.Input[_builtins.str]:
        """
        Describes operator to be matched. Possible values: `Contains`, `EndsWith`, `Equals`, `EqualsAny`, `StartsWith`.
        """
        return pulumi.get(self, "selector_match_operator")

    @selector_match_operator.setter
    def selector_match_operator(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "selector_match_operator", value)

    @_builtins.property
    @pulumi.getter(name="excludedRuleSet")
    def excluded_rule_set(self) -> Optional[pulumi.Input['PolicyManagedRulesExclusionExcludedRuleSetArgs']]:
        """
        One or more `excluded_rule_set` block defined below.
        """
        return pulumi.get(self, "excluded_rule_set")

    @excluded_rule_set.setter
    def excluded_rule_set(self, value: Optional[pulumi.Input['PolicyManagedRulesExclusionExcludedRuleSetArgs']]):
        pulumi.set(self, "excluded_rule_set", value)


if not MYPY:
    class PolicyManagedRulesExclusionExcludedRuleSetArgsDict(TypedDict):
        rule_groups: NotRequired[pulumi.Input[Sequence[pulumi.Input['PolicyManagedRulesExclusionExcludedRuleSetRuleGroupArgsDict']]]]
        """
        One or more `rule_group` block defined below.
        """
        type: NotRequired[pulumi.Input[_builtins.str]]
        """
        The rule set type. Possible values are `Microsoft_DefaultRuleSet`, `Microsoft_BotManagerRuleSet` and `OWASP`. Defaults to `OWASP`.
        """
        version: NotRequired[pulumi.Input[_builtins.str]]
        """
        The rule set version. Possible values are `1.0`, `1.1` (for rule set type `Microsoft_BotManagerRuleSet`), `2.1` (for rule set type `Microsoft_DefaultRuleSet`) and `3.2` (for rule set type `OWASP`). Defaults to `3.2`.
        """
elif False:
    PolicyManagedRulesExclusionExcludedRuleSetArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PolicyManagedRulesExclusionExcludedRuleSetArgs:
    def __init__(__self__, *,
                 rule_groups: Optional[pulumi.Input[Sequence[pulumi.Input['PolicyManagedRulesExclusionExcludedRuleSetRuleGroupArgs']]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['PolicyManagedRulesExclusionExcludedRuleSetRuleGroupArgs']]] rule_groups: One or more `rule_group` block defined below.
        :param pulumi.Input[_builtins.str] type: The rule set type. Possible values are `Microsoft_DefaultRuleSet`, `Microsoft_BotManagerRuleSet` and `OWASP`. Defaults to `OWASP`.
        :param pulumi.Input[_builtins.str] version: The rule set version. Possible values are `1.0`, `1.1` (for rule set type `Microsoft_BotManagerRuleSet`), `2.1` (for rule set type `Microsoft_DefaultRuleSet`) and `3.2` (for rule set type `OWASP`). Defaults to `3.2`.
        """
        if rule_groups is not None:
            pulumi.set(__self__, "rule_groups", rule_groups)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="ruleGroups")
    def rule_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PolicyManagedRulesExclusionExcludedRuleSetRuleGroupArgs']]]]:
        """
        One or more `rule_group` block defined below.
        """
        return pulumi.get(self, "rule_groups")

    @rule_groups.setter
    def rule_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PolicyManagedRulesExclusionExcludedRuleSetRuleGroupArgs']]]]):
        pulumi.set(self, "rule_groups", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The rule set type. Possible values are `Microsoft_DefaultRuleSet`, `Microsoft_BotManagerRuleSet` and `OWASP`. Defaults to `OWASP`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The rule set version. Possible values are `1.0`, `1.1` (for rule set type `Microsoft_BotManagerRuleSet`), `2.1` (for rule set type `Microsoft_DefaultRuleSet`) and `3.2` (for rule set type `OWASP`). Defaults to `3.2`.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)


if not MYPY:
    class PolicyManagedRulesExclusionExcludedRuleSetRuleGroupArgsDict(TypedDict):
        rule_group_name: pulumi.Input[_builtins.str]
        """
        The name of rule group for exclusion. Possible values are `BadBots`, `crs_20_protocol_violations`, `crs_21_protocol_anomalies`, `crs_23_request_limits`, `crs_30_http_policy`, `crs_35_bad_robots`, `crs_40_generic_attacks`, `crs_41_sql_injection_attacks`, `crs_41_xss_attacks`, `crs_42_tight_security`, `crs_45_trojans`, `crs_49_inbound_blocking`, `General`, `GoodBots`, `KnownBadBots`, `Known-CVEs`, `REQUEST-911-METHOD-ENFORCEMENT`, `REQUEST-913-SCANNER-DETECTION`, `REQUEST-920-PROTOCOL-ENFORCEMENT`, `REQUEST-921-PROTOCOL-ATTACK`, `REQUEST-930-APPLICATION-ATTACK-LFI`, `REQUEST-931-APPLICATION-ATTACK-RFI`, `REQUEST-932-APPLICATION-ATTACK-RCE`, `REQUEST-933-APPLICATION-ATTACK-PHP`, `REQUEST-941-APPLICATION-ATTACK-XSS`, `REQUEST-942-APPLICATION-ATTACK-SQLI`, `REQUEST-943-APPLICATION-ATTACK-SESSION-FIXATION`, `REQUEST-944-APPLICATION-ATTACK-JAVA`, `UnknownBots`, `METHOD-ENFORCEMENT`, `PROTOCOL-ENFORCEMENT`, `PROTOCOL-ATTACK`, `LFI`, `RFI`, `RCE`, `PHP`, `NODEJS`, `XSS`, `SQLI`, `FIX`, `JAVA`, `MS-ThreatIntel-WebShells`, `MS-ThreatIntel-AppSec`, `MS-ThreatIntel-SQLI` and `MS-ThreatIntel-CVEs`.
        `MS-ThreatIntel-AppSec`, `MS-ThreatIntel-SQLI` and `MS-ThreatIntel-CVEs`.
        """
        excluded_rules: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        One or more Rule IDs for exclusion.
        """
elif False:
    PolicyManagedRulesExclusionExcludedRuleSetRuleGroupArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PolicyManagedRulesExclusionExcludedRuleSetRuleGroupArgs:
    def __init__(__self__, *,
                 rule_group_name: pulumi.Input[_builtins.str],
                 excluded_rules: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        :param pulumi.Input[_builtins.str] rule_group_name: The name of rule group for exclusion. Possible values are `BadBots`, `crs_20_protocol_violations`, `crs_21_protocol_anomalies`, `crs_23_request_limits`, `crs_30_http_policy`, `crs_35_bad_robots`, `crs_40_generic_attacks`, `crs_41_sql_injection_attacks`, `crs_41_xss_attacks`, `crs_42_tight_security`, `crs_45_trojans`, `crs_49_inbound_blocking`, `General`, `GoodBots`, `KnownBadBots`, `Known-CVEs`, `REQUEST-911-METHOD-ENFORCEMENT`, `REQUEST-913-SCANNER-DETECTION`, `REQUEST-920-PROTOCOL-ENFORCEMENT`, `REQUEST-921-PROTOCOL-ATTACK`, `REQUEST-930-APPLICATION-ATTACK-LFI`, `REQUEST-931-APPLICATION-ATTACK-RFI`, `REQUEST-932-APPLICATION-ATTACK-RCE`, `REQUEST-933-APPLICATION-ATTACK-PHP`, `REQUEST-941-APPLICATION-ATTACK-XSS`, `REQUEST-942-APPLICATION-ATTACK-SQLI`, `REQUEST-943-APPLICATION-ATTACK-SESSION-FIXATION`, `REQUEST-944-APPLICATION-ATTACK-JAVA`, `UnknownBots`, `METHOD-ENFORCEMENT`, `PROTOCOL-ENFORCEMENT`, `PROTOCOL-ATTACK`, `LFI`, `RFI`, `RCE`, `PHP`, `NODEJS`, `XSS`, `SQLI`, `FIX`, `JAVA`, `MS-ThreatIntel-WebShells`, `MS-ThreatIntel-AppSec`, `MS-ThreatIntel-SQLI` and `MS-ThreatIntel-CVEs`.
               `MS-ThreatIntel-AppSec`, `MS-ThreatIntel-SQLI` and `MS-ThreatIntel-CVEs`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] excluded_rules: One or more Rule IDs for exclusion.
        """
        pulumi.set(__self__, "rule_group_name", rule_group_name)
        if excluded_rules is not None:
            pulumi.set(__self__, "excluded_rules", excluded_rules)

    @_builtins.property
    @pulumi.getter(name="ruleGroupName")
    def rule_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of rule group for exclusion. Possible values are `BadBots`, `crs_20_protocol_violations`, `crs_21_protocol_anomalies`, `crs_23_request_limits`, `crs_30_http_policy`, `crs_35_bad_robots`, `crs_40_generic_attacks`, `crs_41_sql_injection_attacks`, `crs_41_xss_attacks`, `crs_42_tight_security`, `crs_45_trojans`, `crs_49_inbound_blocking`, `General`, `GoodBots`, `KnownBadBots`, `Known-CVEs`, `REQUEST-911-METHOD-ENFORCEMENT`, `REQUEST-913-SCANNER-DETECTION`, `REQUEST-920-PROTOCOL-ENFORCEMENT`, `REQUEST-921-PROTOCOL-ATTACK`, `REQUEST-930-APPLICATION-ATTACK-LFI`, `REQUEST-931-APPLICATION-ATTACK-RFI`, `REQUEST-932-APPLICATION-ATTACK-RCE`, `REQUEST-933-APPLICATION-ATTACK-PHP`, `REQUEST-941-APPLICATION-ATTACK-XSS`, `REQUEST-942-APPLICATION-ATTACK-SQLI`, `REQUEST-943-APPLICATION-ATTACK-SESSION-FIXATION`, `REQUEST-944-APPLICATION-ATTACK-JAVA`, `UnknownBots`, `METHOD-ENFORCEMENT`, `PROTOCOL-ENFORCEMENT`, `PROTOCOL-ATTACK`, `LFI`, `RFI`, `RCE`, `PHP`, `NODEJS`, `XSS`, `SQLI`, `FIX`, `JAVA`, `MS-ThreatIntel-WebShells`, `MS-ThreatIntel-AppSec`, `MS-ThreatIntel-SQLI` and `MS-ThreatIntel-CVEs`.
        `MS-ThreatIntel-AppSec`, `MS-ThreatIntel-SQLI` and `MS-ThreatIntel-CVEs`.
        """
        return pulumi.get(self, "rule_group_name")

    @rule_group_name.setter
    def rule_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "rule_group_name", value)

    @_builtins.property
    @pulumi.getter(name="excludedRules")
    def excluded_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        One or more Rule IDs for exclusion.
        """
        return pulumi.get(self, "excluded_rules")

    @excluded_rules.setter
    def excluded_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "excluded_rules", value)


if not MYPY:
    class PolicyManagedRulesManagedRuleSetArgsDict(TypedDict):
        version: pulumi.Input[_builtins.str]
        """
        The rule set version. Possible values: `0.1`, `1.0`, `1.1`, `2.1`, `2.2.9`, `3.0`, `3.1` and `3.2`.
        """
        rule_group_overrides: NotRequired[pulumi.Input[Sequence[pulumi.Input['PolicyManagedRulesManagedRuleSetRuleGroupOverrideArgsDict']]]]
        """
        One or more `rule_group_override` block defined below.
        """
        type: NotRequired[pulumi.Input[_builtins.str]]
        """
        The rule set type. Possible values: `Microsoft_BotManagerRuleSet`, `Microsoft_DefaultRuleSet` and `OWASP`. Defaults to `OWASP`.
        """
elif False:
    PolicyManagedRulesManagedRuleSetArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PolicyManagedRulesManagedRuleSetArgs:
    def __init__(__self__, *,
                 version: pulumi.Input[_builtins.str],
                 rule_group_overrides: Optional[pulumi.Input[Sequence[pulumi.Input['PolicyManagedRulesManagedRuleSetRuleGroupOverrideArgs']]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] version: The rule set version. Possible values: `0.1`, `1.0`, `1.1`, `2.1`, `2.2.9`, `3.0`, `3.1` and `3.2`.
        :param pulumi.Input[Sequence[pulumi.Input['PolicyManagedRulesManagedRuleSetRuleGroupOverrideArgs']]] rule_group_overrides: One or more `rule_group_override` block defined below.
        :param pulumi.Input[_builtins.str] type: The rule set type. Possible values: `Microsoft_BotManagerRuleSet`, `Microsoft_DefaultRuleSet` and `OWASP`. Defaults to `OWASP`.
        """
        pulumi.set(__self__, "version", version)
        if rule_group_overrides is not None:
            pulumi.set(__self__, "rule_group_overrides", rule_group_overrides)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Input[_builtins.str]:
        """
        The rule set version. Possible values: `0.1`, `1.0`, `1.1`, `2.1`, `2.2.9`, `3.0`, `3.1` and `3.2`.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "version", value)

    @_builtins.property
    @pulumi.getter(name="ruleGroupOverrides")
    def rule_group_overrides(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PolicyManagedRulesManagedRuleSetRuleGroupOverrideArgs']]]]:
        """
        One or more `rule_group_override` block defined below.
        """
        return pulumi.get(self, "rule_group_overrides")

    @rule_group_overrides.setter
    def rule_group_overrides(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PolicyManagedRulesManagedRuleSetRuleGroupOverrideArgs']]]]):
        pulumi.set(self, "rule_group_overrides", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The rule set type. Possible values: `Microsoft_BotManagerRuleSet`, `Microsoft_DefaultRuleSet` and `OWASP`. Defaults to `OWASP`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


if not MYPY:
    class PolicyManagedRulesManagedRuleSetRuleGroupOverrideArgsDict(TypedDict):
        rule_group_name: pulumi.Input[_builtins.str]
        """
        The name of the Rule Group. Possible values are `BadBots`, `crs_20_protocol_violations`, `crs_21_protocol_anomalies`, `crs_23_request_limits`, `crs_30_http_policy`, `crs_35_bad_robots`, `crs_40_generic_attacks`, `crs_41_sql_injection_attacks`, `crs_41_xss_attacks`, `crs_42_tight_security`, `crs_45_trojans`, `crs_49_inbound_blocking`, `General`, `GoodBots`, `KnownBadBots`, `Known-CVEs`, `REQUEST-911-METHOD-ENFORCEMENT`, `REQUEST-913-SCANNER-DETECTION`, `REQUEST-920-PROTOCOL-ENFORCEMENT`, `REQUEST-921-PROTOCOL-ATTACK`, `REQUEST-930-APPLICATION-ATTACK-LFI`, `REQUEST-931-APPLICATION-ATTACK-RFI`, `REQUEST-932-APPLICATION-ATTACK-RCE`, `REQUEST-933-APPLICATION-ATTACK-PHP`, `REQUEST-941-APPLICATION-ATTACK-XSS`, `REQUEST-942-APPLICATION-ATTACK-SQLI`, `REQUEST-943-APPLICATION-ATTACK-SESSION-FIXATION`, `REQUEST-944-APPLICATION-ATTACK-JAVA`, `UnknownBots`, `METHOD-ENFORCEMENT`, `PROTOCOL-ENFORCEMENT`, `PROTOCOL-ATTACK`, `LFI`, `RFI`, `RCE`, `PHP`, `NODEJS`, `XSS`, `SQLI`, `FIX`, `JAVA`, `MS-ThreatIntel-WebShells`, `MS-ThreatIntel-AppSec`, `MS-ThreatIntel-SQLI` and `MS-ThreatIntel-CVEs`MS-ThreatIntel-WebShells`,.
        """
        rules: NotRequired[pulumi.Input[Sequence[pulumi.Input['PolicyManagedRulesManagedRuleSetRuleGroupOverrideRuleArgsDict']]]]
        """
        One or more `rule` block defined below.
        """
elif False:
    PolicyManagedRulesManagedRuleSetRuleGroupOverrideArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PolicyManagedRulesManagedRuleSetRuleGroupOverrideArgs:
    def __init__(__self__, *,
                 rule_group_name: pulumi.Input[_builtins.str],
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['PolicyManagedRulesManagedRuleSetRuleGroupOverrideRuleArgs']]]] = None):
        """
        :param pulumi.Input[_builtins.str] rule_group_name: The name of the Rule Group. Possible values are `BadBots`, `crs_20_protocol_violations`, `crs_21_protocol_anomalies`, `crs_23_request_limits`, `crs_30_http_policy`, `crs_35_bad_robots`, `crs_40_generic_attacks`, `crs_41_sql_injection_attacks`, `crs_41_xss_attacks`, `crs_42_tight_security`, `crs_45_trojans`, `crs_49_inbound_blocking`, `General`, `GoodBots`, `KnownBadBots`, `Known-CVEs`, `REQUEST-911-METHOD-ENFORCEMENT`, `REQUEST-913-SCANNER-DETECTION`, `REQUEST-920-PROTOCOL-ENFORCEMENT`, `REQUEST-921-PROTOCOL-ATTACK`, `REQUEST-930-APPLICATION-ATTACK-LFI`, `REQUEST-931-APPLICATION-ATTACK-RFI`, `REQUEST-932-APPLICATION-ATTACK-RCE`, `REQUEST-933-APPLICATION-ATTACK-PHP`, `REQUEST-941-APPLICATION-ATTACK-XSS`, `REQUEST-942-APPLICATION-ATTACK-SQLI`, `REQUEST-943-APPLICATION-ATTACK-SESSION-FIXATION`, `REQUEST-944-APPLICATION-ATTACK-JAVA`, `UnknownBots`, `METHOD-ENFORCEMENT`, `PROTOCOL-ENFORCEMENT`, `PROTOCOL-ATTACK`, `LFI`, `RFI`, `RCE`, `PHP`, `NODEJS`, `XSS`, `SQLI`, `FIX`, `JAVA`, `MS-ThreatIntel-WebShells`, `MS-ThreatIntel-AppSec`, `MS-ThreatIntel-SQLI` and `MS-ThreatIntel-CVEs`MS-ThreatIntel-WebShells`,.
        :param pulumi.Input[Sequence[pulumi.Input['PolicyManagedRulesManagedRuleSetRuleGroupOverrideRuleArgs']]] rules: One or more `rule` block defined below.
        """
        pulumi.set(__self__, "rule_group_name", rule_group_name)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @_builtins.property
    @pulumi.getter(name="ruleGroupName")
    def rule_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Rule Group. Possible values are `BadBots`, `crs_20_protocol_violations`, `crs_21_protocol_anomalies`, `crs_23_request_limits`, `crs_30_http_policy`, `crs_35_bad_robots`, `crs_40_generic_attacks`, `crs_41_sql_injection_attacks`, `crs_41_xss_attacks`, `crs_42_tight_security`, `crs_45_trojans`, `crs_49_inbound_blocking`, `General`, `GoodBots`, `KnownBadBots`, `Known-CVEs`, `REQUEST-911-METHOD-ENFORCEMENT`, `REQUEST-913-SCANNER-DETECTION`, `REQUEST-920-PROTOCOL-ENFORCEMENT`, `REQUEST-921-PROTOCOL-ATTACK`, `REQUEST-930-APPLICATION-ATTACK-LFI`, `REQUEST-931-APPLICATION-ATTACK-RFI`, `REQUEST-932-APPLICATION-ATTACK-RCE`, `REQUEST-933-APPLICATION-ATTACK-PHP`, `REQUEST-941-APPLICATION-ATTACK-XSS`, `REQUEST-942-APPLICATION-ATTACK-SQLI`, `REQUEST-943-APPLICATION-ATTACK-SESSION-FIXATION`, `REQUEST-944-APPLICATION-ATTACK-JAVA`, `UnknownBots`, `METHOD-ENFORCEMENT`, `PROTOCOL-ENFORCEMENT`, `PROTOCOL-ATTACK`, `LFI`, `RFI`, `RCE`, `PHP`, `NODEJS`, `XSS`, `SQLI`, `FIX`, `JAVA`, `MS-ThreatIntel-WebShells`, `MS-ThreatIntel-AppSec`, `MS-ThreatIntel-SQLI` and `MS-ThreatIntel-CVEs`MS-ThreatIntel-WebShells`,.
        """
        return pulumi.get(self, "rule_group_name")

    @rule_group_name.setter
    def rule_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "rule_group_name", value)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PolicyManagedRulesManagedRuleSetRuleGroupOverrideRuleArgs']]]]:
        """
        One or more `rule` block defined below.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PolicyManagedRulesManagedRuleSetRuleGroupOverrideRuleArgs']]]]):
        pulumi.set(self, "rules", value)


if not MYPY:
    class PolicyManagedRulesManagedRuleSetRuleGroupOverrideRuleArgsDict(TypedDict):
        id: pulumi.Input[_builtins.str]
        """
        Identifier for the managed rule.
        """
        action: NotRequired[pulumi.Input[_builtins.str]]
        """
        Describes the override action to be applied when rule matches. Possible values are `Allow`, `AnomalyScoring`, `Block`, `JSChallenge` and `Log`. `JSChallenge` is only valid for rulesets of type `Microsoft_BotManagerRuleSet`.
        """
        enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Describes if the managed rule is in enabled state or disabled state. Defaults to `false`.
        """
elif False:
    PolicyManagedRulesManagedRuleSetRuleGroupOverrideRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PolicyManagedRulesManagedRuleSetRuleGroupOverrideRuleArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[_builtins.str],
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        :param pulumi.Input[_builtins.str] id: Identifier for the managed rule.
        :param pulumi.Input[_builtins.str] action: Describes the override action to be applied when rule matches. Possible values are `Allow`, `AnomalyScoring`, `Block`, `JSChallenge` and `Log`. `JSChallenge` is only valid for rulesets of type `Microsoft_BotManagerRuleSet`.
        :param pulumi.Input[_builtins.bool] enabled: Describes if the managed rule is in enabled state or disabled state. Defaults to `false`.
        """
        pulumi.set(__self__, "id", id)
        if action is not None:
            pulumi.set(__self__, "action", action)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @_builtins.property
    @pulumi.getter
    def id(self) -> pulumi.Input[_builtins.str]:
        """
        Identifier for the managed rule.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "id", value)

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Describes the override action to be applied when rule matches. Possible values are `Allow`, `AnomalyScoring`, `Block`, `JSChallenge` and `Log`. `JSChallenge` is only valid for rulesets of type `Microsoft_BotManagerRuleSet`.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Describes if the managed rule is in enabled state or disabled state. Defaults to `false`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)


if not MYPY:
    class PolicyPolicySettingsArgsDict(TypedDict):
        enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Describes if the policy is in enabled state or disabled state. Defaults to `true`.
        """
        file_upload_enforcement: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether the firewall should block a request with upload size greater then `file_upload_limit_in_mb`.
        """
        file_upload_limit_in_mb: NotRequired[pulumi.Input[_builtins.int]]
        """
        The File Upload Limit in MB. Accepted values are in the range `1` to `4000`. Defaults to `100`.
        """
        js_challenge_cookie_expiration_in_minutes: NotRequired[pulumi.Input[_builtins.int]]
        """
        Specifies the JavaScript challenge cookie validity lifetime in minutes. The user is challenged after the lifetime expires. Accepted values are in the range `5` to `1440`. Defaults to `30`.
        """
        log_scrubbing: NotRequired[pulumi.Input['PolicyPolicySettingsLogScrubbingArgsDict']]
        """
        One `log_scrubbing` block as defined below.
        """
        max_request_body_size_in_kb: NotRequired[pulumi.Input[_builtins.int]]
        """
        The Maximum Request Body Size in KB. Accepted values are in the range `8` to `2000`. Defaults to `128`.
        """
        mode: NotRequired[pulumi.Input[_builtins.str]]
        """
        Describes if it is in detection mode or prevention mode at the policy level. Valid values are `Detection` and `Prevention`. Defaults to `Prevention`.
        """
        request_body_check: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Is Request Body Inspection enabled? Defaults to `true`.
        """
        request_body_enforcement: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether the firewall should block a request with body size greater then `max_request_body_size_in_kb`. Defaults to `true`.
        """
        request_body_inspect_limit_in_kb: NotRequired[pulumi.Input[_builtins.int]]
        """
        Specifies the maximum request body inspection limit in KB for the Web Application Firewall. Defaults to `128`.
        """
elif False:
    PolicyPolicySettingsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PolicyPolicySettingsArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 file_upload_enforcement: Optional[pulumi.Input[_builtins.bool]] = None,
                 file_upload_limit_in_mb: Optional[pulumi.Input[_builtins.int]] = None,
                 js_challenge_cookie_expiration_in_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 log_scrubbing: Optional[pulumi.Input['PolicyPolicySettingsLogScrubbingArgs']] = None,
                 max_request_body_size_in_kb: Optional[pulumi.Input[_builtins.int]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 request_body_check: Optional[pulumi.Input[_builtins.bool]] = None,
                 request_body_enforcement: Optional[pulumi.Input[_builtins.bool]] = None,
                 request_body_inspect_limit_in_kb: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.bool] enabled: Describes if the policy is in enabled state or disabled state. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] file_upload_enforcement: Whether the firewall should block a request with upload size greater then `file_upload_limit_in_mb`.
        :param pulumi.Input[_builtins.int] file_upload_limit_in_mb: The File Upload Limit in MB. Accepted values are in the range `1` to `4000`. Defaults to `100`.
        :param pulumi.Input[_builtins.int] js_challenge_cookie_expiration_in_minutes: Specifies the JavaScript challenge cookie validity lifetime in minutes. The user is challenged after the lifetime expires. Accepted values are in the range `5` to `1440`. Defaults to `30`.
        :param pulumi.Input['PolicyPolicySettingsLogScrubbingArgs'] log_scrubbing: One `log_scrubbing` block as defined below.
        :param pulumi.Input[_builtins.int] max_request_body_size_in_kb: The Maximum Request Body Size in KB. Accepted values are in the range `8` to `2000`. Defaults to `128`.
        :param pulumi.Input[_builtins.str] mode: Describes if it is in detection mode or prevention mode at the policy level. Valid values are `Detection` and `Prevention`. Defaults to `Prevention`.
        :param pulumi.Input[_builtins.bool] request_body_check: Is Request Body Inspection enabled? Defaults to `true`.
        :param pulumi.Input[_builtins.bool] request_body_enforcement: Whether the firewall should block a request with body size greater then `max_request_body_size_in_kb`. Defaults to `true`.
        :param pulumi.Input[_builtins.int] request_body_inspect_limit_in_kb: Specifies the maximum request body inspection limit in KB for the Web Application Firewall. Defaults to `128`.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if file_upload_enforcement is not None:
            pulumi.set(__self__, "file_upload_enforcement", file_upload_enforcement)
        if file_upload_limit_in_mb is not None:
            pulumi.set(__self__, "file_upload_limit_in_mb", file_upload_limit_in_mb)
        if js_challenge_cookie_expiration_in_minutes is not None:
            pulumi.set(__self__, "js_challenge_cookie_expiration_in_minutes", js_challenge_cookie_expiration_in_minutes)
        if log_scrubbing is not None:
            pulumi.set(__self__, "log_scrubbing", log_scrubbing)
        if max_request_body_size_in_kb is not None:
            pulumi.set(__self__, "max_request_body_size_in_kb", max_request_body_size_in_kb)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if request_body_check is not None:
            pulumi.set(__self__, "request_body_check", request_body_check)
        if request_body_enforcement is not None:
            pulumi.set(__self__, "request_body_enforcement", request_body_enforcement)
        if request_body_inspect_limit_in_kb is not None:
            pulumi.set(__self__, "request_body_inspect_limit_in_kb", request_body_inspect_limit_in_kb)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Describes if the policy is in enabled state or disabled state. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="fileUploadEnforcement")
    def file_upload_enforcement(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the firewall should block a request with upload size greater then `file_upload_limit_in_mb`.
        """
        return pulumi.get(self, "file_upload_enforcement")

    @file_upload_enforcement.setter
    def file_upload_enforcement(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "file_upload_enforcement", value)

    @_builtins.property
    @pulumi.getter(name="fileUploadLimitInMb")
    def file_upload_limit_in_mb(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The File Upload Limit in MB. Accepted values are in the range `1` to `4000`. Defaults to `100`.
        """
        return pulumi.get(self, "file_upload_limit_in_mb")

    @file_upload_limit_in_mb.setter
    def file_upload_limit_in_mb(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "file_upload_limit_in_mb", value)

    @_builtins.property
    @pulumi.getter(name="jsChallengeCookieExpirationInMinutes")
    def js_challenge_cookie_expiration_in_minutes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the JavaScript challenge cookie validity lifetime in minutes. The user is challenged after the lifetime expires. Accepted values are in the range `5` to `1440`. Defaults to `30`.
        """
        return pulumi.get(self, "js_challenge_cookie_expiration_in_minutes")

    @js_challenge_cookie_expiration_in_minutes.setter
    def js_challenge_cookie_expiration_in_minutes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "js_challenge_cookie_expiration_in_minutes", value)

    @_builtins.property
    @pulumi.getter(name="logScrubbing")
    def log_scrubbing(self) -> Optional[pulumi.Input['PolicyPolicySettingsLogScrubbingArgs']]:
        """
        One `log_scrubbing` block as defined below.
        """
        return pulumi.get(self, "log_scrubbing")

    @log_scrubbing.setter
    def log_scrubbing(self, value: Optional[pulumi.Input['PolicyPolicySettingsLogScrubbingArgs']]):
        pulumi.set(self, "log_scrubbing", value)

    @_builtins.property
    @pulumi.getter(name="maxRequestBodySizeInKb")
    def max_request_body_size_in_kb(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The Maximum Request Body Size in KB. Accepted values are in the range `8` to `2000`. Defaults to `128`.
        """
        return pulumi.get(self, "max_request_body_size_in_kb")

    @max_request_body_size_in_kb.setter
    def max_request_body_size_in_kb(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_request_body_size_in_kb", value)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Describes if it is in detection mode or prevention mode at the policy level. Valid values are `Detection` and `Prevention`. Defaults to `Prevention`.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mode", value)

    @_builtins.property
    @pulumi.getter(name="requestBodyCheck")
    def request_body_check(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is Request Body Inspection enabled? Defaults to `true`.
        """
        return pulumi.get(self, "request_body_check")

    @request_body_check.setter
    def request_body_check(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "request_body_check", value)

    @_builtins.property
    @pulumi.getter(name="requestBodyEnforcement")
    def request_body_enforcement(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the firewall should block a request with body size greater then `max_request_body_size_in_kb`. Defaults to `true`.
        """
        return pulumi.get(self, "request_body_enforcement")

    @request_body_enforcement.setter
    def request_body_enforcement(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "request_body_enforcement", value)

    @_builtins.property
    @pulumi.getter(name="requestBodyInspectLimitInKb")
    def request_body_inspect_limit_in_kb(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the maximum request body inspection limit in KB for the Web Application Firewall. Defaults to `128`.
        """
        return pulumi.get(self, "request_body_inspect_limit_in_kb")

    @request_body_inspect_limit_in_kb.setter
    def request_body_inspect_limit_in_kb(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "request_body_inspect_limit_in_kb", value)


if not MYPY:
    class PolicyPolicySettingsLogScrubbingArgsDict(TypedDict):
        enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether the log scrubbing is enabled or disabled. Defaults to `true`.
        """
        rules: NotRequired[pulumi.Input[Sequence[pulumi.Input['PolicyPolicySettingsLogScrubbingRuleArgsDict']]]]
        """
        One or more `scrubbing_rule` blocks as define below.
        """
elif False:
    PolicyPolicySettingsLogScrubbingArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PolicyPolicySettingsLogScrubbingArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['PolicyPolicySettingsLogScrubbingRuleArgs']]]] = None):
        """
        :param pulumi.Input[_builtins.bool] enabled: Whether the log scrubbing is enabled or disabled. Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input['PolicyPolicySettingsLogScrubbingRuleArgs']]] rules: One or more `scrubbing_rule` blocks as define below.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the log scrubbing is enabled or disabled. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PolicyPolicySettingsLogScrubbingRuleArgs']]]]:
        """
        One or more `scrubbing_rule` blocks as define below.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PolicyPolicySettingsLogScrubbingRuleArgs']]]]):
        pulumi.set(self, "rules", value)


if not MYPY:
    class PolicyPolicySettingsLogScrubbingRuleArgsDict(TypedDict):
        match_variable: pulumi.Input[_builtins.str]
        enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Describes if the managed rule is in enabled state or disabled state. Defaults to `false`.
        """
        selector: NotRequired[pulumi.Input[_builtins.str]]
        """
        When matchVariable is a collection, operator used to specify which elements in the collection this rule applies to.
        """
        selector_match_operator: NotRequired[pulumi.Input[_builtins.str]]
elif False:
    PolicyPolicySettingsLogScrubbingRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PolicyPolicySettingsLogScrubbingRuleArgs:
    def __init__(__self__, *,
                 match_variable: pulumi.Input[_builtins.str],
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 selector: Optional[pulumi.Input[_builtins.str]] = None,
                 selector_match_operator: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.bool] enabled: Describes if the managed rule is in enabled state or disabled state. Defaults to `false`.
        :param pulumi.Input[_builtins.str] selector: When matchVariable is a collection, operator used to specify which elements in the collection this rule applies to.
        """
        pulumi.set(__self__, "match_variable", match_variable)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if selector is not None:
            pulumi.set(__self__, "selector", selector)
        if selector_match_operator is not None:
            pulumi.set(__self__, "selector_match_operator", selector_match_operator)

    @_builtins.property
    @pulumi.getter(name="matchVariable")
    def match_variable(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "match_variable")

    @match_variable.setter
    def match_variable(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "match_variable", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Describes if the managed rule is in enabled state or disabled state. Defaults to `false`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def selector(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When matchVariable is a collection, operator used to specify which elements in the collection this rule applies to.
        """
        return pulumi.get(self, "selector")

    @selector.setter
    def selector(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "selector", value)

    @_builtins.property
    @pulumi.getter(name="selectorMatchOperator")
    def selector_match_operator(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "selector_match_operator")

    @selector_match_operator.setter
    def selector_match_operator(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "selector_match_operator", value)


