"""
Test utilities for :py:mod:`betty.project.extension.demo.project`.
"""

from __future__ import annotations

import tarfile
from json import dumps
from typing import TYPE_CHECKING

import pytest

from betty.fetch.static import StaticFetcher
from betty.license.licenses import SpdxLicenseRepository

if TYPE_CHECKING:
    from pathlib import Path

    from betty.cache.file import BinaryFileCache
    from betty.fetch import Fetcher
    from betty.serde.dump import Dump, DumpMapping


LICENSES_DATA: DumpMapping[Dump] = {
    "licenseListVersion": SpdxLicenseRepository.SPDX_VERSION,
    "licenses": [
        {
            "reference": "https://spdx.org/licenses/AGPL-3.0-or-later.html",
            "isDeprecatedLicenseId": False,
            "detailsUrl": "https://spdx.org/licenses/AGPL-3.0-or-later.json",
            "referenceNumber": 366,
            "name": "GNU Affero General Public License v3.0 or later",
            "licenseId": "AGPL-3.0-or-later",
            "seeAlso": [
                "https://www.gnu.org/licenses/agpl.txt",
                "https://opensource.org/licenses/AGPL-3.0",
            ],
            "isOsiApproved": True,
            "isFsfLibre": True,
        },
        {
            "reference": "https://spdx.org/licenses/GPL-3.0-or-later.html",
            "isDeprecatedLicenseId": False,
            "detailsUrl": "https://spdx.org/licenses/GPL-3.0-or-later.json",
            "referenceNumber": 269,
            "name": "GNU General Public License v3.0 or later",
            "licenseId": "GPL-3.0-or-later",
            "seeAlso": [
                "https://www.gnu.org/licenses/gpl-3.0-standalone.html",
                "https://opensource.org/licenses/GPL-3.0",
            ],
            "isOsiApproved": True,
            "isFsfLibre": True,
        },
    ],
    "releaseDate": "2024-08-19",
}

GPL_3__0_OR_LATER_LICENSE_DATA: DumpMapping[Dump] = {
    "isDeprecatedLicenseId": False,
    "isFsfLibre": True,
    "licenseText": "GNU GENERAL PUBLIC LICENSE\nVersion 3, 29 June 2007\n\nCopyright © 2007 Free Software Foundation, Inc. \u003chttps://fsf.org/\u003e\n\nEveryone is permitted to copy and distribute verbatim copies of this license document, but changing it is not allowed.\n\nPreamble\n\nThe GNU General Public License is a free, copyleft license for software and other kinds of works.\n\nThe licenses for most software and other practical works are designed to take away your freedom to share and change the works. By contrast, the GNU General Public License is intended to guarantee your freedom to share and change all versions of a program--to make sure it remains free software for all its users. We, the Free Software Foundation, use the GNU General Public License for most of our software; it applies also to any other work released this way by its authors. You can apply it to your programs, too.\n\nWhen we speak of free software, we are referring to freedom, not price. Our General Public Licenses are designed to make sure that you have the freedom to distribute copies of free software (and charge for them if you wish), that you receive source code or can get it if you want it, that you can change the software or use pieces of it in new free programs, and that you know you can do these things.\n\nTo protect your rights, we need to prevent others from denying you these rights or asking you to surrender the rights. Therefore, you have certain responsibilities if you distribute copies of the software, or if you modify it: responsibilities to respect the freedom of others.\n\nFor example, if you distribute copies of such a program, whether gratis or for a fee, you must pass on to the recipients the same freedoms that you received. You must make sure that they, too, receive or can get the source code. And you must show them these terms so they know their rights.\n\nDevelopers that use the GNU GPL protect your rights with two steps: (1) assert copyright on the software, and (2) offer you this License giving you legal permission to copy, distribute and/or modify it.\n\nFor the developers\u0027 and authors\u0027 protection, the GPL clearly explains that there is no warranty for this free software. For both users\u0027 and authors\u0027 sake, the GPL requires that modified versions be marked as changed, so that their problems will not be attributed erroneously to authors of previous versions.\n\nSome devices are designed to deny users access to install or run modified versions of the software inside them, although the manufacturer can do so. This is fundamentally incompatible with the aim of protecting users\u0027 freedom to change the software. The systematic pattern of such abuse occurs in the area of products for individuals to use, which is precisely where it is most unacceptable. Therefore, we have designed this version of the GPL to prohibit the practice for those products. If such problems arise substantially in other domains, we stand ready to extend this provision to those domains in future versions of the GPL, as needed to protect the freedom of users.\n\nFinally, every program is threatened constantly by software patents. States should not allow patents to restrict development and use of software on general-purpose computers, but in those that do, we wish to avoid the special danger that patents applied to a free program could make it effectively proprietary. To prevent this, the GPL assures that patents cannot be used to render the program non-free.\n\nThe precise terms and conditions for copying, distribution and modification follow.\n\nTERMS AND CONDITIONS\n\n0. Definitions.\n\n“This License” refers to version 3 of the GNU General Public License.\n\n“Copyright” also means copyright-like laws that apply to other kinds of works, such as semiconductor masks.\n\n“The Program” refers to any copyrightable work licensed under this License. Each licensee is addressed as “you”. “Licensees” and “recipients” may be individuals or organizations.\n\nTo “modify” a work means to copy from or adapt all or part of the work in a fashion requiring copyright permission, other than the making of an exact copy. The resulting work is called a “modified version” of the earlier work or a work “based on” the earlier work.\n\nA “covered work” means either the unmodified Program or a work based on the Program.\n\nTo “propagate” a work means to do anything with it that, without permission, would make you directly or secondarily liable for infringement under applicable copyright law, except executing it on a computer or modifying a private copy. Propagation includes copying, distribution (with or without modification), making available to the public, and in some countries other activities as well.\n\nTo “convey” a work means any kind of propagation that enables other parties to make or receive copies. Mere interaction with a user through a computer network, with no transfer of a copy, is not conveying.\n\nAn interactive user interface displays “Appropriate Legal Notices” to the extent that it includes a convenient and prominently visible feature that (1) displays an appropriate copyright notice, and (2) tells the user that there is no warranty for the work (except to the extent that warranties are provided), that licensees may convey the work under this License, and how to view a copy of this License. If the interface presents a list of user commands or options, such as a menu, a prominent item in the list meets this criterion.\n\n1. Source Code.\nThe “source code” for a work means the preferred form of the work for making modifications to it. “Object code” means any non-source form of a work.\n\nA “Standard Interface” means an interface that either is an official standard defined by a recognized standards body, or, in the case of interfaces specified for a particular programming language, one that is widely used among developers working in that language.\n\nThe “System Libraries” of an executable work include anything, other than the work as a whole, that (a) is included in the normal form of packaging a Major Component, but which is not part of that Major Component, and (b) serves only to enable use of the work with that Major Component, or to implement a Standard Interface for which an implementation is available to the public in source code form. A “Major Component”, in this context, means a major essential component (kernel, window system, and so on) of the specific operating system (if any) on which the executable work runs, or a compiler used to produce the work, or an object code interpreter used to run it.\n\nThe “Corresponding Source” for a work in object code form means all the source code needed to generate, install, and (for an executable work) run the object code and to modify the work, including scripts to control those activities. However, it does not include the work\u0027s System Libraries, or general-purpose tools or generally available free programs which are used unmodified in performing those activities but which are not part of the work. For example, Corresponding Source includes interface definition files associated with source files for the work, and the source code for shared libraries and dynamically linked subprograms that the work is specifically designed to require, such as by intimate data communication or control flow between those subprograms and other parts of the work.\n\nThe Corresponding Source need not include anything that users can regenerate automatically from other parts of the Corresponding Source.\n\nThe Corresponding Source for a work in source code form is that same work.\n\n2. Basic Permissions.\nAll rights granted under this License are granted for the term of copyright on the Program, and are irrevocable provided the stated conditions are met. This License explicitly affirms your unlimited permission to run the unmodified Program. The output from running a covered work is covered by this License only if the output, given its content, constitutes a covered work. This License acknowledges your rights of fair use or other equivalent, as provided by copyright law.\n\nYou may make, run and propagate covered works that you do not convey, without conditions so long as your license otherwise remains in force. You may convey covered works to others for the sole purpose of having them make modifications exclusively for you, or provide you with facilities for running those works, provided that you comply with the terms of this License in conveying all material for which you do not control copyright. Those thus making or running the covered works for you must do so exclusively on your behalf, under your direction and control, on terms that prohibit them from making any copies of your copyrighted material outside their relationship with you.\n\nConveying under any other circumstances is permitted solely under the conditions stated below. Sublicensing is not allowed; section 10 makes it unnecessary.\n\n3. Protecting Users\u0027 Legal Rights From Anti-Circumvention Law.\nNo covered work shall be deemed part of an effective technological measure under any applicable law fulfilling obligations under article 11 of the WIPO copyright treaty adopted on 20 December 1996, or similar laws prohibiting or restricting circumvention of such measures.\n\nWhen you convey a covered work, you waive any legal power to forbid circumvention of technological measures to the extent such circumvention is effected by exercising rights under this License with respect to the covered work, and you disclaim any intention to limit operation or modification of the work as a means of enforcing, against the work\u0027s users, your or third parties\u0027 legal rights to forbid circumvention of technological measures.\n\n4. Conveying Verbatim Copies.\nYou may convey verbatim copies of the Program\u0027s source code as you receive it, in any medium, provided that you conspicuously and appropriately publish on each copy an appropriate copyright notice; keep intact all notices stating that this License and any non-permissive terms added in accord with section 7 apply to the code; keep intact all notices of the absence of any warranty; and give all recipients a copy of this License along with the Program.\n\nYou may charge any price or no price for each copy that you convey, and you may offer support or warranty protection for a fee.\n\n5. Conveying Modified Source Versions.\nYou may convey a work based on the Program, or the modifications to produce it from the Program, in the form of source code under the terms of section 4, provided that you also meet all of these conditions:\n\n     a) The work must carry prominent notices stating that you modified it, and giving a relevant date.\n\n     b) The work must carry prominent notices stating that it is released under this License and any conditions added under section 7. This requirement modifies the requirement in section 4 to “keep intact all notices”.\n\n     c) You must license the entire work, as a whole, under this License to anyone who comes into possession of a copy. This License will therefore apply, along with any applicable section 7 additional terms, to the whole of the work, and all its parts, regardless of how they are packaged. This License gives no permission to license the work in any other way, but it does not invalidate such permission if you have separately received it.\n\n     d) If the work has interactive user interfaces, each must display Appropriate Legal Notices; however, if the Program has interactive interfaces that do not display Appropriate Legal Notices, your work need not make them do so.\n\nA compilation of a covered work with other separate and independent works, which are not by their nature extensions of the covered work, and which are not combined with it such as to form a larger program, in or on a volume of a storage or distribution medium, is called an “aggregate” if the compilation and its resulting copyright are not used to limit the access or legal rights of the compilation\u0027s users beyond what the individual works permit. Inclusion of a covered work in an aggregate does not cause this License to apply to the other parts of the aggregate.\n\n6. Conveying Non-Source Forms.\nYou may convey a covered work in object code form under the terms of sections 4 and 5, provided that you also convey the machine-readable Corresponding Source under the terms of this License, in one of these ways:\n\n     a) Convey the object code in, or embodied in, a physical product (including a physical distribution medium), accompanied by the Corresponding Source fixed on a durable physical medium customarily used for software interchange.\n\n     b) Convey the object code in, or embodied in, a physical product (including a physical distribution medium), accompanied by a written offer, valid for at least three years and valid for as long as you offer spare parts or customer support for that product model, to give anyone who possesses the object code either (1) a copy of the Corresponding Source for all the software in the product that is covered by this License, on a durable physical medium customarily used for software interchange, for a price no more than your reasonable cost of physically performing this conveying of source, or (2) access to copy the Corresponding Source from a network server at no charge.\n\n     c) Convey individual copies of the object code with a copy of the written offer to provide the Corresponding Source. This alternative is allowed only occasionally and noncommercially, and only if you received the object code with such an offer, in accord with subsection 6b.\n\n     d) Convey the object code by offering access from a designated place (gratis or for a charge), and offer equivalent access to the Corresponding Source in the same way through the same place at no further charge. You need not require recipients to copy the Corresponding Source along with the object code. If the place to copy the object code is a network server, the Corresponding Source may be on a different server (operated by you or a third party) that supports equivalent copying facilities, provided you maintain clear directions next to the object code saying where to find the Corresponding Source. Regardless of what server hosts the Corresponding Source, you remain obligated to ensure that it is available for as long as needed to satisfy these requirements.\n\n     e) Convey the object code using peer-to-peer transmission, provided you inform other peers where the object code and Corresponding Source of the work are being offered to the general public at no charge under subsection 6d.\n\nA separable portion of the object code, whose source code is excluded from the Corresponding Source as a System Library, need not be included in conveying the object code work.\n\nA “User Product” is either (1) a “consumer product”, which means any tangible personal property which is normally used for personal, family, or household purposes, or (2) anything designed or sold for incorporation into a dwelling. In determining whether a product is a consumer product, doubtful cases shall be resolved in favor of coverage. For a particular product received by a particular user, “normally used” refers to a typical or common use of that class of product, regardless of the status of the particular user or of the way in which the particular user actually uses, or expects or is expected to use, the product. A product is a consumer product regardless of whether the product has substantial commercial, industrial or non-consumer uses, unless such uses represent the only significant mode of use of the product.\n\n“Installation Information” for a User Product means any methods, procedures, authorization keys, or other information required to install and execute modified versions of a covered work in that User Product from a modified version of its Corresponding Source. The information must suffice to ensure that the continued functioning of the modified object code is in no case prevented or interfered with solely because modification has been made.\n\nIf you convey an object code work under this section in, or with, or specifically for use in, a User Product, and the conveying occurs as part of a transaction in which the right of possession and use of the User Product is transferred to the recipient in perpetuity or for a fixed term (regardless of how the transaction is characterized), the Corresponding Source conveyed under this section must be accompanied by the Installation Information. But this requirement does not apply if neither you nor any third party retains the ability to install modified object code on the User Product (for example, the work has been installed in ROM).\n\nThe requirement to provide Installation Information does not include a requirement to continue to provide support service, warranty, or updates for a work that has been modified or installed by the recipient, or for the User Product in which it has been modified or installed. Access to a network may be denied when the modification itself materially and adversely affects the operation of the network or violates the rules and protocols for communication across the network.\n\nCorresponding Source conveyed, and Installation Information provided, in accord with this section must be in a format that is publicly documented (and with an implementation available to the public in source code form), and must require no special password or key for unpacking, reading or copying.\n\n7. Additional Terms.\n“Additional permissions” are terms that supplement the terms of this License by making exceptions from one or more of its conditions. Additional permissions that are applicable to the entire Program shall be treated as though they were included in this License, to the extent that they are valid under applicable law. If additional permissions apply only to part of the Program, that part may be used separately under those permissions, but the entire Program remains governed by this License without regard to the additional permissions.\n\nWhen you convey a copy of a covered work, you may at your option remove any additional permissions from that copy, or from any part of it. (Additional permissions may be written to require their own removal in certain cases when you modify the work.) You may place additional permissions on material, added by you to a covered work, for which you have or can give appropriate copyright permission.\n\nNotwithstanding any other provision of this License, for material you add to a covered work, you may (if authorized by the copyright holders of that material) supplement the terms of this License with terms:\n\n     a) Disclaiming warranty or limiting liability differently from the terms of sections 15 and 16 of this License; or\n\n     b) Requiring preservation of specified reasonable legal notices or author attributions in that material or in the Appropriate Legal Notices displayed by works containing it; or\n\n     c) Prohibiting misrepresentation of the origin of that material, or requiring that modified versions of such material be marked in reasonable ways as different from the original version; or\n\n     d) Limiting the use for publicity purposes of names of licensors or authors of the material; or\n\n     e) Declining to grant rights under trademark law for use of some trade names, trademarks, or service marks; or\n\n     f) Requiring indemnification of licensors and authors of that material by anyone who conveys the material (or modified versions of it) with contractual assumptions of liability to the recipient, for any liability that these contractual assumptions directly impose on those licensors and authors.\n\nAll other non-permissive additional terms are considered “further restrictions” within the meaning of section 10. If the Program as you received it, or any part of it, contains a notice stating that it is governed by this License along with a term that is a further restriction, you may remove that term. If a license document contains a further restriction but permits relicensing or conveying under this License, you may add to a covered work material governed by the terms of that license document, provided that the further restriction does not survive such relicensing or conveying.\n\nIf you add terms to a covered work in accord with this section, you must place, in the relevant source files, a statement of the additional terms that apply to those files, or a notice indicating where to find the applicable terms.\n\nAdditional terms, permissive or non-permissive, may be stated in the form of a separately written license, or stated as exceptions; the above requirements apply either way.\n\n8. Termination.\nYou may not propagate or modify a covered work except as expressly provided under this License. Any attempt otherwise to propagate or modify it is void, and will automatically terminate your rights under this License (including any patent licenses granted under the third paragraph of section 11).\n\nHowever, if you cease all violation of this License, then your license from a particular copyright holder is reinstated (a) provisionally, unless and until the copyright holder explicitly and finally terminates your license, and (b) permanently, if the copyright holder fails to notify you of the violation by some reasonable means prior to 60 days after the cessation.\n\nMoreover, your license from a particular copyright holder is reinstated permanently if the copyright holder notifies you of the violation by some reasonable means, this is the first time you have received notice of violation of this License (for any work) from that copyright holder, and you cure the violation prior to 30 days after your receipt of the notice.\n\nTermination of your rights under this section does not terminate the licenses of parties who have received copies or rights from you under this License. If your rights have been terminated and not permanently reinstated, you do not qualify to receive new licenses for the same material under section 10.\n\n9. Acceptance Not Required for Having Copies.\nYou are not required to accept this License in order to receive or run a copy of the Program. Ancillary propagation of a covered work occurring solely as a consequence of using peer-to-peer transmission to receive a copy likewise does not require acceptance. However, nothing other than this License grants you permission to propagate or modify any covered work. These actions infringe copyright if you do not accept this License. Therefore, by modifying or propagating a covered work, you indicate your acceptance of this License to do so.\n\n10. Automatic Licensing of Downstream Recipients.\nEach time you convey a covered work, the recipient automatically receives a license from the original licensors, to run, modify and propagate that work, subject to this License. You are not responsible for enforcing compliance by third parties with this License.\n\nAn “entity transaction” is a transaction transferring control of an organization, or substantially all assets of one, or subdividing an organization, or merging organizations. If propagation of a covered work results from an entity transaction, each party to that transaction who receives a copy of the work also receives whatever licenses to the work the party\u0027s predecessor in interest had or could give under the previous paragraph, plus a right to possession of the Corresponding Source of the work from the predecessor in interest, if the predecessor has it or can get it with reasonable efforts.\n\nYou may not impose any further restrictions on the exercise of the rights granted or affirmed under this License. For example, you may not impose a license fee, royalty, or other charge for exercise of rights granted under this License, and you may not initiate litigation (including a cross-claim or counterclaim in a lawsuit) alleging that any patent claim is infringed by making, using, selling, offering for sale, or importing the Program or any portion of it.\n\n11. Patents.\nA “contributor” is a copyright holder who authorizes use under this License of the Program or a work on which the Program is based. The work thus licensed is called the contributor\u0027s “contributor version”.\n\nA contributor\u0027s “essential patent claims” are all patent claims owned or controlled by the contributor, whether already acquired or hereafter acquired, that would be infringed by some manner, permitted by this License, of making, using, or selling its contributor version, but do not include claims that would be infringed only as a consequence of further modification of the contributor version. For purposes of this definition, “control” includes the right to grant patent sublicenses in a manner consistent with the requirements of this License.\n\nEach contributor grants you a non-exclusive, worldwide, royalty-free patent license under the contributor\u0027s essential patent claims, to make, use, sell, offer for sale, import and otherwise run, modify and propagate the contents of its contributor version.\n\nIn the following three paragraphs, a “patent license” is any express agreement or commitment, however denominated, not to enforce a patent (such as an express permission to practice a patent or covenant not to sue for patent infringement). To “grant” such a patent license to a party means to make such an agreement or commitment not to enforce a patent against the party.\n\nIf you convey a covered work, knowingly relying on a patent license, and the Corresponding Source of the work is not available for anyone to copy, free of charge and under the terms of this License, through a publicly available network server or other readily accessible means, then you must either (1) cause the Corresponding Source to be so available, or (2) arrange to deprive yourself of the benefit of the patent license for this particular work, or (3) arrange, in a manner consistent with the requirements of this License, to extend the patent license to downstream recipients. “Knowingly relying” means you have actual knowledge that, but for the patent license, your conveying the covered work in a country, or your recipient\u0027s use of the covered work in a country, would infringe one or more identifiable patents in that country that you have reason to believe are valid.\n\nIf, pursuant to or in connection with a single transaction or arrangement, you convey, or propagate by procuring conveyance of, a covered work, and grant a patent license to some of the parties receiving the covered work authorizing them to use, propagate, modify or convey a specific copy of the covered work, then the patent license you grant is automatically extended to all recipients of the covered work and works based on it.\n\nA patent license is “discriminatory” if it does not include within the scope of its coverage, prohibits the exercise of, or is conditioned on the non-exercise of one or more of the rights that are specifically granted under this License. You may not convey a covered work if you are a party to an arrangement with a third party that is in the business of distributing software, under which you make payment to the third party based on the extent of your activity of conveying the work, and under which the third party grants, to any of the parties who would receive the covered work from you, a discriminatory patent license (a) in connection with copies of the covered work conveyed by you (or copies made from those copies), or (b) primarily for and in connection with specific products or compilations that contain the covered work, unless you entered into that arrangement, or that patent license was granted, prior to 28 March 2007.\n\nNothing in this License shall be construed as excluding or limiting any implied license or other defenses to infringement that may otherwise be available to you under applicable patent law.\n\n12. No Surrender of Others\u0027 Freedom.\nIf conditions are imposed on you (whether by court order, agreement or otherwise) that contradict the conditions of this License, they do not excuse you from the conditions of this License. If you cannot convey a covered work so as to satisfy simultaneously your obligations under this License and any other pertinent obligations, then as a consequence you may not convey it at all. For example, if you agree to terms that obligate you to collect a royalty for further conveying from those to whom you convey the Program, the only way you could satisfy both those terms and this License would be to refrain entirely from conveying the Program.\n\n13. Use with the GNU Affero General Public License.\nNotwithstanding any other provision of this License, you have permission to link or combine any covered work with a work licensed under version 3 of the GNU Affero General Public License into a single combined work, and to convey the resulting work. The terms of this License will continue to apply to the part which is the covered work, but the special requirements of the GNU Affero General Public License, section 13, concerning interaction through a network will apply to the combination as such.\n\n14. Revised Versions of this License.\nThe Free Software Foundation may publish revised and/or new versions of the GNU General Public License from time to time. Such new versions will be similar in spirit to the present version, but may differ in detail to address new problems or concerns.\n\nEach version is given a distinguishing version number. If the Program specifies that a certain numbered version of the GNU General Public License “or any later version” applies to it, you have the option of following the terms and conditions either of that numbered version or of any later version published by the Free Software Foundation. If the Program does not specify a version number of the GNU General Public License, you may choose any version ever published by the Free Software Foundation.\n\nIf the Program specifies that a proxy can decide which future versions of the GNU General Public License can be used, that proxy\u0027s public statement of acceptance of a version permanently authorizes you to choose that version for the Program.\n\nLater license versions may give you additional or different permissions. However, no additional obligations are imposed on any author or copyright holder as a result of your choosing to follow a later version.\n\n15. Disclaimer of Warranty.\nTHERE IS NO WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW. EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES PROVIDE THE PROGRAM “AS IS” WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU. SHOULD THE PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.\n\n16. Limitation of Liability.\nIN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MODIFIES AND/OR CONVEYS THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.\n\n17. Interpretation of Sections 15 and 16.\nIf the disclaimer of warranty and limitation of liability provided above cannot be given local legal effect according to their terms, reviewing courts shall apply local law that most closely approximates an absolute waiver of all civil liability in connection with the Program, unless a warranty or assumption of liability accompanies a copy of the Program in return for a fee.\n\nEND OF TERMS AND CONDITIONS\n\nHow to Apply These Terms to Your New Programs\n\nIf you develop a new program, and you want it to be of the greatest possible use to the public, the best way to achieve this is to make it free software which everyone can redistribute and change under these terms.\n\nTo do so, attach the following notices to the program. It is safest to attach them to the start of each source file to most effectively state the exclusion of warranty; and each file should have at least the “copyright” line and a pointer to where the full notice is found.\n\n     \u003cone line to give the program\u0027s name and a brief idea of what it does.\u003e\n     Copyright (C) \u003cyear\u003e  \u003cname of author\u003e\n\n     This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.\n\n     This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.\n\n     You should have received a copy of the GNU General Public License along with this program.  If not, see \u003chttps://www.gnu.org/licenses/\u003e.\n\nAlso add information on how to contact you by electronic and paper mail.\n\nIf the program does terminal interaction, make it output a short notice like this when it starts in an interactive mode:\n\n     \u003cprogram\u003e  Copyright (C) \u003cyear\u003e  \u003cname of author\u003e\n     This program comes with ABSOLUTELY NO WARRANTY; for details type `show w\u0027.\n     This is free software, and you are welcome to redistribute it under certain conditions; type `show c\u0027 for details.\n\nThe hypothetical commands `show w\u0027 and `show c\u0027 should show the appropriate parts of the General Public License. Of course, your program\u0027s commands might be different; for a GUI interface, you would use an “about box”.\n\nYou should also get your employer (if you work as a programmer) or school, if any, to sign a “copyright disclaimer” for the program, if necessary. For more information on this, and how to apply and follow the GNU GPL, see \u003chttps://www.gnu.org/licenses/\u003e.\n\nThe GNU General Public License does not permit incorporating your program into proprietary programs. If your program is a subroutine library, you may consider it more useful to permit linking proprietary applications with the library. If this is what you want to do, use the GNU Lesser General Public License instead of this License. But first, please read \u003chttps://www.gnu.org/philosophy/why-not-lgpl.html\u003e.\n",
    "standardLicenseHeaderTemplate": '\u003c\u003cvar;name\u003d"description";original\u003d"\u003cone line to give the program\u0027s name and a brief idea of what it does.\u003e";match\u003d".+"\u003e\u003e\n\nCopyright (C) \u003c\u003cvar;name\u003d"copyright";original\u003d"\u003cyear\u003e \u003cname of author\u003e";match\u003d".+"\u003e\u003e\n\nThis program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.\n\nThis program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.\n\nYou should have received a copy of the GNU General Public License along with this program. If not, see \u003chttps://www.gnu.org/licenses/\u003e.\n\n',
    "standardLicenseTemplate": '\u003c\u003cbeginOptional\u003e\u003eGNU GENERAL PUBLIC LICENSE\n\nVersion 3, 29 June 2007\n\n\u003c\u003cendOptional\u003e\u003e\n\nCopyright © 2007 Free Software Foundation, Inc. \u003chttps://fsf.org/\u003e\n\nEveryone is permitted to copy and distribute verbatim copies of this license document, but changing it is not allowed.\n\nPreamble\n\nThe GNU General Public License is a free, copyleft license for software and other kinds of works.\n\nThe licenses for most software and other practical works are designed to take away your freedom to share and change the works. By contrast, the GNU General Public License is intended to guarantee your freedom to share and change all versions of a program--to make sure it remains free software for all its users. We, the Free Software Foundation, use the GNU General Public License for most of our software; it applies also to any other work released this way by its authors. You can apply it to your programs, too.\n\nWhen we speak of free software, we are referring to freedom, not price. Our General Public Licenses are designed to make sure that you have the freedom to distribute copies of free software (and charge for them if you wish), that you receive source code or can get it if you want it, that you can change the software or use pieces of it in new free programs, and that you know you can do these things.\n\nTo protect your rights, we need to prevent others from denying you these rights or asking you to surrender the rights. Therefore, you have certain responsibilities if you distribute copies of the software, or if you modify it: responsibilities to respect the freedom of others.\n\nFor example, if you distribute copies of such a program, whether gratis or for a fee, you must pass on to the recipients the same freedoms that you received. You must make sure that they, too, receive or can get the source code. And you must show them these terms so they know their rights.\n\nDevelopers that use the GNU GPL protect your rights with two steps: (1) assert copyright on the software, and (2) offer you this License giving you legal permission to copy, distribute and/or modify it.\n\nFor the developers\u0027 and authors\u0027 protection, the GPL clearly explains that there is no warranty for this free software. For both users\u0027 and authors\u0027 sake, the GPL requires that modified versions be marked as changed, so that their problems will not be attributed erroneously to authors of previous versions.\n\nSome devices are designed to deny users access to install or run modified versions of the software inside them, although the manufacturer can do so. This is fundamentally incompatible with the aim of protecting users\u0027 freedom to change the software. The systematic pattern of such abuse occurs in the area of products for individuals to use, which is precisely where it is most unacceptable. Therefore, we have designed this version of the GPL to prohibit the practice for those products. If such problems arise substantially in other domains, we stand ready to extend this provision to those domains in future versions of the GPL, as needed to protect the freedom of users.\n\nFinally, every program is threatened constantly by software patents. States should not allow patents to restrict development and use of software on general-purpose computers, but in those that do, we wish to avoid the special danger that patents applied to a free program could make it effectively proprietary. To prevent this, the GPL assures that patents cannot be used to render the program non-free.\n\nThe precise terms and conditions for copying, distribution and modification follow.\n\nTERMS AND CONDITIONS\n\n   \u003c\u003cvar;name\u003d"bullet";original\u003d"0.";match\u003d".{0,20}"\u003e\u003e Definitions.\n\n   "This License" refers to version 3 of the GNU General Public License.\n\n   "Copyright" also means copyright-like laws that apply to other kinds of works, such as semiconductor masks.\n\n   "The Program" refers to any copyrightable work licensed under this License. Each licensee is addressed as "you". "Licensees" and "recipients" may be individuals or organizations.\n\n   To "modify" a work means to copy from or adapt all or part of the work in a fashion requiring copyright permission, other than the making of an exact copy. The resulting work is called a "modified version" of the earlier work or a work "based on" the earlier work.\n\n   A "covered work" means either the unmodified Program or a work based on the Program.\n\n   To "propagate" a work means to do anything with it that, without permission, would make you directly or secondarily liable for infringement under applicable copyright law, except executing it on a computer or modifying a private copy. Propagation includes copying, distribution (with or without modification), making available to the public, and in some countries other activities as well.\n\n   To "convey" a work means any kind of propagation that enables other parties to make or receive copies. Mere interaction with a user through a computer network, with no transfer of a copy, is not conveying.\n\n   An interactive user interface displays "Appropriate Legal Notices" to the extent that it includes a convenient and prominently visible feature that (1) displays an appropriate copyright notice, and (2) tells the user that there is no warranty for the work (except to the extent that warranties are provided), that licensees may convey the work under this License, and how to view a copy of this License. If the interface presents a list of user commands or options, such as a menu, a prominent item in the list meets this criterion.\n\n   \u003c\u003cvar;name\u003d"bullet";original\u003d"1.";match\u003d".{0,20}"\u003e\u003e Source Code.\n\n   The "source code" for a work means the preferred form of the work for making modifications to it. "Object code" means any non-source form of a work.\n\n   A "Standard Interface" means an interface that either is an official standard defined by a recognized standards body, or, in the case of interfaces specified for a particular programming language, one that is widely used among developers working in that language.\n\n   The "System Libraries" of an executable work include anything, other than the work as a whole, that (a) is included in the normal form of packaging a Major Component, but which is not part of that Major Component, and (b) serves only to enable use of the work with that Major Component, or to implement a Standard Interface for which an implementation is available to the public in source code form. A "Major Component", in this context, means a major essential component (kernel, window system, and so on) of the specific operating system (if any) on which the executable work runs, or a compiler used to produce the work, or an object code interpreter used to run it.\n\n   The "Corresponding Source" for a work in object code form means all the source code needed to generate, install, and (for an executable work) run the object code and to modify the work, including scripts to control those activities. However, it does not include the work\u0027s System Libraries, or general-purpose tools or generally available free programs which are used unmodified in performing those activities but which are not part of the work. For example, Corresponding Source includes interface definition files associated with source files for the work, and the source code for shared libraries and dynamically linked subprograms that the work is specifically designed to require, such as by intimate data communication or control flow between those subprograms and other parts of the work.\n\n   The Corresponding Source need not include anything that users can regenerate automatically from other parts of the Corresponding Source.\n\n   The Corresponding Source for a work in source code form is that same work.\n\n   \u003c\u003cvar;name\u003d"bullet";original\u003d"2.";match\u003d".{0,20}"\u003e\u003e Basic Permissions.\n\n   All rights granted under this License are granted for the term of copyright on the Program, and are irrevocable provided the stated conditions are met. This License explicitly affirms your unlimited permission to run the unmodified Program. The output from running a covered work is covered by this License only if the output, given its content, constitutes a covered work. This License acknowledges your rights of fair use or other equivalent, as provided by copyright law.\n\n   You may make, run and propagate covered works that you do not convey, without conditions so long as your license otherwise remains in force. You may convey covered works to others for the sole purpose of having them make modifications exclusively for you, or provide you with facilities for running those works, provided that you comply with the terms of this License in conveying all material for which you do not control copyright. Those thus making or running the covered works for you must do so exclusively on your behalf, under your direction and control, on terms that prohibit them from making any copies of your copyrighted material outside their relationship with you.\n\n   Conveying under any other circumstances is permitted solely under the conditions stated below. Sublicensing is not allowed; section 10 makes it unnecessary.\n\n   \u003c\u003cvar;name\u003d"bullet";original\u003d"3.";match\u003d".{0,20}"\u003e\u003e Protecting Users\u0027 Legal Rights From Anti-Circumvention Law.\n\n   No covered work shall be deemed part of an effective technological measure under any applicable law fulfilling obligations under article 11 of the WIPO copyright treaty adopted on 20 December 1996, or similar laws prohibiting or restricting circumvention of such measures.\n\n   When you convey a covered work, you waive any legal power to forbid circumvention of technological measures to the extent such circumvention is effected by exercising rights under this License with respect to the covered work, and you disclaim any intention to limit operation or modification of the work as a means of enforcing, against the work\u0027s users, your or third parties\u0027 legal rights to forbid circumvention of technological measures.\n\n   \u003c\u003cvar;name\u003d"bullet";original\u003d"4.";match\u003d".{0,20}"\u003e\u003e Conveying Verbatim Copies.\n\n   You may convey verbatim copies of the Program\u0027s source code as you receive it, in any medium, provided that you conspicuously and appropriately publish on each copy an appropriate copyright notice; keep intact all notices stating that this License and any non-permissive terms added in accord with section 7 apply to the code; keep intact all notices of the absence of any warranty; and give all recipients a copy of this License along with the Program.\n\n   You may charge any price or no price for each copy that you convey, and you may offer support or warranty protection for a fee.\n\n   \u003c\u003cvar;name\u003d"bullet";original\u003d"5.";match\u003d".{0,20}"\u003e\u003e Conveying Modified Source Versions.\n\n   You may convey a work based on the Program, or the modifications to produce it from the Program, in the form of source code under the terms of section 4, provided that you also meet all of these conditions:\n\n      \u003c\u003cvar;name\u003d"bullet";original\u003d"a)";match\u003d".{0,20}"\u003e\u003e The work must carry prominent notices stating that you modified it, and giving a relevant date.\n\n      \u003c\u003cvar;name\u003d"bullet";original\u003d"b)";match\u003d".{0,20}"\u003e\u003e The work must carry prominent notices stating that it is released under this License and any conditions added under section 7. This requirement modifies the requirement in section 4 to "keep intact all notices".\n\n      \u003c\u003cvar;name\u003d"bullet";original\u003d"c)";match\u003d".{0,20}"\u003e\u003e You must license the entire work, as a whole, under this License to anyone who comes into possession of a copy. This License will therefore apply, along with any applicable section 7 additional terms, to the whole of the work, and all its parts, regardless of how they are packaged. This License gives no permission to license the work in any other way, but it does not invalidate such permission if you have separately received it.\n\n      \u003c\u003cvar;name\u003d"bullet";original\u003d"d)";match\u003d".{0,20}"\u003e\u003e If the work has interactive user interfaces, each must display Appropriate Legal Notices; however, if the Program has interactive interfaces that do not display Appropriate Legal Notices, your work need not make them do so.\n\n   A compilation of a covered work with other separate and independent works, which are not by their nature extensions of the covered work, and which are not combined with it such as to form a larger program, in or on a volume of a storage or distribution medium, is called an "aggregate" if the compilation and its resulting copyright are not used to limit the access or legal rights of the compilation\u0027s users beyond what the individual works permit. Inclusion of a covered work in an aggregate does not cause this License to apply to the other parts of the aggregate.\n\n   \u003c\u003cvar;name\u003d"bullet";original\u003d"6.";match\u003d".{0,20}"\u003e\u003e Conveying Non-Source Forms.\n\n   You may convey a covered work in object code form under the terms of sections 4 and 5, provided that you also convey the machine-readable Corresponding Source under the terms of this License, in one of these ways:\n\n      \u003c\u003cvar;name\u003d"bullet";original\u003d"a)";match\u003d".{0,20}"\u003e\u003e Convey the object code in, or embodied in, a physical product (including a physical distribution medium), accompanied by the Corresponding Source fixed on a durable physical medium customarily used for software interchange.\n\n      \u003c\u003cvar;name\u003d"bullet";original\u003d"b)";match\u003d".{0,20}"\u003e\u003e Convey the object code in, or embodied in, a physical product (including a physical distribution medium), accompanied by a written offer, valid for at least three years and valid for as long as you offer spare parts or customer support for that product model, to give anyone who possesses the object code either (1) a copy of the Corresponding Source for all the software in the product that is covered by this License, on a durable physical medium customarily used for software interchange, for a price no more than your reasonable cost of physically performing this conveying of source, or (2) access to copy the Corresponding Source from a network server at no charge.\n\n      \u003c\u003cvar;name\u003d"bullet";original\u003d"c)";match\u003d".{0,20}"\u003e\u003e Convey individual copies of the object code with a copy of the written offer to provide the Corresponding Source. This alternative is allowed only occasionally and noncommercially, and only if you received the object code with such an offer, in accord with subsection 6b.\n\n      \u003c\u003cvar;name\u003d"bullet";original\u003d"d)";match\u003d".{0,20}"\u003e\u003e Convey the object code by offering access from a designated place (gratis or for a charge), and offer equivalent access to the Corresponding Source in the same way through the same place at no further charge. You need not require recipients to copy the Corresponding Source along with the object code. If the place to copy the object code is a network server, the Corresponding Source may be on a different server (operated by you or a third party) that supports equivalent copying facilities, provided you maintain clear directions next to the object code saying where to find the Corresponding Source. Regardless of what server hosts the Corresponding Source, you remain obligated to ensure that it is available for as long as needed to satisfy these requirements.\n\n      \u003c\u003cvar;name\u003d"bullet";original\u003d"e)";match\u003d".{0,20}"\u003e\u003e Convey the object code using peer-to-peer transmission, provided you inform other peers where the object code and Corresponding Source of the work are being offered to the general public at no charge under subsection 6d.\n\n   A separable portion of the object code, whose source code is excluded from the Corresponding Source as a System Library, need not be included in conveying the object code work.\n\n   A "User Product" is either (1) a "consumer product", which means any tangible personal property which is normally used for personal, family, or household purposes, or (2) anything designed or sold for incorporation into a dwelling. In determining whether a product is a consumer product, doubtful cases shall be resolved in favor of coverage. For a particular product received by a particular user, "normally used" refers to a typical or common use of that class of product, regardless of the status of the particular user or of the way in which the particular user actually uses, or expects or is expected to use, the product. A product is a consumer product regardless of whether the product has substantial commercial, industrial or non-consumer uses, unless such uses represent the only significant mode of use of the product.\n\n   "Installation Information" for a User Product means any methods, procedures, authorization keys, or other information required to install and execute modified versions of a covered work in that User Product from a modified version of its Corresponding Source. The information must suffice to ensure that the continued functioning of the modified object code is in no case prevented or interfered with solely because modification has been made.\n\n   If you convey an object code work under this section in, or with, or specifically for use in, a User Product, and the conveying occurs as part of a transaction in which the right of possession and use of the User Product is transferred to the recipient in perpetuity or for a fixed term (regardless of how the transaction is characterized), the Corresponding Source conveyed under this section must be accompanied by the Installation Information. But this requirement does not apply if neither you nor any third party retains the ability to install modified object code on the User Product (for example, the work has been installed in ROM).\n\n   The requirement to provide Installation Information does not include a requirement to continue to provide support service, warranty, or updates for a work that has been modified or installed by the recipient, or for the User Product in which it has been modified or installed. Access to a network may be denied when the modification itself materially and adversely affects the operation of the network or violates the rules and protocols for communication across the network.\n\n   Corresponding Source conveyed, and Installation Information provided, in accord with this section must be in a format that is publicly documented (and with an implementation available to the public in source code form), and must require no special password or key for unpacking, reading or copying.\n\n   \u003c\u003cvar;name\u003d"bullet";original\u003d"7.";match\u003d".{0,20}"\u003e\u003e Additional Terms.\n\n   "Additional permissions" are terms that supplement the terms of this License by making exceptions from one or more of its conditions. Additional permissions that are applicable to the entire Program shall be treated as though they were included in this License, to the extent that they are valid under applicable law. If additional permissions apply only to part of the Program, that part may be used separately under those permissions, but the entire Program remains governed by this License without regard to the additional permissions.\n\n   When you convey a copy of a covered work, you may at your option remove any additional permissions from that copy, or from any part of it. (Additional permissions may be written to require their own removal in certain cases when you modify the work.) You may place additional permissions on material, added by you to a covered work, for which you have or can give appropriate copyright permission.\n\n   Notwithstanding any other provision of this License, for material you add to a covered work, you may (if authorized by the copyright holders of that material) supplement the terms of this License with terms:\n\n      \u003c\u003cvar;name\u003d"bullet";original\u003d"a)";match\u003d".{0,20}"\u003e\u003e Disclaiming warranty or limiting liability differently from the terms of sections 15 and 16 of this License; or\n\n      \u003c\u003cvar;name\u003d"bullet";original\u003d"b)";match\u003d".{0,20}"\u003e\u003e Requiring preservation of specified reasonable legal notices or author attributions in that material or in the Appropriate Legal Notices displayed by works containing it; or\n\n      \u003c\u003cvar;name\u003d"bullet";original\u003d"c)";match\u003d".{0,20}"\u003e\u003e Prohibiting misrepresentation of the origin of that material, or requiring that modified versions of such material be marked in reasonable ways as different from the original version; or\n\n      \u003c\u003cvar;name\u003d"bullet";original\u003d"d)";match\u003d".{0,20}"\u003e\u003e Limiting the use for publicity purposes of names of licensors or authors of the material; or\n\n      \u003c\u003cvar;name\u003d"bullet";original\u003d"e)";match\u003d".{0,20}"\u003e\u003e Declining to grant rights under trademark law for use of some trade names, trademarks, or service marks; or\n\n      \u003c\u003cvar;name\u003d"bullet";original\u003d"f)";match\u003d".{0,20}"\u003e\u003e Requiring indemnification of licensors and authors of that material by anyone who conveys the material (or modified versions of it) with contractual assumptions of liability to the recipient, for any liability that these contractual assumptions directly impose on those licensors and authors.\n\n   All other non-permissive additional terms are considered "further restrictions" within the meaning of section 10. If the Program as you received it, or any part of it, contains a notice stating that it is governed by this License along with a term that is a further restriction, you may remove that term. If a license document contains a further restriction but permits relicensing or conveying under this License, you may add to a covered work material governed by the terms of that license document, provided that the further restriction does not survive such relicensing or conveying.\n\n   If you add terms to a covered work in accord with this section, you must place, in the relevant source files, a statement of the additional terms that apply to those files, or a notice indicating where to find the applicable terms.\n\n   Additional terms, permissive or non-permissive, may be stated in the form of a separately written license, or stated as exceptions; the above requirements apply either way.\n\n   \u003c\u003cvar;name\u003d"bullet";original\u003d"8.";match\u003d".{0,20}"\u003e\u003e Termination.\n\n   You may not propagate or modify a covered work except as expressly provided under this License. Any attempt otherwise to propagate or modify it is void, and will automatically terminate your rights under this License (including any patent licenses granted under the third paragraph of section 11).\n\n   However, if you cease all violation of this License, then your license from a particular copyright holder is reinstated (a) provisionally, unless and until the copyright holder explicitly and finally terminates your license, and (b) permanently, if the copyright holder fails to notify you of the violation by some reasonable means prior to 60 days after the cessation.\n\n   Moreover, your license from a particular copyright holder is reinstated permanently if the copyright holder notifies you of the violation by some reasonable means, this is the first time you have received notice of violation of this License (for any work) from that copyright holder, and you cure the violation prior to 30 days after your receipt of the notice.\n\n   Termination of your rights under this section does not terminate the licenses of parties who have received copies or rights from you under this License. If your rights have been terminated and not permanently reinstated, you do not qualify to receive new licenses for the same material under section 10.\n\n   \u003c\u003cvar;name\u003d"bullet";original\u003d"9.";match\u003d".{0,20}"\u003e\u003e Acceptance Not Required for Having Copies.\n\n   You are not required to accept this License in order to receive or run a copy of the Program. Ancillary propagation of a covered work occurring solely as a consequence of using peer-to-peer transmission to receive a copy likewise does not require acceptance. However, nothing other than this License grants you permission to propagate or modify any covered work. These actions infringe copyright if you do not accept this License. Therefore, by modifying or propagating a covered work, you indicate your acceptance of this License to do so.\n\n   \u003c\u003cvar;name\u003d"bullet";original\u003d"10.";match\u003d".{0,20}"\u003e\u003e Automatic Licensing of Downstream Recipients.\n\n   Each time you convey a covered work, the recipient automatically receives a license from the original licensors, to run, modify and propagate that work, subject to this License. You are not responsible for enforcing compliance by third parties with this License.\n\n   An "entity transaction" is a transaction transferring control of an organization, or substantially all assets of one, or subdividing an organization, or merging organizations. If propagation of a covered work results from an entity transaction, each party to that transaction who receives a copy of the work also receives whatever licenses to the work the party\u0027s predecessor in interest had or could give under the previous paragraph, plus a right to possession of the Corresponding Source of the work from the predecessor in interest, if the predecessor has it or can get it with reasonable efforts.\n\n   You may not impose any further restrictions on the exercise of the rights granted or affirmed under this License. For example, you may not impose a license fee, royalty, or other charge for exercise of rights granted under this License, and you may not initiate litigation (including a cross-claim or counterclaim in a lawsuit) alleging that any patent claim is infringed by making, using, selling, offering for sale, or importing the Program or any portion of it.\n\n   \u003c\u003cvar;name\u003d"bullet";original\u003d"11.";match\u003d".{0,20}"\u003e\u003e Patents.\n\n   A "contributor" is a copyright holder who authorizes use under this License of the Program or a work on which the Program is based. The work thus licensed is called the contributor\u0027s "contributor version".\n\n   A contributor\u0027s "essential patent claims" are all patent claims owned or controlled by the contributor, whether already acquired or hereafter acquired, that would be infringed by some manner, permitted by this License, of making, using, or selling its contributor version, but do not include claims that would be infringed only as a consequence of further modification of the contributor version. For purposes of this definition, "control" includes the right to grant patent sublicenses in a manner consistent with the requirements of this License.\n\n   Each contributor grants you a non-exclusive, worldwide, royalty-free patent license under the contributor\u0027s essential patent claims, to make, use, sell, offer for sale, import and otherwise run, modify and propagate the contents of its contributor version.\n\n   In the following three paragraphs, a "patent license" is any express agreement or commitment, however denominated, not to enforce a patent (such as an express permission to practice a patent or covenant not to sue for patent infringement). To "grant" such a patent license to a party means to make such an agreement or commitment not to enforce a patent against the party.\n\n   If you convey a covered work, knowingly relying on a patent license, and the Corresponding Source of the work is not available for anyone to copy, free of charge and under the terms of this License, through a publicly available network server or other readily accessible means, then you must either (1) cause the Corresponding Source to be so available, or (2) arrange to deprive yourself of the benefit of the patent license for this particular work, or (3) arrange, in a manner consistent with the requirements of this License, to extend the patent license to downstream recipients. "Knowingly relying" means you have actual knowledge that, but for the patent license, your conveying the covered work in a country, or your recipient\u0027s use of the covered work in a country, would infringe one or more identifiable patents in that country that you have reason to believe are valid.\n\n   If, pursuant to or in connection with a single transaction or arrangement, you convey, or propagate by procuring conveyance of, a covered work, and grant a patent license to some of the parties receiving the covered work authorizing them to use, propagate, modify or convey a specific copy of the covered work, then the patent license you grant is automatically extended to all recipients of the covered work and works based on it.\n\n   A patent license is "discriminatory" if it does not include within the scope of its coverage, prohibits the exercise of, or is conditioned on the non-exercise of one or more of the rights that are specifically granted under this License. You may not convey a covered work if you are a party to an arrangement with a third party that is in the business of distributing software, under which you make payment to the third party based on the extent of your activity of conveying the work, and under which the third party grants, to any of the parties who would receive the covered work from you, a discriminatory patent license (a) in connection with copies of the covered work conveyed by you (or copies made from those copies), or (b) primarily for and in connection with specific products or compilations that contain the covered work, unless you entered into that arrangement, or that patent license was granted, prior to 28 March 2007.\n\n   Nothing in this License shall be construed as excluding or limiting any implied license or other defenses to infringement that may otherwise be available to you under applicable patent law.\n\n   \u003c\u003cvar;name\u003d"bullet";original\u003d"12.";match\u003d".{0,20}"\u003e\u003e No Surrender of Others\u0027 Freedom.\n\n   If conditions are imposed on you (whether by court order, agreement or otherwise) that contradict the conditions of this License, they do not excuse you from the conditions of this License. If you cannot convey a covered work so as to satisfy simultaneously your obligations under this License and any other pertinent obligations, then as a consequence you may not convey it at all. For example, if you agree to terms that obligate you to collect a royalty for further conveying from those to whom you convey the Program, the only way you could satisfy both those terms and this License would be to refrain entirely from conveying the Program.\n\n   \u003c\u003cvar;name\u003d"bullet";original\u003d"13.";match\u003d".{0,20}"\u003e\u003e Use with the GNU Affero General Public License.\n\n   Notwithstanding any other provision of this License, you have permission to link or combine any covered work with a work licensed under version 3 of the GNU Affero General Public License into a single combined work, and to convey the resulting work. The terms of this License will continue to apply to the part which is the covered work, but the special requirements of the GNU Affero General Public License, section 13, concerning interaction through a network will apply to the combination as such.\n\n   \u003c\u003cvar;name\u003d"bullet";original\u003d"14.";match\u003d".{0,20}"\u003e\u003e Revised Versions of this License.\n\n   The Free Software Foundation may publish revised and/or new versions of the GNU General Public License from time to time. Such new versions will be similar in spirit to the present version, but may differ in detail to address new problems or concerns.\n\n   Each version is given a distinguishing version number. If the Program specifies that a certain numbered version of the GNU General Public License "or any later version" applies to it, you have the option of following the terms and conditions either of that numbered version or of any later version published by the Free Software Foundation. If the Program does not specify a version number of the GNU General Public License, you may choose any version ever published by the Free Software Foundation.\n\n   If the Program specifies that a proxy can decide which future versions of the GNU General Public License can be used, that proxy\u0027s public statement of acceptance of a version permanently authorizes you to choose that version for the Program.\n\n   Later license versions may give you additional or different permissions. However, no additional obligations are imposed on any author or copyright holder as a result of your choosing to follow a later version.\n\n   \u003c\u003cvar;name\u003d"bullet";original\u003d"15.";match\u003d".{0,20}"\u003e\u003e Disclaimer of Warranty.\n\n   THERE IS NO WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW. EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU. SHOULD THE PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.\n\n   \u003c\u003cvar;name\u003d"bullet";original\u003d"16.";match\u003d".{0,20}"\u003e\u003e Limitation of Liability.\n\n   IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MODIFIES AND/OR CONVEYS THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.\n\n   \u003c\u003cvar;name\u003d"bullet";original\u003d"17.";match\u003d".{0,20}"\u003e\u003e Interpretation of Sections 15 and 16.\n\n   If the disclaimer of warranty and limitation of liability provided above cannot be given local legal effect according to their terms, reviewing courts shall apply local law that most closely approximates an absolute waiver of all civil liability in connection with the Program, unless a warranty or assumption of liability accompanies a copy of the Program in return for a fee.\n\n   \u003c\u003cbeginOptional\u003e\u003eEND OF TERMS AND CONDITIONS\n\nHow to Apply These Terms to Your New Programs\n\nIf you develop a new program, and you want it to be of the greatest possible use to the public, the best way to achieve this is to make it free software which everyone can redistribute and change under these terms.\n\nTo do so, attach the following notices to the program. It is safest to attach them to the start of each source file to most effectively state the exclusion of warranty; and each file should have at least the "copyright" line and a pointer to where the full notice is found.\n\n\u003c\u003cvar;name\u003d"description";original\u003d"\u003cone line to give the program\u0027s name and a brief idea of what it does.\u003e";match\u003d".+"\u003e\u003e\n\nCopyright (C) \u003c\u003cvar;name\u003d"copyright";original\u003d"\u003cyear\u003e \u003cname of author\u003e";match\u003d".+"\u003e\u003e\n\nThis program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.\n\nThis program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.\n\nYou should have received a copy of the GNU General Public License along with this program. If not, see \u003chttps://www.gnu.org/licenses/\u003e.\n\nAlso add information on how to contact you by electronic and paper mail.\n\nIf the program does terminal interaction, make it output a short notice like this when it starts in an interactive mode:\n\n\u003cprogram\u003e Copyright (C) \u003cyear\u003e \u003cname of author\u003e\n\nThis program comes with ABSOLUTELY NO WARRANTY; for details type `show w\u0027.\n\nThis is free software, and you are welcome to redistribute it under certain conditions; type `show c\u0027 for details.\n\nThe hypothetical commands `show w\u0027 and `show c\u0027 should show the appropriate parts of the General Public License. Of course, your program\u0027s commands might be different; for a GUI interface, you would use an "about box".\n\nYou should also get your employer (if you work as a programmer) or school, if any, to sign a "copyright disclaimer" for the program, if necessary. For more information on this, and how to apply and follow the GNU GPL, see \u003chttps://www.gnu.org/licenses/\u003e.\n\nThe GNU General Public License does not permit incorporating your program into proprietary programs. If your program is a subroutine library, you may consider it more useful to permit linking proprietary applications with the library. If this is what you want to do, use the GNU Lesser General Public License instead of this License. But first, please read \u003chttps: \u003c\u003cvar;name\u003d"philicenses";original\u003d"//www.gnu.org/licenses/why-not-lgpl.html\u003e.";match\u003d"//www.gnu.org/philosophy/why-not-lgpl\\.html\u003e\\.|//www.gnu.org/licenses/why-not-lgpl\\.html\u003e\\."\u003e\u003e\n\n\u003c\u003cendOptional\u003e\u003e',
    "name": "GNU General Public License v3.0 or later",
    "licenseComments": 'This license was released: 29 June 2007. This license identifier refers to the choice to use code under GPL-3.0-or-later (i.e., GPL-3.0 or some later version), as distinguished from the use of code under GPL-3.0-only. The license notice (as seen in the Standard License Header field below) states which of these applies to the code in the file. The example in the How to Apply These Terms appendix of the license shows the "or later" approach.',
    "licenseId": "GPL-3.0-or-later",
    "standardLicenseHeader": "\u003cone line to give the program\u0027s name and a brief idea of what it does.\u003e\n\nCopyright (C) \u003cyear\u003e \u003cname of author\u003e\n\nThis program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.\n\nThis program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.\n\nYou should have received a copy of the GNU General Public License along with this program. If not, see \u003chttps://www.gnu.org/licenses/\u003e.\n\n",
    "crossRef": [
        {
            "match": "N/A",
            "url": "https://opensource.org/licenses/GPL-3.0",
            "isValid": True,
            "isLive": False,
            "timestamp": "2024-08-19T17:37:50Z",
            "isWayBackLink": False,
            "order": 1,
        },
        {
            "match": "false",
            "url": "https://www.gnu.org/licenses/gpl-3.0-standalone.html",
            "isValid": True,
            "isLive": True,
            "timestamp": "2024-08-19T17:37:50Z",
            "isWayBackLink": False,
            "order": 0,
        },
    ],
    "seeAlso": [
        "https://www.gnu.org/licenses/gpl-3.0-standalone.html",
        "https://opensource.org/licenses/GPL-3.0",
    ],
    "isOsiApproved": True,
    "licenseTextHtml": '\n    \u003cdiv class\u003d"optional-license-text"\u003e \n      \u003cp\u003e\n        GNU GENERAL PUBLIC LICENSE\u003cbr /\u003e\n\n        Version 3, 29 June 2007\n      \u003c/p\u003e\n\n    \u003c/div\u003e\n    \u003cp\u003e\n      Copyright © 2007 Free Software Foundation, Inc.\n      \u0026lt;https://fsf.org/\u0026gt;\n    \u003c/p\u003e\n\n    \u003cp\u003e\n      Everyone is permitted to copy and distribute verbatim copies\n      of this license document, but changing it is not allowed.\n    \u003c/p\u003e\n\n    \u003cp\u003e\n      Preamble\n    \u003c/p\u003e\n\n    \u003cp\u003e\n      The GNU General Public License is a free, copyleft\n      license for software and other kinds of works.\n    \u003c/p\u003e\n\n    \u003cp\u003e\n      The licenses for most software and other practical works are designed to\n      take away your freedom to share and change the works. By contrast, the GNU\n      General Public License is intended to guarantee your freedom to share and\n      change all versions of a program--to make sure it remains free software\n      for all its users. We, the Free Software Foundation, use the GNU General\n      Public License for most of our software; it applies also to any other work\n      released this way by its authors. You can apply it to your programs, too.\n    \u003c/p\u003e\n\n    \u003cp\u003e\n      When we speak of free software, we are referring to freedom, not\n      price. Our General Public Licenses are designed to make sure that you\n      have the freedom to distribute copies of free software (and charge\n      for them if you wish), that you receive source code or can get it\n      if you want it, that you can change the software or use pieces of\n      it in new free programs, and that you know you can do these things.\n    \u003c/p\u003e\n\n    \u003cp\u003e\n      To protect your rights, we need to prevent others from denying you\n      these rights or asking you to surrender the rights. Therefore, you have\n      certain responsibilities if you distribute copies of the software, or\n      if you modify it: responsibilities to respect the freedom of others.\n    \u003c/p\u003e\n\n    \u003cp\u003e\n      For example, if you distribute copies of such a program, whether gratis\n      or for a fee, you must pass on to the recipients the same freedoms that\n      you received. You must make sure that they, too, receive or can get the\n      source code. And you must show them these terms so they know their rights.\n    \u003c/p\u003e\n\n    \u003cp\u003e\n      Developers that use the GNU GPL protect your rights with two steps:\n      (1) assert copyright on the software, and (2) offer you this License\n      giving you legal permission to copy, distribute and/or modify it.\n    \u003c/p\u003e\n\n    \u003cp\u003e\n      For the developers\u0026apos; and authors\u0026apos; protection, the GPL clearly\n      explains that there is no warranty for this free software. For\n      both users\u0026apos; and authors\u0026apos; sake, the GPL requires that modified\n      versions be marked as changed, so that their problems will\n      not be attributed erroneously to authors of previous versions.\n    \u003c/p\u003e\n\n    \u003cp\u003e\n      Some devices are designed to deny users access to install or run modified\n      versions of the software inside them, although the manufacturer can\n      do so. This is fundamentally incompatible with the aim of protecting\n      users\u0026apos; freedom to change the software. The systematic pattern of\n      such abuse occurs in the area of products for individuals to use,\n      which is precisely where it is most unacceptable. Therefore, we have\n      designed this version of the GPL to prohibit the practice for those\n      products. If such problems arise substantially in other domains,\n      we stand ready to extend this provision to those domains in future\n      versions of the GPL, as needed to protect the freedom of users.\n    \u003c/p\u003e\n\n    \u003cp\u003e\n      Finally, every program is threatened constantly by software patents.\n      States should not allow patents to restrict development and use of\n      software on general-purpose computers, but in those that do, we wish\n      to avoid the special danger that patents applied to a free program\n      could make it effectively proprietary. To prevent this, the GPL\n      assures that patents cannot be used to render the program non-free.\n    \u003c/p\u003e\n\n    \u003cp\u003e\n      The precise terms and conditions for copying,\n      distribution and modification follow.\n    \u003c/p\u003e\n\n    \u003cp\u003e\n      TERMS AND CONDITIONS\n    \u003c/p\u003e\n\n\u003cul style\u003d"list-style:none"\u003e\n      \n\u003cli\u003e\n        \u003cvar class\u003d"replaceable-license-text"\u003e 0.\u003c/var\u003e\n        Definitions.\n        \u003cp\u003e\n          \u0026quot;This License\u0026quot; refers to version 3 of the GNU General Public License.\n        \u003c/p\u003e\n\n        \u003cp\u003e\n          \u0026quot;Copyright\u0026quot; also means copyright-like laws that apply\n          to other kinds of works, such as semiconductor masks.\n        \u003c/p\u003e\n\n        \u003cp\u003e\n          \u0026quot;The Program\u0026quot; refers to any copyrightable work licensed under\n          this License. Each licensee is addressed as \u0026quot;you\u0026quot;. \u0026quot;Licensees\u0026quot;\n          and \u0026quot;recipients\u0026quot; may be individuals or organizations.\n        \u003c/p\u003e\n\n        \u003cp\u003e\n          To \u0026quot;modify\u0026quot; a work means to copy from or adapt all or part of the\n          work in a fashion requiring copyright permission, other than the\n          making of an exact copy. The resulting work is called a \u0026quot;modified\n          version\u0026quot; of the earlier work or a work \u0026quot;based on\u0026quot; the earlier work.\n        \u003c/p\u003e\n\n        \u003cp\u003e\n          A \u0026quot;covered work\u0026quot; means either the unmodified\n          Program or a work based on the Program.\n        \u003c/p\u003e\n\n        \u003cp\u003e\n          To \u0026quot;propagate\u0026quot; a work means to do anything with it that, without\n          permission, would make you directly or secondarily liable for\n          infringement under applicable copyright law, except executing it\n          on a computer or modifying a private copy. Propagation includes\n          copying, distribution (with or without modification), making available\n          to the public, and in some countries other activities as well.\n        \u003c/p\u003e\n\n        \u003cp\u003e\n          To \u0026quot;convey\u0026quot; a work means any kind of propagation\n          that enables other parties to make or receive copies.\n          Mere interaction with a user through a computer\n          network, with no transfer of a copy, is not conveying.\n        \u003c/p\u003e\n\n        \u003cp\u003e\n          An interactive user interface displays \u0026quot;Appropriate Legal Notices\u0026quot;\n          to the extent that it includes a convenient and prominently visible\n          feature that (1) displays an appropriate copyright notice, and (2)\n          tells the user that there is no warranty for the work (except to\n          the extent that warranties are provided), that licensees may convey\n          the work under this License, and how to view a copy of this License.\n          If the interface presents a list of user commands or options,\n          such as a menu, a prominent item in the list meets this criterion.\n        \u003c/p\u003e\n\n      \u003c/li\u003e\n      \n\u003cli\u003e\n        \u003cvar class\u003d"replaceable-license-text"\u003e 1.\u003c/var\u003e\n        Source Code.\u003cbr /\u003e\n\n        The \u0026quot;source code\u0026quot; for a work means the preferred\n        form of the work for making modifications to it.\n        \u0026quot;Object code\u0026quot; means any non-source form of a work.\n        \u003cp\u003e\n          A \u0026quot;Standard Interface\u0026quot; means an interface that either is an official\n          standard defined by a recognized standards body, or, in the case\n          of interfaces specified for a particular programming language,\n          one that is widely used among developers working in that language.\n        \u003c/p\u003e\n\n        \u003cp\u003e\n          The \u0026quot;System Libraries\u0026quot; of an executable work include anything, other\n          than the work as a whole, that (a) is included in the normal form\n          of packaging a Major Component, but which is not part of that Major\n          Component, and (b) serves only to enable use of the work with that\n          Major Component, or to implement a Standard Interface for which an\n          implementation is available to the public in source code form. A\n          \u0026quot;Major Component\u0026quot;, in this context, means a major essential component\n          (kernel, window system, and so on) of the specific operating system\n          (if any) on which the executable work runs, or a compiler used to\n          produce the work, or an object code interpreter used to run it.\n        \u003c/p\u003e\n\n        \u003cp\u003e\n          The \u0026quot;Corresponding Source\u0026quot; for a work in object code form means all\n          the source code needed to generate, install, and (for an executable\n          work) run the object code and to modify the work, including scripts\n          to control those activities. However, it does not include the work\u0026apos;s\n          System Libraries, or general-purpose tools or generally available\n          free programs which are used unmodified in performing those activities\n          but which are not part of the work. For example, Corresponding\n          Source includes interface definition files associated with source\n          files for the work, and the source code for shared libraries\n          and dynamically linked subprograms that the work is specifically\n          designed to require, such as by intimate data communication or\n          control flow between those subprograms and other parts of the work.\n        \u003c/p\u003e\n\n        \u003cp\u003e\n          The Corresponding Source need not include anything that users can\n          regenerate automatically from other parts of the Corresponding Source.\n        \u003c/p\u003e\n\n        \u003cp\u003e\n          The Corresponding Source for a work\n          in source code form is that same work.\n        \u003c/p\u003e\n\n      \u003c/li\u003e\n      \n\u003cli\u003e\n        \u003cvar class\u003d"replaceable-license-text"\u003e 2.\u003c/var\u003e\n        Basic Permissions.\u003cbr /\u003e\n\n        All rights granted under this License are granted for the term of\n        copyright on the Program, and are irrevocable provided the stated\n        conditions are met. This License explicitly affirms your unlimited\n        permission to run the unmodified Program. The output from running a\n        covered work is covered by this License only if the output, given its\n        content, constitutes a covered work. This License acknowledges your\n        rights of fair use or other equivalent, as provided by copyright law.\n        \u003cp\u003e\n          You may make, run and propagate covered works that you do not convey,\n          without conditions so long as your license otherwise remains in force.\n          You may convey covered works to others for the sole purpose of having\n          them make modifications exclusively for you, or provide you with\n          facilities for running those works, provided that you comply with\n          the terms of this License in conveying all material for which you do\n          not control copyright. Those thus making or running the covered works\n          for you must do so exclusively on your behalf, under your direction\n          and control, on terms that prohibit them from making any copies\n          of your copyrighted material outside their relationship with you.\n        \u003c/p\u003e\n\n        \u003cp\u003e\n          Conveying under any other circumstances is permitted\n          solely under the conditions stated below. Sublicensing\n          is not allowed; section 10 makes it unnecessary.\n        \u003c/p\u003e\n\n      \u003c/li\u003e\n      \n\u003cli\u003e\n        \u003cvar class\u003d"replaceable-license-text"\u003e 3.\u003c/var\u003e\n        Protecting Users\u0026apos; Legal Rights From Anti-Circumvention Law.\u003cbr /\u003e\n\n        No covered work shall be deemed part of an effective technological\n        measure under any applicable law fulfilling obligations under article\n        11 of the WIPO copyright treaty adopted on 20 December 1996, or\n        similar laws prohibiting or restricting circumvention of such measures.\n        \u003cp\u003e\n          When you convey a covered work, you waive any legal power to\n          forbid circumvention of technological measures to the extent\n          such circumvention is effected by exercising rights under this\n          License with respect to the covered work, and you disclaim any\n          intention to limit operation or modification of the work as a means\n          of enforcing, against the work\u0026apos;s users, your or third parties\u0026apos;\n          legal rights to forbid circumvention of technological measures.\n        \u003c/p\u003e\n\n      \u003c/li\u003e\n      \n\u003cli\u003e\n        \u003cvar class\u003d"replaceable-license-text"\u003e 4.\u003c/var\u003e\n        Conveying Verbatim Copies.\u003cbr /\u003e\n\n        You may convey verbatim copies of the Program\u0026apos;s source code as\n        you receive it, in any medium, provided that you conspicuously\n        and appropriately publish on each copy an appropriate copyright\n        notice; keep intact all notices stating that this License and any\n        non-permissive terms added in accord with section 7 apply to the\n        code; keep intact all notices of the absence of any warranty; and\n        give all recipients a copy of this License along with the Program.\n        \u003cp\u003e\n          You may charge any price or no price for each copy that you\n          convey, and you may offer support or warranty protection for a fee.\n        \u003c/p\u003e\n\n      \u003c/li\u003e\n      \n\u003cli\u003e\n        \u003cvar class\u003d"replaceable-license-text"\u003e 5.\u003c/var\u003e\n        Conveying Modified Source Versions.\u003cbr /\u003e\n\n        You may convey a work based on the Program, or the modifications to\n        produce it from the Program, in the form of source code under the terms\n        of section 4, provided that you also meet all of these conditions:\n        \n\u003cul style\u003d"list-style:none"\u003e\n          \n\u003cli\u003e\n            \u003cvar class\u003d"replaceable-license-text"\u003e a)\u003c/var\u003e\n            The work must carry prominent notices stating\n            that you modified it, and giving a relevant date.\n          \u003c/li\u003e\n          \n\u003cli\u003e\n            \u003cvar class\u003d"replaceable-license-text"\u003e b)\u003c/var\u003e\n            The work must carry prominent notices stating that\n            it is released under this License and any conditions\n            added under section 7. This requirement modifies the\n            requirement in section 4 to \u0026quot;keep intact all notices\u0026quot;.\n          \u003c/li\u003e\n          \n\u003cli\u003e\n            \u003cvar class\u003d"replaceable-license-text"\u003e c)\u003c/var\u003e\n            You must license the entire work, as a whole, under this License\n            to anyone who comes into possession of a copy. This License\n            will therefore apply, along with any applicable section 7\n            additional terms, to the whole of the work, and all its parts,\n            regardless of how they are packaged. This License gives no\n            permission to license the work in any other way, but it does not\n            invalidate such permission if you have separately received it.\n          \u003c/li\u003e\n          \n\u003cli\u003e\n            \u003cvar class\u003d"replaceable-license-text"\u003e d)\u003c/var\u003e\n            If the work has interactive user interfaces, each must\n            display Appropriate Legal Notices; however, if the Program\n            has interactive interfaces that do not display Appropriate\n            Legal Notices, your work need not make them do so.\n          \u003c/li\u003e\n        \n\u003c/ul\u003e\n        \u003cp\u003e\n          A compilation of a covered work with other separate and independent\n          works, which are not by their nature extensions of the covered\n          work, and which are not combined with it such as to form a larger\n          program, in or on a volume of a storage or distribution medium,\n          is called an \u0026quot;aggregate\u0026quot; if the compilation and its resulting\n          copyright are not used to limit the access or legal rights\n          of the compilation\u0026apos;s users beyond what the individual works\n          permit. Inclusion of a covered work in an aggregate does not\n          cause this License to apply to the other parts of the aggregate.\n        \u003c/p\u003e\n\n      \u003c/li\u003e\n      \n\u003cli\u003e\n        \u003cvar class\u003d"replaceable-license-text"\u003e 6.\u003c/var\u003e\n        Conveying Non-Source Forms.\u003cbr /\u003e\n\n        You may convey a covered work in object code form\n        under the terms of sections 4 and 5, provided that you\n        also convey the machine-readable Corresponding Source\n        under the terms of this License, in one of these ways:\n        \n\u003cul style\u003d"list-style:none"\u003e\n          \n\u003cli\u003e\n            \u003cvar class\u003d"replaceable-license-text"\u003e a)\u003c/var\u003e\n            Convey the object code in, or embodied in, a physical\n            product (including a physical distribution medium),\n            accompanied by the Corresponding Source fixed on a durable\n            physical medium customarily used for software interchange.\n          \u003c/li\u003e\n          \n\u003cli\u003e\n            \u003cvar class\u003d"replaceable-license-text"\u003e b)\u003c/var\u003e\n            Convey the object code in, or embodied in, a physical product\n            (including a physical distribution medium), accompanied by a\n            written offer, valid for at least three years and valid for\n            as long as you offer spare parts or customer support for that\n            product model, to give anyone who possesses the object code\n            either (1) a copy of the Corresponding Source for all the software\n            in the product that is covered by this License, on a durable\n            physical medium customarily used for software interchange,\n            for a price no more than your reasonable cost of physically\n            performing this conveying of source, or (2) access to copy\n            the Corresponding Source from a network server at no charge.\n          \u003c/li\u003e\n          \n\u003cli\u003e\n            \u003cvar class\u003d"replaceable-license-text"\u003e c)\u003c/var\u003e\n            Convey individual copies of the object code with a\n            copy of the written offer to provide the Corresponding\n            Source. This alternative is allowed only occasionally\n            and noncommercially, and only if you received the object\n            code with such an offer, in accord with subsection 6b.\n          \u003c/li\u003e\n          \n\u003cli\u003e\n            \u003cvar class\u003d"replaceable-license-text"\u003e d)\u003c/var\u003e\n            Convey the object code by offering access from a designated place\n            (gratis or for a charge), and offer equivalent access to the\n            Corresponding Source in the same way through the same place at\n            no further charge. You need not require recipients to copy the\n            Corresponding Source along with the object code. If the place\n            to copy the object code is a network server, the Corresponding\n            Source may be on a different server (operated by you or a third\n            party) that supports equivalent copying facilities, provided you\n            maintain clear directions next to the object code saying where\n            to find the Corresponding Source. Regardless of what server hosts\n            the Corresponding Source, you remain obligated to ensure that it\n            is available for as long as needed to satisfy these requirements.\n          \u003c/li\u003e\n          \n\u003cli\u003e\n            \u003cvar class\u003d"replaceable-license-text"\u003e e)\u003c/var\u003e\n            Convey the object code using peer-to-peer transmission,\n            provided you inform other peers where the object code\n            and Corresponding Source of the work are being offered\n            to the general public at no charge under subsection 6d.\n          \u003c/li\u003e\n        \n\u003c/ul\u003e\n        \u003cp\u003e\n          A separable portion of the object code, whose source code is\n          excluded from the Corresponding Source as a System Library,\n          need not be included in conveying the object code work.\n        \u003c/p\u003e\n\n        \u003cp\u003e\n          A \u0026quot;User Product\u0026quot; is either (1) a \u0026quot;consumer product\u0026quot;, which means\n          any tangible personal property which is normally used for personal,\n          family, or household purposes, or (2) anything designed or sold\n          for incorporation into a dwelling. In determining whether a product\n          is a consumer product, doubtful cases shall be resolved in favor\n          of coverage. For a particular product received by a particular\n          user, \u0026quot;normally used\u0026quot; refers to a typical or common use of that\n          class of product, regardless of the status of the particular\n          user or of the way in which the particular user actually uses,\n          or expects or is expected to use, the product. A product is a\n          consumer product regardless of whether the product has substantial\n          commercial, industrial or non-consumer uses, unless such uses\n          represent the only significant mode of use of the product.\n        \u003c/p\u003e\n\n        \u003cp\u003e\n          \u0026quot;Installation Information\u0026quot; for a User Product means any methods,\n          procedures, authorization keys, or other information required\n          to install and execute modified versions of a covered work in\n          that User Product from a modified version of its Corresponding\n          Source. The information must suffice to ensure that the continued\n          functioning of the modified object code is in no case prevented\n          or interfered with solely because modification has been made.\n        \u003c/p\u003e\n\n        \u003cp\u003e\n          If you convey an object code work under this section in, or with,\n          or specifically for use in, a User Product, and the conveying\n          occurs as part of a transaction in which the right of possession\n          and use of the User Product is transferred to the recipient in\n          perpetuity or for a fixed term (regardless of how the transaction\n          is characterized), the Corresponding Source conveyed under this\n          section must be accompanied by the Installation Information.\n          But this requirement does not apply if neither you nor any third\n          party retains the ability to install modified object code on the\n          User Product (for example, the work has been installed in ROM).\n        \u003c/p\u003e\n\n        \u003cp\u003e\n          The requirement to provide Installation Information does not\n          include a requirement to continue to provide support service,\n          warranty, or updates for a work that has been modified\n          or installed by the recipient, or for the User Product in\n          which it has been modified or installed. Access to a network\n          may be denied when the modification itself materially and\n          adversely affects the operation of the network or violates\n          the rules and protocols for communication across the network.\n        \u003c/p\u003e\n\n        \u003cp\u003e\n          Corresponding Source conveyed, and Installation Information\n          provided, in accord with this section must be in a format that\n          is publicly documented (and with an implementation available\n          to the public in source code form), and must require no\n          special password or key for unpacking, reading or copying.\n        \u003c/p\u003e\n\n      \u003c/li\u003e\n      \n\u003cli\u003e\n        \u003cvar class\u003d"replaceable-license-text"\u003e 7.\u003c/var\u003e\n        Additional Terms.\u003cbr /\u003e\n\n        \u0026quot;Additional permissions\u0026quot; are terms that supplement the terms of this\n        License by making exceptions from one or more of its conditions.\n        Additional permissions that are applicable to the entire Program\n        shall be treated as though they were included in this License, to\n        the extent that they are valid under applicable law. If additional\n        permissions apply only to part of the Program, that part may be used\n        separately under those permissions, but the entire Program remains\n        governed by this License without regard to the additional permissions.\n        \u003cp\u003e\n          When you convey a copy of a covered work, you may at your option\n          remove any additional permissions from that copy, or from any part\n          of it. (Additional permissions may be written to require their own\n          removal in certain cases when you modify the work.) You may place\n          additional permissions on material, added by you to a covered work,\n          for which you have or can give appropriate copyright permission.\n        \u003c/p\u003e\n\n        \u003cp\u003e\n          Notwithstanding any other provision of this License, for material you\n          add to a covered work, you may (if authorized by the copyright holders\n          of that material) supplement the terms of this License with terms:\n        \u003c/p\u003e\n\n\u003cul style\u003d"list-style:none"\u003e\n          \n\u003cli\u003e\n            \u003cvar class\u003d"replaceable-license-text"\u003e a)\u003c/var\u003e\n            Disclaiming warranty or limiting liability differently\n            from the terms of sections 15 and 16 of this License; or\n          \u003c/li\u003e\n          \n\u003cli\u003e\n            \u003cvar class\u003d"replaceable-license-text"\u003e b)\u003c/var\u003e\n            Requiring preservation of specified reasonable legal\n            notices or author attributions in that material or in the\n            Appropriate Legal Notices displayed by works containing it; or\n          \u003c/li\u003e\n          \n\u003cli\u003e\n            \u003cvar class\u003d"replaceable-license-text"\u003e c)\u003c/var\u003e\n            Prohibiting misrepresentation of the origin of that material,\n            or requiring that modified versions of such material be marked\n            in reasonable ways as different from the original version; or\n          \u003c/li\u003e\n          \n\u003cli\u003e\n            \u003cvar class\u003d"replaceable-license-text"\u003e d)\u003c/var\u003e\n            Limiting the use for publicity purposes of names\n            of licensors or authors of the material; or\n          \u003c/li\u003e\n          \n\u003cli\u003e\n            \u003cvar class\u003d"replaceable-license-text"\u003e e)\u003c/var\u003e\n            Declining to grant rights under trademark law for use\n            of some trade names, trademarks, or service marks; or\n          \u003c/li\u003e\n          \n\u003cli\u003e\n            \u003cvar class\u003d"replaceable-license-text"\u003e f)\u003c/var\u003e\n            Requiring indemnification of licensors and authors of that\n            material by anyone who conveys the material (or modified\n            versions of it) with contractual assumptions of liability\n            to the recipient, for any liability that these contractual\n            assumptions directly impose on those licensors and authors.\n          \u003c/li\u003e\n        \n\u003c/ul\u003e\n        \u003cp\u003e\n          All other non-permissive additional terms are considered \u0026quot;further\n          restrictions\u0026quot; within the meaning of section 10. If the Program\n          as you received it, or any part of it, contains a notice stating\n          that it is governed by this License along with a term that is\n          a further restriction, you may remove that term. If a license\n          document contains a further restriction but permits relicensing or\n          conveying under this License, you may add to a covered work material\n          governed by the terms of that license document, provided that the\n          further restriction does not survive such relicensing or conveying.\n        \u003c/p\u003e\n\n        \u003cp\u003e\n          If you add terms to a covered work in accord with this\n          section, you must place, in the relevant source files, a\n          statement of the additional terms that apply to those files,\n          or a notice indicating where to find the applicable terms.\n        \u003c/p\u003e\n\n        \u003cp\u003e\n          Additional terms, permissive or non-permissive, may be\n          stated in the form of a separately written license, or stated\n          as exceptions; the above requirements apply either way.\n        \u003c/p\u003e\n\n      \u003c/li\u003e\n      \n\u003cli\u003e\n        \u003cvar class\u003d"replaceable-license-text"\u003e 8.\u003c/var\u003e\n        Termination.\u003cbr /\u003e\n\n        You may not propagate or modify a covered work except as\n        expressly provided under this License. Any attempt otherwise\n        to propagate or modify it is void, and will automatically\n        terminate your rights under this License (including any patent\n        licenses granted under the third paragraph of section 11).\n        \u003cp\u003e\n          However, if you cease all violation of this License, then your\n          license from a particular copyright holder is reinstated (a)\n          provisionally, unless and until the copyright holder explicitly\n          and finally terminates your license, and (b) permanently, if\n          the copyright holder fails to notify you of the violation by\n          some reasonable means prior to 60 days after the cessation.\n        \u003c/p\u003e\n\n        \u003cp\u003e\n          Moreover, your license from a particular copyright holder is\n          reinstated permanently if the copyright holder notifies you\n          of the violation by some reasonable means, this is the first\n          time you have received notice of violation of this License\n          (for any work) from that copyright holder, and you cure the\n          violation prior to 30 days after your receipt of the notice.\n        \u003c/p\u003e\n\n        \u003cp\u003e\n          Termination of your rights under this section does not\n          terminate the licenses of parties who have received copies or\n          rights from you under this License. If your rights have been\n          terminated and not permanently reinstated, you do not qualify\n          to receive new licenses for the same material under section 10.\n        \u003c/p\u003e\n\n      \u003c/li\u003e\n      \n\u003cli\u003e\n        \u003cvar class\u003d"replaceable-license-text"\u003e 9.\u003c/var\u003e\n        Acceptance Not Required for Having Copies.\u003cbr /\u003e\n\n        You are not required to accept this License in order to receive or\n        run a copy of the Program. Ancillary propagation of a covered work\n        occurring solely as a consequence of using peer-to-peer transmission\n        to receive a copy likewise does not require acceptance. However,\n        nothing other than this License grants you permission to propagate\n        or modify any covered work. These actions infringe copyright if you\n        do not accept this License. Therefore, by modifying or propagating a\n        covered work, you indicate your acceptance of this License to do so.\n      \u003c/li\u003e\n      \n\u003cli\u003e\n        \u003cvar class\u003d"replaceable-license-text"\u003e 10.\u003c/var\u003e\n        Automatic Licensing of Downstream Recipients.\u003cbr /\u003e\n\n        Each time you convey a covered work, the recipient automatically\n        receives a license from the original licensors, to run, modify and\n        propagate that work, subject to this License. You are not responsible\n        for enforcing compliance by third parties with this License.\n        \u003cp\u003e\n          An \u0026quot;entity transaction\u0026quot; is a transaction transferring control of\n          an organization, or substantially all assets of one, or subdividing\n          an organization, or merging organizations. If propagation of a\n          covered work results from an entity transaction, each party to that\n          transaction who receives a copy of the work also receives whatever\n          licenses to the work the party\u0026apos;s predecessor in interest had or could\n          give under the previous paragraph, plus a right to possession of the\n          Corresponding Source of the work from the predecessor in interest,\n          if the predecessor has it or can get it with reasonable efforts.\n        \u003c/p\u003e\n\n        \u003cp\u003e\n          You may not impose any further restrictions on the exercise of the\n          rights granted or affirmed under this License. For example, you\n          may not impose a license fee, royalty, or other charge for exercise\n          of rights granted under this License, and you may not initiate\n          litigation (including a cross-claim or counterclaim in a lawsuit)\n          alleging that any patent claim is infringed by making, using, selling,\n          offering for sale, or importing the Program or any portion of it.\n        \u003c/p\u003e\n\n      \u003c/li\u003e\n      \n\u003cli\u003e\n        \u003cvar class\u003d"replaceable-license-text"\u003e 11.\u003c/var\u003e\n        Patents.\u003cbr /\u003e\n\n        A \u0026quot;contributor\u0026quot; is a copyright holder who authorizes use under this\n        License of the Program or a work on which the Program is based. The\n        work thus licensed is called the contributor\u0026apos;s \u0026quot;contributor version\u0026quot;.\n        \u003cp\u003e\n          A contributor\u0026apos;s \u0026quot;essential patent claims\u0026quot; are all patent\n          claims owned or controlled by the contributor, whether already\n          acquired or hereafter acquired, that would be infringed by some\n          manner, permitted by this License, of making, using, or selling\n          its contributor version, but do not include claims that would\n          be infringed only as a consequence of further modification\n          of the contributor version. For purposes of this definition,\n          \u0026quot;control\u0026quot; includes the right to grant patent sublicenses in\n          a manner consistent with the requirements of this License.\n        \u003c/p\u003e\n\n        \u003cp\u003e\n          Each contributor grants you a non-exclusive, worldwide, royalty-free\n          patent license under the contributor\u0026apos;s essential patent claims,\n          to make, use, sell, offer for sale, import and otherwise run,\n          modify and propagate the contents of its contributor version.\n        \u003c/p\u003e\n\n        \u003cp\u003e\n          In the following three paragraphs, a \u0026quot;patent license\u0026quot; is any\n          express agreement or commitment, however denominated, not to\n          enforce a patent (such as an express permission to practice\n          a patent or covenant not to sue for patent infringement). To\n          \u0026quot;grant\u0026quot; such a patent license to a party means to make such an\n          agreement or commitment not to enforce a patent against the party.\n        \u003c/p\u003e\n\n        \u003cp\u003e\n          If you convey a covered work, knowingly relying on a patent license,\n          and the Corresponding Source of the work is not available for anyone\n          to copy, free of charge and under the terms of this License, through\n          a publicly available network server or other readily accessible\n          means, then you must either (1) cause the Corresponding Source to\n          be so available, or (2) arrange to deprive yourself of the benefit\n          of the patent license for this particular work, or (3) arrange, in\n          a manner consistent with the requirements of this License, to extend\n          the patent license to downstream recipients. \u0026quot;Knowingly relying\u0026quot;\n          means you have actual knowledge that, but for the patent license, your\n          conveying the covered work in a country, or your recipient\u0026apos;s use of\n          the covered work in a country, would infringe one or more identifiable\n          patents in that country that you have reason to believe are valid.\n        \u003c/p\u003e\n\n        \u003cp\u003e\n          If, pursuant to or in connection with a single transaction or\n          arrangement, you convey, or propagate by procuring conveyance\n          of, a covered work, and grant a patent license to some of the\n          parties receiving the covered work authorizing them to use,\n          propagate, modify or convey a specific copy of the covered work,\n          then the patent license you grant is automatically extended\n          to all recipients of the covered work and works based on it.\n        \u003c/p\u003e\n\n        \u003cp\u003e\n          A patent license is \u0026quot;discriminatory\u0026quot; if it does not include within the\n          scope of its coverage, prohibits the exercise of, or is conditioned\n          on the non-exercise of one or more of the rights that are specifically\n          granted under this License. You may not convey a covered work if\n          you are a party to an arrangement with a third party that is in the\n          business of distributing software, under which you make payment to\n          the third party based on the extent of your activity of conveying\n          the work, and under which the third party grants, to any of the\n          parties who would receive the covered work from you, a discriminatory\n          patent license (a) in connection with copies of the covered work\n          conveyed by you (or copies made from those copies), or (b) primarily\n          for and in connection with specific products or compilations that\n          contain the covered work, unless you entered into that arrangement,\n          or that patent license was granted, prior to 28 March 2007.\n        \u003c/p\u003e\n\n        \u003cp\u003e\n          Nothing in this License shall be construed as excluding or\n          limiting any implied license or other defenses to infringement\n          that may otherwise be available to you under applicable patent law.\n        \u003c/p\u003e\n\n      \u003c/li\u003e\n      \n\u003cli\u003e\n        \u003cvar class\u003d"replaceable-license-text"\u003e 12.\u003c/var\u003e\n        No Surrender of Others\u0026apos; Freedom.\u003cbr /\u003e\n\n        If conditions are imposed on you (whether by court order, agreement\n        or otherwise) that contradict the conditions of this License,\n        they do not excuse you from the conditions of this License. If\n        you cannot convey a covered work so as to satisfy simultaneously\n        your obligations under this License and any other pertinent\n        obligations, then as a consequence you may not convey it at all.\n        For example, if you agree to terms that obligate you to collect\n        a royalty for further conveying from those to whom you convey the\n        Program, the only way you could satisfy both those terms and this\n        License would be to refrain entirely from conveying the Program.\n      \u003c/li\u003e\n      \n\u003cli\u003e\n        \u003cvar class\u003d"replaceable-license-text"\u003e 13.\u003c/var\u003e\n        Use with the GNU Affero General Public License.\u003cbr /\u003e\n\n        Notwithstanding any other provision of this License, you have\n        permission to link or combine any covered work with a work licensed\n        under version 3 of the GNU Affero General Public License into\n        a single combined work, and to convey the resulting work. The\n        terms of this License will continue to apply to the part which\n        is the covered work, but the special requirements of the GNU\n        Affero General Public License, section 13, concerning interaction\n        through a network will apply to the combination as such.\n      \u003c/li\u003e\n      \n\u003cli\u003e\n        \u003cvar class\u003d"replaceable-license-text"\u003e 14.\u003c/var\u003e\n        Revised Versions of this License.\u003cbr /\u003e\n\n        The Free Software Foundation may publish revised and/or new\n        versions of the GNU General Public License from time to time. Such\n        new versions will be similar in spirit to the present version,\n        but may differ in detail to address new problems or concerns.\n        \u003cp\u003e\n          Each version is given a distinguishing version number. If the\n          Program specifies that a certain numbered version of the GNU\n          General Public License \u0026quot;or any later version\u0026quot; applies to it,\n          you have the option of following the terms and conditions either\n          of that numbered version or of any later version published by\n          the Free Software Foundation. If the Program does not specify a\n          version number of the GNU General Public License, you may choose\n          any version ever published by the Free Software Foundation.\n        \u003c/p\u003e\n\n        \u003cp\u003e\n          If the Program specifies that a proxy can decide which future\n          versions of the GNU General Public License can be used, that\n          proxy\u0026apos;s public statement of acceptance of a version permanently\n          authorizes you to choose that version for the Program.\n        \u003c/p\u003e\n\n        \u003cp\u003e\n          Later license versions may give you additional or\n          different permissions. However, no additional obligations\n          are imposed on any author or copyright holder as a\n          result of your choosing to follow a later version.\n        \u003c/p\u003e\n\n      \u003c/li\u003e\n      \n\u003cli\u003e\n        \u003cvar class\u003d"replaceable-license-text"\u003e 15.\u003c/var\u003e\n        Disclaimer of Warranty.\u003cbr /\u003e\n\n        THERE IS NO WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY\n        APPLICABLE LAW. EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT\n        HOLDERS AND/OR OTHER PARTIES PROVIDE THE PROGRAM \u0026quot;AS IS\u0026quot; WITHOUT\n        WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT\n        LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR\n        A PARTICULAR PURPOSE. THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE\n        OF THE PROGRAM IS WITH YOU. SHOULD THE PROGRAM PROVE DEFECTIVE, YOU\n        ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.\n      \u003c/li\u003e\n      \n\u003cli\u003e\n        \u003cvar class\u003d"replaceable-license-text"\u003e 16.\u003c/var\u003e\n        Limitation of Liability.\u003cbr /\u003e\n\n        IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING\n        WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MODIFIES AND/OR\n        CONVEYS THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES,\n        INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES\n        ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING\n        BUT NOT LIMITED TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE\n        OR LOSSES SUSTAINED BY YOU OR THIRD PARTIES OR A FAILURE OF THE\n        PROGRAM TO OPERATE WITH ANY OTHER PROGRAMS), EVEN IF SUCH HOLDER\n        OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.\n      \u003c/li\u003e\n      \n\u003cli\u003e\n        \u003cvar class\u003d"replaceable-license-text"\u003e 17.\u003c/var\u003e\n        Interpretation of Sections 15 and 16.\n    \u003cp\u003e\n      If the disclaimer of warranty and limitation of liability\n      provided above cannot be given local legal effect according to\n      their terms, reviewing courts shall apply local law that most\n      closely approximates an absolute waiver of all civil liability in\n      connection with the Program, unless a warranty or assumption of\n      liability accompanies a copy of the Program in return for a fee.\n    \u003c/p\u003e\n\n      \u003c/li\u003e\n    \n\u003c/ul\u003e\n    \u003cdiv class\u003d"optional-license-text"\u003e \n      \u003cp\u003e\n        END OF TERMS AND CONDITIONS\n      \u003c/p\u003e\n\n      \u003cp\u003e\n        How to Apply These Terms to Your New Programs\n      \u003c/p\u003e\n\n      \u003cp\u003e\n        If you develop a new program, and you want it to be\n        of the greatest possible use to the public, the best\n        way to achieve this is to make it free software which\n        everyone can redistribute and change under these terms.\n      \u003c/p\u003e\n\n      \u003cp\u003e\n        To do so, attach the following notices to the program. It is safest\n        to attach them to the start of each source file to most effectively\n        state the exclusion of warranty; and each file should have at least\n        the \u0026quot;copyright\u0026quot; line and a pointer to where the full notice is found.\n      \u003c/p\u003e\n\n      \u003cp\u003e\n        \u003cvar class\u003d"replaceable-license-text"\u003e \u0026lt;one line to give the program\u0026apos;s name and\n        a brief idea of what it does.\u0026gt;\u003c/var\u003e\u003cbr /\u003e\n\n        Copyright (C) \u003cvar class\u003d"replaceable-license-text"\u003e \u0026lt;year\u0026gt; \u0026lt;name of author\u0026gt;\u003c/var\u003e\n      \u003c/p\u003e\n\n      \u003cp\u003e\n        This program is free software: you can redistribute it and/or\n        modify it under the terms of the GNU General Public License\n        as published by the Free Software Foundation, either version\n        3 of the License, or (at your option) any later version.\n      \u003c/p\u003e\n\n      \u003cp\u003e\n        This program is distributed in the hope that it will be\n        useful, but WITHOUT ANY WARRANTY; without even the implied\n        warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR\n        PURPOSE. See the GNU General Public License for more details.\n      \u003c/p\u003e\n\n      \u003cp\u003e\n        You should have received a copy of the GNU General\n\tPublic License along with this program. If not, see\n\t\u0026lt;https://www.gnu.org/licenses/\u0026gt;.\n      \u003c/p\u003e\n\n      \u003cp\u003e\n        Also add information on how to contact you by electronic and paper mail.\n      \u003c/p\u003e\n\n      \u003cp\u003e\n        If the program does terminal interaction, make it output a\n        short notice like this when it starts in an interactive mode:\n      \u003c/p\u003e\n\n      \u003cp\u003e\n\t\u0026lt;program\u0026gt; Copyright (C) \u0026lt;year\u0026gt;\n\t\u0026lt;name of author\u0026gt;\u003cbr /\u003e\n\n        This program comes with ABSOLUTELY NO\n        WARRANTY; for details type `show w\u0026apos;.\u003cbr /\u003e\n\n        This is free software, and you are welcome to redistribute\n        it under certain conditions; type `show c\u0026apos; for details.\n      \u003c/p\u003e\n\n      \u003cp\u003e\n        The hypothetical commands `show w\u0026apos; and `show c\u0026apos; should\n        show the appropriate parts of the General Public License.\n        Of course, your program\u0026apos;s commands might be different;\n        for a GUI interface, you would use an \u0026quot;about box\u0026quot;.\n      \u003c/p\u003e\n\n      \u003cp\u003e\n        You should also get your employer (if you work as a\n        programmer) or school, if any, to sign a \u0026quot;copyright disclaimer\u0026quot;\n        for the program, if necessary. For more information on\n\tthis, and how to apply and follow the GNU GPL, see\n\t\u0026lt;https://www.gnu.org/licenses/\u0026gt;.\n      \u003c/p\u003e\n\n      \u003cp\u003e\n        The GNU General Public License does not permit incorporating\n        your program into proprietary programs. If your program is a\n        subroutine library, you may consider it more useful to permit\n        linking proprietary applications with the library. If this\n        is what you want to do, use the GNU Lesser General Public\n\tLicense instead of this License. But first, please read\n\t\u0026lt;https:\u003cvar class\u003d"replaceable-license-text"\u003e //www.gnu.org/licenses/why-not-lgpl.html\u0026gt;.\u003c/var\u003e\n      \u003c/p\u003e\n\n    \u003c/div\u003e\n    ',
    "standardLicenseHeaderHtml": '\n      \u003cp\u003e\n        \u003cvar class\u003d"replaceable-license-text"\u003e \u0026lt;one line to give the program\u0026apos;s name and\n        a brief idea of what it does.\u0026gt;\u003c/var\u003e\u003cbr /\u003e\n\n        Copyright (C) \u003cvar class\u003d"replaceable-license-text"\u003e \u0026lt;year\u0026gt; \u0026lt;name of author\u0026gt;\u003c/var\u003e\n      \u003c/p\u003e\n\n      \u003cp\u003e\n        This program is free software: you can redistribute it and/or\n        modify it under the terms of the GNU General Public License\n        as published by the Free Software Foundation, either version\n        3 of the License, or (at your option) any later version.\n      \u003c/p\u003e\n\n      \u003cp\u003e\n        This program is distributed in the hope that it will be\n        useful, but WITHOUT ANY WARRANTY; without even the implied\n        warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR\n        PURPOSE. See the GNU General Public License for more details.\n      \u003c/p\u003e\n\n      \u003cp\u003e\n        You should have received a copy of the GNU General\n\tPublic License along with this program. If not, see\n\t\u0026lt;https://www.gnu.org/licenses/\u0026gt;.\n      \u003c/p\u003e\n\n      ',
}

AGPL_3__0_OR_LATER_LICENSE_DATA: DumpMapping[Dump] = {
    "isDeprecatedLicenseId": False,
    "isFsfLibre": True,
    "licenseText": 'GNU AFFERO GENERAL PUBLIC LICENSE\nVersion 3, 19 November 2007\n\nCopyright (C) 2007 Free Software Foundation, Inc. \u003chttp://fsf.org/\u003e\n\nEveryone is permitted to copy and distribute verbatim copies of this license document, but changing it is not allowed.\n\n                            Preamble\n\nThe GNU Affero General Public License is a free, copyleft license for software and other kinds of works, specifically designed to ensure cooperation with the community in the case of network server software.\n\nThe licenses for most software and other practical works are designed to take away your freedom to share and change the works.  By contrast, our General Public Licenses are intended to guarantee your freedom to share and change all versions of a program--to make sure it remains free software for all its users.\n\nWhen we speak of free software, we are referring to freedom, not price.  Our General Public Licenses are designed to make sure that you have the freedom to distribute copies of free software (and charge for them if you wish), that you receive source code or can get it if you want it, that you can change the software or use pieces of it in new free programs, and that you know you can do these things.\n\nDevelopers that use our General Public Licenses protect your rights with two steps: (1) assert copyright on the software, and (2) offer you this License which gives you legal permission to copy, distribute and/or modify the software.\n\nA secondary benefit of defending all users\u0027 freedom is that improvements made in alternate versions of the program, if they receive widespread use, become available for other developers to incorporate.  Many developers of free software are heartened and encouraged by the resulting cooperation.  However, in the case of software used on network servers, this result may fail to come about. The GNU General Public License permits making a modified version and letting the public access it on a server without ever releasing its source code to the public.\n\nThe GNU Affero General Public License is designed specifically to ensure that, in such cases, the modified source code becomes available to the community.  It requires the operator of a network server to provide the source code of the modified version running there to the users of that server.  Therefore, public use of a modified version, on a publicly accessible server, gives the public access to the source code of the modified version.\n\nAn older license, called the Affero General Public License and published by Affero, was designed to accomplish similar goals.  This is a different license, not a version of the Affero GPL, but Affero has released a new version of the Affero GPL which permits relicensing under this license.\n\nThe precise terms and conditions for copying, distribution and modification follow.\n\n                       TERMS AND CONDITIONS\n\n0. Definitions.\n\n"This License" refers to version 3 of the GNU Affero General Public License.\n\n"Copyright" also means copyright-like laws that apply to other kinds of works, such as semiconductor masks.\n\n"The Program" refers to any copyrightable work licensed under this License.  Each licensee is addressed as "you".  "Licensees" and "recipients" may be individuals or organizations.\n\nTo "modify" a work means to copy from or adapt all or part of the work in a fashion requiring copyright permission, other than the making of an exact copy.  The resulting work is called a "modified version" of the earlier work or a work "based on" the earlier work.\n\nA "covered work" means either the unmodified Program or a work based on the Program.\n\nTo "propagate" a work means to do anything with it that, without permission, would make you directly or secondarily liable for infringement under applicable copyright law, except executing it on a computer or modifying a private copy.  Propagation includes copying, distribution (with or without modification), making available to the public, and in some countries other activities as well.\n\nTo "convey" a work means any kind of propagation that enables other parties to make or receive copies.  Mere interaction with a user through a computer network, with no transfer of a copy, is not conveying.\n\nAn interactive user interface displays "Appropriate Legal Notices" to the extent that it includes a convenient and prominently visible feature that (1) displays an appropriate copyright notice, and (2) tells the user that there is no warranty for the work (except to the extent that warranties are provided), that licensees may convey the work under this License, and how to view a copy of this License.  If the interface presents a list of user commands or options, such as a menu, a prominent item in the list meets this criterion.\n\n1. Source Code.\nThe "source code" for a work means the preferred form of the work for making modifications to it.  "Object code" means any non-source form of a work.\n\nA "Standard Interface" means an interface that either is an official standard defined by a recognized standards body, or, in the case of interfaces specified for a particular programming language, one that is widely used among developers working in that language.\n\nThe "System Libraries" of an executable work include anything, other than the work as a whole, that (a) is included in the normal form of packaging a Major Component, but which is not part of that Major Component, and (b) serves only to enable use of the work with that Major Component, or to implement a Standard Interface for which an implementation is available to the public in source code form.  A "Major Component", in this context, means a major essential component (kernel, window system, and so on) of the specific operating system (if any) on which the executable work runs, or a compiler used to produce the work, or an object code interpreter used to run it.\n\nThe "Corresponding Source" for a work in object code form means all the source code needed to generate, install, and (for an executable work) run the object code and to modify the work, including scripts to control those activities.  However, it does not include the work\u0027s System Libraries, or general-purpose tools or generally available free programs which are used unmodified in performing those activities but which are not part of the work.  For example, Corresponding Source includes interface definition files associated with source files for the work, and the source code for shared libraries and dynamically linked subprograms that the work is specifically designed to require, such as by intimate data communication or control flow between those\nsubprograms and other parts of the work.\n\nThe Corresponding Source need not include anything that users can regenerate automatically from other parts of the Corresponding Source.\n\nThe Corresponding Source for a work in source code form is that same work.\n\n2. Basic Permissions.\nAll rights granted under this License are granted for the term of copyright on the Program, and are irrevocable provided the stated conditions are met.  This License explicitly affirms your unlimited permission to run the unmodified Program.  The output from running a covered work is covered by this License only if the output, given its content, constitutes a covered work.  This License acknowledges your rights of fair use or other equivalent, as provided by copyright law.\n\nYou may make, run and propagate covered works that you do not convey, without conditions so long as your license otherwise remains in force.  You may convey covered works to others for the sole purpose of having them make modifications exclusively for you, or provide you with facilities for running those works, provided that you comply with the terms of this License in conveying all material for which you do not control copyright.  Those thus making or running the covered works for you must do so exclusively on your behalf, under your direction and control, on terms that prohibit them from making any copies of your copyrighted material outside their relationship with you.\n\nConveying under any other circumstances is permitted solely under the conditions stated below.  Sublicensing is not allowed; section 10 makes it unnecessary.\n\n3. Protecting Users\u0027 Legal Rights From Anti-Circumvention Law.\nNo covered work shall be deemed part of an effective technological measure under any applicable law fulfilling obligations under article 11 of the WIPO copyright treaty adopted on 20 December 1996, or similar laws prohibiting or restricting circumvention of such measures.\n\nWhen you convey a covered work, you waive any legal power to forbid circumvention of technological measures to the extent such circumvention is effected by exercising rights under this License with respect to the covered work, and you disclaim any intention to limit operation or modification of the work as a means of enforcing, against the work\u0027s users, your or third parties\u0027 legal rights to forbid circumvention of technological measures.\n\n4. Conveying Verbatim Copies.\nYou may convey verbatim copies of the Program\u0027s source code as you receive it, in any medium, provided that you conspicuously and appropriately publish on each copy an appropriate copyright notice; keep intact all notices stating that this License and any non-permissive terms added in accord with section 7 apply to the code; keep intact all notices of the absence of any warranty; and give all recipients a copy of this License along with the Program.\n\nYou may charge any price or no price for each copy that you convey, and you may offer support or warranty protection for a fee.\n\n5. Conveying Modified Source Versions.\nYou may convey a work based on the Program, or the modifications to produce it from the Program, in the form of source code under the terms of section 4, provided that you also meet all of these conditions:\n\n    a) The work must carry prominent notices stating that you modified it, and giving a relevant date.\n\n    b) The work must carry prominent notices stating that it is released under this License and any conditions added under section 7.  This requirement modifies the requirement in section 4 to "keep intact all notices".\n\n    c) You must license the entire work, as a whole, under this License to anyone who comes into possession of a copy.  This License will therefore apply, along with any applicable section 7 additional terms, to the whole of the work, and all its parts, regardless of how they are packaged.  This License gives no permission to license the work in any other way, but it does not invalidate such permission if you have separately received it.\n\n    d) If the work has interactive user interfaces, each must display Appropriate Legal Notices; however, if the Program has interactive interfaces that do not display Appropriate Legal Notices, your work need not make them do so.\n\nA compilation of a covered work with other separate and independent works, which are not by their nature extensions of the covered work, and which are not combined with it such as to form a larger program, in or on a volume of a storage or distribution medium, is called an "aggregate" if the compilation and its resulting copyright are not used to limit the access or legal rights of the compilation\u0027s users beyond what the individual works permit.  Inclusion of a covered work in an aggregate does not cause this License to apply to the other parts of the aggregate.\n\n6. Conveying Non-Source Forms.\nYou may convey a covered work in object code form under the terms of sections 4 and 5, provided that you also convey the machine-readable Corresponding Source under the terms of this License, in one of these ways:\n\n    a) Convey the object code in, or embodied in, a physical product (including a physical distribution medium), accompanied by the Corresponding Source fixed on a durable physical medium customarily used for software interchange.\n\n    b) Convey the object code in, or embodied in, a physical product (including a physical distribution medium), accompanied by a written offer, valid for at least three years and valid for as long as you offer spare parts or customer support for that product model, to give anyone who possesses the object code either (1) a copy of the Corresponding Source for all the software in the product that is covered by this License, on a durable physical medium customarily used for software interchange, for a price no more than your reasonable cost of physically performing this conveying of source, or (2) access to copy the Corresponding Source from a network server at no charge.\n\n    c) Convey individual copies of the object code with a copy of the written offer to provide the Corresponding Source.  This alternative is allowed only occasionally and noncommercially, and only if you received the object code with such an offer, in accord with subsection 6b.\n\n    d) Convey the object code by offering access from a designated place (gratis or for a charge), and offer equivalent access to the Corresponding Source in the same way through the same place at no further charge.  You need not require recipients to copy the Corresponding Source along with the object code.  If the place to copy the object code is a network server, the Corresponding Source may be on a different server (operated by you or a third party) that supports equivalent copying facilities, provided you maintain clear directions next to the object code saying where to find the Corresponding Source.  Regardless of what server hosts the Corresponding Source, you remain obligated to ensure that it is available for as long as needed to satisfy these requirements.\n\n    e) Convey the object code using peer-to-peer transmission, provided you inform other peers where the object code and Corresponding Source of the work are being offered to the general public at no charge under subsection 6d.\n\nA separable portion of the object code, whose source code is excluded from the Corresponding Source as a System Library, need not be included in conveying the object code work.\n\nA "User Product" is either (1) a "consumer product", which means any tangible personal property which is normally used for personal, family, or household purposes, or (2) anything designed or sold for incorporation into a dwelling.  In determining whether a product is a consumer product, doubtful cases shall be resolved in favor of coverage.  For a particular product received by a particular user, "normally used" refers to a typical or common use of that class of product, regardless of the status of the particular user or of the way in which the particular user actually uses, or expects or is expected to use, the product.  A product is a consumer product regardless of whether the product has substantial commercial, industrial or non-consumer uses, unless such uses represent the only significant mode of use of the product.\n\n"Installation Information" for a User Product means any methods, procedures, authorization keys, or other information required to install and execute modified versions of a covered work in that User Product from a modified version of its Corresponding Source.  The information must suffice to ensure that the continued functioning of the modified object code is in no case prevented or interfered with solely because modification has been made.\n\nIf you convey an object code work under this section in, or with, or specifically for use in, a User Product, and the conveying occurs as part of a transaction in which the right of possession and use of the User Product is transferred to the recipient in perpetuity or for a fixed term (regardless of how the transaction is characterized), the Corresponding Source conveyed under this section must be accompanied by the Installation Information.  But this requirement does not apply if neither you nor any third party retains the ability to install modified object code on the User Product (for example, the work has been installed in ROM).\n\nThe requirement to provide Installation Information does not include a requirement to continue to provide support service, warranty, or updates for a work that has been modified or installed by the recipient, or for the User Product in which it has been modified or installed.  Access to a network may be denied when the modification itself materially and adversely affects the operation of the network or violates the rules and protocols for communication across the network.\n\nCorresponding Source conveyed, and Installation Information provided, in accord with this section must be in a format that is publicly documented (and with an implementation available to the public in source code form), and must require no special password or key for unpacking, reading or copying.\n\n7. Additional Terms.\n"Additional permissions" are terms that supplement the terms of this License by making exceptions from one or more of its conditions. Additional permissions that are applicable to the entire Program shall be treated as though they were included in this License, to the extent that they are valid under applicable law.  If additional permissions apply only to part of the Program, that part may be used separately under those permissions, but the entire Program remains governed by this License without regard to the additional permissions.\n\nWhen you convey a copy of a covered work, you may at your option remove any additional permissions from that copy, or from any part of it.  (Additional permissions may be written to require their own removal in certain cases when you modify the work.)  You may place additional permissions on material, added by you to a covered work, for which you have or can give appropriate copyright permission.\n\nNotwithstanding any other provision of this License, for material you add to a covered work, you may (if authorized by the copyright holders of that material) supplement the terms of this License with terms:\n\n    a) Disclaiming warranty or limiting liability differently from the terms of sections 15 and 16 of this License; or\n\n    b) Requiring preservation of specified reasonable legal notices or author attributions in that material or in the Appropriate Legal Notices displayed by works containing it; or\n\n    c) Prohibiting misrepresentation of the origin of that material, or requiring that modified versions of such material be marked in reasonable ways as different from the original version; or\n\n    d) Limiting the use for publicity purposes of names of licensors or authors of the material; or\n\n    e) Declining to grant rights under trademark law for use of some trade names, trademarks, or service marks; or\n\n    f) Requiring indemnification of licensors and authors of that material by anyone who conveys the material (or modified versions of it) with contractual assumptions of liability to the recipient, for any liability that these contractual assumptions directly impose on those licensors and authors.\n\nAll other non-permissive additional terms are considered "further restrictions" within the meaning of section 10.  If the Program as you received it, or any part of it, contains a notice stating that it is governed by this License along with a term that is a further restriction, you may remove that term.  If a license document contains a further restriction but permits relicensing or conveying under this License, you may add to a covered work material governed by the terms of that license document, provided that the further restriction does not survive such relicensing or conveying.\n\nIf you add terms to a covered work in accord with this section, you must place, in the relevant source files, a statement of the additional terms that apply to those files, or a notice indicating where to find the applicable terms.\n\nAdditional terms, permissive or non-permissive, may be stated in the form of a separately written license, or stated as exceptions; the above requirements apply either way.\n\n8. Termination.\n\nYou may not propagate or modify a covered work except as expressly provided under this License.  Any attempt otherwise to propagate or modify it is void, and will automatically terminate your rights under this License (including any patent licenses granted under the third paragraph of section 11).\n\nHowever, if you cease all violation of this License, then your license from a particular copyright holder is reinstated (a) provisionally, unless and until the copyright holder explicitly and finally terminates your license, and (b) permanently, if the copyright holder fails to notify you of the violation by some reasonable means prior to 60 days after the cessation.\n\nMoreover, your license from a particular copyright holder is reinstated permanently if the copyright holder notifies you of the violation by some reasonable means, this is the first time you have received notice of violation of this License (for any work) from that copyright holder, and you cure the violation prior to 30 days after your receipt of the notice.\n\nTermination of your rights under this section does not terminate the licenses of parties who have received copies or rights from you under this License.  If your rights have been terminated and not permanently reinstated, you do not qualify to receive new licenses for the same material under section 10.\n\n9. Acceptance Not Required for Having Copies.\n\nYou are not required to accept this License in order to receive or run a copy of the Program.  Ancillary propagation of a covered work occurring solely as a consequence of using peer-to-peer transmission to receive a copy likewise does not require acceptance.  However, nothing other than this License grants you permission to propagate or modify any covered work.  These actions infringe copyright if you do not accept this License.  Therefore, by modifying or propagating a covered work, you indicate your acceptance of this License to do so.\n\n10. Automatic Licensing of Downstream Recipients.\n\nEach time you convey a covered work, the recipient automatically receives a license from the original licensors, to run, modify and propagate that work, subject to this License.  You are not responsible for enforcing compliance by third parties with this License.\n\nAn "entity transaction" is a transaction transferring control of an organization, or substantially all assets of one, or subdividing an organization, or merging organizations.  If propagation of a covered work results from an entity transaction, each party to that transaction who receives a copy of the work also receives whatever licenses to the work the party\u0027s predecessor in interest had or could give under the previous paragraph, plus a right to possession of the Corresponding Source of the work from the predecessor in interest, if the predecessor has it or can get it with reasonable efforts.\n\nYou may not impose any further restrictions on the exercise of the rights granted or affirmed under this License.  For example, you may not impose a license fee, royalty, or other charge for exercise of rights granted under this License, and you may not initiate litigation (including a cross-claim or counterclaim in a lawsuit) alleging that any patent claim is infringed by making, using, selling, offering for sale, or importing the Program or any portion of it.\n\n11. Patents.\n\nA "contributor" is a copyright holder who authorizes use under this License of the Program or a work on which the Program is based.  The work thus licensed is called the contributor\u0027s "contributor version".\n\nA contributor\u0027s "essential patent claims" are all patent claims owned or controlled by the contributor, whether already acquired or hereafter acquired, that would be infringed by some manner, permitted by this License, of making, using, or selling its contributor version, but do not include claims that would be infringed only as a consequence of further modification of the contributor version.  For purposes of this definition, "control" includes the right to grant patent sublicenses in a manner consistent with the requirements of this License.\n\nEach contributor grants you a non-exclusive, worldwide, royalty-free patent license under the contributor\u0027s essential patent claims, to make, use, sell, offer for sale, import and otherwise run, modify and propagate the contents of its contributor version.\n\nIn the following three paragraphs, a "patent license" is any express agreement or commitment, however denominated, not to enforce a patent (such as an express permission to practice a patent or covenant not to sue for patent infringement).  To "grant" such a patent license to a party means to make such an agreement or commitment not to enforce a patent against the party.\n\nIf you convey a covered work, knowingly relying on a patent license, and the Corresponding Source of the work is not available for anyone to copy, free of charge and under the terms of this License, through a publicly available network server or other readily accessible means, then you must either (1) cause the Corresponding Source to be so available, or (2) arrange to deprive yourself of the benefit of the patent license for this particular work, or (3) arrange, in a manner consistent with the requirements of this License, to extend the patent\nlicense to downstream recipients.  "Knowingly relying" means you have actual knowledge that, but for the patent license, your conveying the covered work in a country, or your recipient\u0027s use of the covered work in a country, would infringe one or more identifiable patents in that country that you have reason to believe are valid.\n\nIf, pursuant to or in connection with a single transaction or arrangement, you convey, or propagate by procuring conveyance of, a covered work, and grant a patent license to some of the parties receiving the covered work authorizing them to use, propagate, modify or convey a specific copy of the covered work, then the patent license you grant is automatically extended to all recipients of the covered work and works based on it.\n\nA patent license is "discriminatory" if it does not include within the scope of its coverage, prohibits the exercise of, or is conditioned on the non-exercise of one or more of the rights that are specifically granted under this License.  You may not convey a covered work if you are a party to an arrangement with a third party that is in the business of distributing software, under which you make payment to the third party based on the extent of your activity of conveying the work, and under which the third party grants, to any of the parties who would receive the covered work from you, a discriminatory patent license (a) in connection with copies of the covered work conveyed by you (or copies made from those copies), or (b) primarily for and in connection with specific products or compilations that contain the covered work, unless you entered into that arrangement, or that patent license was granted, prior to 28 March 2007.\n\nNothing in this License shall be construed as excluding or limiting any implied license or other defenses to infringement that may otherwise be available to you under applicable patent law.\n\n12. No Surrender of Others\u0027 Freedom.\n\nIf conditions are imposed on you (whether by court order, agreement or otherwise) that contradict the conditions of this License, they do not excuse you from the conditions of this License.  If you cannot convey a covered work so as to satisfy simultaneously your obligations under this License and any other pertinent obligations, then as a consequence you may\nnot convey it at all.  For example, if you agree to terms that obligate you to collect a royalty for further conveying from those to whom you convey the Program, the only way you could satisfy both those terms and this License would be to refrain entirely from conveying the Program.\n\n13. Remote Network Interaction; Use with the GNU General Public License.\n\nNotwithstanding any other provision of this License, if you modify the Program, your modified version must prominently offer all users interacting with it remotely through a computer network (if your version supports such interaction) an opportunity to receive the Corresponding Source of your version by providing access to the Corresponding Source from a network server at no charge, through some standard or customary means of facilitating copying of software.  This Corresponding Source shall include the Corresponding Source for any work covered by version 3 of the GNU General Public License that is incorporated pursuant to the following paragraph.\n\nNotwithstanding any other provision of this License, you have permission to link or combine any covered work with a work licensed under version 3 of the GNU General Public License into a single combined work, and to convey the resulting work.  The terms of this License will continue to apply to the part which is the covered work, but the work with which it is combined will remain governed by version 3 of the GNU General Public License.\n\n14. Revised Versions of this License.\n\nThe Free Software Foundation may publish revised and/or new versions of the GNU Affero General Public License from time to time.  Such new versions will be similar in spirit to the present version, but may differ in detail to address new problems or concerns.\n\nEach version is given a distinguishing version number.  If the Program specifies that a certain numbered version of the GNU Affero General Public License "or any later version" applies to it, you have the option of following the terms and conditions either of that numbered version or of any later version published by the Free Software Foundation.  If the Program does not specify a version number of the GNU Affero General Public License, you may choose any version ever published by the Free Software Foundation.\n\nIf the Program specifies that a proxy can decide which future versions of the GNU Affero General Public License can be used, that proxy\u0027s public statement of acceptance of a version permanently authorizes you to choose that version for the Program.\n\nLater license versions may give you additional or different permissions.  However, no additional obligations are imposed on any author or copyright holder as a result of your choosing to follow a later version.\n\n15. Disclaimer of Warranty.\n\nTHERE IS NO WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.\n\n16. Limitation of Liability.\n\nIN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MODIFIES AND/OR CONVEYS THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.\n\n17. Interpretation of Sections 15 and 16.\n\nIf the disclaimer of warranty and limitation of liability provided above cannot be given local legal effect according to their terms, reviewing courts shall apply local law that most closely approximates an absolute waiver of all civil liability in connection with the Program, unless a warranty or assumption of liability accompanies a copy of the Program in return for a fee.\n\nEND OF TERMS AND CONDITIONS\n\n            How to Apply These Terms to Your New Programs\n\nIf you develop a new program, and you want it to be of the greatest possible use to the public, the best way to achieve this is to make it free software which everyone can redistribute and change under these terms.\n\nTo do so, attach the following notices to the program.  It is safest to attach them to the start of each source file to most effectively state the exclusion of warranty; and each file should have at least the "copyright" line and a pointer to where the full notice is found.\n\n     \u003cone line to give the program\u0027s name and a brief idea of what it does.\u003e\n     Copyright (C) \u003cyear\u003e  \u003cname of author\u003e\n\n     This program is free software: you can redistribute it and/or modify it under the terms of the GNU Affero General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.\n\n     This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Affero General Public License for more details.\n\n     You should have received a copy of the GNU Affero General Public License along with this program.  If not, see \u003chttp://www.gnu.org/licenses/\u003e.\n\nAlso add information on how to contact you by electronic and paper mail.\n\nIf your software can interact with users remotely through a computer network, you should also make sure that it provides a way for users to get its source.  For example, if your program is a web application, its interface could display a "Source" link that leads users to an archive of the code.  There are many ways you could offer source, and different solutions will be better for different programs; see section 13 for the specific requirements.\n\nYou should also get your employer (if you work as a programmer) or school, if any, to sign a "copyright disclaimer" for the program, if necessary. For more information on this, and how to apply and follow the GNU AGPL, see \u003chttp://www.gnu.org/licenses/\u003e.\n',
    "standardLicenseHeaderTemplate": '\u003c\u003cvar;name\u003d"description";original\u003d"\u003cone line to give the program\u0027s name and a brief idea of what it does.\u003e";match\u003d".+"\u003e\u003e\n\nCopyright (C) \u003c\u003cvar;name\u003d"copyright";original\u003d"\u003cyear\u003e \u003cname of author\u003e";match\u003d".+"\u003e\u003e\n\nThis program is free software: you can redistribute it and/or modify it under the terms of the GNU Affero General Public License as published by the Free Software Foundation, either version 3 of the License, or\u003c\u003cbeginOptional\u003e\u003e (at your option)\u003c\u003cendOptional\u003e\u003e any later version.\n\nThis program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more details.\n\nYou should have received a copy of the GNU Affero General Public License along with this program. If not, see \u003chttps://www.gnu.org/licenses/\u003e.\n\n',
    "standardLicenseTemplate": '\u003c\u003cbeginOptional\u003e\u003eGNU AFFERO GENERAL PUBLIC LICENSE\n\nVersion 3, 19 November 2007\n\n\u003c\u003cendOptional\u003e\u003e\n\nCopyright (C) 2007 Free Software Foundation, Inc. \u003chttps://fsf.org/\u003e\n\nEveryone is permitted to copy and distribute verbatim copies of this license document, but changing it is not allowed.\n\nPreamble\n\nThe GNU Affero General Public License is a free, copyleft license for software and other kinds of works, specifically designed to ensure cooperation with the community in the case of network server software.\n\nThe licenses for most software and other practical works are designed to take away your freedom to share and change the works. By contrast, our General Public Licenses are intended to guarantee your freedom to share and change all versions of a program--to make sure it remains free software for all its users.\n\nWhen we speak of free software, we are referring to freedom, not price. Our General Public Licenses are designed to make sure that you have the freedom to distribute copies of free software (and charge for them if you wish), that you receive source code or can get it if you want it, that you can change the software or use pieces of it in new free programs, and that you know you can do these things.\n\nDevelopers that use our General Public Licenses protect your rights with two steps: (1) assert copyright on the software, and (2) offer you this License which gives you legal permission to copy, distribute and/or modify the software.\n\nA secondary benefit of defending all users\u0027 freedom is that improvements made in alternate versions of the program, if they receive widespread use, become available for other developers to incorporate. Many developers of free software are heartened and encouraged by the resulting cooperation. However, in the case of software used on network servers, this result may fail to come about. The GNU General Public License permits making a modified version and letting the public access it on a server without ever releasing its source code to the public.\n\nThe GNU Affero General Public License is designed specifically to ensure that, in such cases, the modified source code becomes available to the community. It requires the operator of a network server to provide the source code of the modified version running there to the users of that server. Therefore, public use of a modified version, on a publicly accessible server, gives the public access to the source code of the modified version.\n\nAn older license, called the Affero General Public License and published by Affero, was designed to accomplish similar goals. This is a different license, not a version of the Affero GPL, but Affero has released a new version of the Affero GPL which permits relicensing under this license.\n\nThe precise terms and conditions for copying, distribution and modification follow.\n\nTERMS AND CONDITIONS\n\n   \u003c\u003cvar;name\u003d"bullet";original\u003d"0.";match\u003d".{0,20}"\u003e\u003e Definitions.\n\n   "This License" refers to version 3 of the GNU Affero General Public License.\n\n   "Copyright" also means copyright-like laws that apply to other kinds of works, such as semiconductor masks.\n\n   "The Program" refers to any copyrightable work licensed under this License. Each licensee is addressed as "you". "Licensees" and "recipients" may be individuals or organizations.\n\n   To "modify" a work means to copy from or adapt all or part of the work in a fashion requiring copyright permission, other than the making of an exact copy. The resulting work is called a "modified version" of the earlier work or a work "based on" the earlier work.\n\n   A "covered work" means either the unmodified Program or a work based on the Program.\n\n   To "propagate" a work means to do anything with it that, without permission, would make you directly or secondarily liable for infringement under applicable copyright law, except executing it on a computer or modifying a private copy. Propagation includes copying, distribution (with or without modification), making available to the public, and in some countries other activities as well.\n\n   To "convey" a work means any kind of propagation that enables other parties to make or receive copies. Mere interaction with a user through a computer network, with no transfer of a copy, is not conveying.\n\n   An interactive user interface displays "Appropriate Legal Notices" to the extent that it includes a convenient and prominently visible feature that (1) displays an appropriate copyright notice, and (2) tells the user that there is no warranty for the work (except to the extent that warranties are provided), that licensees may convey the work under this License, and how to view a copy of this License. If the interface presents a list of user commands or options, such as a menu, a prominent item in the list meets this criterion.\n\n   \u003c\u003cvar;name\u003d"bullet";original\u003d"1.";match\u003d".{0,20}"\u003e\u003e Source Code.\n\n   The "source code" for a work means the preferred form of the work for making modifications to it. "Object code" means any non-source form of a work.\n\n   A "Standard Interface" means an interface that either is an official standard defined by a recognized standards body, or, in the case of interfaces specified for a particular programming language, one that is widely used among developers working in that language.\n\n   The "System Libraries" of an executable work include anything, other than the work as a whole, that (a) is included in the normal form of packaging a Major Component, but which is not part of that Major Component, and (b) serves only to enable use of the work with that Major Component, or to implement a Standard Interface for which an implementation is available to the public in source code form. A "Major Component", in this context, means a major essential component (kernel, window system, and so on) of the specific operating system (if any) on which the executable work runs, or a compiler used to produce the work, or an object code interpreter used to run it.\n\n   The "Corresponding Source" for a work in object code form means all the source code needed to generate, install, and (for an executable work) run the object code and to modify the work, including scripts to control those activities. However, it does not include the work\u0027s System Libraries, or general-purpose tools or generally available free programs which are used unmodified in performing those activities but which are not part of the work. For example, Corresponding Source includes interface definition files associated with source files for the work, and the source code for shared libraries and dynamically linked subprograms that the work is specifically designed to require, such as by intimate data communication or control flow between those\n\n   subprograms and other parts of the work.\n\n   The Corresponding Source need not include anything that users can regenerate automatically from other parts of the Corresponding Source.\n\n   The Corresponding Source for a work in source code form is that same work.\n\n   \u003c\u003cvar;name\u003d"bullet";original\u003d"2.";match\u003d".{0,20}"\u003e\u003e Basic Permissions.\n\n   All rights granted under this License are granted for the term of copyright on the Program, and are irrevocable provided the stated conditions are met. This License explicitly affirms your unlimited permission to run the unmodified Program. The output from running a covered work is covered by this License only if the output, given its content, constitutes a covered work. This License acknowledges your rights of fair use or other equivalent, as provided by copyright law.\n\n   You may make, run and propagate covered works that you do not convey, without conditions so long as your license otherwise remains in force. You may convey covered works to others for the sole purpose of having them make modifications exclusively for you, or provide you with facilities for running those works, provided that you comply with the terms of this License in conveying all material for which you do not control copyright. Those thus making or running the covered works for you must do so exclusively on your behalf, under your direction and control, on terms that prohibit them from making any copies of your copyrighted material outside their relationship with you.\n\n   Conveying under any other circumstances is permitted solely under the conditions stated below. Sublicensing is not allowed; section 10 makes it unnecessary.\n\n   \u003c\u003cvar;name\u003d"bullet";original\u003d"3.";match\u003d".{0,20}"\u003e\u003e Protecting Users\u0027 Legal Rights From Anti-Circumvention Law.\n\n   No covered work shall be deemed part of an effective technological measure under any applicable law fulfilling obligations under article 11 of the WIPO copyright treaty adopted on 20 December 1996, or similar laws prohibiting or restricting circumvention of such measures.\n\n   When you convey a covered work, you waive any legal power to forbid circumvention of technological measures to the extent such circumvention is effected by exercising rights under this License with respect to the covered work, and you disclaim any intention to limit operation or modification of the work as a means of enforcing, against the work\u0027s users, your or third parties\u0027 legal rights to forbid circumvention of technological measures.\n\n   \u003c\u003cvar;name\u003d"bullet";original\u003d"4.";match\u003d".{0,20}"\u003e\u003e Conveying Verbatim Copies.\n\n   You may convey verbatim copies of the Program\u0027s source code as you receive it, in any medium, provided that you conspicuously and appropriately publish on each copy an appropriate copyright notice; keep intact all notices stating that this License and any non-permissive terms added in accord with section 7 apply to the code; keep intact all notices of the absence of any warranty; and give all recipients a copy of this License along with the Program.\n\n   You may charge any price or no price for each copy that you convey, and you may offer support or warranty protection for a fee.\n\n   \u003c\u003cvar;name\u003d"bullet";original\u003d"5.";match\u003d".{0,20}"\u003e\u003e Conveying Modified Source Versions.\n\n   You may convey a work based on the Program, or the modifications to produce it from the Program, in the form of source code under the terms of section 4, provided that you also meet all of these conditions:\n\n      \u003c\u003cvar;name\u003d"bullet";original\u003d"a)";match\u003d".{0,20}"\u003e\u003e The work must carry prominent notices stating that you modified it, and giving a relevant date.\n\n      \u003c\u003cvar;name\u003d"bullet";original\u003d"b)";match\u003d".{0,20}"\u003e\u003e The work must carry prominent notices stating that it is released under this License and any conditions added under section 7. This requirement modifies the requirement in section 4 to "keep intact all notices".\n\n      \u003c\u003cvar;name\u003d"bullet";original\u003d"c)";match\u003d".{0,20}"\u003e\u003e You must license the entire work, as a whole, under this License to anyone who comes into possession of a copy. This License will therefore apply, along with any applicable section 7 additional terms, to the whole of the work, and all its parts, regardless of how they are packaged. This License gives no permission to license the work in any other way, but it does not invalidate such permission if you have separately received it.\n\n      \u003c\u003cvar;name\u003d"bullet";original\u003d"d)";match\u003d".{0,20}"\u003e\u003e If the work has interactive user interfaces, each must display Appropriate Legal Notices; however, if the Program has interactive interfaces that do not display Appropriate Legal Notices, your work need not make them do so.\n\n   A compilation of a covered work with other separate and independent works, which are not by their nature extensions of the covered work, and which are not combined with it such as to form a larger program, in or on a volume of a storage or distribution medium, is called an "aggregate" if the compilation and its resulting copyright are not used to limit the access or legal rights of the compilation\u0027s users beyond what the individual works permit. Inclusion of a covered work in an aggregate does not cause this License to apply to the other parts of the aggregate.\n\n   \u003c\u003cvar;name\u003d"bullet";original\u003d"6.";match\u003d".{0,20}"\u003e\u003e Conveying Non-Source Forms.\n\n   You may convey a covered work in object code form under the terms of sections 4 and 5, provided that you also convey the machine-readable Corresponding Source under the terms of this License, in one of these ways:\n\n      \u003c\u003cvar;name\u003d"bullet";original\u003d"a)";match\u003d".{0,20}"\u003e\u003e Convey the object code in, or embodied in, a physical product (including a physical distribution medium), accompanied by the Corresponding Source fixed on a durable physical medium customarily used for software interchange.\n\n      \u003c\u003cvar;name\u003d"bullet";original\u003d"b)";match\u003d".{0,20}"\u003e\u003e Convey the object code in, or embodied in, a physical product (including a physical distribution medium), accompanied by a written offer, valid for at least three years and valid for as long as you offer spare parts or customer support for that product model, to give anyone who possesses the object code either (1) a copy of the Corresponding Source for all the software in the product that is covered by this License, on a durable physical medium customarily used for software interchange, for a price no more than your reasonable cost of physically performing this conveying of source, or (2) access to copy the Corresponding Source from a network server at no charge.\n\n      \u003c\u003cvar;name\u003d"bullet";original\u003d"c)";match\u003d".{0,20}"\u003e\u003e Convey individual copies of the object code with a copy of the written offer to provide the Corresponding Source. This alternative is allowed only occasionally and noncommercially, and only if you received the object code with such an offer, in accord with subsection 6b.\n\n      \u003c\u003cvar;name\u003d"bullet";original\u003d"d)";match\u003d".{0,20}"\u003e\u003e Convey the object code by offering access from a designated place (gratis or for a charge), and offer equivalent access to the Corresponding Source in the same way through the same place at no further charge. You need not require recipients to copy the Corresponding Source along with the object code. If the place to copy the object code is a network server, the Corresponding Source may be on a different server (operated by you or a third party) that supports equivalent copying facilities, provided you maintain clear directions next to the object code saying where to find the Corresponding Source. Regardless of what server hosts the Corresponding Source, you remain obligated to ensure that it is available for as long as needed to satisfy these requirements.\n\n      \u003c\u003cvar;name\u003d"bullet";original\u003d"e)";match\u003d".{0,20}"\u003e\u003e Convey the object code using peer-to-peer transmission, provided you inform other peers where the object code and Corresponding Source of the work are being offered to the general public at no charge under subsection 6d.\n\n   A separable portion of the object code, whose source code is excluded from the Corresponding Source as a System Library, need not be included in conveying the object code work.\n\n   A "User Product" is either (1) a "consumer product", which means any tangible personal property which is normally used for personal, family, or household purposes, or (2) anything designed or sold for incorporation into a dwelling. In determining whether a product is a consumer product, doubtful cases shall be resolved in favor of coverage. For a particular product received by a particular user, "normally used" refers to a typical or common use of that class of product, regardless of the status of the particular user or of the way in which the particular user actually uses, or expects or is expected to use, the product. A product is a consumer product regardless of whether the product has substantial commercial, industrial or non-consumer uses, unless such uses represent the only significant mode of use of the product.\n\n   "Installation Information" for a User Product means any methods, procedures, authorization keys, or other information required to install and execute modified versions of a covered work in that User Product from a modified version of its Corresponding Source. The information must suffice to ensure that the continued functioning of the modified object code is in no case prevented or interfered with solely because modification has been made.\n\n   If you convey an object code work under this section in, or with, or specifically for use in, a User Product, and the conveying occurs as part of a transaction in which the right of possession and use of the User Product is transferred to the recipient in perpetuity or for a fixed term (regardless of how the transaction is characterized), the Corresponding Source conveyed under this section must be accompanied by the Installation Information. But this requirement does not apply if neither you nor any third party retains the ability to install modified object code on the User Product (for example, the work has been installed in ROM).\n\n   The requirement to provide Installation Information does not include a requirement to continue to provide support service, warranty, or updates for a work that has been modified or installed by the recipient, or for the User Product in which it has been modified or installed. Access to a network may be denied when the modification itself materially and adversely affects the operation of the network or violates the rules and protocols for communication across the network.\n\n   Corresponding Source conveyed, and Installation Information provided, in accord with this section must be in a format that is publicly documented (and with an implementation available to the public in source code form), and must require no special password or key for unpacking, reading or copying.\n\n   \u003c\u003cvar;name\u003d"bullet";original\u003d"7.";match\u003d".{0,20}"\u003e\u003e Additional Terms.\n\n   "Additional permissions" are terms that supplement the terms of this License by making exceptions from one or more of its conditions. Additional permissions that are applicable to the entire Program shall be treated as though they were included in this License, to the extent that they are valid under applicable law. If additional permissions apply only to part of the Program, that part may be used separately under those permissions, but the entire Program remains governed by this License without regard to the additional permissions.\n\n   When you convey a copy of a covered work, you may at your option remove any additional permissions from that copy, or from any part of it. (Additional permissions may be written to require their own removal in certain cases when you modify the work.) You may place additional permissions on material, added by you to a covered work, for which you have or can give appropriate copyright permission.\n\n   Notwithstanding any other provision of this License, for material you add to a covered work, you may (if authorized by the copyright holders of that material) supplement the terms of this License with terms:\n\n      \u003c\u003cvar;name\u003d"bullet";original\u003d"a)";match\u003d".{0,20}"\u003e\u003e Disclaiming warranty or limiting liability differently from the terms of sections 15 and 16 of this License; or\n\n      \u003c\u003cvar;name\u003d"bullet";original\u003d"b)";match\u003d".{0,20}"\u003e\u003e Requiring preservation of specified reasonable legal notices or author attributions in that material or in the Appropriate Legal Notices displayed by works containing it; or\n\n      \u003c\u003cvar;name\u003d"bullet";original\u003d"c)";match\u003d".{0,20}"\u003e\u003e Prohibiting misrepresentation of the origin of that material, or requiring that modified versions of such material be marked in reasonable ways as different from the original version; or\n\n      \u003c\u003cvar;name\u003d"bullet";original\u003d"d)";match\u003d".{0,20}"\u003e\u003e Limiting the use for publicity purposes of names of licensors or authors of the material; or\n\n      \u003c\u003cvar;name\u003d"bullet";original\u003d"e)";match\u003d".{0,20}"\u003e\u003e Declining to grant rights under trademark law for use of some trade names, trademarks, or service marks; or\n\n      \u003c\u003cvar;name\u003d"bullet";original\u003d"f)";match\u003d".{0,20}"\u003e\u003e Requiring indemnification of licensors and authors of that material by anyone who conveys the material (or modified versions of it) with contractual assumptions of liability to the recipient, for any liability that these contractual assumptions directly impose on those licensors and authors.\n\n   All other non-permissive additional terms are considered "further restrictions" within the meaning of section 10. If the Program as you received it, or any part of it, contains a notice stating that it is governed by this License along with a term that is a further restriction, you may remove that term. If a license document contains a further restriction but permits relicensing or conveying under this License, you may add to a covered work material governed by the terms of that license document, provided that the further restriction does not survive such relicensing or conveying.\n\n   If you add terms to a covered work in accord with this section, you must place, in the relevant source files, a statement of the additional terms that apply to those files, or a notice indicating where to find the applicable terms.\n\n   Additional terms, permissive or non-permissive, may be stated in the form of a separately written license, or stated as exceptions; the above requirements apply either way.\n\n   \u003c\u003cvar;name\u003d"bullet";original\u003d"8.";match\u003d".{0,20}"\u003e\u003e Termination.\n\n   You may not propagate or modify a covered work except as expressly provided under this License. Any attempt otherwise to propagate or modify it is void, and will automatically terminate your rights under this License (including any patent licenses granted under the third paragraph of section 11).\n\n   However, if you cease all violation of this License, then your license from a particular copyright holder is reinstated (a) provisionally, unless and until the copyright holder explicitly and finally terminates your license, and (b) permanently, if the copyright holder fails to notify you of the violation by some reasonable means prior to 60 days after the cessation.\n\n   Moreover, your license from a particular copyright holder is reinstated permanently if the copyright holder notifies you of the violation by some reasonable means, this is the first time you have received notice of violation of this License (for any work) from that copyright holder, and you cure the violation prior to 30 days after your receipt of the notice.\n\n   Termination of your rights under this section does not terminate the licenses of parties who have received copies or rights from you under this License. If your rights have been terminated and not permanently reinstated, you do not qualify to receive new licenses for the same material under section 10.\n\n   \u003c\u003cvar;name\u003d"bullet";original\u003d"9.";match\u003d".{0,20}"\u003e\u003e Acceptance Not Required for Having Copies.\n\n   You are not required to accept this License in order to receive or run a copy of the Program. Ancillary propagation of a covered work occurring solely as a consequence of using peer-to-peer transmission to receive a copy likewise does not require acceptance. However, nothing other than this License grants you permission to propagate or modify any covered work. These actions infringe copyright if you do not accept this License. Therefore, by modifying or propagating a covered work, you indicate your acceptance of this License to do so.\n\n   \u003c\u003cvar;name\u003d"bullet";original\u003d"10.";match\u003d".{0,20}"\u003e\u003e Automatic Licensing of Downstream Recipients.\n\n   Each time you convey a covered work, the recipient automatically receives a license from the original licensors, to run, modify and propagate that work, subject to this License. You are not responsible for enforcing compliance by third parties with this License.\n\n   An "entity transaction" is a transaction transferring control of an organization, or substantially all assets of one, or subdividing an organization, or merging organizations. If propagation of a covered work results from an entity transaction, each party to that transaction who receives a copy of the work also receives whatever licenses to the work the party\u0027s predecessor in interest had or could give under the previous paragraph, plus a right to possession of the Corresponding Source of the work from the predecessor in interest, if the predecessor has it or can get it with reasonable efforts.\n\n   You may not impose any further restrictions on the exercise of the rights granted or affirmed under this License. For example, you may not impose a license fee, royalty, or other charge for exercise of rights granted under this License, and you may not initiate litigation (including a cross-claim or counterclaim in a lawsuit) alleging that any patent claim is infringed by making, using, selling, offering for sale, or importing the Program or any portion of it.\n\n   \u003c\u003cvar;name\u003d"bullet";original\u003d"11.";match\u003d".{0,20}"\u003e\u003e Patents.\n\n   A "contributor" is a copyright holder who authorizes use under this License of the Program or a work on which the Program is based. The work thus licensed is called the contributor\u0027s "contributor version".\n\n   A contributor\u0027s "essential patent claims" are all patent claims owned or controlled by the contributor, whether already acquired or hereafter acquired, that would be infringed by some manner, permitted by this License, of making, using, or selling its contributor version, but do not include claims that would be infringed only as a consequence of further modification of the contributor version. For purposes of this definition, "control" includes the right to grant patent sublicenses in a manner consistent with the requirements of this License.\n\n   Each contributor grants you a non-exclusive, worldwide, royalty-free patent license under the contributor\u0027s essential patent claims, to make, use, sell, offer for sale, import and otherwise run, modify and propagate the contents of its contributor version.\n\n   In the following three paragraphs, a "patent license" is any express agreement or commitment, however denominated, not to enforce a patent (such as an express permission to practice a patent or covenant not to sue for patent infringement). To "grant" such a patent license to a party means to make such an agreement or commitment not to enforce a patent against the party.\n\n   If you convey a covered work, knowingly relying on a patent license, and the Corresponding Source of the work is not available for anyone to copy, free of charge and under the terms of this License, through a publicly available network server or other readily accessible means, then you must either (1) cause the Corresponding Source to be so available, or (2) arrange to deprive yourself of the benefit of the patent license for this particular work, or (3) arrange, in a manner consistent with the requirements of this License, to extend the patent\n\n   license to downstream recipients. "Knowingly relying" means you have actual knowledge that, but for the patent license, your conveying the covered work in a country, or your recipient\u0027s use of the covered work in a country, would infringe one or more identifiable patents in that country that you have reason to believe are valid.\n\n   If, pursuant to or in connection with a single transaction or arrangement, you convey, or propagate by procuring conveyance of, a covered work, and grant a patent license to some of the parties receiving the covered work authorizing them to use, propagate, modify or convey a specific copy of the covered work, then the patent license you grant is automatically extended to all recipients of the covered work and works based on it.\n\n   A patent license is "discriminatory" if it does not include within the scope of its coverage, prohibits the exercise of, or is conditioned on the non-exercise of one or more of the rights that are specifically granted under this License. You may not convey a covered work if you are a party to an arrangement with a third party that is in the business of distributing software, under which you make payment to the third party based on the extent of your activity of conveying the work, and under which the third party grants, to any of the parties who would receive the covered work from you, a discriminatory patent license (a) in connection with copies of the covered work conveyed by you (or copies made from those copies), or (b) primarily for and in connection with specific products or compilations that contain the covered work, unless you entered into that arrangement, or that patent license was granted, prior to 28 March 2007.\n\n   Nothing in this License shall be construed as excluding or limiting any implied license or other defenses to infringement that may otherwise be available to you under applicable patent law.\n\n   \u003c\u003cvar;name\u003d"bullet";original\u003d"12.";match\u003d".{0,20}"\u003e\u003e No Surrender of Others\u0027 Freedom.\n\n   If conditions are imposed on you (whether by court order, agreement or otherwise) that contradict the conditions of this License, they do not excuse you from the conditions of this License. If you cannot convey a covered work so as to satisfy simultaneously your obligations under this License and any other pertinent obligations, then as a consequence you may\n\n   not convey it at all. For example, if you agree to terms that obligate you to collect a royalty for further conveying from those to whom you convey the Program, the only way you could satisfy both those terms and this License would be to refrain entirely from conveying the Program.\n\n   \u003c\u003cvar;name\u003d"bullet";original\u003d"13.";match\u003d".{0,20}"\u003e\u003e Remote Network Interaction; Use with the GNU General Public License.\n\n   Notwithstanding any other provision of this License, if you modify the Program, your modified version must prominently offer all users interacting with it remotely through a computer network (if your version supports such interaction) an opportunity to receive the Corresponding Source of your version by providing access to the Corresponding Source from a network server at no charge, through some standard or customary means of facilitating copying of software. This Corresponding Source shall include the Corresponding Source for any work covered by version 3 of the GNU General Public License that is incorporated pursuant to the following paragraph.\n\n   Notwithstanding any other provision of this License, you have permission to link or combine any covered work with a work licensed under version 3 of the GNU General Public License into a single combined work, and to convey the resulting work. The terms of this License will continue to apply to the part which is the covered work, but the work with which it is combined will remain governed by version 3 of the GNU General Public License.\n\n   \u003c\u003cvar;name\u003d"bullet";original\u003d"14.";match\u003d".{0,20}"\u003e\u003e Revised Versions of this License.\n\n   The Free Software Foundation may publish revised and/or new versions of the GNU Affero General Public License from time to time. Such new versions will be similar in spirit to the present version, but may differ in detail to address new problems or concerns.\n\n   Each version is given a distinguishing version number. If the Program specifies that a certain numbered version of the GNU Affero General Public License "or any later version" applies to it, you have the option of following the terms and conditions either of that numbered version or of any later version published by the Free Software Foundation. If the Program does not specify a version number of the GNU Affero General Public License, you may choose any version ever published by the Free Software Foundation.\n\n   If the Program specifies that a proxy can decide which future versions of the GNU Affero General Public License can be used, that proxy\u0027s public statement of acceptance of a version permanently authorizes you to choose that version for the Program.\n\n   Later license versions may give you additional or different permissions. However, no additional obligations are imposed on any author or copyright holder as a result of your choosing to follow a later version.\n\n   \u003c\u003cvar;name\u003d"bullet";original\u003d"15.";match\u003d".{0,20}"\u003e\u003e Disclaimer of Warranty.\n\n   THERE IS NO WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW. EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU. SHOULD THE PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.\n\n   \u003c\u003cvar;name\u003d"bullet";original\u003d"16.";match\u003d".{0,20}"\u003e\u003e Limitation of Liability.\n\n   IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MODIFIES AND/OR CONVEYS THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.\n\n   \u003c\u003cvar;name\u003d"bullet";original\u003d"17.";match\u003d".{0,20}"\u003e\u003e Interpretation of Sections 15 and 16.\n\n   If the disclaimer of warranty and limitation of liability provided above cannot be given local legal effect according to their terms, reviewing courts shall apply local law that most closely approximates an absolute waiver of all civil liability in connection with the Program, unless a warranty or assumption of liability accompanies a copy of the Program in return for a fee.\n\n   \u003c\u003cbeginOptional\u003e\u003eEND OF TERMS AND CONDITIONS\n\nHow to Apply These Terms to Your New Programs\n\nIf you develop a new program, and you want it to be of the greatest possible use to the public, the best way to achieve this is to make it free software which everyone can redistribute and change under these terms.\n\nTo do so, attach the following notices to the program. It is safest to attach them to the start of each source file to most effectively state the exclusion of warranty; and each file should have at least the "copyright" line and a pointer to where the full notice is found.\n\n\u003c\u003cvar;name\u003d"description";original\u003d"\u003cone line to give the program\u0027s name and a brief idea of what it does.\u003e";match\u003d".+"\u003e\u003e\n\nCopyright (C) \u003c\u003cvar;name\u003d"copyright";original\u003d"\u003cyear\u003e \u003cname of author\u003e";match\u003d".+"\u003e\u003e\n\nThis program is free software: you can redistribute it and/or modify it under the terms of the GNU Affero General Public License as published by the Free Software Foundation, either version 3 of the License, or\u003c\u003cbeginOptional\u003e\u003e (at your option)\u003c\u003cendOptional\u003e\u003e any later version.\n\nThis program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more details.\n\nYou should have received a copy of the GNU Affero General Public License along with this program. If not, see \u003chttps://www.gnu.org/licenses/\u003e.\n\nAlso add information on how to contact you by electronic and paper mail.\n\nIf your software can interact with users remotely through a computer network, you should also make sure that it provides a way for users to get its source. For example, if your program is a web application, its interface could display a "Source" link that leads users to an archive of the code. There are many ways you could offer source, and different solutions will be better for different programs; see section 13 for the specific requirements.\n\nYou should also get your employer (if you work as a programmer) or school, if any, to sign a "copyright disclaimer" for the program, if necessary. For more information on this, and how to apply and follow the GNU AGPL, see \u003chttps://www.gnu.org/licenses/\u003e.\n\n\u003c\u003cendOptional\u003e\u003e',
    "name": "GNU Affero General Public License v3.0 or later",
    "licenseComments": 'This version was released: 19 November 2007. This license identifier refers to the choice to use code under AGPL-3.0-or-later (i.e., AGPL-3.0 or some later version), as distinguished from use of code under AGPL-3.0-only. The license notice (as seen in the Standard License Header field below) states which of these applies the code in the file. The example in the exhibit to the license shows the license notice for the "or later" approach.',
    "licenseId": "AGPL-3.0-or-later",
    "standardLicenseHeader": "\u003cone line to give the program\u0027s name and a brief idea of what it does.\u003e\n\nCopyright (C) \u003cyear\u003e \u003cname of author\u003e\n\nThis program is free software: you can redistribute it and/or modify it under the terms of the GNU Affero General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.\n\nThis program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more details.\n\nYou should have received a copy of the GNU Affero General Public License along with this program. If not, see \u003chttps://www.gnu.org/licenses/\u003e.\n\n",
    "crossRef": [
        {
            "match": "N/A",
            "url": "https://opensource.org/licenses/AGPL-3.0",
            "isValid": True,
            "isLive": True,
            "timestamp": "2024-08-19T17:40:05Z",
            "isWayBackLink": False,
            "order": 1,
        },
        {
            "match": "false",
            "url": "https://www.gnu.org/licenses/agpl.txt",
            "isValid": True,
            "isLive": True,
            "timestamp": "2024-08-19T17:40:07Z",
            "isWayBackLink": False,
            "order": 0,
        },
    ],
    "seeAlso": [
        "https://www.gnu.org/licenses/agpl.txt",
        "https://opensource.org/licenses/AGPL-3.0",
    ],
    "isOsiApproved": True,
    "licenseTextHtml": '\n    \u003cdiv class\u003d"optional-license-text"\u003e \n      \u003cp\u003e\n        GNU AFFERO GENERAL PUBLIC LICENSE\u003cbr /\u003e\n\n        Version 3, 19 November 2007\n      \u003c/p\u003e\n\n    \u003c/div\u003e\n    \u003cp\u003e\n      Copyright (C) 2007 Free Software Foundation, Inc.\n      \u0026lt;https://fsf.org/\u0026gt;\n    \u003c/p\u003e\n\n    \u003cp\u003e\n      Everyone is permitted to copy and distribute verbatim copies\n      of this license document, but changing it is not allowed.\n    \u003c/p\u003e\n\n    \u003cp\u003e\n      Preamble\n    \u003c/p\u003e\n\n    \u003cp\u003e\n      The GNU Affero General Public License is a free, copyleft license for\n      software and other kinds of works, specifically designed to ensure\n      cooperation with the community in the case of network server software.\n    \u003c/p\u003e\n\n    \u003cp\u003e\n      The licenses for most software and other practical works are\n      designed to take away your freedom to share and change the\n      works. By contrast, our General Public Licenses are intended\n      to guarantee your freedom to share and change all versions of a\n      program--to make sure it remains free software for all its users.\n    \u003c/p\u003e\n\n    \u003cp\u003e\n      When we speak of free software, we are referring to freedom, not\n      price. Our General Public Licenses are designed to make sure that you\n      have the freedom to distribute copies of free software (and charge\n      for them if you wish), that you receive source code or can get it\n      if you want it, that you can change the software or use pieces of\n      it in new free programs, and that you know you can do these things.\n    \u003c/p\u003e\n\n    \u003cp\u003e\n      Developers that use our General Public Licenses protect\n      your rights with two steps: (1) assert copyright on the\n      software, and (2) offer you this License which gives you legal\n      permission to copy, distribute and/or modify the software.\n    \u003c/p\u003e\n\n    \u003cp\u003e\n      A secondary benefit of defending all users\u0026apos; freedom is that improvements\n      made in alternate versions of the program, if they receive widespread\n      use, become available for other developers to incorporate. Many\n      developers of free software are heartened and encouraged by the\n      resulting cooperation. However, in the case of software used on network\n      servers, this result may fail to come about. The GNU General Public\n      License permits making a modified version and letting the public access\n      it on a server without ever releasing its source code to the public.\n    \u003c/p\u003e\n\n    \u003cp\u003e\n      The GNU Affero General Public License is designed specifically\n      to ensure that, in such cases, the modified source code becomes\n      available to the community. It requires the operator of a\n      network server to provide the source code of the modified version\n      running there to the users of that server. Therefore, public use\n      of a modified version, on a publicly accessible server, gives\n      the public access to the source code of the modified version.\n    \u003c/p\u003e\n\n    \u003cp\u003e\n      An older license, called the Affero General Public License and published\n      by Affero, was designed to accomplish similar goals. This is a different\n      license, not a version of the Affero GPL, but Affero has released a new\n      version of the Affero GPL which permits relicensing under this license.\n    \u003c/p\u003e\n\n    \u003cp\u003e\n      The precise terms and conditions for copying,\n      distribution and modification follow.\n    \u003c/p\u003e\n\n    \u003cp\u003e\n      TERMS AND CONDITIONS\n    \u003c/p\u003e\n\n\u003cul style\u003d"list-style:none"\u003e\n      \n\u003cli\u003e\n        \u003cvar class\u003d"replaceable-license-text"\u003e 0.\u003c/var\u003e\n        Definitions.\n        \u003cp\u003e\n          \u0026quot;This License\u0026quot; refers to version 3 of\n          the GNU Affero General Public License.\n        \u003c/p\u003e\n\n        \u003cp\u003e\n          \u0026quot;Copyright\u0026quot; also means copyright-like laws that apply\n          to other kinds of works, such as semiconductor masks.\n        \u003c/p\u003e\n\n        \u003cp\u003e\n          \u0026quot;The Program\u0026quot; refers to any copyrightable work licensed under\n          this License. Each licensee is addressed as \u0026quot;you\u0026quot;. \u0026quot;Licensees\u0026quot;\n          and \u0026quot;recipients\u0026quot; may be individuals or organizations.\n        \u003c/p\u003e\n\n        \u003cp\u003e\n          To \u0026quot;modify\u0026quot; a work means to copy from or adapt all or part of the\n          work in a fashion requiring copyright permission, other than the\n          making of an exact copy. The resulting work is called a \u0026quot;modified\n          version\u0026quot; of the earlier work or a work \u0026quot;based on\u0026quot; the earlier work.\n        \u003c/p\u003e\n\n        \u003cp\u003e\n          A \u0026quot;covered work\u0026quot; means either the unmodified\n          Program or a work based on the Program.\n        \u003c/p\u003e\n\n        \u003cp\u003e\n          To \u0026quot;propagate\u0026quot; a work means to do anything with it that, without\n          permission, would make you directly or secondarily liable for\n          infringement under applicable copyright law, except executing it\n          on a computer or modifying a private copy. Propagation includes\n          copying, distribution (with or without modification), making available\n          to the public, and in some countries other activities as well.\n        \u003c/p\u003e\n\n        \u003cp\u003e\n          To \u0026quot;convey\u0026quot; a work means any kind of propagation\n          that enables other parties to make or receive copies.\n          Mere interaction with a user through a computer\n          network, with no transfer of a copy, is not conveying.\n        \u003c/p\u003e\n\n        \u003cp\u003e\n          An interactive user interface displays \u0026quot;Appropriate Legal Notices\u0026quot;\n          to the extent that it includes a convenient and prominently visible\n          feature that (1) displays an appropriate copyright notice, and (2)\n          tells the user that there is no warranty for the work (except to\n          the extent that warranties are provided), that licensees may convey\n          the work under this License, and how to view a copy of this License.\n          If the interface presents a list of user commands or options,\n          such as a menu, a prominent item in the list meets this criterion.\n        \u003c/p\u003e\n\n      \u003c/li\u003e\n      \n\u003cli\u003e\n        \u003cvar class\u003d"replaceable-license-text"\u003e 1.\u003c/var\u003e\n        Source Code.\u003cbr /\u003e\n\n        The \u0026quot;source code\u0026quot; for a work means the preferred\n        form of the work for making modifications to it.\n        \u0026quot;Object code\u0026quot; means any non-source form of a work.\n        \u003cp\u003e\n          A \u0026quot;Standard Interface\u0026quot; means an interface that either is an official\n          standard defined by a recognized standards body, or, in the case\n          of interfaces specified for a particular programming language,\n          one that is widely used among developers working in that language.\n        \u003c/p\u003e\n\n        \u003cp\u003e\n          The \u0026quot;System Libraries\u0026quot; of an executable work include anything, other\n          than the work as a whole, that (a) is included in the normal form\n          of packaging a Major Component, but which is not part of that Major\n          Component, and (b) serves only to enable use of the work with that\n          Major Component, or to implement a Standard Interface for which an\n          implementation is available to the public in source code form. A\n          \u0026quot;Major Component\u0026quot;, in this context, means a major essential component\n          (kernel, window system, and so on) of the specific operating system\n          (if any) on which the executable work runs, or a compiler used to\n          produce the work, or an object code interpreter used to run it.\n        \u003c/p\u003e\n\n        \u003cp\u003e\n          The \u0026quot;Corresponding Source\u0026quot; for a work in object code form means\n          all the source code needed to generate, install, and (for an\n          executable work) run the object code and to modify the work,\n          including scripts to control those activities. However, it does\n          not include the work\u0026apos;s System Libraries, or general-purpose tools\n          or generally available free programs which are used unmodified in\n          performing those activities but which are not part of the work.\n          For example, Corresponding Source includes interface definition\n          files associated with source files for the work, and the source\n          code for shared libraries and dynamically linked subprograms\n          that the work is specifically designed to require, such as by\n          intimate data communication or control flow between those\u003cbr /\u003e\n\n          subprograms and other parts of the work.\n        \u003c/p\u003e\n\n        \u003cp\u003e\n          The Corresponding Source need not include anything that users can\n          regenerate automatically from other parts of the Corresponding Source.\n        \u003c/p\u003e\n\n        \u003cp\u003e\n          The Corresponding Source for a work\n          in source code form is that same work.\n        \u003c/p\u003e\n\n      \u003c/li\u003e\n      \n\u003cli\u003e\n        \u003cvar class\u003d"replaceable-license-text"\u003e 2.\u003c/var\u003e\n        Basic Permissions.\u003cbr /\u003e\n\n        All rights granted under this License are granted for the term of\n        copyright on the Program, and are irrevocable provided the stated\n        conditions are met. This License explicitly affirms your unlimited\n        permission to run the unmodified Program. The output from running a\n        covered work is covered by this License only if the output, given its\n        content, constitutes a covered work. This License acknowledges your\n        rights of fair use or other equivalent, as provided by copyright law.\n        \u003cp\u003e\n          You may make, run and propagate covered works that you do not convey,\n          without conditions so long as your license otherwise remains in force.\n          You may convey covered works to others for the sole purpose of having\n          them make modifications exclusively for you, or provide you with\n          facilities for running those works, provided that you comply with\n          the terms of this License in conveying all material for which you do\n          not control copyright. Those thus making or running the covered works\n          for you must do so exclusively on your behalf, under your direction\n          and control, on terms that prohibit them from making any copies\n          of your copyrighted material outside their relationship with you.\n        \u003c/p\u003e\n\n        \u003cp\u003e\n          Conveying under any other circumstances is permitted\n          solely under the conditions stated below. Sublicensing\n          is not allowed; section 10 makes it unnecessary.\n        \u003c/p\u003e\n\n      \u003c/li\u003e\n      \n\u003cli\u003e\n        \u003cvar class\u003d"replaceable-license-text"\u003e 3.\u003c/var\u003e\n        Protecting Users\u0026apos; Legal Rights From Anti-Circumvention Law.\u003cbr /\u003e\n\n        No covered work shall be deemed part of an effective technological\n        measure under any applicable law fulfilling obligations under article\n        11 of the WIPO copyright treaty adopted on 20 December 1996, or\n        similar laws prohibiting or restricting circumvention of such measures.\n        \u003cp\u003e\n          When you convey a covered work, you waive any legal power to\n          forbid circumvention of technological measures to the extent\n          such circumvention is effected by exercising rights under this\n          License with respect to the covered work, and you disclaim any\n          intention to limit operation or modification of the work as a means\n          of enforcing, against the work\u0026apos;s users, your or third parties\u0026apos;\n          legal rights to forbid circumvention of technological measures.\n        \u003c/p\u003e\n\n      \u003c/li\u003e\n      \n\u003cli\u003e\n        \u003cvar class\u003d"replaceable-license-text"\u003e 4.\u003c/var\u003e\n        Conveying Verbatim Copies.\u003cbr /\u003e\n\n        You may convey verbatim copies of the Program\u0026apos;s source code as\n        you receive it, in any medium, provided that you conspicuously\n        and appropriately publish on each copy an appropriate copyright\n        notice; keep intact all notices stating that this License and any\n        non-permissive terms added in accord with section 7 apply to the\n        code; keep intact all notices of the absence of any warranty; and\n        give all recipients a copy of this License along with the Program.\n        \u003cp\u003e\n          You may charge any price or no price for each copy that you\n          convey, and you may offer support or warranty protection for a fee.\n        \u003c/p\u003e\n\n      \u003c/li\u003e\n      \n\u003cli\u003e\n        \u003cvar class\u003d"replaceable-license-text"\u003e 5.\u003c/var\u003e\n        Conveying Modified Source Versions.\u003cbr /\u003e\n\n        You may convey a work based on the Program, or the modifications to\n        produce it from the Program, in the form of source code under the terms\n        of section 4, provided that you also meet all of these conditions:\n        \n\u003cul style\u003d"list-style:none"\u003e\n          \n\u003cli\u003e\n            \u003cvar class\u003d"replaceable-license-text"\u003e a)\u003c/var\u003e\n            The work must carry prominent notices stating\n            that you modified it, and giving a relevant date.\n          \u003c/li\u003e\n          \n\u003cli\u003e\n            \u003cvar class\u003d"replaceable-license-text"\u003e b)\u003c/var\u003e\n            The work must carry prominent notices stating that\n            it is released under this License and any conditions\n            added under section 7. This requirement modifies the\n            requirement in section 4 to \u0026quot;keep intact all notices\u0026quot;.\n          \u003c/li\u003e\n          \n\u003cli\u003e\n            \u003cvar class\u003d"replaceable-license-text"\u003e c)\u003c/var\u003e\n            You must license the entire work, as a whole, under this License\n            to anyone who comes into possession of a copy. This License\n            will therefore apply, along with any applicable section 7\n            additional terms, to the whole of the work, and all its parts,\n            regardless of how they are packaged. This License gives no\n            permission to license the work in any other way, but it does not\n            invalidate such permission if you have separately received it.\n          \u003c/li\u003e\n          \n\u003cli\u003e\n            \u003cvar class\u003d"replaceable-license-text"\u003e d)\u003c/var\u003e\n            If the work has interactive user interfaces, each must\n            display Appropriate Legal Notices; however, if the Program\n            has interactive interfaces that do not display Appropriate\n            Legal Notices, your work need not make them do so.\n          \u003c/li\u003e\n        \n\u003c/ul\u003e\n        \u003cp\u003e\n          A compilation of a covered work with other separate and independent\n          works, which are not by their nature extensions of the covered\n          work, and which are not combined with it such as to form a larger\n          program, in or on a volume of a storage or distribution medium,\n          is called an \u0026quot;aggregate\u0026quot; if the compilation and its resulting\n          copyright are not used to limit the access or legal rights\n          of the compilation\u0026apos;s users beyond what the individual works\n          permit. Inclusion of a covered work in an aggregate does not\n          cause this License to apply to the other parts of the aggregate.\n        \u003c/p\u003e\n\n      \u003c/li\u003e\n      \n\u003cli\u003e\n        \u003cvar class\u003d"replaceable-license-text"\u003e 6.\u003c/var\u003e\n        Conveying Non-Source Forms.\u003cbr /\u003e\n\n        You may convey a covered work in object code form\n        under the terms of sections 4 and 5, provided that you\n        also convey the machine-readable Corresponding Source\n        under the terms of this License, in one of these ways:\n        \n\u003cul style\u003d"list-style:none"\u003e\n          \n\u003cli\u003e\n            \u003cvar class\u003d"replaceable-license-text"\u003e a)\u003c/var\u003e\n            Convey the object code in, or embodied in, a physical\n            product (including a physical distribution medium),\n            accompanied by the Corresponding Source fixed on a durable\n            physical medium customarily used for software interchange.\n          \u003c/li\u003e\n          \n\u003cli\u003e\n            \u003cvar class\u003d"replaceable-license-text"\u003e b)\u003c/var\u003e\n            Convey the object code in, or embodied in, a physical product\n            (including a physical distribution medium), accompanied by a\n            written offer, valid for at least three years and valid for\n            as long as you offer spare parts or customer support for that\n            product model, to give anyone who possesses the object code\n            either (1) a copy of the Corresponding Source for all the software\n            in the product that is covered by this License, on a durable\n            physical medium customarily used for software interchange,\n            for a price no more than your reasonable cost of physically\n            performing this conveying of source, or (2) access to copy\n            the Corresponding Source from a network server at no charge.\n          \u003c/li\u003e\n          \n\u003cli\u003e\n            \u003cvar class\u003d"replaceable-license-text"\u003e c)\u003c/var\u003e\n            Convey individual copies of the object code with a\n            copy of the written offer to provide the Corresponding\n            Source. This alternative is allowed only occasionally\n            and noncommercially, and only if you received the object\n            code with such an offer, in accord with subsection 6b.\n          \u003c/li\u003e\n          \n\u003cli\u003e\n            \u003cvar class\u003d"replaceable-license-text"\u003e d)\u003c/var\u003e\n            Convey the object code by offering access from a designated place\n            (gratis or for a charge), and offer equivalent access to the\n            Corresponding Source in the same way through the same place at\n            no further charge. You need not require recipients to copy the\n            Corresponding Source along with the object code. If the place\n            to copy the object code is a network server, the Corresponding\n            Source may be on a different server (operated by you or a third\n            party) that supports equivalent copying facilities, provided you\n            maintain clear directions next to the object code saying where\n            to find the Corresponding Source. Regardless of what server hosts\n            the Corresponding Source, you remain obligated to ensure that it\n            is available for as long as needed to satisfy these requirements.\n          \u003c/li\u003e\n          \n\u003cli\u003e\n            \u003cvar class\u003d"replaceable-license-text"\u003e e)\u003c/var\u003e\n            Convey the object code using peer-to-peer transmission,\n            provided you inform other peers where the object code\n            and Corresponding Source of the work are being offered\n            to the general public at no charge under subsection 6d.\n          \u003c/li\u003e\n        \n\u003c/ul\u003e\n        \u003cp\u003e\n          A separable portion of the object code, whose source code is\n          excluded from the Corresponding Source as a System Library,\n          need not be included in conveying the object code work.\n        \u003c/p\u003e\n\n        \u003cp\u003e\n          A \u0026quot;User Product\u0026quot; is either (1) a \u0026quot;consumer product\u0026quot;, which means\n          any tangible personal property which is normally used for personal,\n          family, or household purposes, or (2) anything designed or sold\n          for incorporation into a dwelling. In determining whether a product\n          is a consumer product, doubtful cases shall be resolved in favor\n          of coverage. For a particular product received by a particular\n          user, \u0026quot;normally used\u0026quot; refers to a typical or common use of that\n          class of product, regardless of the status of the particular\n          user or of the way in which the particular user actually uses,\n          or expects or is expected to use, the product. A product is a\n          consumer product regardless of whether the product has substantial\n          commercial, industrial or non-consumer uses, unless such uses\n          represent the only significant mode of use of the product.\n        \u003c/p\u003e\n\n        \u003cp\u003e\n          \u0026quot;Installation Information\u0026quot; for a User Product means any methods,\n          procedures, authorization keys, or other information required\n          to install and execute modified versions of a covered work in\n          that User Product from a modified version of its Corresponding\n          Source. The information must suffice to ensure that the continued\n          functioning of the modified object code is in no case prevented\n          or interfered with solely because modification has been made.\n        \u003c/p\u003e\n\n        \u003cp\u003e\n          If you convey an object code work under this section in, or with,\n          or specifically for use in, a User Product, and the conveying\n          occurs as part of a transaction in which the right of possession\n          and use of the User Product is transferred to the recipient in\n          perpetuity or for a fixed term (regardless of how the transaction\n          is characterized), the Corresponding Source conveyed under this\n          section must be accompanied by the Installation Information.\n          But this requirement does not apply if neither you nor any third\n          party retains the ability to install modified object code on the\n          User Product (for example, the work has been installed in ROM).\n        \u003c/p\u003e\n\n        \u003cp\u003e\n          The requirement to provide Installation Information does not\n          include a requirement to continue to provide support service,\n          warranty, or updates for a work that has been modified\n          or installed by the recipient, or for the User Product in\n          which it has been modified or installed. Access to a network\n          may be denied when the modification itself materially and\n          adversely affects the operation of the network or violates\n          the rules and protocols for communication across the network.\n        \u003c/p\u003e\n\n        \u003cp\u003e\n          Corresponding Source conveyed, and Installation Information\n          provided, in accord with this section must be in a format that\n          is publicly documented (and with an implementation available\n          to the public in source code form), and must require no\n          special password or key for unpacking, reading or copying.\n        \u003c/p\u003e\n\n      \u003c/li\u003e\n      \n\u003cli\u003e\n        \u003cvar class\u003d"replaceable-license-text"\u003e 7.\u003c/var\u003e\n        Additional Terms.\u003cbr /\u003e\n\n        \u0026quot;Additional permissions\u0026quot; are terms that supplement the terms of this\n        License by making exceptions from one or more of its conditions.\n        Additional permissions that are applicable to the entire Program\n        shall be treated as though they were included in this License, to\n        the extent that they are valid under applicable law. If additional\n        permissions apply only to part of the Program, that part may be used\n        separately under those permissions, but the entire Program remains\n        governed by this License without regard to the additional permissions.\n        \u003cp\u003e\n          When you convey a copy of a covered work, you may at your option\n          remove any additional permissions from that copy, or from any part\n          of it. (Additional permissions may be written to require their own\n          removal in certain cases when you modify the work.) You may place\n          additional permissions on material, added by you to a covered work,\n          for which you have or can give appropriate copyright permission.\n        \u003c/p\u003e\n\n        \u003cp\u003e\n          Notwithstanding any other provision of this License, for material you\n          add to a covered work, you may (if authorized by the copyright holders\n          of that material) supplement the terms of this License with terms:\n        \u003c/p\u003e\n\n\u003cul style\u003d"list-style:none"\u003e\n          \n\u003cli\u003e\n            \u003cvar class\u003d"replaceable-license-text"\u003e a)\u003c/var\u003e\n            Disclaiming warranty or limiting liability differently\n            from the terms of sections 15 and 16 of this License; or\n          \u003c/li\u003e\n          \n\u003cli\u003e\n            \u003cvar class\u003d"replaceable-license-text"\u003e b)\u003c/var\u003e\n            Requiring preservation of specified reasonable legal\n            notices or author attributions in that material or in the\n            Appropriate Legal Notices displayed by works containing it; or\n          \u003c/li\u003e\n          \n\u003cli\u003e\n            \u003cvar class\u003d"replaceable-license-text"\u003e c)\u003c/var\u003e\n            Prohibiting misrepresentation of the origin of that material,\n            or requiring that modified versions of such material be marked\n            in reasonable ways as different from the original version; or\n          \u003c/li\u003e\n          \n\u003cli\u003e\n            \u003cvar class\u003d"replaceable-license-text"\u003e d)\u003c/var\u003e\n            Limiting the use for publicity purposes of names\n            of licensors or authors of the material; or\n          \u003c/li\u003e\n          \n\u003cli\u003e\n            \u003cvar class\u003d"replaceable-license-text"\u003e e)\u003c/var\u003e\n            Declining to grant rights under trademark law for use\n            of some trade names, trademarks, or service marks; or\n          \u003c/li\u003e\n          \n\u003cli\u003e\n            \u003cvar class\u003d"replaceable-license-text"\u003e f)\u003c/var\u003e\n            Requiring indemnification of licensors and authors of that\n            material by anyone who conveys the material (or modified\n            versions of it) with contractual assumptions of liability\n            to the recipient, for any liability that these contractual\n            assumptions directly impose on those licensors and authors.\n          \u003c/li\u003e\n        \n\u003c/ul\u003e\n        \u003cp\u003e\n          All other non-permissive additional terms are considered \u0026quot;further\n          restrictions\u0026quot; within the meaning of section 10. If the Program\n          as you received it, or any part of it, contains a notice stating\n          that it is governed by this License along with a term that is\n          a further restriction, you may remove that term. If a license\n          document contains a further restriction but permits relicensing or\n          conveying under this License, you may add to a covered work material\n          governed by the terms of that license document, provided that the\n          further restriction does not survive such relicensing or conveying.\n        \u003c/p\u003e\n\n        \u003cp\u003e\n          If you add terms to a covered work in accord with this\n          section, you must place, in the relevant source files, a\n          statement of the additional terms that apply to those files,\n          or a notice indicating where to find the applicable terms.\n        \u003c/p\u003e\n\n        \u003cp\u003e\n          Additional terms, permissive or non-permissive, may be\n          stated in the form of a separately written license, or stated\n          as exceptions; the above requirements apply either way.\n        \u003c/p\u003e\n\n      \u003c/li\u003e\n      \n\u003cli\u003e\n        \u003cvar class\u003d"replaceable-license-text"\u003e 8.\u003c/var\u003e\n        Termination.\n        \u003cp\u003e\n          You may not propagate or modify a covered work except as\n          expressly provided under this License. Any attempt otherwise\n          to propagate or modify it is void, and will automatically\n          terminate your rights under this License (including any patent\n          licenses granted under the third paragraph of section 11).\n        \u003c/p\u003e\n\n        \u003cp\u003e\n          However, if you cease all violation of this License, then your\n          license from a particular copyright holder is reinstated (a)\n          provisionally, unless and until the copyright holder explicitly\n          and finally terminates your license, and (b) permanently, if\n          the copyright holder fails to notify you of the violation by\n          some reasonable means prior to 60 days after the cessation.\n        \u003c/p\u003e\n\n        \u003cp\u003e\n          Moreover, your license from a particular copyright holder is\n          reinstated permanently if the copyright holder notifies you\n          of the violation by some reasonable means, this is the first\n          time you have received notice of violation of this License\n          (for any work) from that copyright holder, and you cure the\n          violation prior to 30 days after your receipt of the notice.\n        \u003c/p\u003e\n\n        \u003cp\u003e\n          Termination of your rights under this section does not\n          terminate the licenses of parties who have received copies or\n          rights from you under this License. If your rights have been\n          terminated and not permanently reinstated, you do not qualify\n          to receive new licenses for the same material under section 10.\n        \u003c/p\u003e\n\n      \u003c/li\u003e\n      \n\u003cli\u003e\n        \u003cvar class\u003d"replaceable-license-text"\u003e 9.\u003c/var\u003e\n        Acceptance Not Required for Having Copies.\n        \u003cp\u003e\n          You are not required to accept this License in order to receive or\n          run a copy of the Program. Ancillary propagation of a covered work\n          occurring solely as a consequence of using peer-to-peer transmission\n          to receive a copy likewise does not require acceptance. However,\n          nothing other than this License grants you permission to propagate\n          or modify any covered work. These actions infringe copyright if you\n          do not accept this License. Therefore, by modifying or propagating a\n          covered work, you indicate your acceptance of this License to do so.\n        \u003c/p\u003e\n\n      \u003c/li\u003e\n      \n\u003cli\u003e\n        \u003cvar class\u003d"replaceable-license-text"\u003e 10.\u003c/var\u003e\n        Automatic Licensing of Downstream Recipients.\n        \u003cp\u003e\n          Each time you convey a covered work, the recipient automatically\n          receives a license from the original licensors, to run, modify and\n          propagate that work, subject to this License. You are not responsible\n          for enforcing compliance by third parties with this License.\n        \u003c/p\u003e\n\n        \u003cp\u003e\n          An \u0026quot;entity transaction\u0026quot; is a transaction transferring control of\n          an organization, or substantially all assets of one, or subdividing\n          an organization, or merging organizations. If propagation of a\n          covered work results from an entity transaction, each party to that\n          transaction who receives a copy of the work also receives whatever\n          licenses to the work the party\u0026apos;s predecessor in interest had or could\n          give under the previous paragraph, plus a right to possession of the\n          Corresponding Source of the work from the predecessor in interest,\n          if the predecessor has it or can get it with reasonable efforts.\n        \u003c/p\u003e\n\n        \u003cp\u003e\n          You may not impose any further restrictions on the exercise of the\n          rights granted or affirmed under this License. For example, you\n          may not impose a license fee, royalty, or other charge for exercise\n          of rights granted under this License, and you may not initiate\n          litigation (including a cross-claim or counterclaim in a lawsuit)\n          alleging that any patent claim is infringed by making, using, selling,\n          offering for sale, or importing the Program or any portion of it.\n        \u003c/p\u003e\n\n      \u003c/li\u003e\n      \n\u003cli\u003e\n        \u003cvar class\u003d"replaceable-license-text"\u003e 11.\u003c/var\u003e\n        Patents.\n        \u003cp\u003e\n          A \u0026quot;contributor\u0026quot; is a copyright holder who authorizes use under this\n          License of the Program or a work on which the Program is based. The\n          work thus licensed is called the contributor\u0026apos;s \u0026quot;contributor version\u0026quot;.\n        \u003c/p\u003e\n\n        \u003cp\u003e\n          A contributor\u0026apos;s \u0026quot;essential patent claims\u0026quot; are all patent\n          claims owned or controlled by the contributor, whether already\n          acquired or hereafter acquired, that would be infringed by some\n          manner, permitted by this License, of making, using, or selling\n          its contributor version, but do not include claims that would\n          be infringed only as a consequence of further modification\n          of the contributor version. For purposes of this definition,\n          \u0026quot;control\u0026quot; includes the right to grant patent sublicenses in\n          a manner consistent with the requirements of this License.\n        \u003c/p\u003e\n\n        \u003cp\u003e\n          Each contributor grants you a non-exclusive, worldwide, royalty-free\n          patent license under the contributor\u0026apos;s essential patent claims,\n          to make, use, sell, offer for sale, import and otherwise run,\n          modify and propagate the contents of its contributor version.\n        \u003c/p\u003e\n\n        \u003cp\u003e\n          In the following three paragraphs, a \u0026quot;patent license\u0026quot; is any\n          express agreement or commitment, however denominated, not to\n          enforce a patent (such as an express permission to practice\n          a patent or covenant not to sue for patent infringement). To\n          \u0026quot;grant\u0026quot; such a patent license to a party means to make such an\n          agreement or commitment not to enforce a patent against the party.\n        \u003c/p\u003e\n\n        \u003cp\u003e\n          If you convey a covered work, knowingly relying on a patent\n          license, and the Corresponding Source of the work is not available\n          for anyone to copy, free of charge and under the terms of this\n          License, through a publicly available network server or other\n          readily accessible means, then you must either (1) cause the\n          Corresponding Source to be so available, or (2) arrange to\n          deprive yourself of the benefit of the patent license for this\n          particular work, or (3) arrange, in a manner consistent with\n          the requirements of this License, to extend the patent\u003cbr /\u003e\n\n          license to downstream recipients. \u0026quot;Knowingly relying\u0026quot; means you have\n          actual knowledge that, but for the patent license, your conveying\n          the covered work in a country, or your recipient\u0026apos;s use of the\n          covered work in a country, would infringe one or more identifiable\n          patents in that country that you have reason to believe are valid.\n        \u003c/p\u003e\n\n        \u003cp\u003e\n          If, pursuant to or in connection with a single transaction or\n          arrangement, you convey, or propagate by procuring conveyance\n          of, a covered work, and grant a patent license to some of the\n          parties receiving the covered work authorizing them to use,\n          propagate, modify or convey a specific copy of the covered work,\n          then the patent license you grant is automatically extended\n          to all recipients of the covered work and works based on it.\n        \u003c/p\u003e\n\n        \u003cp\u003e\n          A patent license is \u0026quot;discriminatory\u0026quot; if it does not include within the\n          scope of its coverage, prohibits the exercise of, or is conditioned\n          on the non-exercise of one or more of the rights that are specifically\n          granted under this License. You may not convey a covered work if\n          you are a party to an arrangement with a third party that is in the\n          business of distributing software, under which you make payment to\n          the third party based on the extent of your activity of conveying\n          the work, and under which the third party grants, to any of the\n          parties who would receive the covered work from you, a discriminatory\n          patent license (a) in connection with copies of the covered work\n          conveyed by you (or copies made from those copies), or (b) primarily\n          for and in connection with specific products or compilations that\n          contain the covered work, unless you entered into that arrangement,\n          or that patent license was granted, prior to 28 March 2007.\n        \u003c/p\u003e\n\n        \u003cp\u003e\n          Nothing in this License shall be construed as excluding or\n          limiting any implied license or other defenses to infringement\n          that may otherwise be available to you under applicable patent law.\n        \u003c/p\u003e\n\n      \u003c/li\u003e\n      \n\u003cli\u003e\n        \u003cvar class\u003d"replaceable-license-text"\u003e 12.\u003c/var\u003e\n        No Surrender of Others\u0026apos; Freedom.\n        \u003cp\u003e\n          If conditions are imposed on you (whether by court order,\n          agreement or otherwise) that contradict the conditions of this\n          License, they do not excuse you from the conditions of this\n          License. If you cannot convey a covered work so as to satisfy\n          simultaneously your obligations under this License and any other\n          pertinent obligations, then as a consequence you may\u003cbr /\u003e\n\n          not convey it at all. For example, if you agree to terms\n          that obligate you to collect a royalty for further conveying\n          from those to whom you convey the Program, the only\n          way you could satisfy both those terms and this License\n          would be to refrain entirely from conveying the Program.\n        \u003c/p\u003e\n\n      \u003c/li\u003e\n      \n\u003cli\u003e\n        \u003cvar class\u003d"replaceable-license-text"\u003e 13.\u003c/var\u003e\n        Remote Network Interaction; Use with the GNU General Public License.\n        \u003cp\u003e\n          Notwithstanding any other provision of this License, if you modify\n          the Program, your modified version must prominently offer all users\n          interacting with it remotely through a computer network (if your\n          version supports such interaction) an opportunity to receive the\n          Corresponding Source of your version by providing access to the\n          Corresponding Source from a network server at no charge, through\n          some standard or customary means of facilitating copying of\n          software. This Corresponding Source shall include the Corresponding\n          Source for any work covered by version 3 of the GNU General Public\n          License that is incorporated pursuant to the following paragraph.\n        \u003c/p\u003e\n\n        \u003cp\u003e\n          Notwithstanding any other provision of this License, you have\n          permission to link or combine any covered work with a work\n          licensed under version 3 of the GNU General Public License into\n          a single combined work, and to convey the resulting work. The\n          terms of this License will continue to apply to the part which\n          is the covered work, but the work with which it is combined will\n          remain governed by version 3 of the GNU General Public License.\n        \u003c/p\u003e\n\n      \u003c/li\u003e\n      \n\u003cli\u003e\n        \u003cvar class\u003d"replaceable-license-text"\u003e 14.\u003c/var\u003e\n        Revised Versions of this License.\n        \u003cp\u003e\n          The Free Software Foundation may publish revised and/or new versions\n          of the GNU Affero General Public License from time to time. Such\n          new versions will be similar in spirit to the present version,\n          but may differ in detail to address new problems or concerns.\n        \u003c/p\u003e\n\n        \u003cp\u003e\n          Each version is given a distinguishing version number. If the\n          Program specifies that a certain numbered version of the GNU\n          Affero General Public License \u0026quot;or any later version\u0026quot; applies to\n          it, you have the option of following the terms and conditions\n          either of that numbered version or of any later version published\n          by the Free Software Foundation. If the Program does not specify\n          a version number of the GNU Affero General Public License, you may\n          choose any version ever published by the Free Software Foundation.\n        \u003c/p\u003e\n\n        \u003cp\u003e\n          If the Program specifies that a proxy can decide which future\n          versions of the GNU Affero General Public License can be\n          used, that proxy\u0026apos;s public statement of acceptance of a version\n          permanently authorizes you to choose that version for the Program.\n        \u003c/p\u003e\n\n        \u003cp\u003e\n          Later license versions may give you additional or\n          different permissions. However, no additional obligations\n          are imposed on any author or copyright holder as a\n          result of your choosing to follow a later version.\n        \u003c/p\u003e\n\n      \u003c/li\u003e\n      \n\u003cli\u003e\n        \u003cvar class\u003d"replaceable-license-text"\u003e 15.\u003c/var\u003e\n        Disclaimer of Warranty.\n        \u003cp\u003e\n          THERE IS NO WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED\n          BY APPLICABLE LAW. EXCEPT WHEN OTHERWISE STATED IN WRITING\n          THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES PROVIDE THE PROGRAM\n          \u0026quot;AS IS\u0026quot; WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR\n          IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES\n          OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE\n          ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE PROGRAM\n          IS WITH YOU. SHOULD THE PROGRAM PROVE DEFECTIVE, YOU ASSUME\n          THE COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.\n        \u003c/p\u003e\n\n      \u003c/li\u003e\n      \n\u003cli\u003e\n        \u003cvar class\u003d"replaceable-license-text"\u003e 16.\u003c/var\u003e\n        Limitation of Liability.\n        \u003cp\u003e\n          IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING\n          WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MODIFIES AND/OR\n          CONVEYS THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES,\n          INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES\n          ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING\n          BUT NOT LIMITED TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE\n          OR LOSSES SUSTAINED BY YOU OR THIRD PARTIES OR A FAILURE OF THE\n          PROGRAM TO OPERATE WITH ANY OTHER PROGRAMS), EVEN IF SUCH HOLDER\n          OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.\n        \u003c/p\u003e\n\n      \u003c/li\u003e\n      \n\u003cli\u003e\n        \u003cvar class\u003d"replaceable-license-text"\u003e 17.\u003c/var\u003e\n        Interpretation of Sections 15 and 16.\n    \u003cp\u003e\n      If the disclaimer of warranty and limitation of liability\n      provided above cannot be given local legal effect according to\n      their terms, reviewing courts shall apply local law that most\n      closely approximates an absolute waiver of all civil liability in\n      connection with the Program, unless a warranty or assumption of\n      liability accompanies a copy of the Program in return for a fee.\n    \u003c/p\u003e\n\n      \u003c/li\u003e\n    \n\u003c/ul\u003e\n    \u003cdiv class\u003d"optional-license-text"\u003e \n      \u003cp\u003e\n        END OF TERMS AND CONDITIONS\n      \u003c/p\u003e\n\n      \u003cp\u003e\n        How to Apply These Terms to Your New Programs\n      \u003c/p\u003e\n\n      \u003cp\u003e\n        If you develop a new program, and you want it to be\n        of the greatest possible use to the public, the best\n        way to achieve this is to make it free software which\n        everyone can redistribute and change under these terms.\n      \u003c/p\u003e\n\n      \u003cp\u003e\n        To do so, attach the following notices to the program. It is safest\n        to attach them to the start of each source file to most effectively\n        state the exclusion of warranty; and each file should have at least\n        the \u0026quot;copyright\u0026quot; line and a pointer to where the full notice is found.\n      \u003c/p\u003e\n\n      \u003cp\u003e\n        \u003cvar class\u003d"replaceable-license-text"\u003e \u0026lt;one line to give the program\u0026apos;s name and\n        a brief idea of what it does.\u0026gt;\u003c/var\u003e\u003cbr /\u003e\n\n        Copyright (C) \u003cvar class\u003d"replaceable-license-text"\u003e \u0026lt;year\u0026gt; \u0026lt;name of author\u0026gt;\u003c/var\u003e\n      \u003c/p\u003e\n\n      \u003cp\u003e\n        This program is free software: you can redistribute it and/or\n        modify it under the terms of the GNU Affero General Public\n        License as published by the Free Software Foundation, either\n        version 3 of the License, or \u003cvar class\u003d"optional-license-text"\u003e (at your option)\u003c/var\u003e any later version.\n      \u003c/p\u003e\n\n      \u003cp\u003e\n        This program is distributed in the hope that it will be useful,\n        but WITHOUT ANY WARRANTY; without even the implied warranty\n        of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.\n        See the GNU Affero General Public License for more details.\n      \u003c/p\u003e\n\n      \u003cp\u003e\n        You should have received a copy of the GNU Affero General\n\tPublic License along with this program. If not, see\n\t\u0026lt;https://www.gnu.org/licenses/\u0026gt;.\n      \u003c/p\u003e\n\n      \u003cp\u003e\n        Also add information on how to contact you by electronic and paper mail.\n      \u003c/p\u003e\n\n      \u003cp\u003e\n        If your software can interact with users remotely through a\n        computer network, you should also make sure that it provides a\n        way for users to get its source. For example, if your program is\n        a web application, its interface could display a \u0026quot;Source\u0026quot; link\n        that leads users to an archive of the code. There are many ways\n        you could offer source, and different solutions will be better for\n        different programs; see section 13 for the specific requirements.\n      \u003c/p\u003e\n\n      \u003cp\u003e\n        You should also get your employer (if you work as a programmer)\n        or school, if any, to sign a \u0026quot;copyright disclaimer\u0026quot; for\n        the program, if necessary. For more information on this,\n\tand how to apply and follow the GNU AGPL, see\n\t\u0026lt;https://www.gnu.org/licenses/\u0026gt;.\n      \u003c/p\u003e\n\n    \u003c/div\u003e\n    ',
    "standardLicenseHeaderHtml": '\n      \u003cp\u003e\n        \u003cvar class\u003d"replaceable-license-text"\u003e \u0026lt;one line to give the program\u0026apos;s name and\n        a brief idea of what it does.\u0026gt;\u003c/var\u003e\u003cbr /\u003e\n\n        Copyright (C) \u003cvar class\u003d"replaceable-license-text"\u003e \u0026lt;year\u0026gt; \u0026lt;name of author\u0026gt;\u003c/var\u003e\n      \u003c/p\u003e\n\n      \u003cp\u003e\n        This program is free software: you can redistribute it and/or\n        modify it under the terms of the GNU Affero General Public\n        License as published by the Free Software Foundation, either\n        version 3 of the License, or \u003cvar class\u003d"optional-license-text"\u003e (at your option)\u003c/var\u003e any later version.\n      \u003c/p\u003e\n\n      \u003cp\u003e\n        This program is distributed in the hope that it will be useful,\n        but WITHOUT ANY WARRANTY; without even the implied warranty\n        of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.\n        See the GNU Affero General Public License for more details.\n      \u003c/p\u003e\n\n      \u003cp\u003e\n        You should have received a copy of the GNU Affero General\n\tPublic License along with this program. If not, see\n\t\u0026lt;https://www.gnu.org/licenses/\u0026gt;.\n      \u003c/p\u003e\n\n      ',
}

LICENSES = {
    "AGPL-3.0-or-later": AGPL_3__0_OR_LATER_LICENSE_DATA,
    "GPL-3.0-or-later": GPL_3__0_OR_LATER_LICENSE_DATA,
}


@pytest.fixture
def demo_project_fetcher(binary_file_cache: BinaryFileCache, tmp_path: Path) -> Fetcher:
    """
    Create the fetcher necessary to build the demonstration site in isolation.
    """
    spdx_directory_path = tmp_path / "spdx"
    spdx_directory_path.mkdir()

    licenses_file_path = (
        spdx_directory_path
        / f"license-list-data-{SpdxLicenseRepository.SPDX_VERSION}"
        / "json"
        / "licenses.json"
    )
    licenses_file_path.parent.mkdir(parents=True)
    with open(licenses_file_path, "w") as f:
        f.write(dumps(LICENSES_DATA))

    license_details_directory_path = (
        spdx_directory_path
        / f"license-list-data-{SpdxLicenseRepository.SPDX_VERSION}"
        / "json"
        / "details"
    )
    license_details_directory_path.mkdir()
    for spdx_license_id, license_data in LICENSES.items():
        license_file_path = license_details_directory_path / f"{spdx_license_id}.json"
        with open(license_file_path, "w") as f:
            f.write(dumps(license_data))

    spdx_tar_file_path = tmp_path / "spdx.tar.gz"
    with tarfile.open(spdx_tar_file_path, "w:gz") as spdx_tar_file:
        spdx_tar_file.add(spdx_directory_path, "/")
    return StaticFetcher(fetch_file_map={SpdxLicenseRepository.URL: spdx_tar_file_path})
