from dataclasses import dataclass, field
from typing import Union, overload

from ara_api._utils.communication.gRPC.messages.msp_msg_pb2 import (
    motor_data as motor_grpc,
)


@dataclass
class Motor:
    grpc: motor_grpc = field(default_factory=lambda: motor_grpc())
    json: dict = field(default_factory=lambda: {"motor": [0, 0, 0, 0]})

    def __repr__(self):
        if len(self.grpc.data) >= 4:
            return "Motor({first}, {second}, {third}, {fourth})".format(
                first=self.grpc.data[0],
                second=self.grpc.data[1],
                third=self.grpc.data[2],
                fourth=self.grpc.data[3],
            )
        else:
            return "Motor({motors})".format(
                motors=", ".join(str(m) for m in self.grpc.data)
            )

    @overload
    def sync(self, grpc: motor_grpc) -> None: ...

    @overload
    def sync(self, json: dict) -> None: ...

    def sync(self, data: Union[motor_grpc, dict]) -> None:
        if isinstance(data, motor_grpc):
            self.grpc.CopyFrom(data)

            if len(data.data) >= 4:
                motor_values = [
                    data.data[0],
                    data.data[1],
                    data.data[2],
                    data.data[3],
                ]
                self.json["motor"] = motor_values
            else:
                motor_values = list(data.data) + [0] * (4 - len(data.data))
                self.json["motor"] = motor_values

        elif isinstance(data, dict):
            self.json = data

            if "motor" in data and len(data["motor"]) >= 4:
                self.grpc.data = data["motor"]
