## [1.1.0] - 2025-06-19

### New Features

- Add pytest to test deps
- Add config params for frequency of updating
- Add analyzing of summary and create reports path with txt files
- Add classes for obstacle
- Add test for planning
- Add tests for project(try #2)
- Add debugger for testing (but need to test)
- Create documentations for ara api (test, need to reread)
- Add simple smooth algorithm and update config file
- Add visualization test for MPPI and Carrot Planner in 3 cases
- Add carrot planner for movement
- Add simple goal checker
- Add test planner, need to refactor
- Add skeleton of nav algorithms for new planning methods
- Add import testing and unit tests, update .gitignore
- Add test files for visualizing and analyzing of path
- Initial commit for starting navigation local and global planners
- Init data types for msp, vision and navigation nodes
- Init processors files and add msp process manager
- Add new data types for navigation


### Bug Fixes

- Fix fixing imports on generated files
- Fix circular imports in package
- Fix mermaid diagram
- Fix cmd_land_rc rpc in navigation proto
- Fix analyzer pages imports
- Test and fix debug
- Fix imports im grpc
- Fix imports, add new data_types and change path in test.sh
- Fix imports in generated files
- Fix coverage testing
- Fix imports and method Rotation.from_two_position
- Fix thread to process in MSPProcessorManager
- Delete unused imports and fix logging logic
- Fix update_loop in msp service
- Rename file names and update grpc fetcher
- Fix vision_service lock after request and QR-codes
- Fix transmitter abstract methods


### Changes

- Delete unused test files for plotly visualization
- Update import from communication module with new grpc logic
- Update protobuf files and regenerate new instances
- Pre-writing _core path
- Add new methods and classes import from _communication
- Fix imports (local_planner) (wtf)
- Refactor planner path, all planner in algorithms path
- Update config file
- Redefining analyser logic
- Init new structure for api
- Reinitialize vision module
- Add scipy as new dependency
- Update transmitter and refactor
- Update .gitignore(.pytest_cache/)
- Update vision data_types
- Update docs, but need to reread and rewrite smth
- Update project info and gitignore
- Remove path reports from git
- Update generate_proto.sh with new project architecture
- Delete dijkstra from PlanningAlgorithm
- Full refactor msp package (need to write sender for rc and zero odom)
- Delete unused tests
- Add new dependencies for monitoring processors
- Update generate_proto.sh with new logic of protobuf
- Add post-processing to generate_proto.bash for changing imports
- Add representation magic method to msp and nav data types
- Update transmitter and interfaces from review(need to test)
- Simple refactoring of manager, processors and comment grpc_sync
- Update __init__.py in service module
- Early switch to version 1.1.0-pre (for merge)
- Remove test planner, refactoring now
- Refactor obstacle detector and remove local_planner
- Move last ara-api to backup path
- Adapting carrot-test for real life terrain
- Update data logic and fix bags
- Import override for utils
- Update gitignore for mypy and ruff cache
- Refactoring test cases
- Amend "reinitilize navigation module" and fix import in __main__.py
- Update vision_controller and vision_processor, but need to test
- Update msp messages
- Define import logic for communication package
- Reinitialize navigation module
- Update logging logic for ara-api
- Fix pyproject.toml development status
- Update global planner and carrot testing for smoothing
- Implementation of GoalChecker and CarrotPlanner logic into the global planner
- Refactor test path
- Change config for test
- Premature migration for version 1.0.1
- Additional refactoring of imports


### Breaking Changes

- Add MPPI to nav core as controller, add new dataclasses, create config for MPPI and fix imports
- Change project architecture(again and need to refactor more)
- Update protobuf and grpc logic
- Remove backup ara_api code from project
- Initialize new logic for starting the app
- Change privacy of submodule in project and upgrade to 1.0.0-pre1
- Add new navigation checker, smoother and 3 controllers
