# Протоколы связи (ARA API)

В проекте ARA API используются различные протоколы для взаимодействия как внутри системы, так и с внешними клиентами и устройствами.

## 1. gRPC (Google Remote Procedure Call)

* **Назначение**: Основной протокол для предоставления внешнего API системы. Клиенты (например, наземная станция управления, другие приложения) используют gRPC для вызова функций на сервере ARA API.
* **Определение**: Контракты сервисов и структура сообщений определены в `.proto` файлах, расположенных в `ara_api/_utils/communication/protobuf/`:
  * `api.proto`: Общие определения, могут включать статус или Heartbeat.
  * `msp.proto`: Определения для `MspService`.
  * `navigation.proto`: Определения для `NavigationService`.
  * `vision.proto`: Определения для `VisionService`.
* **Транспорт**: Обычно используется HTTP/2.
* **Сериализация**: Protocol Buffers (Protobuf).
* **Преимущества**:
  * Высокая производительность.
  * Строгая типизация и четкие контракты API.
  * Поддержка потоковой передачи данных (streaming).
  * Генерация кода для различных языков программирования.
* **Использование в ARA API**:
  * `MspService`: Для взаимодействия с полетным контроллером через MSP.
  * `NavigationService`: Для команд управления полетом и получения навигационных данных.
  * `VisionService`: Для задач компьютерного зрения (детекция, стриминг видео).
* **Порт по умолчанию**: Определяется в конфигурации (`ara_api/_utils/config.py`, например, переменная `GRPC_PORT`, по умолчанию может быть 50051).

## 2. MSP (MultiWii Serial Protocol)

* **Назначение**: Протокол для связи между основным приложением ARA API (конкретно, `MspProcessor` внутри `MSPManagerProcess`) и полетным контроллером дрона (например, Betaflight, iNAV).
* **Тип**: Двоичный протокол последовательной связи.
* **Транспорт**: UART (через USB-Serial адаптер или напрямую), параметры подключения (порт, скорость) настраиваются в `ara_api/_utils/config.py`.
* **Структура пакета**: Обычно включает преамбулу (`$M<`), направление (запрос/ответ - `<` или `>`), размер данных, код команды, полезную нагрузку (данные) и контрольную сумму (CRC8).
* **Использование в ARA API**:
  * Чтение данных с сенсоров полетного контроллера (акселерометр, гироскоп, магнетометр, барометр, GPS).
  * Получение статусной информации (состояние арминга, режим полета, напряжение батареи).
  * Отправка команд управления (например, установка значений RC-каналов через `MSP_SET_RAW_RC`, команды арминга/дизарминга через `MSP_SET_ARMING_STATE`, команды для выполнения миссий, если поддерживается ПК).
  * Настройка параметров полетного контроллера (PID, режимы и т.д.).
* **Реализация**: Логика формирования, отправки, приема и парсинга MSP-пакетов находится в `ara_api/_core/processors/msp_processor.py` и использует `ara_api/_utils/transmitter.py` для непосредственной работы с последовательным портом. Данные MSP инкапсулируются с помощью `MspData` из `ara_api/_utils/data/msp_data.py`.

## 3. Межпроцессное взаимодействие (IPC) с использованием `multiprocessing.Queue`

* **Назначение**: Внутренний механизм для обмена данными и командами между главным процессом (`ApplicationManager`) и дочерними процессами-менеджерами сервисов (`MSPManagerProcess`, `NavigationManagerProcess`, `VisionManagerProcess`).
* **Тип**: Очереди сообщений из стандартной библиотеки Python `multiprocessing`.
* **Использование в ARA API**:
  * `ApplicationManager` создает и передает очереди каждому дочернему процессу.
  * Дочерние процессы используют очереди для отправки данных (например, телеметрии, результатов обработки) в `ApplicationManager` или другие процессы (если предусмотрена прямая связь).
  * `ApplicationManager` может использовать очереди для отправки команд или конфигурационных обновлений дочерним процессам.
* **Преимущества**:
  * Стандартный механизм Python, не требует внешних зависимостей.
  * Позволяет распараллелить выполнение задач и изолировать компоненты системы.
* **Реализация**: Инициализация очередей и их передача происходит в `ara_api/_core/manager.py`. Логика работы с очередями реализована в каждом из классов-процессоров (`ara_api/_core/processors/*_processor.py`) и их родительских классах менеджеров.

## 4. WebSocket (потенциальное использование)

* **Назначение**: Может использоваться для двунаправленной связи в реальном времени между сервером ARA API и клиентами, особенно веб-клиентами (например, для отображения телеметрии, логов или видеопотока в веб-интерфейсе).
* **Тип**: Протокол, работающий поверх TCP.
* **Преимущества**:
  * Низкая задержка для интерактивных приложений.
  * Эффективен для потоковой передачи данных.
* **Потенциальное использование в ARA API**:
  * Стриминг телеметрии в реальном времени на дашборд.
  * Передача логов событий.
  * Управление некоторыми аспектами системы через веб-интерфейс.
* **Реализация**: Если используется, соответствующая логика сервера WebSocket и обработчики сообщений могут находиться в `ara_api/_utils/communication/websocket_sync.py` (если такой файл будет создан) или в специализированных модулях сервисов.

## 5. Другие возможные протоколы

В зависимости от используемого оборудования и интеграций, могут применяться и другие протоколы:

* **MAVLink (Micro Air Vehicle Link)**: Распространенный протокол для связи с БПЛА и их компонентами. Если ARA API будет взаимодействовать с системами, использующими MAVLink (например, Pixhawk), потребуется соответствующая интеграция.
* **RTMP/RTSP (Real-Time Messaging Protocol / Real-Time Streaming Protocol)**: Для стриминга видео с камер дрона на внешние серверы или клиенты.
* **MQTT (Message Queuing Telemetry Transport)**: Легковесный протокол обмена сообщениями по подписке, удобный для IoT-приложений и распределенных систем.

---
*Этот документ описывает основные протоколы. Детали их реализации и использования в конкретных модулях см. в [Детальном описании модулей](./modules_detailed.md) и [Руководстве по API](./api_guide.md).*
