# /// script
# requires-python = "==3.13"
# dependencies = []
# ///

import os
import time

from ara_api._utils import Altitude, Vector3, get_request, gRPCSync, vector2

TEST_ALTITUDE = Altitude(1.0)
TEST_POSITION = Vector3(1.0, 0.0, 2.0)
TEST_SPEED = vector2(x=1.0, y=-1.0)


class TestNavCommands:
    def grpc_sync():
        return gRPCSync()

    def test_takeoff_command(self, grpc_sync):
        metadata = [
            ("source", "test-cmd"),
            ("client-id", "grpc-sync"),
            ("process-id", str(os.getpid())),
            ("timestamp", str(time.time())),
        ]
        result = grpc_sync.nav_cmd_takeoff(TEST_ALTITUDE.grpc, metadata)
        print(f"TakeOff command result: {result}")
        # assert result is not None, "TakeOff command returned None"

    def test_land_command(self, grpc_sync):
        metadata = [
            ("source", "test-cmd"),
            ("client-id", "grpc-sync"),
            ("process-id", str(os.getpid())),
            ("timestamp", str(time.time())),
        ]
        result = grpc_sync.nav_cmd_land(get_request(), metadata)
        print(f"Land command result: {result}")

    def test_move_command(self, grpc_sync):
        metadata = [
            # ("source", "test-cmd"),
            ("source", "gRPCSync"),
            ("client-id", "grpc-sync"),
            ("process-id", str(os.getpid())),
            ("timestamp", str(time.time())),
        ]
        result = grpc_sync.nav_cmd_move(TEST_POSITION.grpc, metadata)
        print(f"Move command result: {result}")

    def test_velocity_command(self, grpc_sync):
        metadata = [
            ("source", "test-cmd"),
            ("client-id", "grpc-sync"),
            ("process-id", str(os.getpid())),
            ("timestamp", str(time.time())),
        ]
        result = grpc_sync.nav_cmd_velocity(TEST_SPEED, metadata)
        print(f"Velocity command result: {result}")

    def test_altitude_command(self, grpc_sync):
        metadata = [
            ("source", "test-cmd"),
            ("client-id", "grpc-sync"),
            ("process-id", str(os.getpid())),
            ("timestamp", str(time.time())),
        ]
        result = grpc_sync.nav_cmd_altitude(get_request(), metadata)
        print(f"Altitude command result: {result}")


def main():
    print("Running Navigation Command Tests...")

    test_nav_cmds = TestNavCommands()
    grpc_sync = gRPCSync()

    print("Testing TakeOff Command...")
    test_nav_cmds.test_takeoff_command(grpc_sync)

    print("Testing Move Command...")
    test_nav_cmds.test_move_command(grpc_sync)

    # print("Testing Velocity Command...")
    # test_nav_cmds.test_velocity_command(grpc_sync)

    # print("Testing Altitude Command...")
    # test_nav_cmds.test_altitude_command(grpc_sync)

    print("Testing Land Command...")
    test_nav_cmds.test_land_command(grpc_sync)


if __name__ == "__main__":
    main()
