# generated by datamodel-codegen:
#   filename:  openapi_new.json
#   timestamp: 2025-07-17T03:14:16+00:00

from __future__ import annotations

from typing import Annotated, Any, Union

from pydantic import BaseModel, Field


class ValidationErrorTrajectoryType(BaseModel):
    loc: Annotated[list[Union[str, int]], Field(title="Location")]
    msg: Annotated[str, Field(title="Message")]
    type: Annotated[str, Field(title="Error Type")]


class ScorerDataTrajectoryType(BaseModel):
    name: Annotated[str, Field(title="Name")]
    threshold: Annotated[float, Field(title="Threshold")]
    success: Annotated[bool, Field(title="Success")]
    score: Annotated[float | None, Field(title="Score")] = None
    reason: Annotated[str | None, Field(title="Reason")] = None
    strict_mode: Annotated[bool | None, Field(title="Strict Mode")] = None
    evaluation_model: Annotated[
        Union[list[str], str] | None, Field(title="Evaluation Model")
    ] = None
    error: Annotated[str | None, Field(title="Error")] = None
    additional_metadata: Annotated[
        dict[str, Any] | None, Field(title="Additional Metadata")
    ] = None


class ScorerConfigTrajectoryType(BaseModel):
    score_type: Annotated[str, Field(title="Score Type")]
    name: Annotated[str | None, Field(title="Name")] = None
    threshold: Annotated[float | None, Field(title="Threshold")] = 0.5
    strict_mode: Annotated[bool | None, Field(title="Strict Mode")] = False
    required_params: Annotated[list[str] | None, Field(title="Required Params")] = (
        Field(default_factory=list)
    )
    kwargs: Annotated[dict[str, Any] | None, Field(title="Kwargs")] = None


class TraceUsageTrajectoryType(BaseModel):
    prompt_tokens: Annotated[int | None, Field(title="Prompt Tokens")] = None
    completion_tokens: Annotated[int | None, Field(title="Completion Tokens")] = None
    cache_creation_input_tokens: Annotated[
        int | None, Field(title="Cache Creation Input Tokens")
    ] = None
    cache_read_input_tokens: Annotated[
        int | None, Field(title="Cache Read Input Tokens")
    ] = None
    total_tokens: Annotated[int | None, Field(title="Total Tokens")] = None
    prompt_tokens_cost_usd: Annotated[
        float | None, Field(title="Prompt Tokens Cost Usd")
    ] = None
    completion_tokens_cost_usd: Annotated[
        float | None, Field(title="Completion Tokens Cost Usd")
    ] = None
    total_cost_usd: Annotated[float | None, Field(title="Total Cost Usd")] = None
    model_name: Annotated[str | None, Field(title="Model Name")] = None


class ToolTrajectoryType(BaseModel):
    tool_name: Annotated[str, Field(title="Tool Name")]
    parameters: Annotated[dict[str, Any] | None, Field(title="Parameters")] = None
    agent_name: Annotated[str | None, Field(title="Agent Name")] = None
    result_dependencies: Annotated[
        list[dict[str, Any]] | None, Field(title="Result Dependencies")
    ] = None
    action_dependencies: Annotated[
        list[dict[str, Any]] | None, Field(title="Action Dependencies")
    ] = None
    require_all: Annotated[bool | None, Field(title="Require All")] = None


class HTTPValidationErrorTrajectoryType(BaseModel):
    detail: Annotated[
        list[ValidationErrorTrajectoryType] | None, Field(title="Detail")
    ] = None


class TraceSpanTrajectoryType(BaseModel):
    span_id: Annotated[str, Field(title="Span Id")]
    trace_id: Annotated[str, Field(title="Trace Id")]
    function: Annotated[str, Field(title="Function")]
    depth: Annotated[int, Field(title="Depth")]
    created_at: Annotated[Any, Field(title="Created At")] = None
    parent_span_id: Annotated[str | None, Field(title="Parent Span Id")] = None
    span_type: Annotated[str | None, Field(title="Span Type")] = "span"
    inputs: Annotated[dict[str, Any] | None, Field(title="Inputs")] = None
    error: Annotated[dict[str, Any] | None, Field(title="Error")] = None
    output: Annotated[Any, Field(title="Output")] = None
    usage: TraceUsageTrajectoryType | None = None
    duration: Annotated[float | None, Field(title="Duration")] = None
    expected_tools: Annotated[
        list[ToolTrajectoryType] | None, Field(title="Expected Tools")
    ] = None
    additional_metadata: Annotated[
        dict[str, Any] | None, Field(title="Additional Metadata")
    ] = None
    has_evaluation: Annotated[bool | None, Field(title="Has Evaluation")] = False
    agent_name: Annotated[str | None, Field(title="Agent Name")] = None
    state_before: Annotated[dict[str, Any] | None, Field(title="State Before")] = None
    state_after: Annotated[dict[str, Any] | None, Field(title="State After")] = None
    update_id: Annotated[int | None, Field(title="Update Id")] = 1
    verification_results: Annotated[
        dict[str, Any] | None, Field(title="Verification Results")
    ] = None


class ExampleTrajectoryType(BaseModel):
    input: Annotated[Union[str, dict[str, Any]] | None, Field(title="Input")] = None
    actual_output: Annotated[
        Union[str, list[str]] | None, Field(title="Actual Output")
    ] = None
    expected_output: Annotated[
        Union[str, list[str]] | None, Field(title="Expected Output")
    ] = None
    context: Annotated[list[str] | None, Field(title="Context")] = None
    retrieval_context: Annotated[list[str] | None, Field(title="Retrieval Context")] = (
        None
    )
    additional_metadata: Annotated[
        dict[str, Any] | None, Field(title="Additional Metadata")
    ] = None
    tools_called: Annotated[list[str] | None, Field(title="Tools Called")] = Field(
        default_factory=list
    )
    expected_tools: Annotated[
        list[ToolTrajectoryType] | None, Field(title="Expected Tools")
    ] = Field(default_factory=list)
    name: Annotated[str | None, Field(title="Name")] = None
    example_id: Annotated[str, Field(title="Example Id")]
    example_index: Annotated[int | None, Field(title="Example Index")] = None
    created_at: Annotated[str | None, Field(title="Created At")] = None
    trace_id: Annotated[str | None, Field(title="Trace Id")] = None
    trace_span_id: Annotated[str | None, Field(title="Trace Span Id")] = None
    dataset_id: Annotated[str | None, Field(title="Dataset Id")] = None


class TraceTrajectoryType(BaseModel):
    trace_id: Annotated[str, Field(title="Trace Id")]
    name: Annotated[str, Field(title="Name")]
    created_at: Annotated[str, Field(title="Created At")]
    duration: Annotated[float, Field(title="Duration")]
    trace_spans: Annotated[list[TraceSpanTrajectoryType], Field(title="Trace Spans")]
    overwrite: Annotated[bool | None, Field(title="Overwrite")] = False
    offline_mode: Annotated[bool | None, Field(title="Offline Mode")] = False
    rules: Annotated[dict[str, Any] | None, Field(title="Rules")] = Field(
        default_factory=dict
    )
    has_notification: Annotated[bool | None, Field(title="Has Notification")] = False
    customer_id: Annotated[str | None, Field(title="Customer Id")] = None
    tags: Annotated[list[str] | None, Field(title="Tags")] = Field(default_factory=list)
    metadata: Annotated[dict[str, Any] | None, Field(title="Metadata")] = Field(
        default_factory=dict
    )
    update_id: Annotated[int | None, Field(title="Update Id")] = 1


class ScoringResultTrajectoryType(BaseModel):
    success: Annotated[bool, Field(title="Success")]
    scorers_data: Annotated[
        list[ScorerDataTrajectoryType] | None, Field(title="Scorers Data")
    ]
    name: Annotated[str | None, Field(title="Name")] = None
    data_object: Annotated[
        Union[TraceSpanTrajectoryType, ExampleTrajectoryType] | None,
        Field(title="Data Object"),
    ] = None
    trace_id: Annotated[str | None, Field(title="Trace Id")] = None
    run_duration: Annotated[float | None, Field(title="Run Duration")] = None
    evaluation_cost: Annotated[float | None, Field(title="Evaluation Cost")] = None


class TraceRunTrajectoryType(BaseModel):
    project_name: Annotated[str | None, Field(title="Project Name")] = None
    eval_name: Annotated[str | None, Field(title="Eval Name")] = None
    traces: Annotated[list[TraceTrajectoryType], Field(title="Traces")]
    scorers: Annotated[list[ScorerConfigTrajectoryType], Field(title="Scorers")]
    model: Annotated[str, Field(title="Model")]
    append: Annotated[bool | None, Field(title="Append")] = False
    override: Annotated[bool | None, Field(title="Override")] = False
    trace_span_id: Annotated[str | None, Field(title="Trace Span Id")] = None
    tools: Annotated[list[dict[str, Any]] | None, Field(title="Tools")] = None


class TrajectoryEvalTrajectoryType(BaseModel):
    project_name: Annotated[str | None, Field(title="Project Name")] = None
    eval_name: Annotated[str | None, Field(title="Eval Name")] = None
    examples: Annotated[list[ExampleTrajectoryType], Field(title="Examples")]
    scorers: Annotated[list[ScorerConfigTrajectoryType], Field(title="Scorers")]
    model: Annotated[str, Field(title="Model")]
    append: Annotated[bool | None, Field(title="Append")] = False
    override: Annotated[bool | None, Field(title="Override")] = False
    trace_span_id: Annotated[str | None, Field(title="Trace Span Id")] = None


class EvalResultsTrajectoryType(BaseModel):
    results: Annotated[list[ScoringResultTrajectoryType], Field(title="Results")]
    run: Annotated[
        Union[TraceRunTrajectoryType, TrajectoryEvalTrajectoryType], Field(title="Run")
    ]
