import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AlertMutingRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * The account id of the MutingRule..
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/alert_muting_rule#account_id AlertMutingRule#account_id}
    */
    readonly accountId?: number;
    /**
    * The description of the MutingRule.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/alert_muting_rule#description AlertMutingRule#description}
    */
    readonly description?: string;
    /**
    * Whether the MutingRule is enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/alert_muting_rule#enabled AlertMutingRule#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
    * The name of the MutingRule.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/alert_muting_rule#name AlertMutingRule#name}
    */
    readonly name: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/alert_muting_rule#condition AlertMutingRule#condition}
    */
    readonly condition: AlertMutingRuleCondition;
    /**
    * schedule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/alert_muting_rule#schedule AlertMutingRule#schedule}
    */
    readonly schedule?: AlertMutingRuleSchedule;
}
export interface AlertMutingRuleConditionConditions {
    /**
    * The attribute on a violation.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/alert_muting_rule#attribute AlertMutingRule#attribute}
    */
    readonly attribute: string;
    /**
    * The operator used to compare the attribute's value with the supplied value(s).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/alert_muting_rule#operator AlertMutingRule#operator}
    */
    readonly operator: string;
    /**
    * The value(s) to compare against the attribute's value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/alert_muting_rule#values AlertMutingRule#values}
    */
    readonly values: string[];
}
export declare function alertMutingRuleConditionConditionsToTerraform(struct?: AlertMutingRuleConditionConditions | cdktf.IResolvable): any;
export interface AlertMutingRuleCondition {
    /**
    * The operator used to combine all the MutingRuleConditions within the group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/alert_muting_rule#operator AlertMutingRule#operator}
    */
    readonly operator: string;
    /**
    * conditions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/alert_muting_rule#conditions AlertMutingRule#conditions}
    */
    readonly conditions: AlertMutingRuleConditionConditions[] | cdktf.IResolvable;
}
export declare function alertMutingRuleConditionToTerraform(struct?: AlertMutingRuleConditionOutputReference | AlertMutingRuleCondition): any;
export declare class AlertMutingRuleConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AlertMutingRuleCondition | undefined;
    set internalValue(value: AlertMutingRuleCondition | undefined);
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _conditions?;
    get conditions(): AlertMutingRuleConditionConditions[] | cdktf.IResolvable;
    set conditions(value: AlertMutingRuleConditionConditions[] | cdktf.IResolvable);
    get conditionsInput(): cdktf.IResolvable | AlertMutingRuleConditionConditions[] | undefined;
}
export interface AlertMutingRuleSchedule {
    /**
    * The datetime stamp when the MutingRule schedule should stop repeating.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/alert_muting_rule#end_repeat AlertMutingRule#end_repeat}
    */
    readonly endRepeat?: string;
    /**
    * The datetime stamp representing when the MutingRule should end.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/alert_muting_rule#end_time AlertMutingRule#end_time}
    */
    readonly endTime?: string;
    /**
    * The frequency the MutingRule schedule repeats. One of [DAILY, WEEKLY, MONTHLY]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/alert_muting_rule#repeat AlertMutingRule#repeat}
    */
    readonly repeat?: string;
    /**
    * The number of times the MutingRule schedule should repeat.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/alert_muting_rule#repeat_count AlertMutingRule#repeat_count}
    */
    readonly repeatCount?: number;
    /**
    * The datetime stamp representing when the MutingRule should start.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/alert_muting_rule#start_time AlertMutingRule#start_time}
    */
    readonly startTime?: string;
    /**
    * The time zone that applies to the MutingRule schedule.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/alert_muting_rule#time_zone AlertMutingRule#time_zone}
    */
    readonly timeZone: string;
    /**
    * The day(s) of the week that a MutingRule should repeat when the repeat field is set to WEEKLY.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/alert_muting_rule#weekly_repeat_days AlertMutingRule#weekly_repeat_days}
    */
    readonly weeklyRepeatDays?: string[];
}
export declare function alertMutingRuleScheduleToTerraform(struct?: AlertMutingRuleScheduleOutputReference | AlertMutingRuleSchedule): any;
export declare class AlertMutingRuleScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AlertMutingRuleSchedule | undefined;
    set internalValue(value: AlertMutingRuleSchedule | undefined);
    private _endRepeat?;
    get endRepeat(): string;
    set endRepeat(value: string);
    resetEndRepeat(): void;
    get endRepeatInput(): string | undefined;
    private _endTime?;
    get endTime(): string;
    set endTime(value: string);
    resetEndTime(): void;
    get endTimeInput(): string | undefined;
    private _repeat?;
    get repeat(): string;
    set repeat(value: string);
    resetRepeat(): void;
    get repeatInput(): string | undefined;
    private _repeatCount?;
    get repeatCount(): number;
    set repeatCount(value: number);
    resetRepeatCount(): void;
    get repeatCountInput(): number | undefined;
    private _startTime?;
    get startTime(): string;
    set startTime(value: string);
    resetStartTime(): void;
    get startTimeInput(): string | undefined;
    private _timeZone?;
    get timeZone(): string;
    set timeZone(value: string);
    get timeZoneInput(): string | undefined;
    private _weeklyRepeatDays?;
    get weeklyRepeatDays(): string[];
    set weeklyRepeatDays(value: string[]);
    resetWeeklyRepeatDays(): void;
    get weeklyRepeatDaysInput(): string[] | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/newrelic/r/alert_muting_rule newrelic_alert_muting_rule}
*/
export declare class AlertMutingRule extends cdktf.TerraformResource {
    static readonly tfResourceType = "newrelic_alert_muting_rule";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/newrelic/r/alert_muting_rule newrelic_alert_muting_rule} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AlertMutingRuleConfig
    */
    constructor(scope: Construct, id: string, config: AlertMutingRuleConfig);
    private _accountId?;
    get accountId(): number;
    set accountId(value: number);
    resetAccountId(): void;
    get accountIdInput(): number | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _condition;
    get condition(): AlertMutingRuleConditionOutputReference;
    putCondition(value: AlertMutingRuleCondition): void;
    get conditionInput(): AlertMutingRuleCondition | undefined;
    private _schedule;
    get schedule(): AlertMutingRuleScheduleOutputReference;
    putSchedule(value: AlertMutingRuleSchedule): void;
    resetSchedule(): void;
    get scheduleInput(): AlertMutingRuleSchedule | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
