import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CloudGcpLinkAccountConfig extends cdktf.TerraformMetaArguments {
    /**
    * accountID of newrelic account
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_gcp_link_account#account_id CloudGcpLinkAccount#account_id}
    */
    readonly accountId?: number;
    /**
    * name of the linked account
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_gcp_link_account#name CloudGcpLinkAccount#name}
    */
    readonly name: string;
    /**
    * project id of the Gcp account
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_gcp_link_account#project_id CloudGcpLinkAccount#project_id}
    */
    readonly projectId: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_gcp_link_account newrelic_cloud_gcp_link_account}
*/
export declare class CloudGcpLinkAccount extends cdktf.TerraformResource {
    static readonly tfResourceType = "newrelic_cloud_gcp_link_account";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_gcp_link_account newrelic_cloud_gcp_link_account} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CloudGcpLinkAccountConfig
    */
    constructor(scope: Construct, id: string, config: CloudGcpLinkAccountConfig);
    private _accountId?;
    get accountId(): number;
    set accountId(value: number);
    resetAccountId(): void;
    get accountIdInput(): number | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
