import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DashboardConfig extends cdktf.TerraformMetaArguments {
    /**
    * Determines who can edit the dashboard in an account. Valid values are all, editable_by_all, editable_by_owner, or read_only. Defaults to editable_by_all.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/dashboard#editable Dashboard#editable}
    */
    readonly editable?: string;
    /**
    * New Relic One supports a 3 column grid or a 12 column grid. New Relic Insights supports a 3 column grid.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/dashboard#grid_column_count Dashboard#grid_column_count}
    */
    readonly gridColumnCount?: number;
    /**
    * The icon for the dashboard.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/dashboard#icon Dashboard#icon}
    */
    readonly icon?: string;
    /**
    * The title of the dashboard.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/dashboard#title Dashboard#title}
    */
    readonly title: string;
    /**
    * Determines who can see the dashboard in an account. Valid values are all or owner. Defaults to all.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/dashboard#visibility Dashboard#visibility}
    */
    readonly visibility?: string;
    /**
    * filter block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/dashboard#filter Dashboard#filter}
    */
    readonly filter?: DashboardFilter;
    /**
    * widget block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/dashboard#widget Dashboard#widget}
    */
    readonly widget?: DashboardWidget[] | cdktf.IResolvable;
}
export interface DashboardFilter {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/dashboard#attributes Dashboard#attributes}
    */
    readonly attributes?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/dashboard#event_types Dashboard#event_types}
    */
    readonly eventTypes: string[];
}
export declare function dashboardFilterToTerraform(struct?: DashboardFilterOutputReference | DashboardFilter): any;
export declare class DashboardFilterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardFilter | undefined;
    set internalValue(value: DashboardFilter | undefined);
    private _attributes?;
    get attributes(): string[];
    set attributes(value: string[]);
    resetAttributes(): void;
    get attributesInput(): string[] | undefined;
    private _eventTypes?;
    get eventTypes(): string[];
    set eventTypes(value: string[]);
    get eventTypesInput(): string[] | undefined;
}
export interface DashboardWidgetCompareWithPresentation {
    /**
    * The color for the rendered data.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/dashboard#color Dashboard#color}
    */
    readonly color: string;
    /**
    * The name for the rendered data.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/dashboard#name Dashboard#name}
    */
    readonly name: string;
}
export declare function dashboardWidgetCompareWithPresentationToTerraform(struct?: DashboardWidgetCompareWithPresentationOutputReference | DashboardWidgetCompareWithPresentation): any;
export declare class DashboardWidgetCompareWithPresentationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetCompareWithPresentation | undefined;
    set internalValue(value: DashboardWidgetCompareWithPresentation | undefined);
    private _color?;
    get color(): string;
    set color(value: string);
    get colorInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export interface DashboardWidgetCompareWith {
    /**
    * The offset duration for the COMPARE WITH clause.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/dashboard#offset_duration Dashboard#offset_duration}
    */
    readonly offsetDuration: string;
    /**
    * presentation block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/dashboard#presentation Dashboard#presentation}
    */
    readonly presentation: DashboardWidgetCompareWithPresentation;
}
export declare function dashboardWidgetCompareWithToTerraform(struct?: DashboardWidgetCompareWith | cdktf.IResolvable): any;
export interface DashboardWidgetMetric {
    /**
    * The metric name to display.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/dashboard#name Dashboard#name}
    */
    readonly name: string;
    /**
    * The metric scope.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/dashboard#scope Dashboard#scope}
    */
    readonly scope?: string;
    /**
    * The metric units.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/dashboard#units Dashboard#units}
    */
    readonly units?: string;
    /**
    * The metric values to display.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/dashboard#values Dashboard#values}
    */
    readonly values?: string[];
}
export declare function dashboardWidgetMetricToTerraform(struct?: DashboardWidgetMetric | cdktf.IResolvable): any;
export interface DashboardWidget {
    /**
    * The target account ID to fetch data from, if not the current account.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/dashboard#account_id Dashboard#account_id}
    */
    readonly accountId?: number;
    /**
    * Column position of widget from top left, starting at 1.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/dashboard#column Dashboard#column}
    */
    readonly column: number;
    /**
    * The ID of a dashboard to link to from the widget's facets.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/dashboard#drilldown_dashboard_id Dashboard#drilldown_dashboard_id}
    */
    readonly drilldownDashboardId?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/dashboard#duration Dashboard#duration}
    */
    readonly duration?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/dashboard#end_time Dashboard#end_time}
    */
    readonly endTime?: number;
    /**
    * A collection of entity ids to display data for. These are typically application IDs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/dashboard#entity_ids Dashboard#entity_ids}
    */
    readonly entityIds?: number[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * Height of the widget. Valid values are 1 to 3 inclusive. Defaults to 1.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/dashboard#height Dashboard#height}
    */
    readonly height?: number;
    /**
    * The limit of distinct data series to display.  Requires `order_by` to be set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/dashboard#limit Dashboard#limit}
    */
    readonly limit?: number;
    /**
    * Description of the widget.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/dashboard#notes Dashboard#notes}
    */
    readonly notes?: string;
    /**
    * Valid NRQL query string.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/dashboard#nrql Dashboard#nrql}
    */
    readonly nrql?: string;
    /**
    * Set the order of result series.  Required when using `limit`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/dashboard#order_by Dashboard#order_by}
    */
    readonly orderBy?: string;
    /**
    * Row position of widget from top left, starting at 1.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/dashboard#row Dashboard#row}
    */
    readonly row: number;
    /**
    * The markdown source to be rendered in the widget.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/dashboard#source Dashboard#source}
    */
    readonly source?: string;
    /**
    * Threshold above which the displayed value will be styled with a red color.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/dashboard#threshold_red Dashboard#threshold_red}
    */
    readonly thresholdRed?: number;
    /**
    * Threshold above which the displayed value will be styled with a yellow color.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/dashboard#threshold_yellow Dashboard#threshold_yellow}
    */
    readonly thresholdYellow?: number;
    /**
    * A title for the widget.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/dashboard#title Dashboard#title}
    */
    readonly title: string;
    /**
    * How the widget visualizes data.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/dashboard#visualization Dashboard#visualization}
    */
    readonly visualization: string;
    /**
    * Width of the widget. Valid values are 1 to 3 inclusive. Defaults to 1.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/dashboard#width Dashboard#width}
    */
    readonly width?: number;
    /**
    * compare_with block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/dashboard#compare_with Dashboard#compare_with}
    */
    readonly compareWith?: DashboardWidgetCompareWith[] | cdktf.IResolvable;
    /**
    * metric block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/dashboard#metric Dashboard#metric}
    */
    readonly metric?: DashboardWidgetMetric[] | cdktf.IResolvable;
}
export declare function dashboardWidgetToTerraform(struct?: DashboardWidget | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/newrelic/r/dashboard newrelic_dashboard}
*/
export declare class Dashboard extends cdktf.TerraformResource {
    static readonly tfResourceType = "newrelic_dashboard";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/newrelic/r/dashboard newrelic_dashboard} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DashboardConfig
    */
    constructor(scope: Construct, id: string, config: DashboardConfig);
    get dashboardUrl(): string;
    private _editable?;
    get editable(): string;
    set editable(value: string);
    resetEditable(): void;
    get editableInput(): string | undefined;
    private _gridColumnCount?;
    get gridColumnCount(): number;
    set gridColumnCount(value: number);
    resetGridColumnCount(): void;
    get gridColumnCountInput(): number | undefined;
    private _icon?;
    get icon(): string;
    set icon(value: string);
    resetIcon(): void;
    get iconInput(): string | undefined;
    get id(): string;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
    private _visibility?;
    get visibility(): string;
    set visibility(value: string);
    resetVisibility(): void;
    get visibilityInput(): string | undefined;
    private _filter;
    get filter(): DashboardFilterOutputReference;
    putFilter(value: DashboardFilter): void;
    resetFilter(): void;
    get filterInput(): DashboardFilter | undefined;
    private _widget?;
    get widget(): DashboardWidget[] | cdktf.IResolvable;
    set widget(value: DashboardWidget[] | cdktf.IResolvable);
    resetWidget(): void;
    get widgetInput(): cdktf.IResolvable | DashboardWidget[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
