import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataNewrelicAlertChannelConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the alert channel in New Relic.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/d/alert_channel#name DataNewrelicAlertChannel#name}
    */
    readonly name: string;
}
export interface DataNewrelicAlertChannelConfigA {
}
export declare function dataNewrelicAlertChannelConfigAToTerraform(struct?: DataNewrelicAlertChannelConfigA): any;
export declare class DataNewrelicAlertChannelConfigAOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataNewrelicAlertChannelConfigA | undefined;
    set internalValue(value: DataNewrelicAlertChannelConfigA | undefined);
    get apiKey(): string;
    get authPassword(): string;
    get authType(): string;
    get authUsername(): string;
    get baseUrl(): string;
    get channel(): string;
    headers(key: string): string | cdktf.IResolvable;
    get includeJsonAttachment(): string;
    get key(): string;
    payload(key: string): string | cdktf.IResolvable;
    get payloadType(): string;
    get recipients(): string;
    get region(): string;
    get routeKey(): string;
    get serviceKey(): string;
    get tags(): string;
    get teams(): string;
    get url(): string;
    get userId(): string;
}
export declare class DataNewrelicAlertChannelConfigAList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataNewrelicAlertChannelConfigAOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/newrelic/d/alert_channel newrelic_alert_channel}
*/
export declare class DataNewrelicAlertChannel extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "newrelic_alert_channel";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/newrelic/d/alert_channel newrelic_alert_channel} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataNewrelicAlertChannelConfig
    */
    constructor(scope: Construct, id: string, config: DataNewrelicAlertChannelConfig);
    private _config;
    get config(): DataNewrelicAlertChannelConfigAList;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get policyIds(): number[];
    get type(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
