import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataNewrelicApplicationConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the application in New Relic.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/d/application#name DataNewrelicApplication#name}
    */
    readonly name: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/newrelic/d/application newrelic_application}
*/
export declare class DataNewrelicApplication extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "newrelic_application";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/newrelic/d/application newrelic_application} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataNewrelicApplicationConfig
    */
    constructor(scope: Construct, id: string, config: DataNewrelicApplicationConfig);
    get hostIds(): number[];
    get id(): string;
    get instanceIds(): number[];
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
