import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataNewrelicCloudAccountConfig extends cdktf.TerraformMetaArguments {
    /**
    * The ID of the New Relic account.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/d/cloud_account#account_id DataNewrelicCloudAccount#account_id}
    */
    readonly accountId?: number;
    /**
    * The cloud provider of the account, e.g. aws, gcp, azure
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/d/cloud_account#cloud_provider DataNewrelicCloudAccount#cloud_provider}
    */
    readonly cloudProvider: string;
    /**
    * The name of the cloud account.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/d/cloud_account#name DataNewrelicCloudAccount#name}
    */
    readonly name: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/newrelic/d/cloud_account newrelic_cloud_account}
*/
export declare class DataNewrelicCloudAccount extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "newrelic_cloud_account";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/newrelic/d/cloud_account newrelic_cloud_account} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataNewrelicCloudAccountConfig
    */
    constructor(scope: Construct, id: string, config: DataNewrelicCloudAccountConfig);
    private _accountId?;
    get accountId(): number;
    set accountId(value: number);
    resetAccountId(): void;
    get accountIdInput(): number | undefined;
    private _cloudProvider?;
    get cloudProvider(): string;
    set cloudProvider(value: string);
    get cloudProviderInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
