import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataNewrelicEntityConfig extends cdktf.TerraformMetaArguments {
    /**
    * The entity's domain. Valid values are APM, BROWSER, INFRA, MOBILE, SYNTH, and VIZ. If not specified, all domains are searched.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/d/entity#domain DataNewrelicEntity#domain}
    */
    readonly domain?: string;
    /**
    * Ignore case when searching the entity name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/d/entity#ignore_case DataNewrelicEntity#ignore_case}
    */
    readonly ignoreCase?: boolean | cdktf.IResolvable;
    /**
    * The name of the entity in New Relic One.  The first entity matching this name for the given search parameters will be returned.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/d/entity#name DataNewrelicEntity#name}
    */
    readonly name: string;
    /**
    * The entity's type. Valid values are APPLICATION, DASHBOARD, HOST, MONITOR, and WORKLOAD.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/d/entity#type DataNewrelicEntity#type}
    */
    readonly type?: string;
    /**
    * tag block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/d/entity#tag DataNewrelicEntity#tag}
    */
    readonly tag?: DataNewrelicEntityTag;
}
export interface DataNewrelicEntityTag {
    /**
    * The tag key.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/d/entity#key DataNewrelicEntity#key}
    */
    readonly key: string;
    /**
    * The tag value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/d/entity#value DataNewrelicEntity#value}
    */
    readonly value: string;
}
export declare function dataNewrelicEntityTagToTerraform(struct?: DataNewrelicEntityTagOutputReference | DataNewrelicEntityTag): any;
export declare class DataNewrelicEntityTagOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataNewrelicEntityTag | undefined;
    set internalValue(value: DataNewrelicEntityTag | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/newrelic/d/entity newrelic_entity}
*/
export declare class DataNewrelicEntity extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "newrelic_entity";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/newrelic/d/entity newrelic_entity} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataNewrelicEntityConfig
    */
    constructor(scope: Construct, id: string, config: DataNewrelicEntityConfig);
    get accountId(): number;
    get applicationId(): number;
    private _domain?;
    get domain(): string;
    set domain(value: string);
    resetDomain(): void;
    get domainInput(): string | undefined;
    get guid(): string;
    get id(): string;
    private _ignoreCase?;
    get ignoreCase(): boolean | cdktf.IResolvable;
    set ignoreCase(value: boolean | cdktf.IResolvable);
    resetIgnoreCase(): void;
    get ignoreCaseInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get servingApmApplicationId(): number;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _tag;
    get tag(): DataNewrelicEntityTagOutputReference;
    putTag(value: DataNewrelicEntityTag): void;
    resetTag(): void;
    get tagInput(): DataNewrelicEntityTag | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
