import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataNewrelicKeyTransactionConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the key transaction in New Relic.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/d/key_transaction#name DataNewrelicKeyTransaction#name}
    */
    readonly name: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/newrelic/d/key_transaction newrelic_key_transaction}
*/
export declare class DataNewrelicKeyTransaction extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "newrelic_key_transaction";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/newrelic/d/key_transaction newrelic_key_transaction} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataNewrelicKeyTransactionConfig
    */
    constructor(scope: Construct, id: string, config: DataNewrelicKeyTransactionConfig);
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
