import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataNewrelicPluginConfig extends cdktf.TerraformMetaArguments {
    /**
    * The GUID of the plugin in New Relic.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/d/plugin#guid DataNewrelicPlugin#guid}
    */
    readonly guid: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/newrelic/d/plugin newrelic_plugin}
*/
export declare class DataNewrelicPlugin extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "newrelic_plugin";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/newrelic/d/plugin newrelic_plugin} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataNewrelicPluginConfig
    */
    constructor(scope: Construct, id: string, config: DataNewrelicPluginConfig);
    private _guid?;
    get guid(): string;
    set guid(value: string);
    get guidInput(): string | undefined;
    get id(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
