import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataNewrelicSyntheticsMonitorLocationConfig extends cdktf.TerraformMetaArguments {
    /**
    * The label of the Synthetics monitor location.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/d/synthetics_monitor_location#label DataNewrelicSyntheticsMonitorLocation#label}
    */
    readonly label: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/newrelic/d/synthetics_monitor_location newrelic_synthetics_monitor_location}
*/
export declare class DataNewrelicSyntheticsMonitorLocation extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "newrelic_synthetics_monitor_location";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/newrelic/d/synthetics_monitor_location newrelic_synthetics_monitor_location} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataNewrelicSyntheticsMonitorLocationConfig
    */
    constructor(scope: Construct, id: string, config: DataNewrelicSyntheticsMonitorLocationConfig);
    get description(): string;
    get highSecurityMode(): cdktf.IResolvable;
    get id(): string;
    private _label?;
    get label(): string;
    set label(value: string);
    get labelInput(): string | undefined;
    get name(): string;
    get private(): cdktf.IResolvable;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
