import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataNewrelicSyntheticsMonitorConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the synthetics monitor in New Relic.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/d/synthetics_monitor#name DataNewrelicSyntheticsMonitor#name}
    */
    readonly name: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/newrelic/d/synthetics_monitor newrelic_synthetics_monitor}
*/
export declare class DataNewrelicSyntheticsMonitor extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "newrelic_synthetics_monitor";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/newrelic/d/synthetics_monitor newrelic_synthetics_monitor} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataNewrelicSyntheticsMonitorConfig
    */
    constructor(scope: Construct, id: string, config: DataNewrelicSyntheticsMonitorConfig);
    get id(): string;
    get monitorId(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
