import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataNewrelicSyntheticsSecureCredentialConfig extends cdktf.TerraformMetaArguments {
    /**
    * The secure credential's key name. Regardless of the case used in the configuration, the provider will provide an upcased key to the underlying API.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/d/synthetics_secure_credential#key DataNewrelicSyntheticsSecureCredential#key}
    */
    readonly key: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/newrelic/d/synthetics_secure_credential newrelic_synthetics_secure_credential}
*/
export declare class DataNewrelicSyntheticsSecureCredential extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "newrelic_synthetics_secure_credential";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/newrelic/d/synthetics_secure_credential newrelic_synthetics_secure_credential} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataNewrelicSyntheticsSecureCredentialConfig
    */
    constructor(scope: Construct, id: string, config: DataNewrelicSyntheticsSecureCredentialConfig);
    get createdAt(): string;
    get description(): string;
    get id(): string;
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    get lastUpdated(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
