import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NewrelicProviderConfig {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic#account_id NewrelicProvider#account_id}
    */
    readonly accountId: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic#admin_api_key NewrelicProvider#admin_api_key}
    */
    readonly adminApiKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic#api_key NewrelicProvider#api_key}
    */
    readonly apiKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic#api_url NewrelicProvider#api_url}
    */
    readonly apiUrl?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic#cacert_file NewrelicProvider#cacert_file}
    */
    readonly cacertFile?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic#infrastructure_api_url NewrelicProvider#infrastructure_api_url}
    */
    readonly infrastructureApiUrl?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic#insecure_skip_verify NewrelicProvider#insecure_skip_verify}
    */
    readonly insecureSkipVerify?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic#insights_insert_key NewrelicProvider#insights_insert_key}
    */
    readonly insightsInsertKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic#insights_insert_url NewrelicProvider#insights_insert_url}
    */
    readonly insightsInsertUrl?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic#insights_query_url NewrelicProvider#insights_query_url}
    */
    readonly insightsQueryUrl?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic#nerdgraph_api_url NewrelicProvider#nerdgraph_api_url}
    */
    readonly nerdgraphApiUrl?: string;
    /**
    * The data center for which your New Relic account is configured. Only one region per provider block is permitted.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic#region NewrelicProvider#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic#synthetics_api_url NewrelicProvider#synthetics_api_url}
    */
    readonly syntheticsApiUrl?: string;
    /**
    * Alias name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic#alias NewrelicProvider#alias}
    */
    readonly alias?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/newrelic newrelic}
*/
export declare class NewrelicProvider extends cdktf.TerraformProvider {
    static readonly tfResourceType = "newrelic";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/newrelic newrelic} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NewrelicProviderConfig
    */
    constructor(scope: Construct, id: string, config: NewrelicProviderConfig);
    private _accountId?;
    get accountId(): number | undefined;
    set accountId(value: number | undefined);
    get accountIdInput(): number | undefined;
    private _adminApiKey?;
    get adminApiKey(): string | undefined;
    set adminApiKey(value: string | undefined);
    resetAdminApiKey(): void;
    get adminApiKeyInput(): string | undefined;
    private _apiKey?;
    get apiKey(): string | undefined;
    set apiKey(value: string | undefined);
    resetApiKey(): void;
    get apiKeyInput(): string | undefined;
    private _apiUrl?;
    get apiUrl(): string | undefined;
    set apiUrl(value: string | undefined);
    resetApiUrl(): void;
    get apiUrlInput(): string | undefined;
    private _cacertFile?;
    get cacertFile(): string | undefined;
    set cacertFile(value: string | undefined);
    resetCacertFile(): void;
    get cacertFileInput(): string | undefined;
    private _infrastructureApiUrl?;
    get infrastructureApiUrl(): string | undefined;
    set infrastructureApiUrl(value: string | undefined);
    resetInfrastructureApiUrl(): void;
    get infrastructureApiUrlInput(): string | undefined;
    private _insecureSkipVerify?;
    get insecureSkipVerify(): boolean | cdktf.IResolvable | undefined;
    set insecureSkipVerify(value: boolean | cdktf.IResolvable | undefined);
    resetInsecureSkipVerify(): void;
    get insecureSkipVerifyInput(): boolean | cdktf.IResolvable | undefined;
    private _insightsInsertKey?;
    get insightsInsertKey(): string | undefined;
    set insightsInsertKey(value: string | undefined);
    resetInsightsInsertKey(): void;
    get insightsInsertKeyInput(): string | undefined;
    private _insightsInsertUrl?;
    get insightsInsertUrl(): string | undefined;
    set insightsInsertUrl(value: string | undefined);
    resetInsightsInsertUrl(): void;
    get insightsInsertUrlInput(): string | undefined;
    private _insightsQueryUrl?;
    get insightsQueryUrl(): string | undefined;
    set insightsQueryUrl(value: string | undefined);
    resetInsightsQueryUrl(): void;
    get insightsQueryUrlInput(): string | undefined;
    private _nerdgraphApiUrl?;
    get nerdgraphApiUrl(): string | undefined;
    set nerdgraphApiUrl(value: string | undefined);
    resetNerdgraphApiUrl(): void;
    get nerdgraphApiUrlInput(): string | undefined;
    private _region?;
    get region(): string | undefined;
    set region(value: string | undefined);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _syntheticsApiUrl?;
    get syntheticsApiUrl(): string | undefined;
    set syntheticsApiUrl(value: string | undefined);
    resetSyntheticsApiUrl(): void;
    get syntheticsApiUrlInput(): string | undefined;
    private _alias?;
    get alias(): string | undefined;
    set alias(value: string | undefined);
    resetAlias(): void;
    get aliasInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
