"use strict";
var _a, _b, _c, _d;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NrqlAlertCondition = exports.NrqlAlertConditionWarningOutputReference = exports.nrqlAlertConditionWarningToTerraform = exports.nrqlAlertConditionTermToTerraform = exports.NrqlAlertConditionNrqlOutputReference = exports.nrqlAlertConditionNrqlToTerraform = exports.NrqlAlertConditionCriticalOutputReference = exports.nrqlAlertConditionCriticalToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function nrqlAlertConditionCriticalToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        duration: cdktf.numberToTerraform(struct.duration),
        operator: cdktf.stringToTerraform(struct.operator),
        threshold: cdktf.numberToTerraform(struct.threshold),
        threshold_duration: cdktf.numberToTerraform(struct.thresholdDuration),
        threshold_occurrences: cdktf.stringToTerraform(struct.thresholdOccurrences),
        time_function: cdktf.stringToTerraform(struct.timeFunction),
    };
}
exports.nrqlAlertConditionCriticalToTerraform = nrqlAlertConditionCriticalToTerraform;
class NrqlAlertConditionCriticalOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._duration !== undefined) {
            hasAnyValues = true;
            internalValueResult.duration = this._duration;
        }
        if (this._operator !== undefined) {
            hasAnyValues = true;
            internalValueResult.operator = this._operator;
        }
        if (this._threshold !== undefined) {
            hasAnyValues = true;
            internalValueResult.threshold = this._threshold;
        }
        if (this._thresholdDuration !== undefined) {
            hasAnyValues = true;
            internalValueResult.thresholdDuration = this._thresholdDuration;
        }
        if (this._thresholdOccurrences !== undefined) {
            hasAnyValues = true;
            internalValueResult.thresholdOccurrences = this._thresholdOccurrences;
        }
        if (this._timeFunction !== undefined) {
            hasAnyValues = true;
            internalValueResult.timeFunction = this._timeFunction;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._duration = undefined;
            this._operator = undefined;
            this._threshold = undefined;
            this._thresholdDuration = undefined;
            this._thresholdOccurrences = undefined;
            this._timeFunction = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._duration = value.duration;
            this._operator = value.operator;
            this._threshold = value.threshold;
            this._thresholdDuration = value.thresholdDuration;
            this._thresholdOccurrences = value.thresholdOccurrences;
            this._timeFunction = value.timeFunction;
        }
    }
    get duration() {
        return this.getNumberAttribute('duration');
    }
    set duration(value) {
        this._duration = value;
    }
    resetDuration() {
        this._duration = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get durationInput() {
        return this._duration;
    }
    get operator() {
        return this.getStringAttribute('operator');
    }
    set operator(value) {
        this._operator = value;
    }
    resetOperator() {
        this._operator = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get operatorInput() {
        return this._operator;
    }
    get threshold() {
        return this.getNumberAttribute('threshold');
    }
    set threshold(value) {
        this._threshold = value;
    }
    // Temporarily expose input value. Use with caution.
    get thresholdInput() {
        return this._threshold;
    }
    get thresholdDuration() {
        return this.getNumberAttribute('threshold_duration');
    }
    set thresholdDuration(value) {
        this._thresholdDuration = value;
    }
    resetThresholdDuration() {
        this._thresholdDuration = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get thresholdDurationInput() {
        return this._thresholdDuration;
    }
    get thresholdOccurrences() {
        return this.getStringAttribute('threshold_occurrences');
    }
    set thresholdOccurrences(value) {
        this._thresholdOccurrences = value;
    }
    resetThresholdOccurrences() {
        this._thresholdOccurrences = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get thresholdOccurrencesInput() {
        return this._thresholdOccurrences;
    }
    get timeFunction() {
        return this.getStringAttribute('time_function');
    }
    set timeFunction(value) {
        this._timeFunction = value;
    }
    resetTimeFunction() {
        this._timeFunction = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timeFunctionInput() {
        return this._timeFunction;
    }
}
exports.NrqlAlertConditionCriticalOutputReference = NrqlAlertConditionCriticalOutputReference;
_a = JSII_RTTI_SYMBOL_1;
NrqlAlertConditionCriticalOutputReference[_a] = { fqn: "@cdktf/provider-newrelic.NrqlAlertConditionCriticalOutputReference", version: "0.4.22" };
function nrqlAlertConditionNrqlToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        evaluation_offset: cdktf.numberToTerraform(struct.evaluationOffset),
        query: cdktf.stringToTerraform(struct.query),
        since_value: cdktf.stringToTerraform(struct.sinceValue),
    };
}
exports.nrqlAlertConditionNrqlToTerraform = nrqlAlertConditionNrqlToTerraform;
class NrqlAlertConditionNrqlOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._evaluationOffset !== undefined) {
            hasAnyValues = true;
            internalValueResult.evaluationOffset = this._evaluationOffset;
        }
        if (this._query !== undefined) {
            hasAnyValues = true;
            internalValueResult.query = this._query;
        }
        if (this._sinceValue !== undefined) {
            hasAnyValues = true;
            internalValueResult.sinceValue = this._sinceValue;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._evaluationOffset = undefined;
            this._query = undefined;
            this._sinceValue = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._evaluationOffset = value.evaluationOffset;
            this._query = value.query;
            this._sinceValue = value.sinceValue;
        }
    }
    get evaluationOffset() {
        return this.getNumberAttribute('evaluation_offset');
    }
    set evaluationOffset(value) {
        this._evaluationOffset = value;
    }
    resetEvaluationOffset() {
        this._evaluationOffset = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get evaluationOffsetInput() {
        return this._evaluationOffset;
    }
    get query() {
        return this.getStringAttribute('query');
    }
    set query(value) {
        this._query = value;
    }
    // Temporarily expose input value. Use with caution.
    get queryInput() {
        return this._query;
    }
    get sinceValue() {
        return this.getStringAttribute('since_value');
    }
    set sinceValue(value) {
        this._sinceValue = value;
    }
    resetSinceValue() {
        this._sinceValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sinceValueInput() {
        return this._sinceValue;
    }
}
exports.NrqlAlertConditionNrqlOutputReference = NrqlAlertConditionNrqlOutputReference;
_b = JSII_RTTI_SYMBOL_1;
NrqlAlertConditionNrqlOutputReference[_b] = { fqn: "@cdktf/provider-newrelic.NrqlAlertConditionNrqlOutputReference", version: "0.4.22" };
function nrqlAlertConditionTermToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        duration: cdktf.numberToTerraform(struct.duration),
        operator: cdktf.stringToTerraform(struct.operator),
        priority: cdktf.stringToTerraform(struct.priority),
        threshold: cdktf.numberToTerraform(struct.threshold),
        threshold_duration: cdktf.numberToTerraform(struct.thresholdDuration),
        threshold_occurrences: cdktf.stringToTerraform(struct.thresholdOccurrences),
        time_function: cdktf.stringToTerraform(struct.timeFunction),
    };
}
exports.nrqlAlertConditionTermToTerraform = nrqlAlertConditionTermToTerraform;
function nrqlAlertConditionWarningToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        duration: cdktf.numberToTerraform(struct.duration),
        operator: cdktf.stringToTerraform(struct.operator),
        threshold: cdktf.numberToTerraform(struct.threshold),
        threshold_duration: cdktf.numberToTerraform(struct.thresholdDuration),
        threshold_occurrences: cdktf.stringToTerraform(struct.thresholdOccurrences),
        time_function: cdktf.stringToTerraform(struct.timeFunction),
    };
}
exports.nrqlAlertConditionWarningToTerraform = nrqlAlertConditionWarningToTerraform;
class NrqlAlertConditionWarningOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._duration !== undefined) {
            hasAnyValues = true;
            internalValueResult.duration = this._duration;
        }
        if (this._operator !== undefined) {
            hasAnyValues = true;
            internalValueResult.operator = this._operator;
        }
        if (this._threshold !== undefined) {
            hasAnyValues = true;
            internalValueResult.threshold = this._threshold;
        }
        if (this._thresholdDuration !== undefined) {
            hasAnyValues = true;
            internalValueResult.thresholdDuration = this._thresholdDuration;
        }
        if (this._thresholdOccurrences !== undefined) {
            hasAnyValues = true;
            internalValueResult.thresholdOccurrences = this._thresholdOccurrences;
        }
        if (this._timeFunction !== undefined) {
            hasAnyValues = true;
            internalValueResult.timeFunction = this._timeFunction;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._duration = undefined;
            this._operator = undefined;
            this._threshold = undefined;
            this._thresholdDuration = undefined;
            this._thresholdOccurrences = undefined;
            this._timeFunction = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._duration = value.duration;
            this._operator = value.operator;
            this._threshold = value.threshold;
            this._thresholdDuration = value.thresholdDuration;
            this._thresholdOccurrences = value.thresholdOccurrences;
            this._timeFunction = value.timeFunction;
        }
    }
    get duration() {
        return this.getNumberAttribute('duration');
    }
    set duration(value) {
        this._duration = value;
    }
    resetDuration() {
        this._duration = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get durationInput() {
        return this._duration;
    }
    get operator() {
        return this.getStringAttribute('operator');
    }
    set operator(value) {
        this._operator = value;
    }
    resetOperator() {
        this._operator = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get operatorInput() {
        return this._operator;
    }
    get threshold() {
        return this.getNumberAttribute('threshold');
    }
    set threshold(value) {
        this._threshold = value;
    }
    // Temporarily expose input value. Use with caution.
    get thresholdInput() {
        return this._threshold;
    }
    get thresholdDuration() {
        return this.getNumberAttribute('threshold_duration');
    }
    set thresholdDuration(value) {
        this._thresholdDuration = value;
    }
    resetThresholdDuration() {
        this._thresholdDuration = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get thresholdDurationInput() {
        return this._thresholdDuration;
    }
    get thresholdOccurrences() {
        return this.getStringAttribute('threshold_occurrences');
    }
    set thresholdOccurrences(value) {
        this._thresholdOccurrences = value;
    }
    resetThresholdOccurrences() {
        this._thresholdOccurrences = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get thresholdOccurrencesInput() {
        return this._thresholdOccurrences;
    }
    get timeFunction() {
        return this.getStringAttribute('time_function');
    }
    set timeFunction(value) {
        this._timeFunction = value;
    }
    resetTimeFunction() {
        this._timeFunction = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timeFunctionInput() {
        return this._timeFunction;
    }
}
exports.NrqlAlertConditionWarningOutputReference = NrqlAlertConditionWarningOutputReference;
_c = JSII_RTTI_SYMBOL_1;
NrqlAlertConditionWarningOutputReference[_c] = { fqn: "@cdktf/provider-newrelic.NrqlAlertConditionWarningOutputReference", version: "0.4.22" };
/**
* Represents a {@link https://www.terraform.io/docs/providers/newrelic/r/nrql_alert_condition newrelic_nrql_alert_condition}
*/
class NrqlAlertCondition extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/newrelic/r/nrql_alert_condition newrelic_nrql_alert_condition} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NrqlAlertConditionConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'newrelic_nrql_alert_condition',
            terraformGeneratorMetadata: {
                providerName: 'newrelic',
                providerVersion: '2.41.2',
                providerVersionConstraint: '~> 2.32'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        // critical - computed: false, optional: true, required: false
        this._critical = new NrqlAlertConditionCriticalOutputReference(this, "critical");
        // nrql - computed: false, optional: false, required: true
        this._nrql = new NrqlAlertConditionNrqlOutputReference(this, "nrql");
        // warning - computed: false, optional: true, required: false
        this._warning = new NrqlAlertConditionWarningOutputReference(this, "warning");
        this._accountId = config.accountId;
        this._aggregationDelay = config.aggregationDelay;
        this._aggregationMethod = config.aggregationMethod;
        this._aggregationTimer = config.aggregationTimer;
        this._aggregationWindow = config.aggregationWindow;
        this._baselineDirection = config.baselineDirection;
        this._closeViolationsOnExpiration = config.closeViolationsOnExpiration;
        this._description = config.description;
        this._enabled = config.enabled;
        this._expectedGroups = config.expectedGroups;
        this._expirationDuration = config.expirationDuration;
        this._fillOption = config.fillOption;
        this._fillValue = config.fillValue;
        this._ignoreOverlap = config.ignoreOverlap;
        this._name = config.name;
        this._openViolationOnExpiration = config.openViolationOnExpiration;
        this._openViolationOnGroupOverlap = config.openViolationOnGroupOverlap;
        this._policyId = config.policyId;
        this._runbookUrl = config.runbookUrl;
        this._slideBy = config.slideBy;
        this._type = config.type;
        this._valueFunction = config.valueFunction;
        this._violationTimeLimit = config.violationTimeLimit;
        this._violationTimeLimitSeconds = config.violationTimeLimitSeconds;
        this._critical.internalValue = config.critical;
        this._nrql.internalValue = config.nrql;
        this._term = config.term;
        this._warning.internalValue = config.warning;
    }
    get accountId() {
        return this.getNumberAttribute('account_id');
    }
    set accountId(value) {
        this._accountId = value;
    }
    resetAccountId() {
        this._accountId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get accountIdInput() {
        return this._accountId;
    }
    get aggregationDelay() {
        return this.getStringAttribute('aggregation_delay');
    }
    set aggregationDelay(value) {
        this._aggregationDelay = value;
    }
    resetAggregationDelay() {
        this._aggregationDelay = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get aggregationDelayInput() {
        return this._aggregationDelay;
    }
    get aggregationMethod() {
        return this.getStringAttribute('aggregation_method');
    }
    set aggregationMethod(value) {
        this._aggregationMethod = value;
    }
    resetAggregationMethod() {
        this._aggregationMethod = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get aggregationMethodInput() {
        return this._aggregationMethod;
    }
    get aggregationTimer() {
        return this.getStringAttribute('aggregation_timer');
    }
    set aggregationTimer(value) {
        this._aggregationTimer = value;
    }
    resetAggregationTimer() {
        this._aggregationTimer = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get aggregationTimerInput() {
        return this._aggregationTimer;
    }
    get aggregationWindow() {
        return this.getNumberAttribute('aggregation_window');
    }
    set aggregationWindow(value) {
        this._aggregationWindow = value;
    }
    resetAggregationWindow() {
        this._aggregationWindow = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get aggregationWindowInput() {
        return this._aggregationWindow;
    }
    get baselineDirection() {
        return this.getStringAttribute('baseline_direction');
    }
    set baselineDirection(value) {
        this._baselineDirection = value;
    }
    resetBaselineDirection() {
        this._baselineDirection = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get baselineDirectionInput() {
        return this._baselineDirection;
    }
    get closeViolationsOnExpiration() {
        return this.getBooleanAttribute('close_violations_on_expiration');
    }
    set closeViolationsOnExpiration(value) {
        this._closeViolationsOnExpiration = value;
    }
    resetCloseViolationsOnExpiration() {
        this._closeViolationsOnExpiration = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get closeViolationsOnExpirationInput() {
        return this._closeViolationsOnExpiration;
    }
    get description() {
        return this.getStringAttribute('description');
    }
    set description(value) {
        this._description = value;
    }
    resetDescription() {
        this._description = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get descriptionInput() {
        return this._description;
    }
    get enabled() {
        return this.getBooleanAttribute('enabled');
    }
    set enabled(value) {
        this._enabled = value;
    }
    resetEnabled() {
        this._enabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enabledInput() {
        return this._enabled;
    }
    get expectedGroups() {
        return this.getNumberAttribute('expected_groups');
    }
    set expectedGroups(value) {
        this._expectedGroups = value;
    }
    resetExpectedGroups() {
        this._expectedGroups = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get expectedGroupsInput() {
        return this._expectedGroups;
    }
    get expirationDuration() {
        return this.getNumberAttribute('expiration_duration');
    }
    set expirationDuration(value) {
        this._expirationDuration = value;
    }
    resetExpirationDuration() {
        this._expirationDuration = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get expirationDurationInput() {
        return this._expirationDuration;
    }
    get fillOption() {
        return this.getStringAttribute('fill_option');
    }
    set fillOption(value) {
        this._fillOption = value;
    }
    resetFillOption() {
        this._fillOption = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get fillOptionInput() {
        return this._fillOption;
    }
    get fillValue() {
        return this.getNumberAttribute('fill_value');
    }
    set fillValue(value) {
        this._fillValue = value;
    }
    resetFillValue() {
        this._fillValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get fillValueInput() {
        return this._fillValue;
    }
    // id - computed: true, optional: true, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    get ignoreOverlap() {
        return this.getBooleanAttribute('ignore_overlap');
    }
    set ignoreOverlap(value) {
        this._ignoreOverlap = value;
    }
    resetIgnoreOverlap() {
        this._ignoreOverlap = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ignoreOverlapInput() {
        return this._ignoreOverlap;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get openViolationOnExpiration() {
        return this.getBooleanAttribute('open_violation_on_expiration');
    }
    set openViolationOnExpiration(value) {
        this._openViolationOnExpiration = value;
    }
    resetOpenViolationOnExpiration() {
        this._openViolationOnExpiration = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get openViolationOnExpirationInput() {
        return this._openViolationOnExpiration;
    }
    get openViolationOnGroupOverlap() {
        return this.getBooleanAttribute('open_violation_on_group_overlap');
    }
    set openViolationOnGroupOverlap(value) {
        this._openViolationOnGroupOverlap = value;
    }
    resetOpenViolationOnGroupOverlap() {
        this._openViolationOnGroupOverlap = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get openViolationOnGroupOverlapInput() {
        return this._openViolationOnGroupOverlap;
    }
    get policyId() {
        return this.getNumberAttribute('policy_id');
    }
    set policyId(value) {
        this._policyId = value;
    }
    // Temporarily expose input value. Use with caution.
    get policyIdInput() {
        return this._policyId;
    }
    get runbookUrl() {
        return this.getStringAttribute('runbook_url');
    }
    set runbookUrl(value) {
        this._runbookUrl = value;
    }
    resetRunbookUrl() {
        this._runbookUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get runbookUrlInput() {
        return this._runbookUrl;
    }
    get slideBy() {
        return this.getNumberAttribute('slide_by');
    }
    set slideBy(value) {
        this._slideBy = value;
    }
    resetSlideBy() {
        this._slideBy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get slideByInput() {
        return this._slideBy;
    }
    get type() {
        return this.getStringAttribute('type');
    }
    set type(value) {
        this._type = value;
    }
    resetType() {
        this._type = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get typeInput() {
        return this._type;
    }
    get valueFunction() {
        return this.getStringAttribute('value_function');
    }
    set valueFunction(value) {
        this._valueFunction = value;
    }
    resetValueFunction() {
        this._valueFunction = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get valueFunctionInput() {
        return this._valueFunction;
    }
    get violationTimeLimit() {
        return this.getStringAttribute('violation_time_limit');
    }
    set violationTimeLimit(value) {
        this._violationTimeLimit = value;
    }
    resetViolationTimeLimit() {
        this._violationTimeLimit = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get violationTimeLimitInput() {
        return this._violationTimeLimit;
    }
    get violationTimeLimitSeconds() {
        return this.getNumberAttribute('violation_time_limit_seconds');
    }
    set violationTimeLimitSeconds(value) {
        this._violationTimeLimitSeconds = value;
    }
    resetViolationTimeLimitSeconds() {
        this._violationTimeLimitSeconds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get violationTimeLimitSecondsInput() {
        return this._violationTimeLimitSeconds;
    }
    get critical() {
        return this._critical;
    }
    putCritical(value) {
        this._critical.internalValue = value;
    }
    resetCritical() {
        this._critical.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get criticalInput() {
        return this._critical.internalValue;
    }
    get nrql() {
        return this._nrql;
    }
    putNrql(value) {
        this._nrql.internalValue = value;
    }
    // Temporarily expose input value. Use with caution.
    get nrqlInput() {
        return this._nrql.internalValue;
    }
    get term() {
        // Getting the computed value is not yet implemented
        return cdktf.Token.asAny(cdktf.Fn.tolist(this.interpolationForAttribute('term')));
    }
    set term(value) {
        this._term = value;
    }
    resetTerm() {
        this._term = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get termInput() {
        return this._term;
    }
    get warning() {
        return this._warning;
    }
    putWarning(value) {
        this._warning.internalValue = value;
    }
    resetWarning() {
        this._warning.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get warningInput() {
        return this._warning.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            account_id: cdktf.numberToTerraform(this._accountId),
            aggregation_delay: cdktf.stringToTerraform(this._aggregationDelay),
            aggregation_method: cdktf.stringToTerraform(this._aggregationMethod),
            aggregation_timer: cdktf.stringToTerraform(this._aggregationTimer),
            aggregation_window: cdktf.numberToTerraform(this._aggregationWindow),
            baseline_direction: cdktf.stringToTerraform(this._baselineDirection),
            close_violations_on_expiration: cdktf.booleanToTerraform(this._closeViolationsOnExpiration),
            description: cdktf.stringToTerraform(this._description),
            enabled: cdktf.booleanToTerraform(this._enabled),
            expected_groups: cdktf.numberToTerraform(this._expectedGroups),
            expiration_duration: cdktf.numberToTerraform(this._expirationDuration),
            fill_option: cdktf.stringToTerraform(this._fillOption),
            fill_value: cdktf.numberToTerraform(this._fillValue),
            ignore_overlap: cdktf.booleanToTerraform(this._ignoreOverlap),
            name: cdktf.stringToTerraform(this._name),
            open_violation_on_expiration: cdktf.booleanToTerraform(this._openViolationOnExpiration),
            open_violation_on_group_overlap: cdktf.booleanToTerraform(this._openViolationOnGroupOverlap),
            policy_id: cdktf.numberToTerraform(this._policyId),
            runbook_url: cdktf.stringToTerraform(this._runbookUrl),
            slide_by: cdktf.numberToTerraform(this._slideBy),
            type: cdktf.stringToTerraform(this._type),
            value_function: cdktf.stringToTerraform(this._valueFunction),
            violation_time_limit: cdktf.stringToTerraform(this._violationTimeLimit),
            violation_time_limit_seconds: cdktf.numberToTerraform(this._violationTimeLimitSeconds),
            critical: nrqlAlertConditionCriticalToTerraform(this._critical.internalValue),
            nrql: nrqlAlertConditionNrqlToTerraform(this._nrql.internalValue),
            term: cdktf.listMapper(nrqlAlertConditionTermToTerraform)(this._term),
            warning: nrqlAlertConditionWarningToTerraform(this._warning.internalValue),
        };
    }
}
exports.NrqlAlertCondition = NrqlAlertCondition;
_d = JSII_RTTI_SYMBOL_1;
NrqlAlertCondition[_d] = { fqn: "@cdktf/provider-newrelic.NrqlAlertCondition", version: "0.4.22" };
// =================
// STATIC PROPERTIES
// =================
NrqlAlertCondition.tfResourceType = "newrelic_nrql_alert_condition";
//# sourceMappingURL=data:application/json;base64,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