import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface OneDashboardRawConfig extends cdktf.TerraformMetaArguments {
    /**
    * The New Relic account ID where you want to create the dashboard.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard_raw#account_id OneDashboardRaw#account_id}
    */
    readonly accountId?: number;
    /**
    * The dashboard's description.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard_raw#description OneDashboardRaw#description}
    */
    readonly description?: string;
    /**
    * The dashboard's name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard_raw#name OneDashboardRaw#name}
    */
    readonly name: string;
    /**
    * Determines who can see or edit the dashboard. Valid values are private, public_read_only, public_read_write. Defaults to public_read_only.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard_raw#permissions OneDashboardRaw#permissions}
    */
    readonly permissions?: string;
    /**
    * page block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard_raw#page OneDashboardRaw#page}
    */
    readonly page: OneDashboardRawPage[] | cdktf.IResolvable;
}
export interface OneDashboardRawPageWidget {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard_raw#column OneDashboardRaw#column}
    */
    readonly column: number;
    /**
    * The configuration of the widget.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard_raw#configuration OneDashboardRaw#configuration}
    */
    readonly configuration: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard_raw#height OneDashboardRaw#height}
    */
    readonly height?: number;
    /**
    * (Optional) Related entity GUIDs. Currently only supports Dashboard entity GUIDs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard_raw#linked_entity_guids OneDashboardRaw#linked_entity_guids}
    */
    readonly linkedEntityGuids?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard_raw#row OneDashboardRaw#row}
    */
    readonly row: number;
    /**
    * A title for the widget.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard_raw#title OneDashboardRaw#title}
    */
    readonly title: string;
    /**
    * The visualization ID of the widget.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard_raw#visualization_id OneDashboardRaw#visualization_id}
    */
    readonly visualizationId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard_raw#width OneDashboardRaw#width}
    */
    readonly width?: number;
}
export declare function oneDashboardRawPageWidgetToTerraform(struct?: OneDashboardRawPageWidget | cdktf.IResolvable): any;
export interface OneDashboardRawPage {
    /**
    * The dashboard page's description.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard_raw#description OneDashboardRaw#description}
    */
    readonly description?: string;
    /**
    * The dashboard page's name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard_raw#name OneDashboardRaw#name}
    */
    readonly name: string;
    /**
    * widget block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard_raw#widget OneDashboardRaw#widget}
    */
    readonly widget?: OneDashboardRawPageWidget[] | cdktf.IResolvable;
}
export declare function oneDashboardRawPageToTerraform(struct?: OneDashboardRawPage | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard_raw newrelic_one_dashboard_raw}
*/
export declare class OneDashboardRaw extends cdktf.TerraformResource {
    static readonly tfResourceType = "newrelic_one_dashboard_raw";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard_raw newrelic_one_dashboard_raw} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options OneDashboardRawConfig
    */
    constructor(scope: Construct, id: string, config: OneDashboardRawConfig);
    private _accountId?;
    get accountId(): number;
    set accountId(value: number);
    resetAccountId(): void;
    get accountIdInput(): number | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get guid(): string;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get permalink(): string;
    private _permissions?;
    get permissions(): string;
    set permissions(value: string);
    resetPermissions(): void;
    get permissionsInput(): string | undefined;
    private _page?;
    get page(): OneDashboardRawPage[] | cdktf.IResolvable;
    set page(value: OneDashboardRawPage[] | cdktf.IResolvable);
    get pageInput(): cdktf.IResolvable | OneDashboardRawPage[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
