import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SyntheticsMonitorScriptConfig extends cdktf.TerraformMetaArguments {
    /**
    * The ID of the monitor to attach the script to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/synthetics_monitor_script#monitor_id SyntheticsMonitorScript#monitor_id}
    */
    readonly monitorId: string;
    /**
    * The plaintext representing the monitor script.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/synthetics_monitor_script#text SyntheticsMonitorScript#text}
    */
    readonly text: string;
    /**
    * location block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/synthetics_monitor_script#location SyntheticsMonitorScript#location}
    */
    readonly location?: SyntheticsMonitorScriptLocation[] | cdktf.IResolvable;
}
export interface SyntheticsMonitorScriptLocation {
    /**
    * The HMAC for the monitor script location. Use only one of `hmac` or `vse_password.`
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/synthetics_monitor_script#hmac SyntheticsMonitorScript#hmac}
    */
    readonly hmac?: string;
    /**
    * The monitor script location name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/synthetics_monitor_script#name SyntheticsMonitorScript#name}
    */
    readonly name: string;
    /**
    * The password for the monitor script location used to calculate HMAC. Use only one of `vse_password` or `hmac.`
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/synthetics_monitor_script#vse_password SyntheticsMonitorScript#vse_password}
    */
    readonly vsePassword?: string;
}
export declare function syntheticsMonitorScriptLocationToTerraform(struct?: SyntheticsMonitorScriptLocation | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/newrelic/r/synthetics_monitor_script newrelic_synthetics_monitor_script}
*/
export declare class SyntheticsMonitorScript extends cdktf.TerraformResource {
    static readonly tfResourceType = "newrelic_synthetics_monitor_script";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/newrelic/r/synthetics_monitor_script newrelic_synthetics_monitor_script} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SyntheticsMonitorScriptConfig
    */
    constructor(scope: Construct, id: string, config: SyntheticsMonitorScriptConfig);
    get id(): string;
    private _monitorId?;
    get monitorId(): string;
    set monitorId(value: string);
    get monitorIdInput(): string | undefined;
    private _text?;
    get text(): string;
    set text(value: string);
    get textInput(): string | undefined;
    private _location?;
    get location(): SyntheticsMonitorScriptLocation[] | cdktf.IResolvable;
    set location(value: SyntheticsMonitorScriptLocation[] | cdktf.IResolvable);
    resetLocation(): void;
    get locationInput(): cdktf.IResolvable | SyntheticsMonitorScriptLocation[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
