# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InputsTcpRawArgs', 'InputsTcpRaw']

@pulumi.input_type
class InputsTcpRawArgs:
    def __init__(__self__, *,
                 acl: Optional[pulumi.Input['InputsTcpRawAclArgs']] = None,
                 connection_host: Optional[pulumi.Input[_builtins.str]] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 host: Optional[pulumi.Input[_builtins.str]] = None,
                 index: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 queue: Optional[pulumi.Input[_builtins.str]] = None,
                 raw_tcp_done_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 restrict_to_host: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None,
                 sourcetype: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a InputsTcpRaw resource.
        :param pulumi.Input['InputsTcpRawAclArgs'] acl: The app/user context that is the namespace for the resource
        :param pulumi.Input[_builtins.str] connection_host: Valid values: (ip | dns | none)
               Set the host for the remote server that is sending data.
               ip sets the host to the IP address of the remote server sending data.
               dns sets the host to the reverse DNS entry for the IP address of the remote server sending data.
               none leaves the host as specified in inputs.conf, which is typically the Splunk system hostname.
               Default value is dns.
        :param pulumi.Input[_builtins.bool] disabled: Indicates if input is disabled.
        :param pulumi.Input[_builtins.str] host: Host from which the indexer gets data.
        :param pulumi.Input[_builtins.str] index: Index to store generated events. Defaults to default.
        :param pulumi.Input[_builtins.str] name: The input port which receives raw data.
        :param pulumi.Input[_builtins.str] queue: Valid values: (parsingQueue | indexQueue)
               Specifies where the input processor should deposit the events it reads. Defaults to parsingQueue.
               Set queue to parsingQueue to apply props.conf and other parsing rules to your data. For more information about props.conf and rules for timestamping and linebreaking, refer to props.conf and the online documentation at "Monitor files and directories with inputs.conf"
               Set queue to indexQueue to send your data directly into the index.
        :param pulumi.Input[_builtins.int] raw_tcp_done_timeout: Specifies in seconds the timeout value for adding a Done-key. Default value is 10 seconds.
               If a connection over the port specified by name remains idle after receiving data for specified number of seconds, it adds a Done-key. This implies the last event is completely received.
        :param pulumi.Input[_builtins.str] restrict_to_host: Allows for restricting this input to only accept data from the host specified here.
        :param pulumi.Input[_builtins.str] source: Sets the source key/field for events from this input. Defaults to the input file path.
               Sets the source key initial value. The key is used during parsing/indexing, in particular to set the source field during indexing. It is also the source field used at search time. As a convenience, the chosen string is prepended with 'source::'.
        :param pulumi.Input[_builtins.str] sourcetype: Set the source type for events from this input.
               "sourcetype=" is automatically prepended to <string>.
               Defaults to audittrail (if signedaudit=true) or fschange (if signedaudit=false).
        """
        if acl is not None:
            pulumi.set(__self__, "acl", acl)
        if connection_host is not None:
            pulumi.set(__self__, "connection_host", connection_host)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if index is not None:
            pulumi.set(__self__, "index", index)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if queue is not None:
            pulumi.set(__self__, "queue", queue)
        if raw_tcp_done_timeout is not None:
            pulumi.set(__self__, "raw_tcp_done_timeout", raw_tcp_done_timeout)
        if restrict_to_host is not None:
            pulumi.set(__self__, "restrict_to_host", restrict_to_host)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if sourcetype is not None:
            pulumi.set(__self__, "sourcetype", sourcetype)

    @_builtins.property
    @pulumi.getter
    def acl(self) -> Optional[pulumi.Input['InputsTcpRawAclArgs']]:
        """
        The app/user context that is the namespace for the resource
        """
        return pulumi.get(self, "acl")

    @acl.setter
    def acl(self, value: Optional[pulumi.Input['InputsTcpRawAclArgs']]):
        pulumi.set(self, "acl", value)

    @_builtins.property
    @pulumi.getter(name="connectionHost")
    def connection_host(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Valid values: (ip | dns | none)
        Set the host for the remote server that is sending data.
        ip sets the host to the IP address of the remote server sending data.
        dns sets the host to the reverse DNS entry for the IP address of the remote server sending data.
        none leaves the host as specified in inputs.conf, which is typically the Splunk system hostname.
        Default value is dns.
        """
        return pulumi.get(self, "connection_host")

    @connection_host.setter
    def connection_host(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_host", value)

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates if input is disabled.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disabled", value)

    @_builtins.property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Host from which the indexer gets data.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host", value)

    @_builtins.property
    @pulumi.getter
    def index(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Index to store generated events. Defaults to default.
        """
        return pulumi.get(self, "index")

    @index.setter
    def index(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "index", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The input port which receives raw data.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def queue(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Valid values: (parsingQueue | indexQueue)
        Specifies where the input processor should deposit the events it reads. Defaults to parsingQueue.
        Set queue to parsingQueue to apply props.conf and other parsing rules to your data. For more information about props.conf and rules for timestamping and linebreaking, refer to props.conf and the online documentation at "Monitor files and directories with inputs.conf"
        Set queue to indexQueue to send your data directly into the index.
        """
        return pulumi.get(self, "queue")

    @queue.setter
    def queue(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "queue", value)

    @_builtins.property
    @pulumi.getter(name="rawTcpDoneTimeout")
    def raw_tcp_done_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies in seconds the timeout value for adding a Done-key. Default value is 10 seconds.
        If a connection over the port specified by name remains idle after receiving data for specified number of seconds, it adds a Done-key. This implies the last event is completely received.
        """
        return pulumi.get(self, "raw_tcp_done_timeout")

    @raw_tcp_done_timeout.setter
    def raw_tcp_done_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "raw_tcp_done_timeout", value)

    @_builtins.property
    @pulumi.getter(name="restrictToHost")
    def restrict_to_host(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Allows for restricting this input to only accept data from the host specified here.
        """
        return pulumi.get(self, "restrict_to_host")

    @restrict_to_host.setter
    def restrict_to_host(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "restrict_to_host", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Sets the source key/field for events from this input. Defaults to the input file path.
        Sets the source key initial value. The key is used during parsing/indexing, in particular to set the source field during indexing. It is also the source field used at search time. As a convenience, the chosen string is prepended with 'source::'.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source", value)

    @_builtins.property
    @pulumi.getter
    def sourcetype(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Set the source type for events from this input.
        "sourcetype=" is automatically prepended to <string>.
        Defaults to audittrail (if signedaudit=true) or fschange (if signedaudit=false).
        """
        return pulumi.get(self, "sourcetype")

    @sourcetype.setter
    def sourcetype(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sourcetype", value)


@pulumi.input_type
class _InputsTcpRawState:
    def __init__(__self__, *,
                 acl: Optional[pulumi.Input['InputsTcpRawAclArgs']] = None,
                 connection_host: Optional[pulumi.Input[_builtins.str]] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 host: Optional[pulumi.Input[_builtins.str]] = None,
                 index: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 queue: Optional[pulumi.Input[_builtins.str]] = None,
                 raw_tcp_done_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 restrict_to_host: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None,
                 sourcetype: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering InputsTcpRaw resources.
        :param pulumi.Input['InputsTcpRawAclArgs'] acl: The app/user context that is the namespace for the resource
        :param pulumi.Input[_builtins.str] connection_host: Valid values: (ip | dns | none)
               Set the host for the remote server that is sending data.
               ip sets the host to the IP address of the remote server sending data.
               dns sets the host to the reverse DNS entry for the IP address of the remote server sending data.
               none leaves the host as specified in inputs.conf, which is typically the Splunk system hostname.
               Default value is dns.
        :param pulumi.Input[_builtins.bool] disabled: Indicates if input is disabled.
        :param pulumi.Input[_builtins.str] host: Host from which the indexer gets data.
        :param pulumi.Input[_builtins.str] index: Index to store generated events. Defaults to default.
        :param pulumi.Input[_builtins.str] name: The input port which receives raw data.
        :param pulumi.Input[_builtins.str] queue: Valid values: (parsingQueue | indexQueue)
               Specifies where the input processor should deposit the events it reads. Defaults to parsingQueue.
               Set queue to parsingQueue to apply props.conf and other parsing rules to your data. For more information about props.conf and rules for timestamping and linebreaking, refer to props.conf and the online documentation at "Monitor files and directories with inputs.conf"
               Set queue to indexQueue to send your data directly into the index.
        :param pulumi.Input[_builtins.int] raw_tcp_done_timeout: Specifies in seconds the timeout value for adding a Done-key. Default value is 10 seconds.
               If a connection over the port specified by name remains idle after receiving data for specified number of seconds, it adds a Done-key. This implies the last event is completely received.
        :param pulumi.Input[_builtins.str] restrict_to_host: Allows for restricting this input to only accept data from the host specified here.
        :param pulumi.Input[_builtins.str] source: Sets the source key/field for events from this input. Defaults to the input file path.
               Sets the source key initial value. The key is used during parsing/indexing, in particular to set the source field during indexing. It is also the source field used at search time. As a convenience, the chosen string is prepended with 'source::'.
        :param pulumi.Input[_builtins.str] sourcetype: Set the source type for events from this input.
               "sourcetype=" is automatically prepended to <string>.
               Defaults to audittrail (if signedaudit=true) or fschange (if signedaudit=false).
        """
        if acl is not None:
            pulumi.set(__self__, "acl", acl)
        if connection_host is not None:
            pulumi.set(__self__, "connection_host", connection_host)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if index is not None:
            pulumi.set(__self__, "index", index)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if queue is not None:
            pulumi.set(__self__, "queue", queue)
        if raw_tcp_done_timeout is not None:
            pulumi.set(__self__, "raw_tcp_done_timeout", raw_tcp_done_timeout)
        if restrict_to_host is not None:
            pulumi.set(__self__, "restrict_to_host", restrict_to_host)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if sourcetype is not None:
            pulumi.set(__self__, "sourcetype", sourcetype)

    @_builtins.property
    @pulumi.getter
    def acl(self) -> Optional[pulumi.Input['InputsTcpRawAclArgs']]:
        """
        The app/user context that is the namespace for the resource
        """
        return pulumi.get(self, "acl")

    @acl.setter
    def acl(self, value: Optional[pulumi.Input['InputsTcpRawAclArgs']]):
        pulumi.set(self, "acl", value)

    @_builtins.property
    @pulumi.getter(name="connectionHost")
    def connection_host(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Valid values: (ip | dns | none)
        Set the host for the remote server that is sending data.
        ip sets the host to the IP address of the remote server sending data.
        dns sets the host to the reverse DNS entry for the IP address of the remote server sending data.
        none leaves the host as specified in inputs.conf, which is typically the Splunk system hostname.
        Default value is dns.
        """
        return pulumi.get(self, "connection_host")

    @connection_host.setter
    def connection_host(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_host", value)

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates if input is disabled.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disabled", value)

    @_builtins.property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Host from which the indexer gets data.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host", value)

    @_builtins.property
    @pulumi.getter
    def index(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Index to store generated events. Defaults to default.
        """
        return pulumi.get(self, "index")

    @index.setter
    def index(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "index", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The input port which receives raw data.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def queue(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Valid values: (parsingQueue | indexQueue)
        Specifies where the input processor should deposit the events it reads. Defaults to parsingQueue.
        Set queue to parsingQueue to apply props.conf and other parsing rules to your data. For more information about props.conf and rules for timestamping and linebreaking, refer to props.conf and the online documentation at "Monitor files and directories with inputs.conf"
        Set queue to indexQueue to send your data directly into the index.
        """
        return pulumi.get(self, "queue")

    @queue.setter
    def queue(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "queue", value)

    @_builtins.property
    @pulumi.getter(name="rawTcpDoneTimeout")
    def raw_tcp_done_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies in seconds the timeout value for adding a Done-key. Default value is 10 seconds.
        If a connection over the port specified by name remains idle after receiving data for specified number of seconds, it adds a Done-key. This implies the last event is completely received.
        """
        return pulumi.get(self, "raw_tcp_done_timeout")

    @raw_tcp_done_timeout.setter
    def raw_tcp_done_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "raw_tcp_done_timeout", value)

    @_builtins.property
    @pulumi.getter(name="restrictToHost")
    def restrict_to_host(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Allows for restricting this input to only accept data from the host specified here.
        """
        return pulumi.get(self, "restrict_to_host")

    @restrict_to_host.setter
    def restrict_to_host(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "restrict_to_host", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Sets the source key/field for events from this input. Defaults to the input file path.
        Sets the source key initial value. The key is used during parsing/indexing, in particular to set the source field during indexing. It is also the source field used at search time. As a convenience, the chosen string is prepended with 'source::'.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source", value)

    @_builtins.property
    @pulumi.getter
    def sourcetype(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Set the source type for events from this input.
        "sourcetype=" is automatically prepended to <string>.
        Defaults to audittrail (if signedaudit=true) or fschange (if signedaudit=false).
        """
        return pulumi.get(self, "sourcetype")

    @sourcetype.setter
    def sourcetype(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sourcetype", value)


@pulumi.type_token("splunk:index/inputsTcpRaw:InputsTcpRaw")
class InputsTcpRaw(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl: Optional[pulumi.Input[Union['InputsTcpRawAclArgs', 'InputsTcpRawAclArgsDict']]] = None,
                 connection_host: Optional[pulumi.Input[_builtins.str]] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 host: Optional[pulumi.Input[_builtins.str]] = None,
                 index: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 queue: Optional[pulumi.Input[_builtins.str]] = None,
                 raw_tcp_done_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 restrict_to_host: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None,
                 sourcetype: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## # Resource: InputsTcpRaw

        Create or update raw TCP input information for managing raw tcp inputs from forwarders.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_splunk as splunk

        tcp_raw = splunk.InputsTcpRaw("tcp_raw",
            name="41000",
            index="main",
            queue="indexQueue",
            source="new",
            sourcetype="new",
            disabled=False)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['InputsTcpRawAclArgs', 'InputsTcpRawAclArgsDict']] acl: The app/user context that is the namespace for the resource
        :param pulumi.Input[_builtins.str] connection_host: Valid values: (ip | dns | none)
               Set the host for the remote server that is sending data.
               ip sets the host to the IP address of the remote server sending data.
               dns sets the host to the reverse DNS entry for the IP address of the remote server sending data.
               none leaves the host as specified in inputs.conf, which is typically the Splunk system hostname.
               Default value is dns.
        :param pulumi.Input[_builtins.bool] disabled: Indicates if input is disabled.
        :param pulumi.Input[_builtins.str] host: Host from which the indexer gets data.
        :param pulumi.Input[_builtins.str] index: Index to store generated events. Defaults to default.
        :param pulumi.Input[_builtins.str] name: The input port which receives raw data.
        :param pulumi.Input[_builtins.str] queue: Valid values: (parsingQueue | indexQueue)
               Specifies where the input processor should deposit the events it reads. Defaults to parsingQueue.
               Set queue to parsingQueue to apply props.conf and other parsing rules to your data. For more information about props.conf and rules for timestamping and linebreaking, refer to props.conf and the online documentation at "Monitor files and directories with inputs.conf"
               Set queue to indexQueue to send your data directly into the index.
        :param pulumi.Input[_builtins.int] raw_tcp_done_timeout: Specifies in seconds the timeout value for adding a Done-key. Default value is 10 seconds.
               If a connection over the port specified by name remains idle after receiving data for specified number of seconds, it adds a Done-key. This implies the last event is completely received.
        :param pulumi.Input[_builtins.str] restrict_to_host: Allows for restricting this input to only accept data from the host specified here.
        :param pulumi.Input[_builtins.str] source: Sets the source key/field for events from this input. Defaults to the input file path.
               Sets the source key initial value. The key is used during parsing/indexing, in particular to set the source field during indexing. It is also the source field used at search time. As a convenience, the chosen string is prepended with 'source::'.
        :param pulumi.Input[_builtins.str] sourcetype: Set the source type for events from this input.
               "sourcetype=" is automatically prepended to <string>.
               Defaults to audittrail (if signedaudit=true) or fschange (if signedaudit=false).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[InputsTcpRawArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## # Resource: InputsTcpRaw

        Create or update raw TCP input information for managing raw tcp inputs from forwarders.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_splunk as splunk

        tcp_raw = splunk.InputsTcpRaw("tcp_raw",
            name="41000",
            index="main",
            queue="indexQueue",
            source="new",
            sourcetype="new",
            disabled=False)
        ```

        :param str resource_name: The name of the resource.
        :param InputsTcpRawArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InputsTcpRawArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl: Optional[pulumi.Input[Union['InputsTcpRawAclArgs', 'InputsTcpRawAclArgsDict']]] = None,
                 connection_host: Optional[pulumi.Input[_builtins.str]] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 host: Optional[pulumi.Input[_builtins.str]] = None,
                 index: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 queue: Optional[pulumi.Input[_builtins.str]] = None,
                 raw_tcp_done_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 restrict_to_host: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None,
                 sourcetype: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InputsTcpRawArgs.__new__(InputsTcpRawArgs)

            __props__.__dict__["acl"] = acl
            __props__.__dict__["connection_host"] = connection_host
            __props__.__dict__["disabled"] = disabled
            __props__.__dict__["host"] = host
            __props__.__dict__["index"] = index
            __props__.__dict__["name"] = name
            __props__.__dict__["queue"] = queue
            __props__.__dict__["raw_tcp_done_timeout"] = raw_tcp_done_timeout
            __props__.__dict__["restrict_to_host"] = restrict_to_host
            __props__.__dict__["source"] = source
            __props__.__dict__["sourcetype"] = sourcetype
        super(InputsTcpRaw, __self__).__init__(
            'splunk:index/inputsTcpRaw:InputsTcpRaw',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            acl: Optional[pulumi.Input[Union['InputsTcpRawAclArgs', 'InputsTcpRawAclArgsDict']]] = None,
            connection_host: Optional[pulumi.Input[_builtins.str]] = None,
            disabled: Optional[pulumi.Input[_builtins.bool]] = None,
            host: Optional[pulumi.Input[_builtins.str]] = None,
            index: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            queue: Optional[pulumi.Input[_builtins.str]] = None,
            raw_tcp_done_timeout: Optional[pulumi.Input[_builtins.int]] = None,
            restrict_to_host: Optional[pulumi.Input[_builtins.str]] = None,
            source: Optional[pulumi.Input[_builtins.str]] = None,
            sourcetype: Optional[pulumi.Input[_builtins.str]] = None) -> 'InputsTcpRaw':
        """
        Get an existing InputsTcpRaw resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['InputsTcpRawAclArgs', 'InputsTcpRawAclArgsDict']] acl: The app/user context that is the namespace for the resource
        :param pulumi.Input[_builtins.str] connection_host: Valid values: (ip | dns | none)
               Set the host for the remote server that is sending data.
               ip sets the host to the IP address of the remote server sending data.
               dns sets the host to the reverse DNS entry for the IP address of the remote server sending data.
               none leaves the host as specified in inputs.conf, which is typically the Splunk system hostname.
               Default value is dns.
        :param pulumi.Input[_builtins.bool] disabled: Indicates if input is disabled.
        :param pulumi.Input[_builtins.str] host: Host from which the indexer gets data.
        :param pulumi.Input[_builtins.str] index: Index to store generated events. Defaults to default.
        :param pulumi.Input[_builtins.str] name: The input port which receives raw data.
        :param pulumi.Input[_builtins.str] queue: Valid values: (parsingQueue | indexQueue)
               Specifies where the input processor should deposit the events it reads. Defaults to parsingQueue.
               Set queue to parsingQueue to apply props.conf and other parsing rules to your data. For more information about props.conf and rules for timestamping and linebreaking, refer to props.conf and the online documentation at "Monitor files and directories with inputs.conf"
               Set queue to indexQueue to send your data directly into the index.
        :param pulumi.Input[_builtins.int] raw_tcp_done_timeout: Specifies in seconds the timeout value for adding a Done-key. Default value is 10 seconds.
               If a connection over the port specified by name remains idle after receiving data for specified number of seconds, it adds a Done-key. This implies the last event is completely received.
        :param pulumi.Input[_builtins.str] restrict_to_host: Allows for restricting this input to only accept data from the host specified here.
        :param pulumi.Input[_builtins.str] source: Sets the source key/field for events from this input. Defaults to the input file path.
               Sets the source key initial value. The key is used during parsing/indexing, in particular to set the source field during indexing. It is also the source field used at search time. As a convenience, the chosen string is prepended with 'source::'.
        :param pulumi.Input[_builtins.str] sourcetype: Set the source type for events from this input.
               "sourcetype=" is automatically prepended to <string>.
               Defaults to audittrail (if signedaudit=true) or fschange (if signedaudit=false).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InputsTcpRawState.__new__(_InputsTcpRawState)

        __props__.__dict__["acl"] = acl
        __props__.__dict__["connection_host"] = connection_host
        __props__.__dict__["disabled"] = disabled
        __props__.__dict__["host"] = host
        __props__.__dict__["index"] = index
        __props__.__dict__["name"] = name
        __props__.__dict__["queue"] = queue
        __props__.__dict__["raw_tcp_done_timeout"] = raw_tcp_done_timeout
        __props__.__dict__["restrict_to_host"] = restrict_to_host
        __props__.__dict__["source"] = source
        __props__.__dict__["sourcetype"] = sourcetype
        return InputsTcpRaw(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def acl(self) -> pulumi.Output['outputs.InputsTcpRawAcl']:
        """
        The app/user context that is the namespace for the resource
        """
        return pulumi.get(self, "acl")

    @_builtins.property
    @pulumi.getter(name="connectionHost")
    def connection_host(self) -> pulumi.Output[_builtins.str]:
        """
        Valid values: (ip | dns | none)
        Set the host for the remote server that is sending data.
        ip sets the host to the IP address of the remote server sending data.
        dns sets the host to the reverse DNS entry for the IP address of the remote server sending data.
        none leaves the host as specified in inputs.conf, which is typically the Splunk system hostname.
        Default value is dns.
        """
        return pulumi.get(self, "connection_host")

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates if input is disabled.
        """
        return pulumi.get(self, "disabled")

    @_builtins.property
    @pulumi.getter
    def host(self) -> pulumi.Output[_builtins.str]:
        """
        Host from which the indexer gets data.
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter
    def index(self) -> pulumi.Output[_builtins.str]:
        """
        Index to store generated events. Defaults to default.
        """
        return pulumi.get(self, "index")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The input port which receives raw data.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def queue(self) -> pulumi.Output[_builtins.str]:
        """
        Valid values: (parsingQueue | indexQueue)
        Specifies where the input processor should deposit the events it reads. Defaults to parsingQueue.
        Set queue to parsingQueue to apply props.conf and other parsing rules to your data. For more information about props.conf and rules for timestamping and linebreaking, refer to props.conf and the online documentation at "Monitor files and directories with inputs.conf"
        Set queue to indexQueue to send your data directly into the index.
        """
        return pulumi.get(self, "queue")

    @_builtins.property
    @pulumi.getter(name="rawTcpDoneTimeout")
    def raw_tcp_done_timeout(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies in seconds the timeout value for adding a Done-key. Default value is 10 seconds.
        If a connection over the port specified by name remains idle after receiving data for specified number of seconds, it adds a Done-key. This implies the last event is completely received.
        """
        return pulumi.get(self, "raw_tcp_done_timeout")

    @_builtins.property
    @pulumi.getter(name="restrictToHost")
    def restrict_to_host(self) -> pulumi.Output[_builtins.str]:
        """
        Allows for restricting this input to only accept data from the host specified here.
        """
        return pulumi.get(self, "restrict_to_host")

    @_builtins.property
    @pulumi.getter
    def source(self) -> pulumi.Output[_builtins.str]:
        """
        Sets the source key/field for events from this input. Defaults to the input file path.
        Sets the source key initial value. The key is used during parsing/indexing, in particular to set the source field during indexing. It is also the source field used at search time. As a convenience, the chosen string is prepended with 'source::'.
        """
        return pulumi.get(self, "source")

    @_builtins.property
    @pulumi.getter
    def sourcetype(self) -> pulumi.Output[_builtins.str]:
        """
        Set the source type for events from this input.
        "sourcetype=" is automatically prepended to <string>.
        Defaults to audittrail (if signedaudit=true) or fschange (if signedaudit=false).
        """
        return pulumi.get(self, "sourcetype")

