# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['LookupTableFileArgs', 'LookupTableFile']

@pulumi.input_type
class LookupTableFileArgs:
    def __init__(__self__, *,
                 app: pulumi.Input[_builtins.str],
                 file_contents: pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]],
                 file_name: pulumi.Input[_builtins.str],
                 owner: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a LookupTableFile resource.
        :param pulumi.Input[_builtins.str] app: The app context for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]] file_contents: The column header and row value contents for the lookup table file.
        :param pulumi.Input[_builtins.str] file_name: A name for the lookup table file. Generally ends with ".csv"
        :param pulumi.Input[_builtins.str] owner: User name of resource owner. Defaults to the resource creator. Required for updating any knowledge object ACL properties. nobody = All users may access the resource, but write access to the resource might be restricted.
        """
        pulumi.set(__self__, "app", app)
        pulumi.set(__self__, "file_contents", file_contents)
        pulumi.set(__self__, "file_name", file_name)
        pulumi.set(__self__, "owner", owner)

    @_builtins.property
    @pulumi.getter
    def app(self) -> pulumi.Input[_builtins.str]:
        """
        The app context for the resource.
        """
        return pulumi.get(self, "app")

    @app.setter
    def app(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "app", value)

    @_builtins.property
    @pulumi.getter(name="fileContents")
    def file_contents(self) -> pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]]:
        """
        The column header and row value contents for the lookup table file.
        """
        return pulumi.get(self, "file_contents")

    @file_contents.setter
    def file_contents(self, value: pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]]):
        pulumi.set(self, "file_contents", value)

    @_builtins.property
    @pulumi.getter(name="fileName")
    def file_name(self) -> pulumi.Input[_builtins.str]:
        """
        A name for the lookup table file. Generally ends with ".csv"
        """
        return pulumi.get(self, "file_name")

    @file_name.setter
    def file_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "file_name", value)

    @_builtins.property
    @pulumi.getter
    def owner(self) -> pulumi.Input[_builtins.str]:
        """
        User name of resource owner. Defaults to the resource creator. Required for updating any knowledge object ACL properties. nobody = All users may access the resource, but write access to the resource might be restricted.
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "owner", value)


@pulumi.input_type
class _LookupTableFileState:
    def __init__(__self__, *,
                 app: Optional[pulumi.Input[_builtins.str]] = None,
                 file_contents: Optional[pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]]] = None,
                 file_name: Optional[pulumi.Input[_builtins.str]] = None,
                 owner: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering LookupTableFile resources.
        :param pulumi.Input[_builtins.str] app: The app context for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]] file_contents: The column header and row value contents for the lookup table file.
        :param pulumi.Input[_builtins.str] file_name: A name for the lookup table file. Generally ends with ".csv"
        :param pulumi.Input[_builtins.str] owner: User name of resource owner. Defaults to the resource creator. Required for updating any knowledge object ACL properties. nobody = All users may access the resource, but write access to the resource might be restricted.
        """
        if app is not None:
            pulumi.set(__self__, "app", app)
        if file_contents is not None:
            pulumi.set(__self__, "file_contents", file_contents)
        if file_name is not None:
            pulumi.set(__self__, "file_name", file_name)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)

    @_builtins.property
    @pulumi.getter
    def app(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The app context for the resource.
        """
        return pulumi.get(self, "app")

    @app.setter
    def app(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app", value)

    @_builtins.property
    @pulumi.getter(name="fileContents")
    def file_contents(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]]]:
        """
        The column header and row value contents for the lookup table file.
        """
        return pulumi.get(self, "file_contents")

    @file_contents.setter
    def file_contents(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]]]):
        pulumi.set(self, "file_contents", value)

    @_builtins.property
    @pulumi.getter(name="fileName")
    def file_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A name for the lookup table file. Generally ends with ".csv"
        """
        return pulumi.get(self, "file_name")

    @file_name.setter
    def file_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "file_name", value)

    @_builtins.property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User name of resource owner. Defaults to the resource creator. Required for updating any knowledge object ACL properties. nobody = All users may access the resource, but write access to the resource might be restricted.
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "owner", value)


@pulumi.type_token("splunk:index/lookupTableFile:LookupTableFile")
class LookupTableFile(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app: Optional[pulumi.Input[_builtins.str]] = None,
                 file_contents: Optional[pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]]] = None,
                 file_name: Optional[pulumi.Input[_builtins.str]] = None,
                 owner: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## # Resource: LookupTableFile

        Create and manage lookup table files.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_splunk as splunk

        lookup_table_file = splunk.LookupTableFile("lookup_table_file",
            app="search",
            owner="nobody",
            file_name="lookup.csv",
            file_contents=[
                [
                    "status",
                    "status_description",
                    "status_type",
                ],
                [
                    "100",
                    "Continue",
                    "Informational",
                ],
                [
                    "101",
                    "Switching Protocols",
                    "Informational",
                ],
                [
                    "200",
                    "OK",
                    "Successful",
                ],
            ])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] app: The app context for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]] file_contents: The column header and row value contents for the lookup table file.
        :param pulumi.Input[_builtins.str] file_name: A name for the lookup table file. Generally ends with ".csv"
        :param pulumi.Input[_builtins.str] owner: User name of resource owner. Defaults to the resource creator. Required for updating any knowledge object ACL properties. nobody = All users may access the resource, but write access to the resource might be restricted.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LookupTableFileArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## # Resource: LookupTableFile

        Create and manage lookup table files.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_splunk as splunk

        lookup_table_file = splunk.LookupTableFile("lookup_table_file",
            app="search",
            owner="nobody",
            file_name="lookup.csv",
            file_contents=[
                [
                    "status",
                    "status_description",
                    "status_type",
                ],
                [
                    "100",
                    "Continue",
                    "Informational",
                ],
                [
                    "101",
                    "Switching Protocols",
                    "Informational",
                ],
                [
                    "200",
                    "OK",
                    "Successful",
                ],
            ])
        ```

        :param str resource_name: The name of the resource.
        :param LookupTableFileArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LookupTableFileArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app: Optional[pulumi.Input[_builtins.str]] = None,
                 file_contents: Optional[pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]]] = None,
                 file_name: Optional[pulumi.Input[_builtins.str]] = None,
                 owner: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LookupTableFileArgs.__new__(LookupTableFileArgs)

            if app is None and not opts.urn:
                raise TypeError("Missing required property 'app'")
            __props__.__dict__["app"] = app
            if file_contents is None and not opts.urn:
                raise TypeError("Missing required property 'file_contents'")
            __props__.__dict__["file_contents"] = file_contents
            if file_name is None and not opts.urn:
                raise TypeError("Missing required property 'file_name'")
            __props__.__dict__["file_name"] = file_name
            if owner is None and not opts.urn:
                raise TypeError("Missing required property 'owner'")
            __props__.__dict__["owner"] = owner
        super(LookupTableFile, __self__).__init__(
            'splunk:index/lookupTableFile:LookupTableFile',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            app: Optional[pulumi.Input[_builtins.str]] = None,
            file_contents: Optional[pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]]] = None,
            file_name: Optional[pulumi.Input[_builtins.str]] = None,
            owner: Optional[pulumi.Input[_builtins.str]] = None) -> 'LookupTableFile':
        """
        Get an existing LookupTableFile resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] app: The app context for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]] file_contents: The column header and row value contents for the lookup table file.
        :param pulumi.Input[_builtins.str] file_name: A name for the lookup table file. Generally ends with ".csv"
        :param pulumi.Input[_builtins.str] owner: User name of resource owner. Defaults to the resource creator. Required for updating any knowledge object ACL properties. nobody = All users may access the resource, but write access to the resource might be restricted.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LookupTableFileState.__new__(_LookupTableFileState)

        __props__.__dict__["app"] = app
        __props__.__dict__["file_contents"] = file_contents
        __props__.__dict__["file_name"] = file_name
        __props__.__dict__["owner"] = owner
        return LookupTableFile(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def app(self) -> pulumi.Output[_builtins.str]:
        """
        The app context for the resource.
        """
        return pulumi.get(self, "app")

    @_builtins.property
    @pulumi.getter(name="fileContents")
    def file_contents(self) -> pulumi.Output[Sequence[Sequence[_builtins.str]]]:
        """
        The column header and row value contents for the lookup table file.
        """
        return pulumi.get(self, "file_contents")

    @_builtins.property
    @pulumi.getter(name="fileName")
    def file_name(self) -> pulumi.Output[_builtins.str]:
        """
        A name for the lookup table file. Generally ends with ".csv"
        """
        return pulumi.get(self, "file_name")

    @_builtins.property
    @pulumi.getter
    def owner(self) -> pulumi.Output[_builtins.str]:
        """
        User name of resource owner. Defaults to the resource creator. Required for updating any knowledge object ACL properties. nobody = All users may access the resource, but write access to the resource might be restricted.
        """
        return pulumi.get(self, "owner")

