# ========= Copyright 2023-2024 @ CAMEL-AI.org. All Rights Reserved. =========
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# ========= Copyright 2023-2024 @ CAMEL-AI.org. All Rights Reserved. =========

from .apify_reader import Apify
from .base_io import File, create_file, create_file_from_raw_bytes
from .chunkr_reader import ChunkrReader, ChunkrReaderConfig
from .crawl4ai_reader import Crawl4AI
from .firecrawl_reader import Firecrawl
from .jina_url_reader import JinaURLReader
from .markitdown import MarkItDownLoader
from .mineru_extractor import MinerU
from .mistral_reader import MistralReader
from .scrapegraph_reader import ScrapeGraphAI
from .unstructured_io import UnstructuredIO

__all__ = [
    'File',
    'create_file',
    'create_file_from_raw_bytes',
    'UnstructuredIO',
    'JinaURLReader',
    'Firecrawl',
    'Apify',
    'ChunkrReader',
    'ChunkrReaderConfig',
    'MinerU',
    'Crawl4AI',
    'MarkItDownLoader',
    'ScrapeGraphAI',
    'MistralReader',
]


def __getattr__(name: str):
    if name == 'PandasReader':
        raise ImportError(
            "PandasReader has been removed from camel.loaders. "
            "The pandasai dependency limited pandas to version 1.5.3. "
            "Please use ExcelToolkit from camel.toolkits instead for "
            "handling structured data."
        )
    raise AttributeError(f"module '{__name__}' has no attribute '{name}'")
