"""Shared constants for demo helper modules."""

categories = {
    "Fantasy": "Features magical elements, mythical creatures, and imaginary worlds.",
    "Science Fiction": "Explores futuristic concepts, advanced technology, and often space exploration.",
    "Mystery": "Involves suspenseful and puzzling scenarios, often with a detective or investigator.",
    "Thriller": "Focuses on generating excitement and suspense, with high stakes and constant tension.",
    "Romance": "Centres on love stories and romantic relationships between characters.",
    "Historical Fiction": "Set in the past, blending historical facts with fictional characters and plots.",
    "Horror": "Aimed to scare, unsettle, or horrify the reader, often with supernatural elements.",
    "Literary Fiction": "Emphasises themes, character development, and stylistic complexity over plot.",
    "Young Adult": "Targets teenagers and young adults, dealing with themes relevant to youth.",
    "Children's Books": "Designed for young readers, featuring stories and illustrations suitable for children.",
    "Biography": "A detailed account of a person's life, told by someone else.",
    "Self-Help": "Intended to guide readers in personal improvement and tackling personal problems.",
    "Cookbooks": "A collection of recipes and cooking tips, often accompanied by culinary guidance.",
    "Poetry": "Expressive writing, often employing verse, metre, and imagery for emotional impact.",
    "Graphic Novels": "Narrative works in which the story is conveyed through sequential art.",
}

good_words = [
    "amazing",
    "wonderful",
    "exciting",
    "delightful",
    "marvellous",
    "superb",
    "enjoyable",
    "splendid",
    "fabulous",
    "terrific",
    "entertaining",
    "joyful",
    "brilliant",
    "captivating",
    "magnificent",
]

bad_words = [
    "bad",
    "terrible",
    "awful",
    "boring",
    "unpleasant",
    "dreadful",
    "poor",
    "unenjoyable",
    "dismal",
    "mediocre",
    "horrible",
    "tedious",
    "miserable",
    "lacklustre",
    "uninspiring",
    "disappointing",
]

first_names = [
    "William",
    "James",
    "George",
    "Edward",
    "Charles",
    "Henry",
    "Robert",
    "John",
    "Thomas",
    "Richard",
    "David",
    "Michael",
    "Peter",
    "Christopher",
    "Benjamin",
    "Daniel",
    "Matthew",
    "Andrew",
    "Joseph",
    "Arthur",
    "Elizabeth",
    "Mary",
    "Margaret",
    "Catherine",
    "Jane",
    "Anne",
    "Victoria",
    "Sarah",
    "Emily",
    "Charlotte",
    "Emma",
    "Alice",
    "Helen",
    "Lucy",
    "Eleanor",
    "Grace",
    "Rebecca",
    "Abigail",
    "Olivia",
    "Sophia",
]

last_names = [
    "Smith",
    "Jones",
    "Taylor",
    "Brown",
    "Wilson",
    "Evans",
    "Thomas",
    "Roberts",
    "Johnson",
    "Lewis",
    "Morris",
    "Hughes",
    "Edwards",
    "Davies",
    "Williams",
    "Patel",
    "Jackson",
    "Lee",
    "Walker",
    "Robinson",
    "Wood",
    "Thompson",
    "White",
    "Watson",
    "Jackson",
    "Wright",
    "Green",
    "Harris",
    "Cooper",
    "King",
    "Edwards",
    "Clarke",
    "Turner",
]

nationality = ["English"] * 10 + ["Scottish"] * 10 + ["Welsh"] * 10 + ["Irish"] * 5 + ["American"] * 3 + ["Australian"] * 3

bios = [
    "Renowned for their vivid storytelling, this author has captivated readers worldwide with their imaginative ",
    "narratives.",
    "With a unique voice that resonates across genres, this writer has consistently been at the forefront of literary ",
    "innovation.",
    "An acclaimed master of character development, their books offer deep insights into the human condition.",
    "Known for their suspenseful plots and unexpected twists, this author has become a staple for thrill-seekers and ",
    "mystery lovers alike.",
    "Their elegant prose and poetic descriptions have earned them a distinguished place among contemporary literary ",
    "figures.",
    "With a keen eye for detail, this writer crafts immersive worlds that transport readers to different times and ",
    "places.",
    "A trailblazer in their genre, they have garnered numerous awards and accolades for their groundbreaking work.",
    "Their compelling narratives and complex characters reflect a profound understanding of social and cultural ",
    "dynamics.",
    "This author's ability to weave humour and wit into their storytelling has delighted audiences, making their books ",
    "a joy to read.",
    "A champion of exploring challenging themes, their works are known for their depth and thought-provoking content.",
    "Blending rich imagination with intricate plots, this author creates captivating tales that linger in the minds",
    " of readers.",
    "Known for their eloquent narrative style, their books explore the nuances of everyday life with grace and",
    " sensitivity.",
    "With a flair for bringing characters to life, their stories resonate with readers, evoking a range of emotions.",
    "Their work stands out for its lyrical quality, turning even the most mundane scenarios into something magical.",
    "Masterfully constructing complex relationships in their narratives, this writer reveals the multifaceted nature",
    " of human connections.",
    "Renowned for crafting compelling dialogues, they bring authenticity and depth to each character they create.",
    "Their storytelling transcends boundaries, appealing to a diverse and broad audience with its universal themes.",
    "Expertly intertwining multiple storylines, they create rich tapestries that capture the complexity of life.",
    "Their attention to emotional detail makes each novel a deeply moving experience, inviting readers to reflect",
    " on their own lives.",
    "With a gift for observation, their books offer insightful perspectives on everyday experiences and encounters.",
]

recommendations = [
    "Definitely worth checking out!",
    "Highly recommended!",
    "I strongly suggest giving it a try.",
    "It's a must-see!",
    "You won't be disappointed.",
    "An absolute gem!",
    "Thoroughly enjoyable from start to finish.",
    "I can't recommend it enough!",
    "It exceeded my expectations.",
    "Truly outstanding in every way.",
    "A delightful experience that shouldn't be missed.",
    "It's been a long time since I've been this impressed.",
    "An exemplary showcase of quality.",
    "A perfect example of excellence.",
    "It's a standout choice in its category.",
]

negative_reviews = [
    "Utterly disappointing.",
    "I wouldn't recommend it at all.",
    "A complete waste of time.",
    "Far below expectations.",
    "Not worth the effort.",
    "Highly unsatisfactory.",
    "Left a lot to be desired.",
    "Thoroughly unenjoyable from start to finish.",
    "One of the worst I've experienced.",
    "Deeply regrettable.",
    "Falls short in every aspect.",
    "A dismal failure by all standards.",
    "An experience I'd like to forget.",
    "Missed the mark entirely.",
    "A letdown in every sense of the word.",
]
