import traceback

def explain(error: Exception) -> str:
    """
    Explains Python errors in clear, beginner-friendly English.
    """
    error_type = type(error).__name__
    message = str(error)

    explanations = {
        "ZeroDivisionError": "You tried to divide a number by zero. Division by zero is undefined.",
        "NameError": "You used a variable or function name that is not defined. Check for typos or define it first.",
        "TypeError": "You used a value of the wrong type for an operation, e.g., adding a string to an int.",
        "ValueError": "You passed a value with correct type but invalid value.",
        "IndexError": "You tried to access a position in a list or tuple that doesn’t exist.",
        "KeyError": "You tried to access a dictionary key that doesn’t exist.",
        "AttributeError": "You tried to access an attribute or method that doesn't exist for this object type.",
        "FileNotFoundError": "You tried to open a file that doesn't exist or the path is incorrect.",
        "ImportError": "Python couldn't import a module or name from it.",
        "IndentationError": "Incorrect indentation. Use consistent spaces or tabs.",
        "SyntaxError": "Syntax error. Check punctuation, parentheses, or keywords."
    }

    explanation = explanations.get(
        error_type,
        "Uncommon Python error. Check the documentation or error details."
    )

    return f"❌ Error Type: {error_type}\n💬 Message: {message}\n💡 Explanation: {explanation}"

def safe_run(func):
    """
    Runs a function safely and explains any error in English.
    """
    try:
        func()
    except Exception as e:
        print(explain(e))
        print("\n🔍 Traceback:")
        traceback.print_exc()
