from typing import Protocol, List, Literal, Dict
 

class Computer(Protocol):
    """Defines the 'shape' (methods/properties) our loop expects."""

    @property
    def environment(self) -> Literal["windows", "mac", "linux", "browser"]: ...
    @property
    def dimensions(self) -> tuple[int, int]: ...

    async def screenshot(self) -> str: ...

    async def click(self, x: int, y: int, button: str = "left") -> None: ...

    async def double_click(self, x: int, y: int) -> None: ...

    async def scroll(self, x: int, y: int, scroll_x: int, scroll_y: int) -> None: ...

    async def type(self, text: str) -> None: ...

    async def wait(self, ms: int = 1000) -> None: ...

    async def move(self, x: int, y: int) -> None: ...

    async def keypress(self, keys: List[str]) -> None: ...

    async def drag(self, path: List[Dict[str, int]]) -> None: ...

    async def get_current_url() -> str: ...
    
    async def __aenter__(self) -> 'Computer':
        return self

    async def __aexit__(self, exc_type, exc_val, exc_tb) -> 'Computer':
        return self