# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from typing import TYPE_CHECKING, Dict, List, Optional
from typing_extensions import Literal

from pydantic import Field as FieldInfo

from .._models import BaseModel

__all__ = ["EmbeddingsResponse", "Data", "Usage", "UsagePromptTokensDetails"]


class Data(BaseModel):
    embedding: Optional[List[float]] = None
    """List of floats containing the embedding vector."""

    index: int
    """The index of the embedding in the list of embeddings."""

    object: Literal["embedding"]
    """Object type, always embedding."""


class UsagePromptTokensDetails(BaseModel):
    cached_tokens: Optional[int] = None
    """amount of cached tokens"""

    if TYPE_CHECKING:
        # Some versions of Pydantic <2.8.0 have a bug and don’t allow assigning a
        # value to this field, so for compatibility we avoid doing it at runtime.
        __pydantic_extra__: Dict[str, object] = FieldInfo(init=False)  # pyright: ignore[reportIncompatibleVariableOverride]

        # Stub to indicate that arbitrary properties are accepted.
        # To access properties that are not valid identifiers you can use `getattr`, e.g.
        # `getattr(obj, '$type')`
        def __getattr__(self, attr: str) -> object: ...
    else:
        __pydantic_extra__: Dict[str, object]


class Usage(BaseModel):
    acceptance_rate: Optional[float] = None
    """acceptance rate"""

    completion_tokens: Optional[int] = None
    """number of tokens generated in completion"""

    completion_tokens_after_first_per_sec: Optional[float] = None
    """completion tokens per second after first token generation"""

    completion_tokens_after_first_per_sec_first_ten: Optional[float] = None
    """completion tokens per second after first token generation first ten"""

    completion_tokens_after_first_per_sec_graph: Optional[float] = None
    """completion tokens per second after first token generation"""

    completion_tokens_per_sec: Optional[float] = None
    """completion tokens per second"""

    end_time: Optional[float] = None
    """The Unix timestamp (in seconds) of when the generation finished."""

    is_last_response: Optional[Literal[True]] = None
    """whether or not is last response, always true for non streaming response"""

    prompt_tokens: Optional[int] = None
    """number of tokens used in the prompt sent"""

    prompt_tokens_details: Optional[UsagePromptTokensDetails] = None
    """Extra tokens details"""

    start_time: Optional[float] = None
    """The Unix timestamp (in seconds) of when the generation started."""

    time_to_first_token: Optional[float] = None
    """also TTF, time (in seconds) taken to generate the first token"""

    total_latency: Optional[float] = None
    """total time (in seconds) taken to generate the full generation"""

    total_tokens: Optional[int] = None
    """prompt tokens + completion tokens"""

    total_tokens_per_sec: Optional[float] = None
    """tokens per second including prompt and completion"""

    if TYPE_CHECKING:
        # Some versions of Pydantic <2.8.0 have a bug and don’t allow assigning a
        # value to this field, so for compatibility we avoid doing it at runtime.
        __pydantic_extra__: Dict[str, object] = FieldInfo(init=False)  # pyright: ignore[reportIncompatibleVariableOverride]

        # Stub to indicate that arbitrary properties are accepted.
        # To access properties that are not valid identifiers you can use `getattr`, e.g.
        # `getattr(obj, '$type')`
        def __getattr__(self, attr: str) -> object: ...
    else:
        __pydantic_extra__: Dict[str, object]


class EmbeddingsResponse(BaseModel):
    data: List[Data]
    """The list of embeddings generated by the model."""

    model: str
    """The name of the model used to generate the embedding."""

    object: Literal["list"]
    """The object type, which is always "list"."""

    usage: Optional[Usage] = None
    """
    Usage metrics for the completion, embeddings,transcription or translation
    request
    """
