# Generated by Django 5.2.7 on 2025-11-03 08:28

from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        (
            "grpc",
            "0002_rename_django_cfg__service_4c4a8e_idx_django_cfg__service_584308_idx_and_more",
        ),
    ]

    operations = [
        migrations.CreateModel(
            name="GRPCServerStatus",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                (
                    "instance_id",
                    models.CharField(
                        db_index=True,
                        help_text="Unique instance identifier (hostname:port:pid)",
                        max_length=100,
                        unique=True,
                    ),
                ),
                ("host", models.CharField(help_text="Server host address", max_length=200)),
                ("port", models.IntegerField(help_text="Server port")),
                (
                    "address",
                    models.CharField(
                        db_index=True, help_text="Full server address (host:port)", max_length=200
                    ),
                ),
                ("pid", models.IntegerField(help_text="Process ID of gRPC server")),
                ("hostname", models.CharField(help_text="Server hostname", max_length=255)),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("starting", "Starting"),
                            ("running", "Running"),
                            ("stopping", "Stopping"),
                            ("stopped", "Stopped"),
                            ("error", "Error"),
                        ],
                        db_index=True,
                        default="starting",
                        help_text="Current server status",
                        max_length=20,
                    ),
                ),
                (
                    "started_at",
                    models.DateTimeField(
                        auto_now_add=True, db_index=True, help_text="When server started"
                    ),
                ),
                (
                    "last_heartbeat",
                    models.DateTimeField(
                        auto_now=True, db_index=True, help_text="Last heartbeat timestamp"
                    ),
                ),
                (
                    "stopped_at",
                    models.DateTimeField(blank=True, help_text="When server stopped", null=True),
                ),
                (
                    "max_workers",
                    models.IntegerField(default=10, help_text="Maximum worker threads"),
                ),
                (
                    "enable_reflection",
                    models.BooleanField(default=False, help_text="Whether reflection is enabled"),
                ),
                (
                    "enable_health_check",
                    models.BooleanField(default=True, help_text="Whether health check is enabled"),
                ),
                (
                    "error_message",
                    models.TextField(
                        blank=True, help_text="Error message if status is ERROR", null=True
                    ),
                ),
                (
                    "created_at",
                    models.DateTimeField(auto_now_add=True, help_text="Record creation time"),
                ),
                (
                    "updated_at",
                    models.DateTimeField(auto_now=True, help_text="Record last update time"),
                ),
            ],
            options={
                "verbose_name": "gRPC Server Status",
                "verbose_name_plural": "gRPC Server Statuses",
                "db_table": "django_cfg_grpc_server_status",
                "ordering": ["-started_at"],
                "indexes": [
                    models.Index(
                        fields=["status", "-started_at"], name="django_cfg__status_b0ce6c_idx"
                    ),
                    models.Index(
                        fields=["address", "-started_at"], name="django_cfg__address_4966eb_idx"
                    ),
                    models.Index(fields=["pid", "-started_at"], name="django_cfg__pid_bab561_idx"),
                ],
            },
        ),
    ]
