"""
Example Command Implementations

This package contains example command implementations that demonstrate
the universal streaming command pattern.

These examples show:
- How to decompose commands into separate modules
- How to use Protocol for type-safe model operations
- How to implement Django async ORM updates
- How to build a wrapper client class

To use these examples in your project:
1. Copy the pattern from base_client.py
2. Adapt command functions (start.py, stop.py, config.py) to your needs
3. Create a wrapper client class (client.py)
4. Update protobuf imports to match your service

See @commands/EXAMPLES.md for detailed documentation.
"""

__all__ = []
