# generated by datamodel-codegen:
#   filename:  plato.yaml
#   timestamp: 2025-10-27T02:40:30+00:00

from __future__ import annotations

from enum import Enum
from typing import Dict, List, Optional

from pydantic import BaseModel


class SimConfigCompute(BaseModel):
    cpus: int
    memory: int
    disk: int
    app_port: int
    plato_messaging_port: int


class Variable(BaseModel):
    name: str
    value: str


class SimConfigMetadata(BaseModel):
    favicon: Optional[str] = None
    name: str
    description: Optional[str] = None
    source_code_url: Optional[str] = None
    start_url: Optional[str] = None
    license: Optional[str] = None
    variables: Optional[List[Variable]] = None
    flows_path: Optional[str] = None


class SimConfigService(BaseModel):
    type: str
    file: Optional[str] = None
    required_healthy_containers: Optional[List[str]] = None
    healthy_wait_timeout: Optional[int] = None


class Type(Enum):
    db = 'db'
    file = 'file'
    proxy = 'proxy'


class SimConfigListener(BaseModel):
    type: Type
    db_type: Optional[str] = None
    db_host: Optional[str] = None
    db_port: Optional[int] = None
    db_user: Optional[str] = None
    db_password: Optional[str] = None
    db_database: Optional[str] = None
    target_dir: Optional[str] = None
    watch_enabled: Optional[bool] = None
    watch_patterns: Optional[List[str]] = None
    ignore_patterns: Optional[List[str]] = None
    seed_data_path: Optional[str] = None
    seed_data_paths: Optional[List[str]] = None
    volumes: Optional[List[str]] = None


class SimConfigDataset(BaseModel):
    compute: SimConfigCompute
    metadata: SimConfigMetadata
    services: Optional[Dict[str, SimConfigService]] = None
    listeners: Optional[Dict[str, SimConfigListener]] = None


class PlatoConfig(BaseModel):
    service: Optional[str] = None
    datasets: Optional[Dict[str, SimConfigDataset]] = None


class Sandbox(BaseModel):
    job_id: str
    public_id: str
    job_group_id: str
    url: Optional[str] = None
    status: Optional[str] = None
    correlation_id: Optional[str] = None


class Environment(BaseModel):
    job_id: str
    alias: Optional[str] = None
    status: Optional[str] = None


class SimulatorListItem(BaseModel):
    name: str
    description: Optional[str] = None
    artifact_id: Optional[str] = None


class DBConfig(BaseModel):
    """Database configuration for pre-snapshot cleanup"""
    db_type: str  # "postgresql" or "mysql"
    user: str
    password: str
    dest_port: int
    databases: List[str]


class CreateSnapshotRequest(BaseModel):
    service: Optional[str] = None
    git_hash: Optional[str] = None
    dataset: Optional[str] = None


class CreateSnapshotResponse(BaseModel):
    artifact_id: str
    status: str
    timestamp: str
    correlation_id: str
    s3_uri: str
    git_hash: Optional[str] = None


class StartWorkerRequest(BaseModel):
    service: Optional[str] = None
    dataset: str
    plato_dataset_config: SimConfigDataset
    timeout: Optional[int] = None


class StartWorkerResponse(BaseModel):
    status: str
    timestamp: str
    correlation_id: str


class SSHInfo(BaseModel):
    """SSH connection information for a sandbox"""
    ssh_command: str
    ssh_host: str
    ssh_config_path: str
    public_id: str
