"""webtask - Web automation framework with LLM-powered agents."""

from .webtask import Webtask
from .agent import Agent

from .dom import (
    DomNode,
    DomNodeData,
    Text,
    BoundingBox,
    parse_html,
    parse_cdp,
    DomSnapshot,
)

from .llm_browser.dom_filter_config import DomFilterConfig

from .llm import (
    Context,
    Block,
    Tokenizer,
    LLM,
)

from .media import Image

__version__ = "0.1.0"

__all__ = [
    # Manager
    'Webtask',

    # Agent
    'Agent',

    # DOM types
    'DomNode',
    'DomNodeData',
    'Text',
    'BoundingBox',

    # Parsers
    'parse_html',
    'parse_cdp',

    # Snapshot
    'DomSnapshot',

    # Config
    'DomFilterConfig',

    # LLM
    'Context',
    'Block',
    'Tokenizer',
    'LLM',

    # Media
    'Image',
]
