# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AppsSettingsCustomTemplateArgs', 'AppsSettingsCustomTemplate']

@pulumi.input_type
class AppsSettingsCustomTemplateArgs:
    def __init__(__self__, *,
                 git_provider: pulumi.Input[_builtins.str],
                 git_repo: pulumi.Input[_builtins.str],
                 manifest: pulumi.Input['AppsSettingsCustomTemplateManifestArgs'],
                 path: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AppsSettingsCustomTemplate resource.
        :param pulumi.Input[_builtins.str] git_provider: The Git provider of the template
        :param pulumi.Input[_builtins.str] git_repo: The Git repository URL that the template resides in
        :param pulumi.Input['AppsSettingsCustomTemplateManifestArgs'] manifest: The manifest of the template. It defines fields and default values when installing the template
        :param pulumi.Input[_builtins.str] path: The path to the template within the Git repository
        :param pulumi.Input[_builtins.str] description: The description of the template
        :param pulumi.Input[_builtins.str] name: The name of the template. It must contain only alphanumeric characters, hyphens, underscores, and whitespaces.
               It must be unique within the workspace
        :param pulumi.Input[_builtins.str] workspace_id: Workspace ID of the resource
        """
        pulumi.set(__self__, "git_provider", git_provider)
        pulumi.set(__self__, "git_repo", git_repo)
        pulumi.set(__self__, "manifest", manifest)
        pulumi.set(__self__, "path", path)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)

    @_builtins.property
    @pulumi.getter(name="gitProvider")
    def git_provider(self) -> pulumi.Input[_builtins.str]:
        """
        The Git provider of the template
        """
        return pulumi.get(self, "git_provider")

    @git_provider.setter
    def git_provider(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "git_provider", value)

    @_builtins.property
    @pulumi.getter(name="gitRepo")
    def git_repo(self) -> pulumi.Input[_builtins.str]:
        """
        The Git repository URL that the template resides in
        """
        return pulumi.get(self, "git_repo")

    @git_repo.setter
    def git_repo(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "git_repo", value)

    @_builtins.property
    @pulumi.getter
    def manifest(self) -> pulumi.Input['AppsSettingsCustomTemplateManifestArgs']:
        """
        The manifest of the template. It defines fields and default values when installing the template
        """
        return pulumi.get(self, "manifest")

    @manifest.setter
    def manifest(self, value: pulumi.Input['AppsSettingsCustomTemplateManifestArgs']):
        pulumi.set(self, "manifest", value)

    @_builtins.property
    @pulumi.getter
    def path(self) -> pulumi.Input[_builtins.str]:
        """
        The path to the template within the Git repository
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "path", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the template
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the template. It must contain only alphanumeric characters, hyphens, underscores, and whitespaces.
        It must be unique within the workspace
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Workspace ID of the resource
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workspace_id", value)


@pulumi.input_type
class _AppsSettingsCustomTemplateState:
    def __init__(__self__, *,
                 creator: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 git_provider: Optional[pulumi.Input[_builtins.str]] = None,
                 git_repo: Optional[pulumi.Input[_builtins.str]] = None,
                 manifest: Optional[pulumi.Input['AppsSettingsCustomTemplateManifestArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AppsSettingsCustomTemplate resources.
        :param pulumi.Input[_builtins.str] creator: (string)
        :param pulumi.Input[_builtins.str] description: The description of the template
        :param pulumi.Input[_builtins.str] git_provider: The Git provider of the template
        :param pulumi.Input[_builtins.str] git_repo: The Git repository URL that the template resides in
        :param pulumi.Input['AppsSettingsCustomTemplateManifestArgs'] manifest: The manifest of the template. It defines fields and default values when installing the template
        :param pulumi.Input[_builtins.str] name: The name of the template. It must contain only alphanumeric characters, hyphens, underscores, and whitespaces.
               It must be unique within the workspace
        :param pulumi.Input[_builtins.str] path: The path to the template within the Git repository
        :param pulumi.Input[_builtins.str] workspace_id: Workspace ID of the resource
        """
        if creator is not None:
            pulumi.set(__self__, "creator", creator)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if git_provider is not None:
            pulumi.set(__self__, "git_provider", git_provider)
        if git_repo is not None:
            pulumi.set(__self__, "git_repo", git_repo)
        if manifest is not None:
            pulumi.set(__self__, "manifest", manifest)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)

    @_builtins.property
    @pulumi.getter
    def creator(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (string)
        """
        return pulumi.get(self, "creator")

    @creator.setter
    def creator(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "creator", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the template
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="gitProvider")
    def git_provider(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Git provider of the template
        """
        return pulumi.get(self, "git_provider")

    @git_provider.setter
    def git_provider(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "git_provider", value)

    @_builtins.property
    @pulumi.getter(name="gitRepo")
    def git_repo(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Git repository URL that the template resides in
        """
        return pulumi.get(self, "git_repo")

    @git_repo.setter
    def git_repo(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "git_repo", value)

    @_builtins.property
    @pulumi.getter
    def manifest(self) -> Optional[pulumi.Input['AppsSettingsCustomTemplateManifestArgs']]:
        """
        The manifest of the template. It defines fields and default values when installing the template
        """
        return pulumi.get(self, "manifest")

    @manifest.setter
    def manifest(self, value: Optional[pulumi.Input['AppsSettingsCustomTemplateManifestArgs']]):
        pulumi.set(self, "manifest", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the template. It must contain only alphanumeric characters, hyphens, underscores, and whitespaces.
        It must be unique within the workspace
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path to the template within the Git repository
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "path", value)

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Workspace ID of the resource
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workspace_id", value)


@pulumi.type_token("databricks:index/appsSettingsCustomTemplate:AppsSettingsCustomTemplate")
class AppsSettingsCustomTemplate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 git_provider: Optional[pulumi.Input[_builtins.str]] = None,
                 git_repo: Optional[pulumi.Input[_builtins.str]] = None,
                 manifest: Optional[pulumi.Input[Union['AppsSettingsCustomTemplateManifestArgs', 'AppsSettingsCustomTemplateManifestArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Custom App Templates store the metadata of custom app code hosted in an external Git repository, enabling users to reuse boilerplate code when creating apps.

        ## Example Usage

        ### Basic Example

        This example creates a Custom Template in the workspace with the specified name.

        ```python
        import pulumi
        import pulumi_databricks as databricks

        this = databricks.AppsSettingsCustomTemplate("this",
            name="my-custom-template",
            description="A sample custom app template",
            git_repo="https://github.com/example/repo.git",
            path="path-to-template",
            git_provider="github",
            manifest={
                "version": 1,
                "name": "my-custom-app",
            })
        ```

        ## Import

        As of Pulumi v1.5, resources can be imported through configuration.

        hcl

        import {

          id = "name"

          to = databricks_apps_settings_custom_template.this

        }

        If you are using an older version of Pulumi, import the resource using the `pulumi import` command as follows:

        ```sh
        $ pulumi import databricks:index/appsSettingsCustomTemplate:AppsSettingsCustomTemplate databricks_apps_settings_custom_template "name"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The description of the template
        :param pulumi.Input[_builtins.str] git_provider: The Git provider of the template
        :param pulumi.Input[_builtins.str] git_repo: The Git repository URL that the template resides in
        :param pulumi.Input[Union['AppsSettingsCustomTemplateManifestArgs', 'AppsSettingsCustomTemplateManifestArgsDict']] manifest: The manifest of the template. It defines fields and default values when installing the template
        :param pulumi.Input[_builtins.str] name: The name of the template. It must contain only alphanumeric characters, hyphens, underscores, and whitespaces.
               It must be unique within the workspace
        :param pulumi.Input[_builtins.str] path: The path to the template within the Git repository
        :param pulumi.Input[_builtins.str] workspace_id: Workspace ID of the resource
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AppsSettingsCustomTemplateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Custom App Templates store the metadata of custom app code hosted in an external Git repository, enabling users to reuse boilerplate code when creating apps.

        ## Example Usage

        ### Basic Example

        This example creates a Custom Template in the workspace with the specified name.

        ```python
        import pulumi
        import pulumi_databricks as databricks

        this = databricks.AppsSettingsCustomTemplate("this",
            name="my-custom-template",
            description="A sample custom app template",
            git_repo="https://github.com/example/repo.git",
            path="path-to-template",
            git_provider="github",
            manifest={
                "version": 1,
                "name": "my-custom-app",
            })
        ```

        ## Import

        As of Pulumi v1.5, resources can be imported through configuration.

        hcl

        import {

          id = "name"

          to = databricks_apps_settings_custom_template.this

        }

        If you are using an older version of Pulumi, import the resource using the `pulumi import` command as follows:

        ```sh
        $ pulumi import databricks:index/appsSettingsCustomTemplate:AppsSettingsCustomTemplate databricks_apps_settings_custom_template "name"
        ```

        :param str resource_name: The name of the resource.
        :param AppsSettingsCustomTemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AppsSettingsCustomTemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 git_provider: Optional[pulumi.Input[_builtins.str]] = None,
                 git_repo: Optional[pulumi.Input[_builtins.str]] = None,
                 manifest: Optional[pulumi.Input[Union['AppsSettingsCustomTemplateManifestArgs', 'AppsSettingsCustomTemplateManifestArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AppsSettingsCustomTemplateArgs.__new__(AppsSettingsCustomTemplateArgs)

            __props__.__dict__["description"] = description
            if git_provider is None and not opts.urn:
                raise TypeError("Missing required property 'git_provider'")
            __props__.__dict__["git_provider"] = git_provider
            if git_repo is None and not opts.urn:
                raise TypeError("Missing required property 'git_repo'")
            __props__.__dict__["git_repo"] = git_repo
            if manifest is None and not opts.urn:
                raise TypeError("Missing required property 'manifest'")
            __props__.__dict__["manifest"] = manifest
            __props__.__dict__["name"] = name
            if path is None and not opts.urn:
                raise TypeError("Missing required property 'path'")
            __props__.__dict__["path"] = path
            __props__.__dict__["workspace_id"] = workspace_id
            __props__.__dict__["creator"] = None
        super(AppsSettingsCustomTemplate, __self__).__init__(
            'databricks:index/appsSettingsCustomTemplate:AppsSettingsCustomTemplate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            creator: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            git_provider: Optional[pulumi.Input[_builtins.str]] = None,
            git_repo: Optional[pulumi.Input[_builtins.str]] = None,
            manifest: Optional[pulumi.Input[Union['AppsSettingsCustomTemplateManifestArgs', 'AppsSettingsCustomTemplateManifestArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            path: Optional[pulumi.Input[_builtins.str]] = None,
            workspace_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'AppsSettingsCustomTemplate':
        """
        Get an existing AppsSettingsCustomTemplate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] creator: (string)
        :param pulumi.Input[_builtins.str] description: The description of the template
        :param pulumi.Input[_builtins.str] git_provider: The Git provider of the template
        :param pulumi.Input[_builtins.str] git_repo: The Git repository URL that the template resides in
        :param pulumi.Input[Union['AppsSettingsCustomTemplateManifestArgs', 'AppsSettingsCustomTemplateManifestArgsDict']] manifest: The manifest of the template. It defines fields and default values when installing the template
        :param pulumi.Input[_builtins.str] name: The name of the template. It must contain only alphanumeric characters, hyphens, underscores, and whitespaces.
               It must be unique within the workspace
        :param pulumi.Input[_builtins.str] path: The path to the template within the Git repository
        :param pulumi.Input[_builtins.str] workspace_id: Workspace ID of the resource
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AppsSettingsCustomTemplateState.__new__(_AppsSettingsCustomTemplateState)

        __props__.__dict__["creator"] = creator
        __props__.__dict__["description"] = description
        __props__.__dict__["git_provider"] = git_provider
        __props__.__dict__["git_repo"] = git_repo
        __props__.__dict__["manifest"] = manifest
        __props__.__dict__["name"] = name
        __props__.__dict__["path"] = path
        __props__.__dict__["workspace_id"] = workspace_id
        return AppsSettingsCustomTemplate(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def creator(self) -> pulumi.Output[_builtins.str]:
        """
        (string)
        """
        return pulumi.get(self, "creator")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the template
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="gitProvider")
    def git_provider(self) -> pulumi.Output[_builtins.str]:
        """
        The Git provider of the template
        """
        return pulumi.get(self, "git_provider")

    @_builtins.property
    @pulumi.getter(name="gitRepo")
    def git_repo(self) -> pulumi.Output[_builtins.str]:
        """
        The Git repository URL that the template resides in
        """
        return pulumi.get(self, "git_repo")

    @_builtins.property
    @pulumi.getter
    def manifest(self) -> pulumi.Output['outputs.AppsSettingsCustomTemplateManifest']:
        """
        The manifest of the template. It defines fields and default values when installing the template
        """
        return pulumi.get(self, "manifest")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the template. It must contain only alphanumeric characters, hyphens, underscores, and whitespaces.
        It must be unique within the workspace
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def path(self) -> pulumi.Output[_builtins.str]:
        """
        The path to the template within the Git repository
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Workspace ID of the resource
        """
        return pulumi.get(self, "workspace_id")

