# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['EntityTagAssignmentArgs', 'EntityTagAssignment']

@pulumi.input_type
class EntityTagAssignmentArgs:
    def __init__(__self__, *,
                 entity_name: pulumi.Input[_builtins.str],
                 entity_type: pulumi.Input[_builtins.str],
                 tag_key: pulumi.Input[_builtins.str],
                 tag_value: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a EntityTagAssignment resource.
        :param pulumi.Input[_builtins.str] entity_name: The fully qualified name of the entity to which the tag is assigned
        :param pulumi.Input[_builtins.str] entity_type: The type of the entity to which the tag is assigned. Allowed values are: catalogs, schemas, tables, columns, volumes
        :param pulumi.Input[_builtins.str] tag_key: The key of the tag
        :param pulumi.Input[_builtins.str] tag_value: The value of the tag
        :param pulumi.Input[_builtins.str] workspace_id: Workspace ID of the resource
        """
        pulumi.set(__self__, "entity_name", entity_name)
        pulumi.set(__self__, "entity_type", entity_type)
        pulumi.set(__self__, "tag_key", tag_key)
        if tag_value is not None:
            pulumi.set(__self__, "tag_value", tag_value)
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)

    @_builtins.property
    @pulumi.getter(name="entityName")
    def entity_name(self) -> pulumi.Input[_builtins.str]:
        """
        The fully qualified name of the entity to which the tag is assigned
        """
        return pulumi.get(self, "entity_name")

    @entity_name.setter
    def entity_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "entity_name", value)

    @_builtins.property
    @pulumi.getter(name="entityType")
    def entity_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of the entity to which the tag is assigned. Allowed values are: catalogs, schemas, tables, columns, volumes
        """
        return pulumi.get(self, "entity_type")

    @entity_type.setter
    def entity_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "entity_type", value)

    @_builtins.property
    @pulumi.getter(name="tagKey")
    def tag_key(self) -> pulumi.Input[_builtins.str]:
        """
        The key of the tag
        """
        return pulumi.get(self, "tag_key")

    @tag_key.setter
    def tag_key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "tag_key", value)

    @_builtins.property
    @pulumi.getter(name="tagValue")
    def tag_value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The value of the tag
        """
        return pulumi.get(self, "tag_value")

    @tag_value.setter
    def tag_value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tag_value", value)

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Workspace ID of the resource
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workspace_id", value)


@pulumi.input_type
class _EntityTagAssignmentState:
    def __init__(__self__, *,
                 entity_name: Optional[pulumi.Input[_builtins.str]] = None,
                 entity_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tag_key: Optional[pulumi.Input[_builtins.str]] = None,
                 tag_value: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering EntityTagAssignment resources.
        :param pulumi.Input[_builtins.str] entity_name: The fully qualified name of the entity to which the tag is assigned
        :param pulumi.Input[_builtins.str] entity_type: The type of the entity to which the tag is assigned. Allowed values are: catalogs, schemas, tables, columns, volumes
        :param pulumi.Input[_builtins.str] tag_key: The key of the tag
        :param pulumi.Input[_builtins.str] tag_value: The value of the tag
        :param pulumi.Input[_builtins.str] workspace_id: Workspace ID of the resource
        """
        if entity_name is not None:
            pulumi.set(__self__, "entity_name", entity_name)
        if entity_type is not None:
            pulumi.set(__self__, "entity_type", entity_type)
        if tag_key is not None:
            pulumi.set(__self__, "tag_key", tag_key)
        if tag_value is not None:
            pulumi.set(__self__, "tag_value", tag_value)
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)

    @_builtins.property
    @pulumi.getter(name="entityName")
    def entity_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The fully qualified name of the entity to which the tag is assigned
        """
        return pulumi.get(self, "entity_name")

    @entity_name.setter
    def entity_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "entity_name", value)

    @_builtins.property
    @pulumi.getter(name="entityType")
    def entity_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the entity to which the tag is assigned. Allowed values are: catalogs, schemas, tables, columns, volumes
        """
        return pulumi.get(self, "entity_type")

    @entity_type.setter
    def entity_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "entity_type", value)

    @_builtins.property
    @pulumi.getter(name="tagKey")
    def tag_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The key of the tag
        """
        return pulumi.get(self, "tag_key")

    @tag_key.setter
    def tag_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tag_key", value)

    @_builtins.property
    @pulumi.getter(name="tagValue")
    def tag_value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The value of the tag
        """
        return pulumi.get(self, "tag_value")

    @tag_value.setter
    def tag_value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tag_value", value)

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Workspace ID of the resource
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workspace_id", value)


@pulumi.type_token("databricks:index/entityTagAssignment:EntityTagAssignment")
class EntityTagAssignment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 entity_name: Optional[pulumi.Input[_builtins.str]] = None,
                 entity_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tag_key: Optional[pulumi.Input[_builtins.str]] = None,
                 tag_value: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Import

        As of Pulumi v1.5, resources can be imported through configuration.

        hcl

        import {

          id = "entity_type,entity_name,tag_key"

          to = databricks_entity_tag_assignment.this

        }

        If you are using an older version of Pulumi, import the resource using the `pulumi import` command as follows:

        ```sh
        $ pulumi import databricks:index/entityTagAssignment:EntityTagAssignment databricks_entity_tag_assignment "entity_type,entity_name,tag_key"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] entity_name: The fully qualified name of the entity to which the tag is assigned
        :param pulumi.Input[_builtins.str] entity_type: The type of the entity to which the tag is assigned. Allowed values are: catalogs, schemas, tables, columns, volumes
        :param pulumi.Input[_builtins.str] tag_key: The key of the tag
        :param pulumi.Input[_builtins.str] tag_value: The value of the tag
        :param pulumi.Input[_builtins.str] workspace_id: Workspace ID of the resource
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EntityTagAssignmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        As of Pulumi v1.5, resources can be imported through configuration.

        hcl

        import {

          id = "entity_type,entity_name,tag_key"

          to = databricks_entity_tag_assignment.this

        }

        If you are using an older version of Pulumi, import the resource using the `pulumi import` command as follows:

        ```sh
        $ pulumi import databricks:index/entityTagAssignment:EntityTagAssignment databricks_entity_tag_assignment "entity_type,entity_name,tag_key"
        ```

        :param str resource_name: The name of the resource.
        :param EntityTagAssignmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EntityTagAssignmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 entity_name: Optional[pulumi.Input[_builtins.str]] = None,
                 entity_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tag_key: Optional[pulumi.Input[_builtins.str]] = None,
                 tag_value: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EntityTagAssignmentArgs.__new__(EntityTagAssignmentArgs)

            if entity_name is None and not opts.urn:
                raise TypeError("Missing required property 'entity_name'")
            __props__.__dict__["entity_name"] = entity_name
            if entity_type is None and not opts.urn:
                raise TypeError("Missing required property 'entity_type'")
            __props__.__dict__["entity_type"] = entity_type
            if tag_key is None and not opts.urn:
                raise TypeError("Missing required property 'tag_key'")
            __props__.__dict__["tag_key"] = tag_key
            __props__.__dict__["tag_value"] = tag_value
            __props__.__dict__["workspace_id"] = workspace_id
        super(EntityTagAssignment, __self__).__init__(
            'databricks:index/entityTagAssignment:EntityTagAssignment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            entity_name: Optional[pulumi.Input[_builtins.str]] = None,
            entity_type: Optional[pulumi.Input[_builtins.str]] = None,
            tag_key: Optional[pulumi.Input[_builtins.str]] = None,
            tag_value: Optional[pulumi.Input[_builtins.str]] = None,
            workspace_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'EntityTagAssignment':
        """
        Get an existing EntityTagAssignment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] entity_name: The fully qualified name of the entity to which the tag is assigned
        :param pulumi.Input[_builtins.str] entity_type: The type of the entity to which the tag is assigned. Allowed values are: catalogs, schemas, tables, columns, volumes
        :param pulumi.Input[_builtins.str] tag_key: The key of the tag
        :param pulumi.Input[_builtins.str] tag_value: The value of the tag
        :param pulumi.Input[_builtins.str] workspace_id: Workspace ID of the resource
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EntityTagAssignmentState.__new__(_EntityTagAssignmentState)

        __props__.__dict__["entity_name"] = entity_name
        __props__.__dict__["entity_type"] = entity_type
        __props__.__dict__["tag_key"] = tag_key
        __props__.__dict__["tag_value"] = tag_value
        __props__.__dict__["workspace_id"] = workspace_id
        return EntityTagAssignment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="entityName")
    def entity_name(self) -> pulumi.Output[_builtins.str]:
        """
        The fully qualified name of the entity to which the tag is assigned
        """
        return pulumi.get(self, "entity_name")

    @_builtins.property
    @pulumi.getter(name="entityType")
    def entity_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the entity to which the tag is assigned. Allowed values are: catalogs, schemas, tables, columns, volumes
        """
        return pulumi.get(self, "entity_type")

    @_builtins.property
    @pulumi.getter(name="tagKey")
    def tag_key(self) -> pulumi.Output[_builtins.str]:
        """
        The key of the tag
        """
        return pulumi.get(self, "tag_key")

    @_builtins.property
    @pulumi.getter(name="tagValue")
    def tag_value(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The value of the tag
        """
        return pulumi.get(self, "tag_value")

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Workspace ID of the resource
        """
        return pulumi.get(self, "workspace_id")

