# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetAppsSettingsCustomTemplateResult',
    'AwaitableGetAppsSettingsCustomTemplateResult',
    'get_apps_settings_custom_template',
    'get_apps_settings_custom_template_output',
]

@pulumi.output_type
class GetAppsSettingsCustomTemplateResult:
    """
    A collection of values returned by getAppsSettingsCustomTemplate.
    """
    def __init__(__self__, creator=None, description=None, git_provider=None, git_repo=None, id=None, manifest=None, name=None, path=None, workspace_id=None):
        if creator and not isinstance(creator, str):
            raise TypeError("Expected argument 'creator' to be a str")
        pulumi.set(__self__, "creator", creator)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if git_provider and not isinstance(git_provider, str):
            raise TypeError("Expected argument 'git_provider' to be a str")
        pulumi.set(__self__, "git_provider", git_provider)
        if git_repo and not isinstance(git_repo, str):
            raise TypeError("Expected argument 'git_repo' to be a str")
        pulumi.set(__self__, "git_repo", git_repo)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if manifest and not isinstance(manifest, dict):
            raise TypeError("Expected argument 'manifest' to be a dict")
        pulumi.set(__self__, "manifest", manifest)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if path and not isinstance(path, str):
            raise TypeError("Expected argument 'path' to be a str")
        pulumi.set(__self__, "path", path)
        if workspace_id and not isinstance(workspace_id, str):
            raise TypeError("Expected argument 'workspace_id' to be a str")
        pulumi.set(__self__, "workspace_id", workspace_id)

    @_builtins.property
    @pulumi.getter
    def creator(self) -> _builtins.str:
        """
        (string)
        """
        return pulumi.get(self, "creator")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        (string) - Description of the App Resource
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="gitProvider")
    def git_provider(self) -> _builtins.str:
        """
        (string) - The Git provider of the template
        """
        return pulumi.get(self, "git_provider")

    @_builtins.property
    @pulumi.getter(name="gitRepo")
    def git_repo(self) -> _builtins.str:
        """
        (string) - The Git repository URL that the template resides in
        """
        return pulumi.get(self, "git_repo")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def manifest(self) -> 'outputs.GetAppsSettingsCustomTemplateManifestResult':
        """
        (AppManifest) - The manifest of the template. It defines fields and default values when installing the template
        """
        return pulumi.get(self, "manifest")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        (string) - Name of the App Resource
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        (string) - The path to the template within the Git repository
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "workspace_id")


class AwaitableGetAppsSettingsCustomTemplateResult(GetAppsSettingsCustomTemplateResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAppsSettingsCustomTemplateResult(
            creator=self.creator,
            description=self.description,
            git_provider=self.git_provider,
            git_repo=self.git_repo,
            id=self.id,
            manifest=self.manifest,
            name=self.name,
            path=self.path,
            workspace_id=self.workspace_id)


def get_apps_settings_custom_template(description: Optional[_builtins.str] = None,
                                      git_provider: Optional[_builtins.str] = None,
                                      git_repo: Optional[_builtins.str] = None,
                                      manifest: Optional[Union['GetAppsSettingsCustomTemplateManifestArgs', 'GetAppsSettingsCustomTemplateManifestArgsDict']] = None,
                                      name: Optional[_builtins.str] = None,
                                      path: Optional[_builtins.str] = None,
                                      workspace_id: Optional[_builtins.str] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAppsSettingsCustomTemplateResult:
    """
    This data source can be used to get a single Custom Template.

    ## Example Usage

    Referring to a Custom Template by name:

    ```python
    import pulumi
    import pulumi_databricks as databricks

    my_template = databricks.get_apps_settings_custom_template(name="my-custom-template")
    ```


    :param _builtins.str description: (string) - Description of the App Resource
    :param _builtins.str git_provider: (string) - The Git provider of the template
    :param _builtins.str git_repo: (string) - The Git repository URL that the template resides in
    :param Union['GetAppsSettingsCustomTemplateManifestArgs', 'GetAppsSettingsCustomTemplateManifestArgsDict'] manifest: (AppManifest) - The manifest of the template. It defines fields and default values when installing the template
    :param _builtins.str name: The name of the template. It must contain only alphanumeric characters, hyphens, underscores, and whitespaces.
           It must be unique within the workspace
    :param _builtins.str path: (string) - The path to the template within the Git repository
    :param _builtins.str workspace_id: Workspace ID of the resource
    """
    __args__ = dict()
    __args__['description'] = description
    __args__['gitProvider'] = git_provider
    __args__['gitRepo'] = git_repo
    __args__['manifest'] = manifest
    __args__['name'] = name
    __args__['path'] = path
    __args__['workspaceId'] = workspace_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('databricks:index/getAppsSettingsCustomTemplate:getAppsSettingsCustomTemplate', __args__, opts=opts, typ=GetAppsSettingsCustomTemplateResult).value

    return AwaitableGetAppsSettingsCustomTemplateResult(
        creator=pulumi.get(__ret__, 'creator'),
        description=pulumi.get(__ret__, 'description'),
        git_provider=pulumi.get(__ret__, 'git_provider'),
        git_repo=pulumi.get(__ret__, 'git_repo'),
        id=pulumi.get(__ret__, 'id'),
        manifest=pulumi.get(__ret__, 'manifest'),
        name=pulumi.get(__ret__, 'name'),
        path=pulumi.get(__ret__, 'path'),
        workspace_id=pulumi.get(__ret__, 'workspace_id'))
def get_apps_settings_custom_template_output(description: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                             git_provider: Optional[pulumi.Input[_builtins.str]] = None,
                                             git_repo: Optional[pulumi.Input[_builtins.str]] = None,
                                             manifest: Optional[pulumi.Input[Union['GetAppsSettingsCustomTemplateManifestArgs', 'GetAppsSettingsCustomTemplateManifestArgsDict']]] = None,
                                             name: Optional[pulumi.Input[_builtins.str]] = None,
                                             path: Optional[pulumi.Input[_builtins.str]] = None,
                                             workspace_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAppsSettingsCustomTemplateResult]:
    """
    This data source can be used to get a single Custom Template.

    ## Example Usage

    Referring to a Custom Template by name:

    ```python
    import pulumi
    import pulumi_databricks as databricks

    my_template = databricks.get_apps_settings_custom_template(name="my-custom-template")
    ```


    :param _builtins.str description: (string) - Description of the App Resource
    :param _builtins.str git_provider: (string) - The Git provider of the template
    :param _builtins.str git_repo: (string) - The Git repository URL that the template resides in
    :param Union['GetAppsSettingsCustomTemplateManifestArgs', 'GetAppsSettingsCustomTemplateManifestArgsDict'] manifest: (AppManifest) - The manifest of the template. It defines fields and default values when installing the template
    :param _builtins.str name: The name of the template. It must contain only alphanumeric characters, hyphens, underscores, and whitespaces.
           It must be unique within the workspace
    :param _builtins.str path: (string) - The path to the template within the Git repository
    :param _builtins.str workspace_id: Workspace ID of the resource
    """
    __args__ = dict()
    __args__['description'] = description
    __args__['gitProvider'] = git_provider
    __args__['gitRepo'] = git_repo
    __args__['manifest'] = manifest
    __args__['name'] = name
    __args__['path'] = path
    __args__['workspaceId'] = workspace_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('databricks:index/getAppsSettingsCustomTemplate:getAppsSettingsCustomTemplate', __args__, opts=opts, typ=GetAppsSettingsCustomTemplateResult)
    return __ret__.apply(lambda __response__: GetAppsSettingsCustomTemplateResult(
        creator=pulumi.get(__response__, 'creator'),
        description=pulumi.get(__response__, 'description'),
        git_provider=pulumi.get(__response__, 'git_provider'),
        git_repo=pulumi.get(__response__, 'git_repo'),
        id=pulumi.get(__response__, 'id'),
        manifest=pulumi.get(__response__, 'manifest'),
        name=pulumi.get(__response__, 'name'),
        path=pulumi.get(__response__, 'path'),
        workspace_id=pulumi.get(__response__, 'workspace_id')))
